<?php
/**
 * The main template file for display page.
 *
 * @package WordPress
*/

//Check if single attachment page
if($post->post_type == 'attachment')
{
	get_template_part("single-attachment");
	die;
}

/**
*	Get Current page object
**/
if(!is_null($post))
{
	$page_obj = get_page($post->ID);
}

$current_page_id = '';

/**
*	Get current page id
**/

if(!is_null($post) && isset($page_obj->ID))
{
    $current_page_id = $page_obj->ID;
}

get_header(); 
?>

<?php
	$inner_background_image_style = '';
	
	$is_current_user = false;
	$is_learn_press_profile = false;
	$obj_user = false;
	
	if(class_exists('LP_Global'))
	{
		$profile = LP_Global::profile();
		$is_current_user = $profile->is_current_user();
		$is_learn_press_profile = learn_press_is_profile();
		
		$user = $profile->get_user();
		$profile_email = $user->get_email();
		$obj_user = get_user_by('email', $profile_email);
	}

	//Check if not enrolling course
	if(isset($_GET['redirect_to']))
	{
		if($is_current_user OR !$is_learn_press_profile OR !is_object($obj_user))
		{
			get_template_part("/templates/template-header");
		}
		else
		{
			get_template_part("/templates/template-profile-header");
		}
	}
	else
	{
		//Include custom header feature, if no password protected
		if(!post_password_required()){
			get_template_part("/templates/template-header");
		}
		else
		{
			//Get page featured image
			if(has_post_thumbnail($current_page_id, 'original'))
			{
				$image_id = get_post_thumbnail_id($current_page_id); 
				$image_thumb = wp_get_attachment_image_src($image_id, 'original', true);
				
				if(isset($image_thumb[0]) && !empty($image_thumb[0]))
				{
					$pp_page_bg = $image_thumb[0];
					$inner_background_image_style = 'style="background-image:url(\''.esc_url($pp_page_bg).'\');"';
				}
			}
		}
	}
?>
    <div class="inner" <?php echo $inner_background_image_style; ?>>
    	<!-- Begin main content -->
    	<div class="inner-wrapper">
    		<div class="sidebar-content fullwidth">
    		<?php
    		if ( have_posts() && ($is_current_user OR !$is_learn_press_profile OR !is_object($obj_user)) ) {
    		    while ( have_posts() ) : the_post(); ?>		
    	
    		    <?php 
	    		    the_content(); 
	    		    break;  
	    		?>
	
	    		<?php endwhile; 
	    		
	    		wp_link_pages(
	    			array(
						'before'           => '<br class="clear"/><div class="wp-link-pages"><span class="wp-link-pages-label">' . esc_html__( 'Pages:', 'artale' ).'</span>',
						'after'            => '</div>',
					)
				);
    		}
			
			//If enrolling course
			if(!is_object($obj_user) && !is_object($obj_user))
			{
				if(function_exists('learn_press_get_template') && $is_learn_press_profile)
				{
					 learn_press_get_template( 'global/form-login.php');
					 learn_press_get_template( 'global/form-register.php');
				}
			}

			if (comments_open($post->ID)) 
			{
			?>
			<div class="fullwidth-comment-wrapper theme-border"><?php comments_template( '', true ); ?></div>
			<?php
			}
			else
			{
			?>
			<div class="comment_disable_clearer"></div>
			<?php
			}
			?>
    		</div>
    	</div>
    	<!-- End main content -->
    </div>
</div>
<?php get_footer(); ?>