<?php
/**
 * Template Name: Page Left Sidebar
 * The main template file for display page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
if(!is_null($post))
{
	$page_obj = get_page($post->ID);
}

$current_page_id = '';

/**
*	Get current page id
**/

if(!is_null($post) && isset($page_obj->ID))
{
    $current_page_id = $page_obj->ID;
}

$page_style = 'Right Sidebar';
$page_sidebar = get_post_meta($current_page_id, 'page_sidebar', true);

if(empty($page_sidebar))
{
	$page_sidebar = 'Page Sidebar';
}

$add_sidebar = TRUE;

get_header(); 

$page_sidebar = sanitize_title($page_sidebar);
?>

<?php
	$inner_background_image_style = '';
	
    //Include custom header feature, if no password protected
	if(!post_password_required()){
		get_template_part("/templates/template-header");
	}
	else
	{
		//Get page featured image
		if(has_post_thumbnail($current_page_id, 'original'))
		{
			$image_id = get_post_thumbnail_id($current_page_id); 
			$image_thumb = wp_get_attachment_image_src($image_id, 'original', true);
			
			if(isset($image_thumb[0]) && !empty($image_thumb[0]))
			{
				$pp_page_bg = $image_thumb[0];
				$inner_background_image_style = 'style="background-image:url(\''.esc_url($pp_page_bg).'\');"';
			}
		}
	}
?>

    <div class="inner" <?php echo $inner_background_image_style; ?>>
    
    <!-- Begin main content -->
    <div class="inner-wrapper">
        	
        <div class="sidebar-content left-sidebar <?php if(!is_active_sidebar($page_sidebar)) { ?>fullwidth<?php } ?>">
        	
        	 <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
			 	<?php the_content(); ?>
			 <?php endwhile;
					wp_link_pages(
		    			array(
							'before'           => '<br class="clear"/><p>' . esc_html__( 'Pages:', 'artale' ),
							'after'            => '</p>',
						)
					);
				?>
			 
			 <?php
			if (comments_open($post->ID)) 
			{
			?>
			<div class="fullwidth-comment-wrapper sidebar theme-border">
				<?php comments_template( '', true ); ?>
			</div>
			<?php
			}
			?>
        	
        </div>
        
        <?php 
			if (is_active_sidebar($page_sidebar)) 
			{ 
		?>	
    		<div class="sidebar-wrapper left-sidebar">
    	
	    		<div class="sidebar_top"></div>
	    	
	    		<div class="sidebar">
	    		
	    			<div class="content">
	
		    	    	<ul class="sidebar-widget">
		    	    		<?php dynamic_sidebar($page_sidebar); ?>
		    	    	</ul>
	    			
	    			</div>
	    	
	    		</div>
	    		<br class="clear"/>
	    
	    		<div class="sidebar_bottom"></div>
    		</div>
    	<?php 
	    	}
	    ?>
    
    </div>
    <!-- End main content -->
    </div>
    <br class="clear"/>
</div>
<?php get_footer(); ?>
