<?php
//Change number of products per page
add_filter( 'loop_shop_per_page', 'artale_shop_per_page', 20 );
function artale_shop_per_page()
{
	$artale_shop_items = get_theme_mod('artale_shop_items', 16);
	return $artale_shop_items;
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'artale_loop_columns');
if (!function_exists('artale_loop_columns')) {
	function artale_loop_columns() {
		//Get Shop columns Settting
		$artale_shop_columns = get_theme_mod('artale_shop_columns', 3);
		if(empty($artale_shop_columns))
		{
			$artale_shop_columns = 3;
		}
		
		//If theme demo, then display columns options
		if(ARTALE_THEMEDEMO && isset($_GET['shop_columns']))
		{
			$artale_shop_columns = $_GET['shop_columns'];
		}
		
		return $artale_shop_columns; // products per row
	}
}

/**
 * WooCommerce Extra Feature
 * --------------------------
 *
 * Change number of related products on product page
 * Set your own value for 'posts_per_page'
 *
 */ 
add_filter( 'woocommerce_output_related_products_args', 'artale_related_products_args' );

function artale_related_products_args( $args ) 
{
  	//Check if display related products
	$artale_shop_related_products = get_theme_mod('artale_shop_related_products', true);
	
	if(!empty($artale_shop_related_products))
	{
		$args['posts_per_page'] = 3; // 4 related products
		$args['columns'] = 3; // arranged in 2 columns
	}
	else
	{
		$args['posts_per_page'] = 0;
	}
	
	return $args;
}

//Check if display fly-out mini cart
$artale_mini_cart = get_theme_mod('artale_mini_cart', 1);

if(!empty($artale_mini_cart))
{
	function artale_update_mini_cart() {
	  echo get_template_part("/templates/template-mini-cart");
	  die();
	}
	add_filter( 'wp_ajax_nopriv_artale_update_mini_cart', 'artale_update_mini_cart' );
	add_filter( 'wp_ajax_artale_update_mini_cart', 'artale_update_mini_cart' );
	
	function artale_ajax_add_to_cart_js() {
	    wp_enqueue_script('artale-mini-cart-ajax-add-to-cart', get_template_directory_uri() . '/js/ajax-add-to-cart.js', array('jquery'), '', true);
	}
	
	add_action('wp_enqueue_scripts', 'artale_ajax_add_to_cart_js', 99);
	add_action('wp_enqueue_scripts', 'artale_ajax_add_to_cart_js', 99);
	
	
	add_action('wp_footer', 'artale_single_added_to_cart_event');
	function artale_single_added_to_cart_event()
	{
	    if( isset($_POST['add-to-cart']) && isset($_POST['quantity']) ) {
	        // Get added to cart product ID (or variation ID) and quantity (if needed)
	        $quantity   = $_POST['quantity'];
	        $product_id = isset($_POST['variation_id']) ? $_POST['variation_id'] : $_POST['add-to-cart'];
	
	        // JS code goes here below
	        ?>
	        <script>
	        jQuery(document).ready(function(){ 
				if(jQuery('#woocommerce-mini-cart-wrapper').length) {
					jQuery('#woocommerce-mini-cart-wrapper').addClass('visible');
			     
				    jQuery('#woocommerce-mini-cart-overlay').on( 'click', function(){
					   jQuery('#woocommerce-mini-cart-wrapper').removeClass('visible');
					   jQuery('#go-to-top').css('opacity', 1);
					});
				}
			});
	        </script>
	        <?php
	    }
	}
	
	/*function artale_remove_added_to_cart_notice()
	{
	    $notices = WC()->session->get('wc_notices', array());
	
		if(is_array($notices) && !empty($notices)) {
		    foreach( $notices['success'] as $key => &$notice){
		        if( strpos( $notice, 'has been added' ) !== false){
		            $added_to_cart_key = $key;
		            break;
		        }
		    }
		    unset( $notices['success'][$added_to_cart_key] );
		
		    WC()->session->set('wc_notices', $notices);
		}
	}*/
	//add_action('woocommerce_before_single_product','artale_remove_added_to_cart_notice',1);
	//add_action('woocommerce_shortcode_before_product_cat_loop','artale_remove_added_to_cart_notice',1);
	//add_action('woocommerce_before_shop_loop','artale_remove_added_to_cart_notice',1);
}
?>