<?php
if ( function_exists( 'add_theme_support' ) ) {
	// Setup thumbnail support
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'custom-background' );
	add_theme_support( 'html5', array( 'search-form' ) );
}

if (class_exists('MultiPostThumbnails')) {
 
new MultiPostThumbnails(array(
		'label' => 'Video Preview Image',
		'id' => 'preview-image',
		'post_type' => 'lp_course'
	) 
);
 
}

if ( function_exists( 'add_image_size' ) ) { 
	//Setup video grid dimensions
	add_image_size( 'artale-video-grid', 700, 393, true );
	
	
	//Setup image grid dimensions
	$pp_gallery_grid_image_width = get_theme_mod('artale_gallery_grid_width', 700);
	$pp_gallery_grid_image_height = get_theme_mod('artale_gallery_grid_height', 466);

	$image_crop = true;
	if($pp_gallery_grid_image_height == 9999)
	{
		$image_crop = false;
	}
	add_image_size( 'artale-gallery-grid', intval($pp_gallery_grid_image_width), intval($pp_gallery_grid_image_height), $image_crop );
	
	
	//Setup image masonry dimensions
	$pp_gallery_masonry_image_width = get_theme_mod('artale_gallery_masonry_width', 440);
	$pp_gallery_masonry_image_height = get_theme_mod('artale_gallery_masonry_height', 9999);

	$image_crop = true;
	if($pp_gallery_masonry_image_height == 9999)
	{
		$image_crop = false;
	}
	add_image_size( 'artale-gallery-masonry', intval($pp_gallery_masonry_image_width), intval($pp_gallery_masonry_image_height), $image_crop );

	
	//Setup image grid list dimensions
	$pp_gallery_list_image_width = get_theme_mod('artale_gallery_list_width', 610);
	$pp_gallery_list_image_height = get_theme_mod('artale_gallery_list_height', 610);

	$image_crop = true;
	if($pp_gallery_list_image_height == 9999)
	{
		$image_crop = false;
	}
	add_image_size( 'artale-gallery-list', intval($pp_gallery_list_image_width), intval($pp_gallery_list_image_height), $image_crop );

	add_image_size( 'artale-album-grid', 660, 770, true );
	
	
	//Setup image blog classic dimensions
	$pp_blog_image_width = get_theme_mod('artale_blog_classic_width', 960);
	$pp_blog_image_height = get_theme_mod('artale_blog_classic_height', 604);

	$image_crop = true;
	if($pp_blog_image_height == 9999)
	{
		$image_crop = false;
	}
	add_image_size( 'artale-blog', intval($pp_blog_image_width), intval($pp_blog_image_height), $image_crop );
	
	
	//Setup image blog grid dimensions
	$pp_blog_grid_image_width = get_theme_mod('artale_blog_grid_width', 480);
	$pp_blog_grid_image_height = get_theme_mod('artale_blog_grid_height', 302);

	$image_crop = true;
	if($pp_blog_grid_image_height == 9999)
	{
		$image_crop = false;
	}
	add_image_size( 'artale-blog-grid', intval($pp_blog_grid_image_width), intval($pp_blog_grid_image_height), $image_crop );
}

add_action( 'after_setup_theme', 'artale_woocommerce_support' );

function artale_woocommerce_support() {
    add_theme_support( 'woocommerce' );
}

add_theme_support( 'post-formats', array('video') );

/* Flush rewrite rules for custom post types. */
add_action( 'after_switch_theme', 'flush_rewrite_rules' );

add_theme_support( 'admin-bar', array( 'callback' => '__return_false' ) );
?>