<?php

//Add more CURL timeout if purchase code is not registered
$is_verified_envato_purchase_code = artale_is_registered();

//Check if registered purchase code valid
if(empty($is_verified_envato_purchase_code)) {
	add_filter('http_request_args', 'artale_http_request_args', 100, 1);
	function artale_http_request_args($r) 
	{
		$r['timeout'] = 30;
		return $r;
	}
	 
	add_action('http_api_curl', 'artale_http_api_curl', 100, 1);
	function artale_http_api_curl($handle) 
	{
		curl_setopt( $handle, CURLOPT_CONNECTTIMEOUT, 30 );
		curl_setopt( $handle, CURLOPT_TIMEOUT, 30 );
	}
}

if(ARTALE_THEMEDEMO) {
	add_action( 'wp_enqueue_scripts', 'artale_juice_cleanse', 200 );
	function artale_juice_cleanse() {
	
		wp_dequeue_style('wp-block-library');
	
		// This also removes some inline CSS variables for colors since 5.9 - global-styles-inline-css
		wp_dequeue_style('global-styles');
	
		// WooCommerce - you can remove the following if you don't use Woocommerce
		wp_dequeue_style('wc-block-style');
		wp_dequeue_style('wc-blocks-vendors-style');
		wp_dequeue_style('wc-blocks-style'); 
	}
}

/**
 * This function runs when WordPress completes its upgrade process
 * It iterates through each plugin updated to see if ours is included
 * @param $upgrader_object Array
 * @param $options Array
 */
function artale_upgrade_completed( $upgrader_object, $hook_extra ) { 
	
	if ($hook_extra['type'] = 'theme' && !ARTALE_THEMEDEMO) {
		//Get verified purchase code data
		$is_verified_envato_purchase_code = artale_is_registered();
		
		//Check if registered purchase code valid
		if(!empty($is_verified_envato_purchase_code)) {
			$site_domain = artale_get_site_domain();
			
			if($site_domain != 'localhost') {
				$url = THEMEGOODS_API.'/check-purchase-domain';
				//var_dump($url);
				$data = array(
					'purchase_code' => $is_verified_envato_purchase_code, 
					'domain' => $site_domain,
				);
				$data = wp_json_encode( $data );
				$args = array( 
					'method'   	=> 'POST',
					'body'		=> $data,
				);
				//print '<pre>'; var_dump($args); print '</pre>';
				
				$response = wp_remote_post( $url, $args );
				$response_body = wp_remote_retrieve_body( $response );
				$response_obj = json_decode($response_body);
				
				$response_json = urlencode($response_body);
				
				//If no data then unregister theme
				if(!empty($response_body)) {
					$response_body_obj = json_decode($response_body);
					
					if(!$response_body_obj->response[0]->domain) {
						
					}
					else {
						/*print '<pre>'; var_dump($response_body_obj->response[0]->domain); print '</pre>';
						die;*/
						if(!empty($response_body_obj->response[0]->domain) && $response_body_obj->response[0]->domain != $site_domain) {
							artale_unregister_theme();
						}
					}
				}
			}
		}
	}
}
add_action( 'upgrader_process_complete', 'artale_upgrade_completed', 10, 2 );

//Remove one click demo import plugin from admin menus
function artale_plugin_page_setup( $default_settings ) {
	$default_settings['parent_slug'] = 'themes.php';
	$default_settings['page_title']  = esc_html__( 'Demo Import' , 'artale' );
	$default_settings['menu_title']  = esc_html__( 'Import Demo Content' , 'artale' );
	$default_settings['capability']  = 'import';
	$default_settings['menu_slug']   = 'tg-one-click-demo-import';

	return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'artale_plugin_page_setup' );

function artale_menu_page_removing() {
    remove_submenu_page( 'themes.php', 'tg-one-click-demo-import' );
}
add_action( 'admin_menu', 'artale_menu_page_removing', 99 );

$is_verified_envato_purchase_code = false;

//Get verified purchase code data
$is_verified_envato_purchase_code = artale_is_registered();

if($is_verified_envato_purchase_code)
{
	function artale_import_files() {
	  return array(
		array(
			'import_file_name'             => 'V2.2 - Demo 2',
			'import_preview_image_url'     => 'https://assets.themegoods.com/demo/artale/importer/demo6/demo.jpg',
			'import_file_url'            => 'https://assets.themegoods.com/demo/artale/importer/demo6/demo.xml',
			'import_customizer_file_url' => 'https://assets.themegoods.com/demo/artale/importer/demo6/demo.dat',
			'preview_url'                  => 'https://artalev2-2.themegoods.com/demo2',
		),
		array(
			'import_file_name'             => 'V2.2 - Demo 1',
			'import_preview_image_url'     => 'https://assets.themegoods.com/demo/artale/importer/demo5/demo.jpg',
			'import_file_url'            => 'https://assets.themegoods.com/demo/artale/importer/demo5/demo.xml',
			'import_customizer_file_url' => 'https://assets.themegoods.com/demo/artale/importer/demo5/demo.dat',
			'preview_url'                  => 'https://artalev2-2.themegoods.com',
		),
		array(
			'import_file_name'             => 'V2 - Demo 3',
			'import_preview_image_url'     => 'https://assets.themegoods.com/demo/artale/importer/demo4/demo.jpg',
			'import_file_url'            => 'https://assets.themegoods.com/demo/artale/importer/demo4/demo.xml',
			'import_customizer_file_url' => 'https://assets.themegoods.com/demo/artale/importer/demo4/demo.dat',
			'preview_url'                  => 'https://artalev2.themegoods.com/demo3',
		),
		array(
			'import_file_name'             => 'V2 - Demo 2',
			'import_preview_image_url'     => 'https://assets.themegoods.com/demo/artale/importer/demo3/demo.jpg',
			'import_file_url'            => 'https://assets.themegoods.com/demo/artale/importer/demo3/demo.xml',
			'import_customizer_file_url' => 'https://assets.themegoods.com/demo/artale/importer/demo3/demo.dat',
			'preview_url'                  => 'https://artalev2.themegoods.com/demo2',
		),
		array(
			'import_file_name'             => 'V2 - Demo 1',
			'import_preview_image_url'     => 'https://assets.themegoods.com/demo/artale/importer/demo2/demo.jpg',
			'import_file_url'            => 'https://assets.themegoods.com/demo/artale/importer/demo2/demo.xml',
			'import_customizer_file_url' => 'https://assets.themegoods.com/demo/artale/importer/demo2/demo.dat',
			'preview_url'                  => 'https://artalev2.themegoods.com',
		),
	    array(
	      'import_file_name'             => 'V1 - Classic',
		  'import_preview_image_url'     => 'https://assets.themegoods.com/demo/artale/importer/demo1/demo.jpg',
	      'import_file_url'            => 'https://assets.themegoods.com/demo/artale/importer/demo1/demo.xml',
	      'import_widget_file_url'     => 'https://assets.themegoods.com/demo/artale/importer/demo1/demo.wie',
	      'import_customizer_file_url' => 'https://assets.themegoods.com/demo/artale/importer/demo1/demo.dat',
	      'preview_url'                  => 'https://themes.themegoods.com/artale',
	    ),
	  );
	}
	add_filter( 'pt-ocdi/import_files', 'artale_import_files' );
	
	function artale_confirmation_dialog_options ( $options ) {
		return array_merge( $options, array(
			'width'       => 300,
			'dialogClass' => 'wp-dialog',
			'resizable'   => false,
			'height'      => 'auto',
			'modal'       => true,
		) );
	}
	add_filter( 'pt-ocdi/confirmation_dialog_options', 'artale_confirmation_dialog_options', 10, 1 );
	
	function artale_after_import( $selected_import ) {
		switch($selected_import['import_file_name'])
		{
			case 'V1 - Classic':
			case 'V2 - Demo 3':
				// Assign menus to their locations.
				$main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
			
				set_theme_mod( 'nav_menu_locations', array(
						'primary-menu' => $main_menu->term_id,
						'side-menu' => $main_menu->term_id,
					)
				);
				
			break;
			
			case 'V2 - Demo 2':
				// Assign menus to their locations.
				$main_menu = get_term_by( 'name', 'Main Menu Left', 'nav_menu' );
			
				set_theme_mod( 'nav_menu_locations', array(
						'primary-menu' => $main_menu->term_id,
						'side-menu' => $main_menu->term_id,
					)
				);
				
			break;
			
			default:
				wp_delete_nav_menu('Main Menu');
			break;
		}
		
		// Assign front page
		switch($selected_import['import_file_name'])
		{
			case 'V1 - Classic':
				$front_page_id = get_page_by_title( 'Home 1' );
				
			break;
			
			default:
				$front_page_id = get_page_by_title( 'Home' );
			break;
		}
		
		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );
		
		// Assign Woocommerce related page
		$shop_page_id = get_page_by_title( 'Shop' );
		update_option( 'woocommerce_shop_page_id', $shop_page_id->ID );
		
		$cart_page_id = get_page_by_title( 'Cart' );
		update_option( 'woocommerce_cart_page_id', $cart_page_id->ID );
		
		$checkout_page_id = get_page_by_title( 'Checkout' );
		update_option( 'woocommerce_checkout_page_id', $checkout_page_id->ID );
		
		$myaccount_page_id = get_page_by_title( 'My account' );
		update_option( 'woocommerce_myaccount_page_id', $myaccount_page_id->ID );
		
		//Install Default Fonts
		remove_theme_mod('artale_custom_fonts');
		$default_custom_fonts = array(
			0 => array(
				'font_name' => 	'deriviaregular',
				'font_url' 	=>	get_template_directory_uri().'/fonts/derivia-regular-webfont.woff',
				'font_fallback'	=> 'sans-serif',
				'font_weight' => 400,
				'font_style' => 'normal',
			)
		);
		set_theme_mod( 'artale_custom_fonts', $default_custom_fonts );
		
		//Set theme's default Elementor kit
		$default_kit = get_page_by_path('default-kit-2', OBJECT, 'elementor_library');
		if(is_object($default_kit)) {
			update_option( 'elementor_active_kit', $default_kit->ID );
		}
		
		// 'Hello World!' post
	    wp_delete_post( 1, true );
	
	    // 'Sample page' page
	    wp_delete_post( 2, true );
	    
	    //Set permalink
	    global $wp_rewrite;
		$wp_rewrite->set_permalink_structure('/%postname%/');
		
		switch($selected_import['import_file_name'])
		{
			case 'V2 - Demo 2':
			case 'V2.2 - Demo 2':
				artale_elementor_replace_urls($selected_import['preview_url'].'/wp-content/uploads/sites/2', home_url().'/wp-content/uploads');
				
			break;
			
			case 'V2 - Demo 3':
				artale_elementor_replace_urls($selected_import['preview_url'].'/wp-content/uploads/sites/3', home_url().'/wp-content/uploads');
				
			break;
		}
		
		//Set the option
		update_option( "rewrite_rules", FALSE ); 
		
		//Flush the rules and tell it to write htaccess
		$wp_rewrite->flush_rules( true );
		
		//Update all Elementor URLs
		artale_elementor_replace_urls($selected_import['preview_url'], home_url());
		
		//Update custom field URLs
		artale_update_urls(array('custom'), $selected_import['preview_url'], home_url());
	}
	add_action( 'pt-ocdi/after_import', 'artale_after_import' );
	add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
}
	
add_filter( 'the_password_form', 'artale_password_form' );
function artale_password_form() {
    $post = artale_get_wp_post();
    
    $label = 'pwbox-'.( empty( $post->ID ) ? rand() : $post->ID );
    
    $return_html = '<div class="protected-post-header"><h1>' . esc_html($post->post_title) . '</h1></div>';
    $return_html.= '<form class="protected-post-form" action="' .wp_login_url(). '?action=postpass" method="post">';
    $return_html.= '<div class="protected-post-text">'.esc_html__( "This content is password protected. To view it please enter your password below:", 'artale'  ).'</div><input name="post_password" id="' . $label . '" type="password" size="40" />';
    
    $return_html.= '<input type="submit" name="Submit" class="button" value="' . esc_html__( "Authenticate", 'artale' ) . '" />';
    $return_html.= '</form>';
    
    return $return_html;
}
	
if ( ! function_exists( 'artale_theme_kirki_update_url' ) ) {
    function artale_theme_kirki_update_url( $config ) {
        $config['url_path'] = get_template_directory_uri() . '/modules/kirki/';
        return $config;
    }
}
add_filter( 'kirki/config', 'artale_theme_kirki_update_url' );

add_action( 'customize_register', function( $wp_customize ) {
	/**
	 * The custom control class
	 */
	class Kirki_Controls_Title_Control extends Kirki_Control_Base {
		public $type = 'title';
		public function render_content() { 
			echo esc_html($this->label);
		}
	}
	// Register our custom control with Kirki
	add_filter( 'kirki/control_types', function( $controls ) {
		$controls['title'] = 'Kirki_Controls_Title_Control';
		return $controls;
	} );

} );


/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function artale_tag_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'artale_tag_pingback_header' );


function artale_tag_cloud_filter($args = array()) {
   $args['smallest'] = 12;
   $args['largest'] = 12;
   $args['unit'] = 'px';
   return $args;
}

add_filter('widget_tag_cloud_args', 'artale_tag_cloud_filter', 90);

//Customise Widget Title Code
add_filter( 'dynamic_sidebar_params', 'artale_wrap_widget_titles', 1 );
function artale_wrap_widget_titles( array $params ) 
{
	$widget =& $params[0];
	$widget['before_title'] = '<h2 class="widgettitle"><span>';
	$widget['after_title'] = '</span></h2>';
	
	return $params;
}

//Control post excerpt length
function artale_custom_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'artale_custom_excerpt_length', 200 );
remove_filter( 'get_the_excerpt', 'wp_trim_excerpt' );

function artale_theme_queue_js(){
  if (is_singular() AND comments_open() AND (get_option('thread_comments') == 1)) {
      wp_enqueue_script( 'comment-reply' );
  }
}
add_action('get_header', 'artale_theme_queue_js');

add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function( $size ) {
    return array(
        'width' => 330,
        'height' => 220,
        'crop' => 0,
    );
} );

function artale_add_meta_tags() {
    $post = artale_get_wp_post();
    
    echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
    
    //Check if responsive layout is enabled
    echo '<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />';
	
	//meta for phone number link on mobile
	echo '<meta name="format-detection" content="telephone=no">';
}
add_action( 'wp_head', 'artale_add_meta_tags' , 1 );

add_filter('redirect_canonical','custom_disable_redirect_canonical');
function custom_disable_redirect_canonical($redirect_url) {if (is_paged() && is_singular()) $redirect_url = false; return $redirect_url; }

function artale_body_class_names($classes) 
{
	$post = artale_get_wp_post();
	
	if(isset($post->ID))
	{
		//Check if boxed layout is enable
		$page_boxed_layout = get_post_meta($post->ID, 'page_boxed_layout', true);
		if(!empty($page_boxed_layout))
		{
			$classes[] = esc_attr('boxed-layout');
		}
		
		//Get Page Menu Transparent Option
		$page_menu_transparent = get_post_meta($post->ID, 'page_menu_transparent', true);
		if(!empty($page_menu_transparent))
		{
			$classes[] = esc_attr('menu-transparent');
		}
	}
	
	//if password protected
	if(post_password_required())
	{
	   	$classes[] = esc_attr('password-protected');
		   
		//Get post featured image
		if(has_post_thumbnail($post->ID, 'original'))
		{
			$classes[] = esc_attr('password-protected-image');
		}
	}
	
	//Get lightbox color scheme
	$artale_lightbox_color_scheme = get_theme_mod('artale_lightbox_color_scheme', 'black');
	
	if(!empty($artale_lightbox_color_scheme))
	{
		$classes[] = esc_attr('lightbox-'.$artale_lightbox_color_scheme);
	}
	
	//Get input style
	$artale_input_style = get_theme_mod('artale_input_style', 'paper');
	
	if(!empty($artale_input_style))
	{
		$classes[] = esc_attr('artale-input-'.$artale_input_style);
	}
	
	//Get sidemenu on desktop class
	$artale_sidemenu = get_theme_mod('artale_sidemenu', false);

	if(!empty($artale_sidemenu))
	{
		$classes[] = esc_attr('sidemenu-desktop-disabled');
	}
	
	//Get main menu layout
	$artale_menu_layout = artale_menu_layout();
	if(!empty($artale_menu_layout))
	{
		$classes[] = esc_attr($artale_menu_layout);
	}
	
	//Get fotoer reveal class
	$artale_footer_reveal = get_theme_mod('artale_footer_reveal', false);
	if(!empty($artale_footer_reveal))
	{
		$classes[] = esc_attr('footer-reveal');
	}
	
	if(is_page() && !comments_open($post->ID) && !class_exists('\\Elementor\\Plugin'))
	{
		$classes[] = esc_attr('comment-close');
	}
	
	//Get single course template
	if(is_single() && is_object($post))
	{
		$artale_course_template = artale_get_single_course_template($post->ID);
		$classes[] = esc_attr('tg-single-course-'.$artale_course_template);
	}
	
	//Get single post template
	if(is_single() && is_object($post) && $post->post_type == 'post')
	{
		$post_layout = get_post_meta($post->ID, 'post_layout', true);
		$classes[] = esc_attr('themegoods-single-post-'.strtolower($post_layout));
	}
	
	//Get current user
	$current_user_id = get_current_user_id();

	if(!empty($current_user_id) && is_object($post) && function_exists('learn_press_get_current_user'))
	{
		$lp_user = learn_press_get_current_user();
		$is_enrolled = $lp_user->has_enrolled_or_finished($post->ID);
		
		if($is_enrolled)
		{
			$classes[] = esc_attr('is-enrolled');
		}
	}
	
	$artale_fullmenu_effect = get_theme_mod('artale_fullmenu_effect', '');
	if(!empty($artale_fullmenu_effect))
	{
		$classes[] = esc_attr('fullmenu-effect-'.$artale_fullmenu_effect);
	}

	return $classes;
}

function artale_password_placeholder($output) {
	$placeholder = esc_html__( "Password", 'artale' );
	$search = 'type="password"';
	return str_replace($search, $search . " placeholder=\"$placeholder\"", $output);
}
add_filter('the_password_form', 'artale_password_placeholder');

//Now add test class to the filter
add_filter('body_class','artale_body_class_names');

add_filter('wp_list_categories', 'artale_add_span_cat_count');

function artale_add_span_cat_count($links) {
	$links = str_replace('</a> (', '</a> <span class="cat-count">', $links);
	$links = str_replace(')', '</span>', $links);
	return $links;
}

add_filter('get_archives_link', 'artale_add_span_archive_count');

function artale_add_span_archive_count($links) {
	$links = str_replace('</a>&nbsp;(', '</a> <span class="archive-count">', $links);
	$links = str_replace(')', '</span>', $links);
	return $links;
}

//Custom font installation after importing demo
$artale_installed_default_font = get_option('artale_installed_default_font');

if(class_exists('Bsf_Custom_Fonts_Taxonomy') && empty($artale_installed_default_font)) {
	add_action('init', 'artale_update_font_url_after_import');
	
	function artale_update_font_url_after_import() {
	    $bsf_custom_fonts = get_terms(  array('taxonomy' => 'bsf_custom_fonts','hide_empty' => false) );
		$count_installed_font = 0;
		
		if(is_array($bsf_custom_fonts) && !empty($bsf_custom_fonts))
		{
			foreach($bsf_custom_fonts as $bsf_custom_font)
			{
				//2nd demo font
				if($bsf_custom_font->name == 'deriviaregular')
				{	
					//Get current font data
					$current_font_data = Bsf_Custom_Fonts_Taxonomy::get_font_links($bsf_custom_font->term_id);
					//var_dump($current_font_data);
					
					//Get font URL
					$uploaded_font_file_url = artale_get_attachment_url_by_slug('derivia-regular-webfont');
					//var_dump($uploaded_font_file_url); 
					
					//If empty then fallback to default file from theme folder
					if(empty($uploaded_font_file_url)) {
						$uploaded_font_file_url = get_template_directory_uri().'/fonts/derivia-regular-webfont.woff';
					}
					
					if(!isset($current_font_data['font_woff_2-0']) OR empty($current_font_data['font_woff_2-0']) && !empty($uploaded_font_file_url))
					//if(true)
					{
						Bsf_Custom_Fonts_Taxonomy::update_font_links(array('font_woff_2-0' => $uploaded_font_file_url),$bsf_custom_font->term_id);
						$count_installed_font++;
					}
				}
				
				//If install all fonts then mark as font installed
				if($count_installed_font == 3)
				{
					update_option( 'artale_installed_default_font', true );
				}
			}
		}
	}
}

if( is_admin() ){
	add_action( 'wp_default_scripts', 'artale_default_custom_scripts' );
	function artale_default_custom_scripts( $scripts ){
		$scripts->add( 'wp-color-picker', "/wp-admin/js/color-picker.js", array( 'iris' ), false, 1 );
		did_action( 'init' ) && $scripts->localize(
			'wp-color-picker',
			'wpColorPickerL10n',
			array(
				'clear'            => esc_html__( 'Clear', 'artale' ),
				'clearAriaLabel'   => esc_html__( 'Clear color', 'artale' ),
				'defaultString'    => esc_html__( 'Default', 'artale' ),
				'defaultAriaLabel' => esc_html__( 'Select default color', 'artale' ),
				'pick'             => esc_html__( 'Select Color', 'artale' ),
				'defaultLabel'     => esc_html__( 'Color value', 'artale' ),
			)
		);
	}
}

$font_files_to_remove = artale_display_font_files_with_title_starting_with('beyond');

if(!empty($font_files_to_remove)) {
	foreach($font_files_to_remove as $font_file) {
		if(!empty($font_file->ID)) {
			wp_delete_attachment($font_file->ID, true);
		}
	}
}
?>