<?php
//Setup theme constant and default data
$theme_obj = wp_get_theme('artale');

define("ARTALE_THEMENAME", $theme_obj['Name']);
if (!defined('ARTALE_THEMEDEMO'))
{
	define("ARTALE_THEMEDEMO", false);
}

define("ARTALE_THEMEVERSION", $theme_obj['Version']);
define("ARTALE_THEMEDEMOURL", $theme_obj['ThemeURI']);
define("ARTALE_MEGAMENU", true);

define("THEMEGOODS_API", 'http://license.themegoods.com/manager/wp-json/envato');
define("THEMEGOODS_PURCHASE_URL", 'https://1.envato.market/anz40o');

if (!defined('ARTALE_THEMEDATEFORMAT'))
{
	define("ARTALE_THEMEDATEFORMAT", get_option('date_format'));
}

if (!defined('ARTALE_THEMETIMEFORMAT'))
{
	define("ARTALE_THEMETIMEFORMAT", get_option('time_format'));
}

//Theme Envato item ID
if (!defined('ENVATOITEMID'))
{
	define("ENVATOITEMID", 31670402);
}

//Get default WP uploads folder
$wp_upload_arr = wp_upload_dir();
define("ARTALE_THEMEUPLOAD", $wp_upload_arr['basedir']."/".strtolower(sanitize_title(ARTALE_THEMENAME))."/");
define("ARTALE_THEMEUPLOADURL", $wp_upload_arr['baseurl']."/".strtolower(sanitize_title(ARTALE_THEMENAME))."/");

if(!is_dir(ARTALE_THEMEUPLOAD))
{
	wp_mkdir_p(ARTALE_THEMEUPLOAD);
}

/**
*  Begin Global variables functions
*/

//Get default WordPress post variable
function artale_get_wp_post() {
	global $post;
	return $post;
}

//Get default WordPress file system variable
function artale_get_wp_filesystem() {
	require_once(ABSPATH . 'wp-admin/includes/file.php');
	WP_Filesystem();
	global $wp_filesystem;
	return $wp_filesystem;
}

//Get default WordPress wpdb variable
function artale_get_wpdb() {
	global $wpdb;
	return $wpdb;
}

//Get default WordPress wp_query variable
function artale_get_wp_query() {
	global $wp_query;
	return $wp_query;
}

//Get default WordPress customize variable
function artale_get_wp_customize() {
	global $wp_customize;
	return $wp_customize;
}

//Get default WordPress current screen variable
function artale_get_current_screen() {
	global $current_screen;
	return $current_screen;
}

//Get default WordPress paged variable
function artale_get_paged() {
	global $paged;
	return $paged;
}

//Get default WordPress registered widgets variable
function artale_get_registered_widget_controls() {
	global $wp_registered_widget_controls;
	return $wp_registered_widget_controls;
}

//Get default WordPress registered sidebars variable
function artale_get_registered_sidebars() {
	global $wp_registered_sidebars;
	return $wp_registered_sidebars;
}

//Get default Woocommerce variable
function artale_get_woocommerce() {
	global $woocommerce;
	return $woocommerce;
}

//Get all google font usages in customizer
function artale_get_google_fonts() {
	$artale_google_fonts = array('artale_body_font', 'artale_header_font', 'artale_menu_font', 'artale_sidemenu_font', 'artale_sidebar_title_font', 'artale_button_font');
	
	global $artale_google_fonts;
	return $artale_google_fonts;
}

//Get menu transparent variable
function artale_get_page_menu_transparent() {
	global $artale_page_menu_transparent;
	return $artale_page_menu_transparent;
}

//Set menu transparent variable
function artale_set_page_menu_transparent($new_value = '') {
	global $artale_page_menu_transparent;
	$artale_page_menu_transparent = $new_value;
}

//Get no header checker variable
function artale_get_is_no_header() {
	global $artale_is_no_header;
	return $artale_is_no_header;
}

//Get deafult theme screen CSS class
function artale_get_screen_class() {
	global $artale_screen_class;
	return $artale_screen_class;
}

//Set deafult theme screen CSS class
function artale_set_screen_class($new_value = '') {
	global $artale_screen_class;
	$artale_screen_class = $new_value;
}

//Get theme homepage style
function artale_get_homepage_style() {
	global $artale_homepage_style;
	return $artale_homepage_style;
}

//Set theme homepage style
function artale_set_homepage_style($new_value = '') {
	global $artale_homepage_style;
	$artale_homepage_style = $new_value;
}

//Get page gallery ID
function artale_get_page_gallery_id() {
	global $artale_page_gallery_id;
	return $artale_page_gallery_id;
}

//Get default theme options variable
function artale_get_options() {
	global $artale_options;
	return $artale_options;
}

//Set default theme options variable
function artale_set_options($new_value = '') {
	global $artale_options;
	$artale_options = $new_value;
}

//Get top bar setting
function artale_get_topbar() {
	global $artale_topbar;
	return $artale_topbar;
}

//Set top bar setting
function artale_set_topbar($new_value = '') {
	global $artale_topbar;
	$artale_topbar = $new_value;
}

//Get is hide title option
function artale_get_hide_title() {
	global $artale_hide_title;
	return $artale_hide_title;
}

//Set is hide title option
function artale_set_hide_title($new_value = '') {
	global $artale_hide_title;
	$artale_hide_title = $new_value;
}

//Get theme page content CSS class
function artale_get_page_content_class() {
	global $artale_page_content_class;
	return $artale_page_content_class;
}

//Set theme page content CSS class
function artale_set_page_content_class($new_value = '') {
	global $artale_page_content_class;
	$artale_page_content_class = $new_value;
}

//Get Kirki global variable
function artale_get_kirki() {
	global $kirki;
	return $kirki;
}

//Get admin theme global variable
function artale_get_wp_admin_css_colors() {
	global $_wp_admin_css_colors;
	return $_wp_admin_css_colors;
}

//Get theme plugins
function artale_get_plugins() {
	global $artale_tgm_plugins;
	return $artale_tgm_plugins;
}

//Set theme plugins
function artale_set_plugins($new_value = '') {
	global $artale_tgm_plugins;
	$artale_tgm_plugins = $new_value;
}

$is_verified_envato_purchase_code = false;

//Get verified purchase code data
$pp_verified_envato_artale = get_option("pp_verified_envato_artale");
if(!empty($pp_verified_envato_artale))
{
	$is_verified_envato_purchase_code = true;
}

$is_imported_elementor_templates_artale = false;
$pp_imported_elementor_templates_artale = get_option("pp_imported_elementor_templates_artale");
if(!empty($pp_imported_elementor_templates_artale))
{
	$is_imported_elementor_templates_artale = true;
}
?>