<?php	
/*
Theme Name: Artale Theme
Theme URI: https://themes.themegoods.com/artale/landing
Author: ThemeGoods
Author URI: http://themeforest.net/user/ThemeGoods
License: GPLv2
*/

//Setup theme default constant and data
require_once get_template_directory() . "/lib/config.php";

//Setup theme translation
require_once get_template_directory() . "/lib/translation.php";

//Setup theme support and image size handler
require_once get_template_directory() . "/lib/theme-support.php";

//Get custom function
require_once get_template_directory() . "/lib/custom-functions.php";

//Setup menu settings
require_once get_template_directory() . "/lib/menu.php";

//Setup Sidebar
require_once get_template_directory() . "/lib/sidebar.php";

//Setup required plugin activation
require_once get_template_directory() . "/lib/tgmpa-extension.php";

//Setup theme admin settings
require_once get_template_directory() . "/lib/theme-setting.php";

//Setup theme admin pointers
require_once get_template_directory() . "/lib/admin.pointer.lib.php";

/**
*	Begin Theme Setting Panel
**/ 

function artale_add_admin() 
{
	$artale_options = artale_get_options();
	$redirect_uri = '';
	 
	if (is_admin() && current_user_can('manage_options') && isset($_REQUEST['_wpnonce']) && wp_verify_nonce($_REQUEST['_wpnonce'], 'artale_save_theme_setting') && isset($_REQUEST['action']) && 'save' == $_REQUEST['action']) {
	
		//check if verify purchase code
		if(isset($_REQUEST['submit']) && $_REQUEST['submit'] == 'Register')
		{
			if(!empty($_REQUEST['pp_envato_personal_token']) && strlen($_REQUEST['pp_envato_personal_token']) == 36) {
				$url = THEMEGOODS_API.'/register-purchase';
				$data = array(
					'purchase_code' => $_REQUEST['pp_envato_personal_token'], 
					'domain' => $_REQUEST['themegoods-site-domain'],
					'item_id' => ENVATOITEMID,
				);
				$data = wp_json_encode( $data );
				$args = array( 
					'method'   	=> 'POST',
					'body'		=> $data,
				);
				//print '<pre>'; var_dump($args); print '</pre>';
				
				$response = wp_remote_post( $url, $args );
				$response_body = wp_remote_retrieve_body( $response );
				$response_obj = json_decode($response_body);
				
				$response_json = urlencode($response_body);
				//print '<pre>'; var_dump($response_body); print '</pre>';
				//print '<pre>'; var_dump("admin.php?page=functions.php&response=".$response_json."".$redirect_uri.$_REQUEST['current_tab']); print '</pre>';
				//die;
				
				if(is_bool($response_obj->response_code)) {
					if($response_obj->response_code) {
						$success_message = "Purchase code is registered.";
						
						if(!empty($response_obj->response)) {
							$error_message = $response_obj->response;
						}
						
						artale_register_theme($_REQUEST['pp_envato_personal_token']);
						wp_redirect(admin_url()."?page=functions.php&purchase_code=".$_REQUEST['pp_envato_personal_token']."&response=".$response_json."".$redirect_uri.$_REQUEST['current_tab']);
						
						die;
					}
					else {
						$error_message = "Purchase code is invalid.";
						
						wp_redirect(admin_url()."?page=functions.php&purchase_code=".$_REQUEST['pp_envato_personal_token']."&response=".$response_json."".$redirect_uri.$_REQUEST['current_tab']);
						
						die;
					}
				}
				else {
					$error_message = "Purchase code is invalid";
					
					wp_redirect(admin_url()."?page=functions.php&purchase_code=".$_REQUEST['pp_envato_personal_token']."&response=".$response_json."".$redirect_uri.$_REQUEST['current_tab']);
					
					die;
				}
			}
			else {
				$error_message = "Purchase code is invalid";
				wp_redirect(admin_url()."?page=functions.php&purchase_code=".$_REQUEST['pp_envato_personal_token']."&response=".$response_json."".$redirect_uri.$_REQUEST['current_tab']);
				
				die;
			}
		}
		
		//check if unregister purchase code
		if(isset($_REQUEST['submit']) && $_REQUEST['submit'] == 'Unregister')
		{
			if(!empty($_REQUEST['pp_envato_personal_token']) && strlen($_REQUEST['pp_envato_personal_token']) == 36) {
				$url = THEMEGOODS_API.'/unregister-purchase';
				$data = array(
					'purchase_code' => $_REQUEST['pp_envato_personal_token'], 
					'domain' => $_REQUEST['themegoods-site-domain'],
					'item_id' => ENVATOITEMID,
				);
				$data = wp_json_encode( $data );
				$args = array( 
					'method'   	=> 'POST',
					'body'		=> $data,
				);
				$response = wp_remote_post( $url, $args );
				$response_body = wp_remote_retrieve_body( $response );
				$response_obj = json_decode($response_body);
				
				$response_json = urlencode($response_body);
				/*print '<pre>'; var_dump($args); print '</pre>';
				print '<pre>'; var_dump($response_json); print '</pre>';
				die;*/
				if(is_bool($response_obj->response_code)) {
					if($response_obj->response_code) {
						$success_message = "Purchase code is unregistered.";
						
						if(!empty($response_obj->response)) {
							$error_message = $response_obj->response;
						}
						
						artale_unregister_theme();
						wp_redirect(admin_url()."?page=functions.php&response=".$response_json."".$redirect_uri.$_REQUEST['current_tab']);
						
						die;
					}
					else {
						$error_message = "Purchase code is invalid.";
						
						wp_redirect(admin_url()."?page=functions.php&purchase_code=".$_REQUEST['pp_envato_personal_token']."&response=".$response_json."".$redirect_uri.$_REQUEST['current_tab']);
						
						die;
					}
				}
				else {
					$error_message = "Purchase code is invalid";
					
					wp_redirect(admin_url()."?page=functions.php&purchase_code=".$_REQUEST['pp_envato_personal_token']."&response=".$response_json."".$redirect_uri.$_REQUEST['current_tab']);
					
					die;
				}
			}
			else {
				$error_message = "Purchase code is invalid";
				wp_redirect(admin_url()."?page=functions.php&purchase_code=".$_REQUEST['pp_envato_personal_token']."&response=".$response_json."".$redirect_uri.$_REQUEST['current_tab']);
				
				die;
			}
		}
	
		foreach ($artale_options as $value) 
		{
			if($value['type'] != 'image' && isset($value['id']) && isset($_REQUEST[ $value['id'] ]))
			{
				update_option( $value['id'], $_REQUEST[ $value['id'] ] );
			}
		}
		
		foreach ($artale_options as $value) {
		
			if( isset($value['id']) && isset( $_REQUEST[ $value['id'] ] )) 
			{ 
	
				if($value['id'] != "pp_sidebar0" && $value['id'] != "pp_ggfont0")
				{
					if(is_admin())
					{
						if($value['type']=='image')
						{
							update_option( $value['id'], esc_url($_REQUEST[ $value['id'] ])  );
						}
						elseif($value['type']=='textarea')
						{
							if(isset($value['validation']) && !empty($value['validation']))
							{
								update_option( $value['id'], esc_textarea($_REQUEST[ $value['id'] ]) );
							}
							else
							{
								update_option( $value['id'], $_REQUEST[ $value['id'] ] );
							}
						}
						elseif($value['type']=='iphone_checkboxes' OR $value['type']=='jslider')
						{
							update_option( $value['id'], $_REQUEST[ $value['id'] ]  );
						}
						else
						{
							if(isset($value['validation']) && !empty($value['validation']))
							{
								$request_value = $_REQUEST[ $value['id'] ];
								
								//Begin data validation
								switch($value['validation'])
								{
									case 'text':
									default:
										$request_value = sanitize_text_field($request_value);
									
									break;
									
									case 'email':
										$request_value = sanitize_email($request_value);
	
									break;
									
									case 'javascript':
										$request_value = sanitize_text_field($request_value);
	
									break;
									
								}
								update_option( $value['id'], $request_value);
							}
							else
							{
								update_option( $value['id'], $_REQUEST[ $value['id'] ]  );
							}
						}
					}
				}
			} 
			else 
			{ 
				if(is_admin() && isset($value['id']))
				{
					delete_option( $value['id'] );
				}
			} 
		}
	
		header("Location: admin.php?page=functions.php&saved=true".$redirect_uri.$_REQUEST['current_tab']);
	}
	 
	add_menu_page('Theme Setting', 'Theme Setting', 'administrator', 'functions.php', 'artale_admin', '', 3);
}

function artale_enqueue_admin_page_scripts() 
{
	$current_screen = artale_get_current_screen();
	
	//Enqueue CSS scripts for backend
	wp_enqueue_style('thickbox');
	wp_enqueue_style('artale-functions', get_template_directory_uri().'/backend/css/functions.css', false, '', 'all');
	wp_enqueue_style('tooltipster', get_template_directory_uri().'/css/tooltipster.css', false, '', 'all');

	wp_enqueue_style('switchery', get_template_directory_uri().'/backend/css/switchery.css', false, '', 'all');
	
	$is_elementor_edit_mode = false;
	$is_elementor_preview_mode = false;
	if (class_exists('\\Elementor\\Plugin')) {
		$is_elementor_edit_mode = \Elementor\Plugin::$instance->editor->is_edit_mode();
		$is_elementor_preview_mode = \Elementor\Plugin::$instance->preview->is_preview_mode();
	}
	
	if(!$is_elementor_edit_mode && !$is_elementor_preview_mode)
	{
		wp_enqueue_style('fontawesome', get_template_directory_uri().'/css/font-awesome.min.css', false, '', 'all');
	}
	
	//Enqueue JS scripts for backend
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-tabs');
	wp_enqueue_script('media-upload');
	wp_enqueue_script('thickbox');
	wp_enqueue_script('jquery-ui-datepicker');
	
	$ap_vars = array(
	    'url' => esc_url(get_home_url('/')),
	    'includes_url' => esc_url(includes_url())
	);
	
	wp_enqueue_script('switchery', get_template_directory_uri().'/backend/switchery.js', false, '');
	wp_enqueue_script('tooltipster', get_template_directory_uri().'/js/jquery-tooltipster.js', false, '', true);
	
	$custom_tooltipster_script = '
	jQuery(function( $ ) {
		jQuery(".tooltipster").tooltipster({
			position: "left",
			multiple: true,
			theme: "tooltipster-shadow",
			delay: 0
		});
	});
	';
	wp_add_inline_script( 'tooltipster', $custom_tooltipster_script );
	
	wp_register_script('artale-theme-script', get_template_directory_uri().'/backend/main-script.js', false, '', true);
	$params = array(
	  'ajaxurl' => esc_url(admin_url('admin-ajax.php')),
	  'nonce' => wp_create_nonce( 'wp_rest' ),
	  'tgurl' => THEMEGOODS_API,
	  'itemid' => ENVATOITEMID,
	  'purchaseurl' => THEMEGOODS_PURCHASE_URL,
	);
	wp_localize_script('artale-theme-script', 'tgAjax', $params );
	wp_enqueue_script('artale-theme-script');
}

add_action('admin_enqueue_scripts',	'artale_enqueue_admin_page_scripts' );

function artale_enqueue_front_page_scripts() 
{
	wp_enqueue_style('dashicons');
	wp_enqueue_style('artale-reset-css', get_template_directory_uri().'/css/core/reset.css', false, '');
	wp_enqueue_style('artale-wordpress-css', get_template_directory_uri().'/css/core/wordpress.css', false, '');
	wp_enqueue_style('artale-screen', get_template_directory_uri().'/css/core/screen.css', false, '', 'all');
	wp_enqueue_style('modulobox', get_template_directory_uri().'/css/modulobox.css', false, false, 'all' );
	
	//Check menu layout
	$artale_menu_layout = artale_menu_layout();
	
	switch($artale_menu_layout)
	{
		case 'leftalign':
			wp_enqueue_style('artale-left-align-menu', get_template_directory_uri().'/css/menus/left-align-menu.css', false, '', 'all');
		break;
		
		case 'full-burger-menu':
			wp_enqueue_style('artale-full-burger-menu', get_template_directory_uri().'/css/menus/full-burger-menu.css', false, '', 'all');
		break;
		
		case 'center-menu-logo':
			wp_enqueue_style('artale-center-menu-logo', get_template_directory_uri().'/css/menus/center-menu-logo.css', false, '', 'all');
		break;
	}
	
	//Add Font Awesome Support
	wp_enqueue_style('fontawesome', get_template_directory_uri().'/css/font-awesome.min.css', false, '', 'all');
	wp_enqueue_style('themify-icons', get_template_directory_uri().'/css/themify-icons.css', false, '', 'all');
	wp_enqueue_style('tooltipster', get_template_directory_uri().'/css/tooltipster.css', false, '', 'all');
    
    $artale_frame = get_theme_mod('artale_frame', false);
    if(!empty($artale_frame))
    {
    	wp_enqueue_style('artale-frame', get_template_directory_uri().'/css/core/frame.css', false, '', 'all');
    }
	
	if(ARTALE_THEMEDEMO)
    {
	    wp_enqueue_style('artale-demo', get_template_directory_uri().'/css/core/demo.css', false, '', 'all');
	}
	
	//If using child theme
	if(is_child_theme())
	{
	    wp_enqueue_style('artale-childtheme', get_template_directory_uri().'/style.css', false, '', 'all');
	}
	
	//Enqueue javascripts
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script('jquery-effects-core');
	wp_enqueue_script('tweenmax', get_template_directory_uri().'/js/tweenmax.min.js', false, '', true);
	wp_enqueue_script('waypoints', get_template_directory_uri().'/js/waypoints.min.js', false, '', true);
	wp_enqueue_script('stellar', get_template_directory_uri().'/js/jquery-stellar.js', false, '', true);
	wp_enqueue_script('modulobox', get_template_directory_uri().'/js/modulobox.js', false, '', true);
	wp_enqueue_script('smoove', get_template_directory_uri().'/js/jquery-smoove.js', false, '', true);
	
	//Register theme javascript plugin file
	wp_register_script('artale-custom-plugins', get_template_directory_uri().'/js/core/artale-plugins.js', false, '', true);
	$params = array(
		'backTitle' 		=> esc_html__('Back', 'artale' ),
	);
	wp_localize_script( 'artale-custom-plugins', 'artalePluginParams', $params );
	wp_enqueue_script( 'artale-custom-plugins' );
	
	//Get settings params
	
	//Register theme main javascript file
	wp_register_script('artale-custom-script', get_template_directory_uri().'/js/core/artale-custom.js', false, '', true);
	$params = array(
	  'ajaxurl' => esc_url(admin_url('admin-ajax.php')),
	);
	wp_localize_script('artale-custom-script', 'tgAjax', $params );
	wp_enqueue_script('artale-custom-script');
	
	//Get settings params
	$artale_menu_layout = artale_menu_layout();
	$artale_fixed_menu = get_theme_mod('artale_fixed_menu', true);
	$artale_footer_reveal = get_theme_mod('artale_footer_reveal', false);
	$artale_header_content = get_theme_mod('artale_header_content', 'menu');
	$artale_topbar = get_theme_mod('artale_topbar', false);
	$artale_lightbox_thumbnails = get_theme_mod('artale_lightbox_thumbnails', 'thumbnail');
	$artale_lightbox_timer = get_theme_mod('artale_lightbox_timer', 7);
	
	$params = array(
		'menulayout' 		=> $artale_menu_layout,
		'fixedmenu' 		=> $artale_fixed_menu,
		'footerreveal' 		=> $artale_footer_reveal,
		'headercontent' 	=> $artale_header_content,
		'lightboxthumbnails' => $artale_lightbox_thumbnails,
		'lightboxtimer' 	=> intval($artale_lightbox_timer*1000),
	);
	wp_localize_script( 'artale-custom-script', 'artaleParams', $params );
	wp_enqueue_script( 'artale-custom-script' );
	
	//Check if disable right click
	$artale_enable_right_click = get_theme_mod('artale_enable_right_click', false);
	if(!empty($artale_enable_right_click))
	{
		$custom_right_click_script = '
		jQuery(function( $ ) {
			jQuery(document).bind("contextmenu", function(e) {
				jQuery("#right-click-content").addClass("visible");
				jQuery("body").addClass("right-clicked");
		    	e.preventDefault();
		    	
		    	jQuery(document).mousedown(function(event) {
			    	jQuery("#right-click-content").removeClass("visible");
					jQuery("body").removeClass("right-clicked");
			    });
		    });
		});
		';
		
		wp_add_inline_script( 'artale-custom-script', $custom_right_click_script );
	}
	
	$artale_enable_dragging = get_theme_mod('artale_enable_dragging', false);
	if(!empty($artale_enable_dragging))
	{
		$custom_drag_script = '
		jQuery(function( $ ) {
			jQuery("img").on("dragstart", function(event) { event.preventDefault(); });
		});
		';
		
		wp_add_inline_script( 'artale-custom-script', $custom_drag_script );
	}
	
	//Check if sticky sidebar
	$artale_sidebar_sticky = get_theme_mod('artale_sidebar_sticky', false);
	
	if(!empty($artale_sidebar_sticky))
	{
		wp_enqueue_script('sticky-sidebar', get_template_directory_uri().'/js/jquery.sticky-sidebar.js', false, '', true);
		
		$custom_sticky_kit_script = '
		jQuery(function( $ ) {
			jQuery("#page-content-wrapper .inner .sidebar-wrapper .sidebar").stickySidebar({
				topSpacing: 120,
				bottomSpacing: 100
			});
		});
		';
		
		wp_add_inline_script( 'sticky-sidebar', $custom_sticky_kit_script );
	}
	
	//Check if enable lazy load image
	$artale_enable_lazy_loading = get_theme_mod('artale_enable_lazy_loading', true);
		
	if(!empty($artale_enable_lazy_loading))
	{
		wp_enqueue_script('lazy', get_template_directory_uri().'/js/jquery-lazy.js', false, '', true);
		$custom_lazy_script = '
		jQuery(function( $ ) {
			jQuery("img.lazy").each(function() {
				var currentImg = jQuery(this);
				
				jQuery(this).Lazy({
					onFinishedAll: function() {
						currentImg.parent("div.post-featured-image-hover").removeClass("lazy");
						currentImg.parent(".artale_gallery_lightbox").parent("div.gallery_grid_item").removeClass("lazy");
						currentImg.parent("div.gallery_grid_item").removeClass("lazy");
			        }
				});
			});
		});
		';
		
		wp_add_inline_script( 'lazy', $custom_lazy_script );
	}
	
	wp_enqueue_script('tooltipster', get_template_directory_uri().'/js/jquery-tooltipster.js', false, '', true);
	
	$custom_tooltipster_script = '
	jQuery(function( $ ) {
		jQuery(".demotip").tooltipster({
			position: "left",
			multiple: true,
			theme: "tooltipster-shadow",
			delay: 0
		});
	});
	';
	
	if(class_exists('LP_Global'))
	{
		$custom_tooltipster_script .= '
		jQuery("body.learnpress.profile .course-tooltip").tooltipster({
			position: "right",
			multiple: true,
			contentCloning: true,
			theme: "tooltipster-shadow",
			minWidth: 300,
			maxWidth: 300,
			delay: 50,
			interactive: true,
		});
		';
	}
	
	wp_add_inline_script( 'tooltipster', $custom_tooltipster_script );
	
	//Add parallax script effect
	wp_enqueue_script('jarallax', get_template_directory_uri().'/js/jarallax.js', false, '', true);
	
	$custom_parallax_script = '
	jQuery(document).ready(function(){ 
		jQuery(".themegoods-parallax").jarallax({
			speed: 0.8
		});
	});
	';
	
	wp_add_inline_script( 'jarallax', $custom_parallax_script );
	
}
add_action( 'wp_enqueue_scripts', 'artale_enqueue_front_page_scripts' );


//Enqueue mobile CSS after all others CSS load
function artale_register_mobile_css() 
{
	//Check if enable responsive layout
	wp_enqueue_style('artale-script-responsive-css', get_template_directory_uri().'/css/core/responsive.css', false, '', 'all');
}
add_action('wp_enqueue_scripts', 'artale_register_mobile_css', 99);


function artale_admin() 
{ 
	$artale_options = artale_get_options();
	
	if(function_exists( 'wp_enqueue_media' )){
	    wp_enqueue_media();
	}
	?>
		
		<form id="theme-setting-form" method="post" enctype="multipart/form-data">
		<div class="theme-setting-wrapper setting-wrapper">
		
		<div class="header-wrapper">
			<div class="header-logo">
			<?php
				//Display logo in theme setting
				$artale_retina_logo_for_admin = get_theme_mod('artale_retina_logo_for_admin');
				$artale_retina_logo = get_theme_mod('artale_retina_logo');
				
				if(empty($artale_retina_logo_for_admin))
				{
			?>
			<h2><?php esc_html_e('Theme Setting', 'artale' ); ?><span class="theme-version"><?php esc_html_e('Version', 'artale' ); ?> <?php echo ARTALE_THEMEVERSION; ?></span></h2>
			<?php
				}
				else if(!empty($artale_retina_logo))
				{
			?>
			<div class="theme-setting-logo-wrapper">
			<?php
					//Get image width and height
			    	$image_id = artale_get_image_id($artale_retina_logo);
			    	if(!empty($image_id))
			    	{
			    		$obj_image = wp_get_attachment_image_src($image_id, 'original');
			    		
			    		$image_width = 0;
				    	$image_height = 0;
				    	
				    	if(isset($obj_image[1]))
				    	{
				    		$image_width = intval($obj_image[1]/2);
				    	}
				    	if(isset($obj_image[2]))
				    	{
				    		$image_height = intval($obj_image[2]/2);
				    	}
			    	}
			    	else
			    	{
				    	$image_width = 0;
				    	$image_height = 0;
			    	}
						
					if($image_width > 0 && $image_height > 0)
					{
					?>
					<img src="<?php echo esc_url($artale_retina_logo); ?>" alt="<?php esc_attr(get_bloginfo('name')); ?>" width="<?php echo esc_attr($image_width); ?>" height="<?php echo esc_attr($image_height); ?>"/>
					<?php
					}
					else
					{
					?>
	    	    	<img src="<?php echo esc_url($artale_retina_logo); ?>" alt="<?php esc_attr(get_bloginfo('name')); ?>" width="126" height ="32"/>
	    	    <?php 
		    	    }
		    	?>
		    	<span class="theme-version"><?php esc_html_e('Version', 'artale' ); ?> <?php echo ARTALE_THEMEVERSION; ?></span>
			</div>
			<?php
				}
			?>
			</div>
			<div class="pp-wrap-save-setting">
				<input type="hidden" name="action" value="save" />
				<input type="hidden" name="current_tab" id="current_tab" value="#setting-panel-registration" />
				<?php wp_nonce_field('artale_save_theme_setting'); ?>
			</div>
			<input type="hidden" name="pp_admin_url" id="pp_admin_url" value="<?php echo esc_url(get_template_directory_uri()); ?>"/>
			<br class="clear"/>
	
		</div>
		
		<div class="theme-setting-wrapper">
		<div id="theme-setting-panel">
		<?php 
			foreach ($artale_options as $value) {
				
				$active = '';
				
				if($value['type'] == 'section')
				{
					if($value['name'] == 'Registration')
					{
						$active = 'nav-tab-active';
					}
					
					echo '<a id="'.esc_attr('setting-panel-'.strtolower($value['name']).'-a').'" href="'.esc_url('').'" data-section="'.esc_attr('setting-panel-'.strtolower($value['name'])).'" class="nav-tab '.esc_attr($active).'"><span class="dashicons  '.esc_attr($value['icon']).'"></span>'.str_replace('-', ' ', $value['name']).'</a>';
				}
			}
		?>
		</h2>
		</div>
	
		<div class="setting-options-content">
		
		<?php 
		foreach ($artale_options as $value) {
			
			//Change underscore to dash
			$option_section_class = '';
			if(isset($value['id']))
			{
				$option_section_id = $value['id'];
				$option_section_class = str_replace('_', '-', $option_section_id);
			}
				
			switch ( $value['type'] ) {
			 
			case "open":
		?> 
			
		<?php break;
			 
			case "close":
		?>
				
				</div>
				</div>
			
			
		<?php break;
			 
			case "title":
		?>
			
			
		<?php break;
			 
			case 'text':
				
				//if sidebar input then not show default value
				$default_val = get_option( $value['id'] );
			?>
			
				<div id="<?php echo esc_attr($option_section_class.'-section'); ?>" class="setting-options-input rm_text"><label for="<?php echo esc_attr($value['id']); ?>"><?php echo esc_html(stripslashes($value['name'])); ?></label>
				
				<small class="description"><?php echo esc_html(stripslashes($value['desc'])); ?></small>
				
				<input name="<?php echo esc_attr($value['id']); ?>"
					id="<?php echo esc_attr($value['id']); ?>" type="<?php echo esc_attr($value['type']); ?>"
					value="<?php if ($default_val != "") { echo esc_attr(get_option( $value['id'])) ; } else { echo esc_attr($value['std']); } ?>" />
				<div class="clearfix"></div>
			
				</div>
		<?php
			break;
			 
			case 'textarea':
			?>
			
				<div id="<?php echo esc_attr($option_section_class); ?>-section" class="setting-options-input rm_textarea"><label
					for="<?php echo esc_attr($value['id']); ?>"><?php echo esc_html(stripslashes($value['name'])); ?></label>
					
				<small class="description"><?php echo esc_html(stripslashes($value['desc'])); ?></small>
				
				<textarea id="<?php echo esc_attr($value['id']); ?>" name="<?php echo esc_attr($value['id']); ?>"
					type="<?php echo esc_attr($value['type']); ?>" cols="" rows=""><?php if ( get_option( $value['id'] ) != "") { echo esc_html(stripslashes(get_option( $value['id']) )); } else { echo esc_html($value['std']); } ?></textarea>
				
				<div class="clearfix"></div>
			
				</div>
			
		<?php
			break;
			 
			case "checkbox":
		?>
			
				<div id="<?php echo esc_attr($option_section_class); ?>-section" class="setting-options-input rm_checkbox"><label
					for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
			
				<?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
				<input type="checkbox" name="<?php echo esc_attr($value['id']); ?>"
					id="<?php echo esc_attr($value['id']); ?>" value="true" <?php echo esc_html($checked); ?> />
			
			
				<small class="description"><?php echo esc_html(stripslashes($value['desc'])); ?></small>
				<div class="clearfix"></div>
				</div>
		<?php break; 
			
			case "iphone_checkboxes":
		?>
			
				<div id="<?php echo esc_attr($option_section_class); ?>-section" class="setting-options-input rm_checkbox"><label
					for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label>
			
				<small class="description"><?php echo esc_html(stripslashes($value['desc'])); ?></small>
			
				<?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
				<input type="checkbox" class="iphone_checkboxes" name="<?php echo esc_attr($value['id']); ?>"
					id="<?php echo esc_attr($value['id']); ?>" value="true" <?php echo esc_html($checked); ?> />
			
				<div class="clearfix"></div>
				</div>
			
		<?php break; 
			
			case "html":
		?>
			
				<div id="<?php echo esc_attr($option_section_class); ?>-section" class="setting-options-input rm_checkbox"><label
					for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
			
				<small class="description"><?php echo stripslashes($value['desc']); ?></small>
			
				<?php echo stripslashes($value['html']); ?>
			
				<div class="clearfix"></div>
				</div>
			
		<?php break; 
				
			case "section":
			
		?>
			
				<div id="setting-panel-<?php echo strtolower($value['name']); ?>" class="setting-section">
				<div class="setting-options-title">
				<span class="submit"><input class="button-primary" name="save-<?php echo strtolower($value['name']); ?>" type="submit"
					value="<?php esc_attr_e('Save changes', 'artale' ); ?>" /> </span>
				<div class="clearfix"></div>
				</div>
				<div class="setting-options-wrapper"><?php break;
			 
			}
		}
		?>
	 	
	 	<div class="clearfix"></div>
	 	</form>
	 	</div>
	</div>
<?php
}

add_action('admin_menu', 'artale_add_admin');

/**
*	End Theme Setting Panel
**/ 

//Setup Theme Customizer
require_once get_template_directory() . "/modules/kirki/kirki.php";

//Setup theme custom filters
require_once get_template_directory() . "/lib/theme-filters.php";

//Setup theme learnpress plugin filters
require_once get_template_directory() . "/lib/learnpress-extension.php";

//Setup Custom Font Support
require_once get_template_directory() . "/modules/fonts/section-fonts.php";
require_once get_template_directory() . "/modules/fonts/kirki-add-fonts.php";

require_once get_template_directory() . "/lib/customizer.php";


//Check if Woocommerce is installed	
if(class_exists('Woocommerce'))
{
	//Setup Woocommerce Config
	require_once get_template_directory() . "/modules/woocommerce.php";
}

/**
*	End add product to cart function
**/

add_action('wp_ajax_kirki_dynamic_css', 'kirki_dynamic_css');
add_action('wp_ajax_nopriv_kirki_dynamic_css', 'kirki_dynamic_css');

function kirki_dynamic_css() {
	$kirki = artale_get_kirki();

	die();
}

//Setup custom settings when theme is activated
if (isset($_GET['activated']) && $_GET['activated'] && is_admin() && current_user_can('manage_options')){
	$artale_custom_fonts = get_theme_mod('artale_custom_fonts');
	$is_added_default_font = FALSE;
	
	if(!empty($artale_custom_fonts) && is_array($artale_custom_fonts))
	{
		foreach($artale_custom_fonts as $artale_custom_font)
		{
			if(isset($artale_custom_font['font_name']))
			{
				$artale_custom_font['font_name'] == 'deriviaregular';
				$is_added_default_font = TRUE;
				break;
			}
		}
	}
	$is_added_default_font = FALSE;
	if(!$is_added_default_font)
	{
		$default_custom_fonts = array(
			0 => array(
				'font_name' => 	'deriviaregular',
				'font_url' 	=>	get_template_directory_uri().'/fonts/derivia-regular-webfont.woff',
				'font_fallback'	=> 'sans-serif',
				'font_weight' => 400,
				'font_style' => 'normal',
			),
		);
		set_theme_mod( 'artale_custom_fonts', $default_custom_fonts );
	}
	
	update_option('elementor_disable_color_schemes', 'yes');
	update_option('elementor_disable_typography_schemes', 'yes');
	update_option('elementor_page_title_selector', '#page-header');
	update_option('elementor_space_between_widgets', 0);
	update_option('elementor_container_width', 1170);
	update_option('elementor_cpt_support', array('post', 'page', 'footer', 'header', 'megamenu', 'fullmenu', 'portfolios', 'galleries'));
	update_option('elementor_global_image_lightbox', 0);
	
	wp_safe_redirect(admin_url("admin.php?page=functions.php&activate=true"));
	exit;
}
?>