<?php
/**
 * The template for displaying the footer.
 *
 * @package WordPress
 */
 
?>
</div>
<?php
//if no password protected then display footer
if(!post_password_required()){
	$artale_footer_content = get_theme_mod('artale_footer_content', 'sidebar');
	$artale_footer_sidebar = get_theme_mod('artale_footer_sidebar', 3);
	
	//Check if blank template
	$artale_is_no_header = artale_get_is_no_header();
	$artale_screen_class = artale_get_screen_class();
	
	if(!is_bool($artale_is_no_header) OR !$artale_is_no_header)
	{

	$artale_homepage_style = artale_get_homepage_style();
	$artale_page_hide_footer_default = 0;
	
	if(is_page())
	{
		//Check if hide footer
		$artale_page_hide_footer_default = get_post_meta($post->ID, 'page_hide_footer', false);
	}
	
	if(empty($artale_page_hide_footer_default))
	{
?>
<div id="footer-wrapper">
<?php
//if using footer post content
if($artale_footer_content == 'content')
{
	if(is_page())
	{
		$artale_footer_content_default = get_post_meta($post->ID, 'page_footer', true);
		
		if(empty($artale_footer_content_default))
		{
			$artale_footer_content_default = get_theme_mod('artale_footer_content_default');
		}
	}
	else
	{
		$artale_footer_content_default = get_theme_mod('artale_footer_content_default');
	}
	
	//Add Polylang plugin support
	if (function_exists('pll_get_post')) {
		$artale_footer_content_default = pll_get_post($artale_footer_content_default);
	}
	
	//Add WPML plugin support
	if (function_exists('icl_object_id')) {
		$artale_footer_content_default = icl_object_id($artale_footer_content_default, 'page', false, ICL_LANGUAGE_CODE);
	}

	if(!empty($artale_footer_content_default) && class_exists("\\Elementor\\Plugin"))
	{
		echo artale_get_elementor_content($artale_footer_content_default);
	}	
}
//end if using footer post content

//if use footer sidebar as content
else if($artale_footer_content == 'sidebar')
{
	//Check if page type
	if(is_page())
	{
		$page_show_footer_sidebar = get_post_meta($post->ID, 'page_show_footer_sidebar', true);
	}
	else
	{
		$page_show_footer_sidebar = 0;
	}
	
    if(!empty($artale_footer_sidebar) && empty($page_show_footer_sidebar))
    {
    	$footer_class = '';
    	
    	switch($artale_footer_sidebar)
    	{
    		case 1:
    			$footer_class = 'one';
    		break;
    		case 2:
    			$footer_class = 'two';
    		break;
    		case 3:
    			$footer_class = 'three';
    		break;
    		case 4:
    			$footer_class = 'four';
    		break;
    		default:
    			$footer_class = 'four';
    		break;
    	}
?>
<div id="footer" class="<?php if(isset($artale_homepage_style) && !empty($artale_homepage_style)) { echo esc_attr($artale_homepage_style); } ?> <?php if(!empty($artale_screen_class)) { echo esc_attr($artale_screen_class); } ?>">
<?php
	if(is_active_sidebar('Footer Sidebar')) 
	{
?>
	<ul class="sidebar-widget <?php echo esc_attr($footer_class); ?>">
	    <?php dynamic_sidebar('Footer Sidebar'); ?>
	</ul>
<?php
	}
?>
</div>
<?php
    }
    
	//Check if page type
	if(is_page())
	{
		$page_show_copyright = get_post_meta($post->ID, 'page_show_copyright', true);
	}
	else
	{
		$page_show_copyright = 0;
	}
	
	if(empty($page_show_copyright))
	{
	?>
	<div class="footer-main-container <?php if(isset($artale_homepage_style) && !empty($artale_homepage_style)) { echo esc_attr($artale_homepage_style); } ?> <?php if(!empty($artale_screen_class)) { echo esc_attr($artale_screen_class); } ?> <?php if(empty($artale_footer_sidebar)) { ?>noborder<?php } ?>">
	
		<div class="footer-main-container-wrapper <?php if(isset($artale_homepage_style) && !empty($artale_homepage_style)) { echo esc_attr($artale_homepage_style); } ?>">
			<?php
				//Check if display social icons or footer menu
				$artale_footer_copyright_right_area = get_theme_mod('artale_footer_copyright_right_area', 'menu');
				
				if($artale_footer_copyright_right_area=='social')
				{
					if($artale_homepage_style!='flow' && $artale_homepage_style!='fullscreen' && $artale_homepage_style!='carousel' && $artale_homepage_style!='flip' && $artale_homepage_style!='fullscreen_video')
					{	
						//Get Soical Icon
						get_template_part("/templates/template-socials");
					}
				} //End if display social icons
				else
				{
					if ( has_nav_menu( 'footer-menu' ) ) 
				    {
					    wp_nav_menu( 
					        	array( 
					        		'menu_id'			=> 'footer-menu',
					        		'menu_class'		=> 'footer_nav',
					        		'theme_location' 	=> 'footer-menu',
					        	) 
					    ); 
					}
				}
			?>
		    <?php
		    	//Display copyright text
		        $artale_footer_copyright_text = get_theme_mod('artale_footer_copyright_text', 'Copyright');
	
		        if(!empty($artale_footer_copyright_text))
		        {
		        	echo '<div id="copyright">'.wp_kses_post(wp_specialchars_decode($artale_footer_copyright_text)).'</div><br class="clear"/>';
		        }
		    ?>
		</div>
	</div>
	<?php
	}
} //end if using footer sidebar as content
?>
</div>
<?php
    } //End if not blank template
?>

<?php
	//Check if display to top button
	$artale_footer_copyright_totop = get_theme_mod('artale_footer_copyright_totop', true);
	
	if(!empty($artale_footer_copyright_totop))
	{
?>
 	<a id="go-to-top" href="<?php echo esc_js('javascript:;'); ?>"><span class="ti-arrow-up"></span></a>
<?php
 	}
?>

<?php
    //Check if theme demo then enable layout switcher
    if(ARTALE_THEMEDEMO)
    {	
?>
	<div id="option_wrapper">
	<div class="inner">
		<div style="text-align:center">
			<div class="purchase_theme_button">
				<a class="button" href="<?php echo esc_url(THEMEGOODS_PURCHASE_URL); ?>" target="_blank">Purchase Theme</a>
			</div>
			
			<h5>Demo Homepages</h5>
			<p>
				Here are example of homepage that can be imported within one click.
			</p>
			<?php
				$customizer_styling_arr = array( 
					array(
						'id'	=>	'2-2-home2', 
						'url' => 'https://artalev2-2.themegoods.com/demo2/',
						'new' => true,
					),
					array(
						'id'	=>	'2-2-home1', 
						'url' => 'https://artalev2-2.themegoods.com/',
						'new' => true,
					),
					array(
						'id'	=>	'2-home3', 
						'url' => 'https://themes.themegoods.com/artale/home-12/',
						'new' => true,
					),
					array(
						'id'	=>	'2-home2', 
						'url' => 'https://artalev2.themegoods.com/demo2/',
						'new' => true,
					),
					array(
						'id'	=>	'2-home1', 
						'url' => 'https://artalev2.themegoods.com/',
						'new' => true,
					),
					array(
						'id'	=>	'1-home12', 
						'url' => 'https://themes.themegoods.com/artale/home-12/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home11', 
						'url' => 'https://themes.themegoods.com/artale/home-11/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home10', 
						'url' => 'https://themes.themegoods.com/artale/home-10/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home9', 
						'url' => 'https://themes.themegoods.com/artale/home-9/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home8', 
						'url' => 'https://themes.themegoods.com/artale/home-8/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home7', 
						'url' => 'https://themes.themegoods.com/artale/home-7/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home6', 
						'url' => 'https://themes.themegoods.com/artale/home-6/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home5', 
						'url' => 'https://themes.themegoods.com/artale/home-5/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home4', 
						'url' => 'https://themes.themegoods.com/artale/home-4/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home3', 
						'url' => 'https://themes.themegoods.com/artale/home-3/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home2', 
						'url' => 'https://themes.themegoods.com/artale/home-2/',
						'new' => false,
					),
					array(
						'id'	=>	'1-home1', 
						'url' => 'https://themes.themegoods.com/artale/',
						'new' => false,
					),
				);
			?>
			<ul class="demo_list">
				<?php
					foreach($customizer_styling_arr as $customizer_styling)
					{
				?>
				<li>
					<img src="<?php echo get_template_directory_uri(); ?>/data/demos/screenshots/<?php echo esc_html($customizer_styling['id']); ?>.jpg" alt="" <?php if(empty($customizer_styling['url'])) { ?>class="no_blur"<?php } ?>/>
					<?php 
						if($customizer_styling['new'])
						{
					?>
						<span class="label_new">New</span>
					<?php 
						}
						
						if(!empty($customizer_styling['url']))
						{
					?>
					<div class="demo_thumb_hover_wrapper">
						<div class="demo_thumb_hover_inner">
							<div class="demo_thumb_desc">
								<a href="<?php echo esc_url($customizer_styling['url']); ?>" target="_blank" class="button white">Launch</a>
							</div> 
						</div>	   
					</div>		
					<?php
						}
					?>   
				</li>
				<?php
					}
				?>
			</ul>
		</div>
	</div>
	</div>
    <div id="option_btn">
		<a href="javascript:;" class="demotip" title="Choose Theme Demo"><span class="ti-settings"></span></a>
		
	    <a href="https://1.envato.market/KeNmk7" class="demotip" title="Presale Question" target="_blank"><span class="ti-comment"></span></a>
    	<a href="https://docs.themegoods.com/docs/artale/" class="demotip" title="Theme Documentation" target="_blank"><span class="ti-book"></span></a>
    	
    	<a href="<?php echo esc_url(THEMEGOODS_PURCHASE_URL); ?>" title="Purchase Theme" class="demotip" target="_blank"><span class="ti-shopping-cart"></span></a>
    </div>
<?php
    	wp_enqueue_script("tooltipster", get_template_directory_uri()."/js/jquery-tooltipster.js", false, ARTALE_THEMEDEMO, true);
    }
?>

<?php
    $artale_frame = get_theme_mod('artale_frame', false);
    
    if(!empty($artale_frame))
    {
?>
    <div class="frame_top"></div>
    <div class="frame_bottom"></div>
    <div class="frame_left"></div>
    <div class="frame_right"></div>
<?php
    }
?>

<?php
	//Check if display fly-out mini cart
	$artale_mini_cart = get_theme_mod('artale_mini_cart', 1);
	
	if(!empty($artale_mini_cart) && class_exists('WooCommerce'))
	{
?>
<div id="woocommerce-mini-cart-wrapper">
	<?php
		//Display when in single product
		get_template_part("/templates/template-mini-cart");
	?>
</div>
<?php
	}
?>

</div>
<?php
	} //End if page hide footer
?>
<?php
    $artale_enable_right_click = get_theme_mod('artale_enable_right_click', false);
    $artale_enable_right_click_content = get_theme_mod('artale_enable_right_click_content', false);

    if(!empty($artale_enable_right_click) && !empty($artale_enable_right_click_content))
    {
	    $artale_enable_right_click_content_text = get_theme_mod('artale_enable_right_click_content_text');
?>
    <div id="right-click-content">
	    <div class="right-click-content-table">
		    <div class="right-click-content-cell">
		    	<div><?php echo esc_html($artale_enable_right_click_content_text); ?></div>
	    	</div>
	    </div>
    </div>
<?php
    }

	//Display fullscreen menu
	$artale_fullmenu_default = get_theme_mod('artale_fullmenu_default');
	if(!empty($artale_fullmenu_default))
	{
		//Add Polylang plugin support
		if (function_exists('pll_get_post')) {
			$artale_fullmenu_default = pll_get_post($artale_fullmenu_default);
		}
		
		//Add WPML plugin support
		if (function_exists('icl_object_id')) {
			$artale_fullmenu_default = icl_object_id($artale_fullmenu_default, 'page', false, ICL_LANGUAGE_CODE);
		}
		
		if(!empty($artale_fullmenu_default) && class_exists("\\Elementor\\Plugin"))
		{
?>
	<div id="fullmenu-wrapper-<?php echo esc_attr($artale_fullmenu_default); ?>" class="fullmenu-wrapper">
<?php
			echo artale_get_elementor_content($artale_fullmenu_default);
?>
	</div>
<?php
		}
	}
} //End if no password protected then display footer

	/* Always have wp_footer() just before the closing </body>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to reference JavaScript files.
	 */

	wp_footer();
?>
</body>
</html>
