<?php

get_header();

global $post, $arlo_fn_option;


$layout 			= 'boxed';
if(isset($arlo_fn_option['search_layout'])){
	$layout			= $arlo_fn_option['search_layout'];
}
$searchText 		= esc_html__('Search','arlo');
$nothingMatchedText = esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'arlo');
?>
        
        
        
<!-- MAIN CONTENT -->
<section class="arlo_fn_content">

	<div class="container"> 
		
		<?php if($layout == 'full'){?>
		<div class="arlo_fn_searchlist arlo_fn_search_common arlo_fn_search_full">
			<div class="title_holder">
				<h3><?php printf( esc_html__('Results For: %s', 'arlo'), get_search_query() ); ?></h3>
				<p><?php echo esc_html__('If you are not happy with the results below please do another search', 'arlo'); ?></p>
			</div>
			
			<div class="search_list">
				<ul>
				<?php if (have_posts()){while (have_posts()) : the_post(); ?>
				<?php 
					$thumbnail	= arlo_fn_getImageInSearchList();
					$hasThumb 	= 'fn_not_thumb';
					if($thumbnail != ''){
						$hasThumb = 'fn_has_thumb';
					}
					if(!post_password_required($post)){
				?>
					<li>
						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							<div class="search_item <?php echo esc_attr($hasThumb);?>">

								<?php if($hasThumb == 'fn_has_thumb'){?>
								<div class="attachment_holder">
									
									<?php echo arlo_fn_callback_thumbs(84,67); ?>
									<a href="<?php the_permalink(); ?>"></a>
									<div class="abs_img" data-fn-bg-img="<?php echo esc_attr($thumbnail);?>"></div>
								</div>
								<?php }?>

								<div class="title_holder">
									<div class="date_holder">
										<span class="sub">
											<span><?php the_time(get_option('date_format')); ?></span>
											<span>/</span>
											<span><?php echo arlo_fn_getPostType();?></span>
										</span>
									</div>

									<?php if(get_the_title() != ''){ ?>
									<div class="heading_holder">
										<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									</div>
									<?php } ?>


									<?php if(arlo_fn_excerpt(1,get_the_id()) != ''){ ?>
									<div class="desc_holder">
										<p><?php echo arlo_fn_excerpt(25,get_the_id());?></p>
									</div>
									<?php } ?>


									<div class="read_holder">
										<a href="<?php the_permalink(); ?>" class="read_more"><?php echo esc_html__('Read More', 'arlo') ?><span></span></a>
									</div>
								</div>

							</div>
						</article>
					</li>
				<?php } endwhile; ?>
				</ul>
				<?php }else{ ?>
				<div class="not_found">
					<div class="desc">
						<p><?php echo esc_html($nothingMatchedText);?></p>
					</div>
					<div class="s_seach">
						<div class="s_search_in">
							<form action="<?php echo esc_url(home_url("/"));?>" method="get" >
								<input type="text"  placeholder="<?php echo esc_attr($searchText);?>..." class="ft" name="s"/>
								<input type="submit" value="" class="fs">
								<a class="fn_search" href="#"><img class="arlo_fn_svg" src="<?php echo get_template_directory_uri();?>/framework/svg/search.svg" alt="svg" /></a>
							</form>
						</div>
					</div>
				</div>
				<?php } ?>
			</div>
			
			
		
			<?php arlo_fn_pagination('',1,0,2); wp_reset_postdata(); ?>
		</div>
		<?php }?>
		
		<?php if($layout == 'masonry'){?>
		<div class="arlo_fn_searchlist arlo_fn_search_common arlo_fn_search_masonry">
			<div class="title_holder">
				<h3><?php printf( esc_html__('Results For: %s', 'arlo'), get_search_query() ); ?></h3>
				<p><?php echo esc_html__('If you are not happy with the results below please do another search', 'arlo'); ?></p>
			</div>
			
			<div class="search_list">
				<ul class="arlo_fn_masonry">
				<?php if (have_posts()){while (have_posts()) : the_post(); ?>
				<?php 
					$thumbnail	= arlo_fn_getImageInSearchList('arlo_fn_thumb-1000-1000');
					$hasThumb 	= 'fn_not_thumb';
					if($thumbnail != ''){
						$hasThumb = 'fn_has_thumb';
					}
					if(!post_password_required($post)){
				?>
					<li class="arlo_fn_masonry_in">
						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							<div class="search_item <?php echo esc_attr($hasThumb);?>">

								<?php if($hasThumb == 'fn_has_thumb'){?>
								<div class="attachment_holder">
									<?php //echo arlo_fn_callback_thumbs(84,67); ?>
									<img src="<?php echo esc_url($thumbnail);?>" alt="" />
									<a href="<?php the_permalink(); ?>"></a>
<!--									<div class="abs_img" data-fn-bg-img="<?php //echo esc_attr($thumbnail);?>"></div>-->
								</div>
								<?php }?>

								<div class="title_holder">
									<div class="date_holder">
										<span class="sub">
											<span><?php the_time(get_option('date_format')); ?></span>
											<span>/</span>
											<span><?php echo arlo_fn_getPostType();?></span>
										</span>
									</div>

									<?php if(get_the_title() != ''){ ?>
									<div class="heading_holder">
										<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									</div>
									<?php } ?>


									<?php if(arlo_fn_excerpt(1,get_the_id()) != ''){ ?>
									<div class="desc_holder">
										<p><?php echo arlo_fn_excerpt(25,get_the_id());?></p>
									</div>
									<?php } ?>


									<div class="read_holder">
										<a href="<?php the_permalink(); ?>" class="read_more"><?php echo esc_html__('Read More', 'arlo') ?><span></span></a>
									</div>
								</div>

							</div>
						</article>
					</li>
				<?php } endwhile; ?>
				</ul>
				<?php }else{ ?>
				<div class="not_found">
					<div class="desc">
						<p><?php echo esc_html($nothingMatchedText);?></p>
					</div>
					<div class="s_seach">
						<div class="s_search_in">
							<form action="<?php echo esc_url(home_url("/"));?>" method="get" >
								<input type="text"  placeholder="<?php echo esc_attr($searchText);?>..." class="ft" name="s"/>
								<input type="submit" value="" class="fs">
								<a class="fn_search" href="#"><img class="arlo_fn_svg" src="<?php echo get_template_directory_uri();?>/framework/svg/search.svg" alt="svg" /></a>
							</form>
						</div>
					</div>
				</div>
				<?php } ?>
			</div>
			
			
		
			<?php arlo_fn_pagination('',1,0,3); wp_reset_postdata(); ?>
		</div>
		<?php }?>
		
		<?php if($layout == 'boxed'){?>
		<!-- SEARCH -->
		
		<div class="arlo_fn_searchlist arlo_fn_search_boxed">
			<div class="arlo_fn_pagetitle index_page">
				<div class="title_holder">
					<h3><?php printf( esc_html__('Search results for "%s"', 'arlo'), get_search_query() ); ?></h3>
				</div>
			</div>
		
		
			<div class="arlo_fn_searchpagelist">
				<?php if (have_posts()){ ?>
					<?php 
						while (have_posts()) : the_post();
						if(!post_password_required($post)){
					?>
					<article  id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div class="arlo_fn_searchpagelist_item">
							<h1><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
							<span class="sub"><span><?php the_time(get_option('date_format')); ?></span></span>
							<?php 
								$thecontent = get_the_content();	
								if(!empty($thecontent)){?>
									<p><?php echo arlo_fn_excerpt(60,get_the_id());?></p>
								<?php }?>
							<a href="<?php the_permalink(); ?>" class="read_more"><?php esc_html_e('Read More', 'arlo') ?></a>
						</div>
					</article>
					<?php } endwhile; ?>
				<?php 
				}else{
					$goHome 		= '<a class="for_icon" title="'.esc_attr__('Go Home', 'arlo').'" href="'.esc_url(home_url('/')).'"></a>';
					$inputSearch 	= '<div class="search2">
											<form action="'.esc_url(home_url("/")).'" method="get" >
												<input type="text"  placeholder="'.$searchText.'..." class="ft" name="s"/>
												<input type="submit" value="" class="fs">
												<a class="fn_search" href="#"><img class="arlo_fn_svg" src="'. get_template_directory_uri().'/framework/svg/search.svg" alt="'.esc_attr__("svg", "arlo").'" /></a>
											</form>
										</div>';
					printf('<div class="arlo_fn_searchpage_nothing"><div><p>%s</p><div>%s%s</div></div></div>', $nothingMatchedText, $inputSearch, $goHome);
				}
				?>
			</div>

			<?php arlo_fn_pagination(); wp_reset_postdata(); ?>
		</div>
		<!-- /SEARCH -->
		<?php }?>
		

	</div>    
</section>
<!-- /MAIN CONTENT -->
        
<?php get_footer('null'); ?>   