<?php
/*
	Template Name: Portfolio Page
*/
get_header();

global $post, $arlo_fn_option;
$arlo_fn_pagetitle = '';
$arlo_fn_top_padding = '';
$arlo_fn_bot_padding = '';
$arlo_fn_page_spaces = '';

// since v2.4
// Portfolio Layout
$layout 	= 'ajax';
if(isset($arlo_fn_option['project_layout'])){
	$layout = $arlo_fn_option['project_layout'];
}

if(function_exists('rwmb_meta')){
	$arlo_fn_pagetitle 		= get_post_meta(get_the_ID(),'arlo_fn_page_title', true);
	$arlo_fn_top_padding 	= get_post_meta(get_the_ID(),'arlo_fn_page_padding_top', true);
	$arlo_fn_bot_padding 	= get_post_meta(get_the_ID(),'arlo_fn_page_padding_bottom', true);
	$pageLayout 			= get_post_meta(get_the_ID(),'arlo_fn_page_portfolio_layout', true);
	
	$arlo_fn_page_spaces	 = 'style=';
	if($arlo_fn_top_padding != ''){$arlo_fn_page_spaces .= 'padding-top:'.$arlo_fn_top_padding.'px;';}
	if($arlo_fn_bot_padding != ''){$arlo_fn_page_spaces .= 'padding-bottom:'.$arlo_fn_bot_padding.'px;';}
	if($arlo_fn_top_padding == '' && $arlo_fn_bot_padding == ''){$arlo_fn_page_spaces = '';}
	
}
if(isset($pageLayout) && $pageLayout == 'default'){
	$portfolioLayout 	= $layout;
}else{
	$portfolioLayout 	= $pageLayout;
}
if(isset($_GET['project_layout'])){$portfolioLayout = $_GET['project_layout'];}

if(isset($arlo_fn_option['project_grid_list_ratio'])){
	$portfolioGridRatio = $arlo_fn_option['project_grid_list_ratio'];
}else{
	$portfolioGridRatio = 0.77;
}
$portfolioGridCSS		= '';
if($portfolioLayout == 'grid'){
	$portfolioGridRatio	= $portfolioGridRatio - 1;
	$portfolioGridCSS	= 'style="margin-bottom:calc('.$portfolioGridRatio.' * 100%);"';
	$thumb 				= get_template_directory_uri() .'/framework/img/thumb/thumb-800-800.jpg'; 
	$callbackImage 		= '<img '.$portfolioGridCSS.' src="'. esc_url($thumb) .'" alt="" />'; 
}

// QUERY ARGUMENTS
if(isset($arlo_fn_option['project_perpage'])){
	$arlo_fn_project_perpage = $arlo_fn_option['project_perpage'];
}else{
	$arlo_fn_project_perpage = 6;
}

if(is_front_page()) { $paged = (get_query_var('page')) ? get_query_var('page') : 1;	} else { $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;}
$query_args = array(
	'post_type' 			=> 'arlo-project', 
	'paged' 				=> $paged, 
	'posts_per_page' 		=> $arlo_fn_project_perpage,
	'post_status' 			=> 'publish',
);
// QUERY WITH ARGUMENTS
$arlo_fn_loop = new WP_Query($query_args);


$query_args2 = array(
	'post_type' 			=> 'arlo-project', 
	'paged' 				=> $paged, 
	'posts_per_page' 		=> -1,
	'post_status' 			=> 'publish',
);
// QUERY WITH ARGUMENTS
$arlo_fn_loop2 = new WP_Query($query_args2);

$allCount = count($arlo_fn_loop2->posts);

$viewMoreText = esc_html__('View More', 'arlo');

// CHeck if page is password protected	
if(post_password_required($post)){
	echo '<div class="arlo_fn_password_protected">
		 	<div class="in">
				<div>
					<div class="message_holder">
						<h1>'.esc_html__('Protected','arlo').'</h1>
						<h3>'.esc_html__('This page was protected','arlo').'</h3>
						'.get_the_password_form().'
					</div>
				</div>
		  	</div>
		  </div>';
}
else
{

?>
<div class="arlo_fn_all_pages_content arlo_fn_project_page">
	<?php if($arlo_fn_pagetitle !== 'disable'){ ?>
		<!-- PAGE TITLE -->
		<div class="arlo_fn_pagetitle">
			<div class="container">
				<div class="title_holder">
					<h3><?php the_title(); ?></h3>
					<?php arlo_fn_breadcrumbs();?>
				</div>
			</div>
		</div>
		<!-- /PAGE TITLE -->
	<?php } ?>
	
	<!-- ALL PAGES -->		
	<div class="arlo_fn_all_pages">
		<div>
			<div class="arlo_fn_all_pages_inner">
				
				<!-- WITHOUT SIDEBAR -->
				<div class="arlo_fn_without_sidebar_page" <?php echo esc_attr($arlo_fn_page_spaces); ?>>
					<div class="inner">
						
						<div class="arlo_fn_portfolio_page">
						
							<!-- PORTFOLIO CONTENT -->
							<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
							<div class="portfolio_content">
								<div class="container">
									<?php the_content(); ?>
								</div>
							</div>
							<?php endwhile; endif;?>
							<!-- PORTFOLIO /CONTENT -->
							
							<?php 
								if($portfolioLayout == 'ajax'){
							?>
							
							<!-- PORTFOLIO LIST -->
							<div class="portfolio_list">
								<div class="container">
									<div class="arlo_fn_portfolio_category_filter">
										<a href="#"><?php esc_html_e('All Projects', 'arlo');?></a>
										<span class="spinner"></span>
										<?php arlo_fn_category_list();?>
									</div>
									<div class="portfolio_list_in">
										<ul class="arlo_fn_portfolio_list">
											<?php 
												if ($arlo_fn_loop->have_posts()) : while ($arlo_fn_loop->have_posts()) : $arlo_fn_loop->the_post(); 

												$imageURL = NULL;
												$imageURL = get_the_post_thumbnail_url(get_the_id(),'arlo_fn_thumb-1000-1000');
												if(($imageURL == '') || ($imageURL == NULL) || ($imageURL == 'undefined')){
													$have_img = 'no_img';
												}else{
													$have_img = 'have_img';
												}
											?>
											<li>
												<div class="item <?php echo esc_attr($have_img);?>">
												
													<?php if($have_img == 'have_img'){?>
													<div class="img_holder">
														<img src="<?php echo get_template_directory_uri() .'/framework/img/thumb/thumb-560-375.jpg'; ?>" alt="<?php  esc_attr(bloginfo('description')); ?>" />
														<div class="img_abs" data-fn-bg-img="<?php echo esc_url($imageURL); ?>"></div>
														<a href="<?php the_permalink(); ?>"></a>
													</div>
													<?php }?>

													<div class="title_holder">
														<h3>
															<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
														</h3>
														<p>
															<a class="view_more" href="<?php the_permalink(); ?>">
																<span class="text"><?php echo esc_html($viewMoreText);?></span>
																<span class="arrow">
																	<?php 
																		$arrowURL = get_template_directory_uri().'/framework/svg/right-arrow-1.svg';
																	?>
																	<img class="arlo_fn_svg" src="<?php echo esc_url($arrowURL);?>" alt="<?php echo esc_attr__('svg', 'arlo');?>" />
																</span>
															</a>
														</p>
														<a class="hover_link" href="<?php the_permalink(); ?>"></a>
													</div>

												</div>
											</li>
											<?php endwhile; endif;?>
										</ul>
									</div>
								</div>
							</div>
							<!-- /PORTFOLIO LIST -->
							
							<div class="arlo_fn_ajax_pagination">
								<div class="container">
									<?php echo arlo_fn_ajax_pagination($arlo_fn_loop->found_posts); wp_reset_postdata();?>
								</div>
							</div>
							
							<!-- GRID LIST -->
							<?php }else if($portfolioLayout == 'grid'){ ?>
							
							<div class="arlo_fn_portfolio_grid">
								<div class="container">
									<div class="inner">
										
										<ul>
											<?php 
												if ($arlo_fn_loop->have_posts()) : while ($arlo_fn_loop->have_posts()) : $arlo_fn_loop->the_post(); 

												$imageURL = get_the_post_thumbnail_url(get_the_id(),'full');
												if(($imageURL == '') || ($imageURL == NULL) || ($imageURL == 'undefined')){
													$have_img = 'no_img';
												}else{
													$have_img = 'have_img';
												}
											?>
											<li>
												<div class="item <?php echo esc_attr($have_img);?>">
												
													<?php if($have_img == 'have_img'){?>
													<div class="img_holder">
														<?php echo $callbackImage; ?>
														<div class="img_abs" data-fn-bg-img="<?php echo esc_url($imageURL); ?>"></div>
														<a href="<?php the_permalink(); ?>"></a>
													</div>
													<?php }?>

													<div class="title_holder">
														<p><?php arlo_fn_taxanomy_list(get_the_id(),'project_category', true, 999, ', ');?></p>
														<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
													</div>

												</div>
											</li>
											<?php endwhile; endif;?>
										</ul>
										
									</div>
									
									<?php arlo_fn_pagination($arlo_fn_loop->max_num_pages); wp_reset_postdata(); ?>
									
								</div>
							</div>
							<!-- /GRID LIST -->

							<?php }else if($portfolioLayout == 'masonry'){ ?>
							
							<!-- MASONRY LIST -->
							
							<div class="arlo_fn_portfolio_masonry">
								<div class="container">
									<div class="inner">
										
										<ul class="arlo_fn_masonry">
											<?php 
												if ($arlo_fn_loop->have_posts()) : while ($arlo_fn_loop->have_posts()) : $arlo_fn_loop->the_post(); 

												$imageURL = get_the_post_thumbnail_url(get_the_id(),'arlo_fn_thumb-1000-9999');
												if(($imageURL == '') || ($imageURL == NULL) || ($imageURL == 'undefined')){
													$have_img = 'no_img';
												}else{
													$have_img = 'have_img';
												}
											?>
											<li class="arlo_fn_masonry_in">
												<div class="item <?php echo esc_attr($have_img);?>">
												
													<?php if($have_img == 'have_img'){?>
													<div class="img_holder">
														<img src="<?php echo esc_url($imageURL); ?>" alt="" />
														<a href="<?php the_permalink(); ?>"></a>
													</div>
													<?php }?>

													<div class="title_holder">
														<p><?php arlo_fn_taxanomy_list(get_the_id(),'project_category', true, 999, ', ');?></p>
														<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
													</div>

												</div>
											</li>
											<?php endwhile; endif;?>
										</ul>
										
									</div>
									
									<?php arlo_fn_pagination($arlo_fn_loop->max_num_pages); wp_reset_postdata(); ?>
									
								</div>
							</div>
							<!-- /MASONRY LIST -->

							<?php }else if($portfolioLayout == 'block'){ ?>
							
							<!-- BLOCK LIST -->
							
							<div class="arlo_fn_portfolio_block">
								<div class="container">
									<div class="inner">
										
										<div class="arlo_fn_portfolio_block_filter">
											<?php arlo_fn_portfolio_block_category_list();?>
										</div>
										
											<?php 
												
												list($width, $height, $type, $attr) = getimagesize(ARLO_CORE_SHORTCODE_URL.'assets/img/thumb-420-300.jpg');
												$ratio = $height / $width;
												$key = -1;
												$html	 	= '<div class="fn_cs_agency_filter" data-ratio="'.$ratio.'">';
												$fn_list	= '<ul class="posts_list">';
												$pagination		= arlo_fn_portfolio_block_pagination($allCount,$arlo_fn_project_perpage,1);
												if ($arlo_fn_loop->have_posts()) : while ($arlo_fn_loop->have_posts()) : $arlo_fn_loop->the_post(); 
												$key++;
																		
												$post_id 			= get_the_id();
												$post_permalink 	= get_permalink();
												$post_image 		= get_the_post_thumbnail_url( $post_id, 'full' );
												$post_title			= get_the_title();
												$post_taxonomy		= arlo_fn_post_taxanomy('arlo-project');
												$cats__mobile 		= arlo_fn_taxanomy_list($post_id, $post_taxonomy[0], false, 999, ' , ');

												$img_holder			= '<div class="img_holder"><img src="'.ARLO_CORE_SHORTCODE_URL.'assets/img/thumb-420-300.jpg" alt="" /><div class="abs_img" data-fn-bg-img="'.$post_image.'"><a href="'.$post_permalink.'"></a></div></div>';
												$titleHolder		= '<div class="title_holder"><p>'.$cats__mobile.'</p><h3><a href="'.$post_permalink.'">'.$post_title.'</a></h3></div>';

												$item	= '<div class="item">'.$img_holder.$titleHolder.'</div>';


												if($key%6 == 0){
													$fn_list .= '<div class="fn_cs_rows_wrapper">'; 	// -->> starts #1 row
													$fn_list .= '<div class="first_row">';
													$fn_list .= $item;
													$fn_list .= '</div>';
												}
												if($key%6 == 1){
													$fn_list .= '<div class="second_row">';
													$fn_list .= $item;
												}
												if($key%6 == 2){
													$fn_list .= $item;
													$fn_list .= '</div>';
													$fn_list .= '</div>';								// <<-- ends #1 row
												}
												if($key%6 == 3){
													$fn_list .= '<div class="fn_cs_cols_wrapper"><ul>'; // -->> starts #2 row
													$fn_list .= '<li>'.$item.'</li>';
												}
												if($key%6 == 4){
													$fn_list .= '<li>'.$item.'</li>';
												}
												if($key%6 == 5){
													$fn_list .= '<li>'.$item.'</li>';
													$fn_list .= '</ul></div>';							// <<-- ends #2 row
												}
												endwhile; endif; wp_reset_postdata();
												if($key%6 == 1 || $key%6 == 0){
													$fn_list .= '</div>';								// <<-- ends #1 row
												}
												if($key%6 == 3 || $key%6 == 4){
													$fn_list .= '</ul></div>';							// <<-- ends #2 row
												}
												$fn_list 	.= '</ul>';
												$html .= $fn_list;
												$html .= $pagination;
												$html .= '</div>';
												echo wp_kses_post($html);
											?>
									</div>
									
								</div>
							</div>
							<!-- /BLOCK LIST -->

							<?php } ?>
							
						</div>

					</div>					
				</div>
				<!-- /WITHOUT SIDEBAR -->
					
			</div>
		</div>
	</div>		
	<!-- /ALL PAGES -->
</div>
<?php } ?>

<?php get_footer(); ?>  