<?php 
	global $arlo_fn_option, $post;
	
	$main_nav 	= array('theme_location'  => 'main_menu','menu_class' => 'arlo_fn_main_nav nav__hor', 'echo' => false, 'walker' => new arlo_fn_walker);
	
	// get logo
	$allLogos 	= arlo_fn_getLogo('three_lines');
	$lightLogo	= $allLogos[0];
	$darkLogo	= $allLogos[1];
	$customLogo	= $allLogos[2];


	
	// get extra information
	$extraInfo					= array();
	if(isset($arlo_fn_option['three_lines_multi_info'])){
		$extraInfo				= $arlo_fn_option['three_lines_multi_info'];
	}
	$information				= '';
	if(!empty($extraInfo)){
		foreach($extraInfo as $info){
			$information		.= '<div class="third_info">'.$info.'</div>';
		}
	}

	

	// get menu position
	$menuPos					= 'center';
	if(isset($arlo_fn_option['three_lines_menu_pos'])){
		$menuPos				= $arlo_fn_option['three_lines_menu_pos'];
	}
	

	// get navigation width
	$navigationWidth			= 'full';
	if(isset($arlo_fn_option['three_lines_nav_width'])){
		$navigationWidth		= $arlo_fn_option['three_lines_nav_width'];
	}
	if(isset($_GET['width'])){$navigationWidth = $_GET['width'];}

	// get navigation padding left and right
	$paddingLeftRightSize		= 50;
	$paddingLeftRightUnit		= 'px';
	if(isset($arlo_fn_option['three_lines_left_right']['width']) && isset($arlo_fn_option['three_lines_left_right']['units'])){
		$paddingLeftRightSize	= (int)$arlo_fn_option['three_lines_left_right']['width'];
		$paddingLeftRightUnit	= $arlo_fn_option['three_lines_left_right']['units'];
	}
	if($navigationWidth == 'full'){
		if($paddingLeftRightUnit != 'px' && $paddingLeftRightUnit != '%'){$paddingLeftRightUnit = 'px';}
		$size					= $paddingLeftRightSize.$paddingLeftRightUnit;
		$paddingCSS				= '.arlo_fn_three_lines.full .third_top, .arlo_fn_three_lines.full .third_middle, .arlo_fn_three_lines.full .third_bottom{padding-left:'.$size.';padding-right:'.$size.';}';
	}

	
	// get navigation position
	$navigationPos				= 'relative';
	if(isset($arlo_fn_option['three_lines_position'])){
		$navigationPos			= $arlo_fn_option['three_lines_position'];
	}
	if(function_exists('rwmb_meta')){
		$navigationPos 			= get_post_meta(get_the_ID(),'arlo_fn_page_nav_position', true);
		if($navigationPos === 'default' && isset($arlo_fn_option['three_lines_position'])){
			$navigationPos 		= $arlo_fn_option['three_lines_position'];
		}
	}
	if(isset($arlo_fn_option['three_lines_position'])){
		if($navigationPos === 'undefined' || $navigationPos === ''){
			$navigationPos 		= $arlo_fn_option['three_lines_position'];
		}
	}

	// get navigation skin
	$navigationSkin				= arlo_fn_getLinesNavSkin('three_lines');
	if($navigationSkin != 'dark' && $navigationSkin != 'light' && $navigationSkin != 'custom' && $navigationPos != 'fixed'){$navigationPos = 'absolute';}
	if(is_404() || is_search() || is_archive()){
		$navigationSkin = 'light';
		$navigationPos 	= 'relative';
	}

	
	// get navigation bottom line
	$navigationBottomLine		= 'enabled';
	if(isset($arlo_fn_option['three_lines_border'])){
		$navigationBottomLine	= $arlo_fn_option['three_lines_border'];
	}

	
	// topbar background color
	$topbarBgColor				= '#956597';
	if(isset($arlo_fn_option['three_lines_topbar_bg'])){
		$topbarBgColor			= $arlo_fn_option['three_lines_topbar_bg']['rgba'];
	}
	$topbarCSS					= '.arlo_fn_three_lines .third_top{background-color:'.$topbarBgColor.';}';

	
	// menu background color
	$middleSectionBgColor		= '#fff';
	if(isset($arlo_fn_option['three_lines_middle_bg'])){
		$middleSectionBgColor	= $arlo_fn_option['three_lines_middle_bg']['rgba'];
	}
	$middlebarCSS				= '.arlo_fn_three_lines .third_middle{background-color:'.$middleSectionBgColor.';}';

	
	// menu background color
	$menuBgColor				= '#fff';
	if(isset($arlo_fn_option['three_lines_menu_bg'])){
		$menuBgColor			= $arlo_fn_option['three_lines_menu_bg']['rgba'];
	}
	$bottombarCSS				= '.arlo_fn_three_lines .third_bottom{background-color:'.$menuBgColor.';}';

	
	// get navigation border
	$navigationBorder			= 'enabled';
	if(isset($arlo_fn_option['three_lines_border'])){
		$navigationBorder		= $arlo_fn_option['three_lines_border'];
	}

	// get menu
	if(has_nav_menu('main_menu')){
		$navMenu 			 	= wp_nav_menu( $main_nav );
	}else{
		$navMenu 		 		= '<ul class="nav__hor"><li><a href="">'.esc_html__('No menu assigned', 'arlo').'</a></li></ul>';
	}
	
	
	if($navigationSkin == 'light' || $navigationSkin == 'translight' || $navigationSkin == 'nonedark'){
		$defaultLogo 	= $lightLogo;
	}else if($navigationSkin == 'dark' || $navigationSkin == 'transdark' || $navigationSkin == 'nonelight'){
		$defaultLogo 	= $darkLogo;
	}else{
		$defaultLogo 	= $customLogo;
	}
	$logo		= '<div class="fn_logo"><a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($defaultLogo).'" alt="" /></a></div>';
	$hiddenLogo	= '<div class="fn_logo" style="display:none;"><a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($defaultLogo).'" alt="" /></a></div>';


	$trigger 			 = arlo_fn_getMainTrigger();
	$socialList			 = arlo_fn_getSocialList();
	$helperList			 = arlo_fn_getHelperLineNavigation();

	// ********************************************************************************************
	// Extra Buttons
	// ********************************************************************************************
	$extraButton1				= '';
	$extraButton1Switcher 		= true;
	if(isset($arlo_fn_option['extra_button_1_switcher'])){
		$extraButton1Switcher	= $arlo_fn_option['extra_button_1_switcher'];
	}
	$extraButton2				= '';
	$extraButton2Switcher		= true;
	if(isset($arlo_fn_option['extra_button_2_switcher'])){
		$extraButton2Switcher	= $arlo_fn_option['extra_button_2_switcher'];
	}
	

	// ********************************************************************************************
	// DISABLED column
	// ********************************************************************************************
	$middleLogo			= false;
	$menuCount			= 1;
	if(isset($arlo_fn_option['three_lines_middle_logo_in_nav'])){
		$middleLogo		= $arlo_fn_option['three_lines_middle_logo_in_nav'];
	}
	if(isset($arlo_fn_option['three_lines_sorter']['disabled']) && !empty($arlo_fn_option['three_lines_sorter']['disabled'])){
		foreach($arlo_fn_option['three_lines_sorter']['disabled'] as $key => $value){
			if($key == 'menu'){$menuCount = 0;}
			if($key == 'extra_button_1'){$extraButton1Switcher = false;}
			if($key == 'extra_button_2'){$extraButton2Switcher = false;}
		}
	}
	if($middleLogo && $menuCount == 1){
		$logo			= $hiddenLogo;
	}
	if($extraButton1Switcher){
		$extraButton1 	= arlo_fn_getExtraButtons(1);
	}
	if($extraButton2Switcher){
		$extraButton2 	= arlo_fn_getExtraButtons(2);
	}



	if(isset($_GET['middle_logo'])){
		$middleLogo		= true;
		$logo			= $hiddenLogo;
	}

	if(isset($_GET['menu_pos'])){
		$menuPos		= $_GET['menu_pos'];
	}

	if(isset($_GET['three_lines'])){
		$globalNavStructure	= $_GET['three_lines']; // ?three_lines=top_left:extra_info,top_right:helper,middle_left:social,middle_center:logo,middle_right:trigger&menu_pos=center
		$extraArray        	= explode(',', $globalNavStructure);


		foreach($extraArray as $eArr){
			if(strpos($eArr, 'top_left:') !== false){
				$expStr 		= explode("top_left:",$eArr);
				$topLeftArr		= array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'top_center:') !== false) {
				$expStr 		= explode("top_center:",$eArr);
				$topCenterArr 	= array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'top_right:') !== false) {
				$expStr 		= explode("top_right:",$eArr);
				$topRightArr  	= array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'middle_left:') !== false){
				$expStr 		= explode("middle_left:",$eArr);
				$middleLeftArr	= array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'middle_center:') !== false) {
				$expStr 		= explode("middle_center:",$eArr);
				$middleCenterArr= array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'middle_right:') !== false) {
				$expStr 		= explode("middle_right:",$eArr);
				$middleRightArr = array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'bottom_left:') !== false) {
				$expStr 		= explode("bottom_left:",$eArr);
				$bottomLeftArr	= array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'bottom_center:') !== false) {
				$expStr 		= explode("bottom_center:",$eArr);
				$bottomCenterArr= array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'bottom_right:') !== false) {
				$expStr 		= explode("bottom_right:",$eArr);
				$bottomRightArr	= array_unique(explode('.', $expStr[1]));
			}
		}
		
		$extraButton1 		= arlo_fn_getExtraButtons(1);
		$extraButton2 		= arlo_fn_getExtraButtons(2);
		
		// top left
		$topLeft 		= '<div class="tt_left">';
		if(isset($topLeftArr)){
			foreach($topLeftArr as $key){
				switch($key){
					case 'extra_info': 		$topLeft .= '<div class="tt_left_item">'.$information.'</div>'; break;
					case 'helper': 			$topLeft .= '<div class="tt_left_item">'.$helperList.'</div>'; break;
					case 'social': 			$topLeft .= '<div class="tt_left_item">'.$socialList.'</div>'; break;
					case 'logo': 			$topLeft .= '<div class="tt_left_item">'.$logo.'</div>'; break;
					case 'trigger': 		$topLeft .= '<div class="tt_left_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$topLeft .= '<div class="tt_left_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$topLeft .= '<div class="tt_left_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$topLeft 		.= '</div>';

		// top center
		$topCenter 		= '<div class="tt_center">';
		if(isset($topCenterArr)){
			foreach($topCenterArr as $key){
				switch($key){
					case 'extra_info': 		$topCenter .= '<div class="tt_center_item">'.$information.'</div>'; break;
					case 'helper': 			$topCenter .= '<div class="tt_center_item">'.$helperList.'</div>'; break;
					case 'social': 			$topCenter .= '<div class="tt_center_item">'.$socialList.'</div>'; break;
					case 'logo': 			$topCenter .= '<div class="tt_center_item">'.$logo.'</div>'; break;
					case 'trigger': 		$topCenter .= '<div class="tt_center_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$topCenter .= '<div class="tt_center_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$topCenter .= '<div class="tt_center_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$topCenter 		.= '</div>';

		// top right
		$topRight 		= '<div class="tt_right">';
		if(isset($topRightArr)){
			foreach($topRightArr as $key){
				switch($key){
					case 'extra_info': 		$topRight .= '<div class="tt_right_item">'.$information.'</div>'; break;
					case 'helper': 			$topRight .= '<div class="tt_right_item">'.$helperList.'</div>'; break;
					case 'social': 			$topRight .= '<div class="tt_right_item">'.$socialList.'</div>'; break;
					case 'logo': 			$topRight .= '<div class="tt_right_item">'.$logo.'</div>'; break;
					case 'trigger': 		$topRight .= '<div class="tt_right_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$topRight .= '<div class="tt_right_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$topRight .= '<div class="tt_right_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$topRight 		.= '</div>';

		$topPartHTML			 = '<div class="third_top">';
			$topPartHTML			.= '<div class="container">';
				$topPartHTML			.= '<div class="third_top_in">';
					$topPartHTML			.= $topLeft.$topCenter.$topRight;
				$topPartHTML			.= '</div>';
			$topPartHTML			.= '</div>';
		$topPartHTML			.= '</div>';

		// ********************************************************************************************
		// get MIDDLE PART
		// ********************************************************************************************

		// middle left
		$middleLeft 		= '<div class="tt_left">';
		if(isset($middleLeftArr)){
			foreach($middleLeftArr as $key){
				switch($key){
					case 'extra_info': 		$middleLeft .= '<div class="tt_left_item">'.$information.'</div>'; break;
					case 'helper': 			$middleLeft .= '<div class="tt_left_item">'.$helperList.'</div>'; break;
					case 'social': 			$middleLeft .= '<div class="tt_left_item">'.$socialList.'</div>'; break;
					case 'logo': 			$middleLeft .= '<div class="tt_left_item">'.$logo.'</div>'; break;
					case 'trigger': 		$middleLeft .= '<div class="tt_left_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$middleLeft .= '<div class="tt_left_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$middleLeft .= '<div class="tt_left_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$middleLeft 		.= '</div>';

		// middle center
		$middleCenter 		= '<div class="tt_center">';
		if(isset($middleCenterArr)){
			foreach($middleCenterArr as $key){
				switch($key){
					case 'extra_info': 		$middleCenter .= '<div class="tt_center_item">'.$information.'</div>'; break;
					case 'helper': 			$middleCenter .= '<div class="tt_center_item">'.$helperList.'</div>'; break;
					case 'social': 			$middleCenter .= '<div class="tt_center_item">'.$socialList.'</div>'; break;
					case 'logo': 			$middleCenter .= '<div class="tt_center_item">'.$logo.'</div>'; break;
					case 'trigger': 		$middleCenter .= '<div class="tt_center_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$middleCenter .= '<div class="tt_center_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$middleCenter .= '<div class="tt_center_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$middleCenter 		.= '</div>';

		// middle right
		$middleRight 		= '<div class="tt_right">';
		if(isset($middleRightArr)){
			foreach($middleRightArr as $key){
				switch($key){
					case 'extra_info': 		$middleRight .= '<div class="tt_right_item">'.$information.'</div>'; break;
					case 'helper': 			$middleRight .= '<div class="tt_right_item">'.$helperList.'</div>'; break;
					case 'social': 			$middleRight .= '<div class="tt_right_item">'.$socialList.'</div>'; break;
					case 'logo': 			$middleRight .= '<div class="tt_right_item">'.$logo.'</div>'; break;
					case 'trigger': 		$middleRight .= '<div class="tt_right_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$middleRight .= '<div class="tt_right_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$middleRight .= '<div class="tt_right_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$middleRight 		.= '</div>';

		$middlePartHTML			 = '<div class="third_middle">';
			$middlePartHTML			.= '<div class="container">';
				$middlePartHTML			.= '<div class="third_middle_in">';
					$middlePartHTML			.= $middleLeft.$middleCenter.$middleRight;
				$middlePartHTML			.= '</div>';
			$middlePartHTML			.= '</div>';
		$middlePartHTML			.= '</div>';

		// ********************************************************************************************
		// get BOTTOM PART
		// ********************************************************************************************

		// bottom left
		$bottomLeft 		= '<div class="tt_left">';
		if($menuPos == 'left'){$bottomLeft .= '<div class="tt_left_item">'.$navMenu.'</div>';}
		if(isset($bottomLeftArr)){
			foreach($bottomLeftArr as $key){
				switch($key){
					case 'extra_info': 		$bottomLeft .= '<div class="tt_left_item">'.$information.'</div>'; break;
					case 'helper': 			$bottomLeft .= '<div class="tt_left_item">'.$helperList.'</div>'; break;
					case 'social': 			$bottomLeft .= '<div class="tt_left_item">'.$socialList.'</div>'; break;
					case 'logo': 			$bottomLeft .= '<div class="tt_left_item">'.$logo.'</div>'; break;
					case 'trigger': 		$bottomLeft .= '<div class="tt_left_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$bottomLeft .= '<div class="tt_left_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$bottomLeft .= '<div class="tt_left_item">'.$extraButton2.'</div>';} break;
				}
			}
		}

		$bottomLeft 		.= '</div>';

		// bottom center
		$bottomCenter 		= '<div class="tt_center">';
		if($menuPos == 'center'){$bottomCenter .= '<div class="tt_center_item">'.$navMenu.'</div>';}
		if(isset($bottomCenterArr)){
			foreach($bottomCenterArr as $key){
				switch($key){
					case 'extra_info': 		$bottomCenter .= '<div class="tt_center_item">'.$information.'</div>'; break;
					case 'helper': 			$bottomCenter .= '<div class="tt_center_item">'.$helperList.'</div>'; break;
					case 'social': 			$bottomCenter .= '<div class="tt_center_item">'.$socialList.'</div>'; break;
					case 'logo': 			$bottomCenter .= '<div class="tt_center_item">'.$logo.'</div>'; break;
					case 'trigger': 		$bottomCenter .= '<div class="tt_center_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$bottomCenter .= '<div class="tt_center_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$bottomCenter .= '<div class="tt_center_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$bottomCenter 		.= '</div>';

		// bottom right
		$bottomRight 		= '<div class="tt_right">';
		if($menuPos == 'right'){$bottomRight .= '<div class="tt_right_item">'.$navMenu.'</div>';}
		if(isset($bottomRightArr)){
			foreach($bottomRightArr as $key){
				switch($key){
					case 'extra_info': 		$bottomRight .= '<div class="tt_right_item">'.$information.'</div>'; break;
					case 'helper': 			$bottomRight .= '<div class="tt_right_item">'.$helperList.'</div>'; break;
					case 'social': 			$bottomRight .= '<div class="tt_right_item">'.$socialList.'</div>'; break;
					case 'logo': 			$bottomRight .= '<div class="tt_right_item">'.$logo.'</div>'; break;
					case 'trigger': 		$bottomRight .= '<div class="tt_right_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$bottomRight .= '<div class="tt_right_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$bottomRight .= '<div class="tt_right_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$bottomRight 		.= '</div>';

		$bottomPartHTML			 = '<div class="third_bottom">';
			$bottomPartHTML			.= '<div class="container">';
				$bottomPartHTML			.= '<div class="third_bottom_in">';
					$bottomPartHTML			.= $bottomLeft.$bottomCenter.$bottomRight;
				$bottomPartHTML			.= '</div>';
			$bottomPartHTML			.= '</div><div class="arlo_fn_megamenu"></div>';
		$bottomPartHTML			.= '</div>';
		
	}else{
		// ********************************************************************************************
		// get TOP PART
		// ********************************************************************************************

		// top left
		$topLeft 		= '<div class="tt_left">';
		if(isset($arlo_fn_option['three_lines_sorter']['top_left']) && !empty($arlo_fn_option['three_lines_sorter']['top_left'])){
			foreach($arlo_fn_option['three_lines_sorter']['top_left'] as $key => $value){
				switch($key){
					case 'extra_info': 		$topLeft .= '<div class="tt_left_item">'.$information.'</div>'; break;
					case 'helper': 			$topLeft .= '<div class="tt_left_item">'.$helperList.'</div>'; break;
					case 'social': 			$topLeft .= '<div class="tt_left_item">'.$socialList.'</div>'; break;
					case 'logo': 			$topLeft .= '<div class="tt_left_item">'.$logo.'</div>'; break;
					case 'trigger': 		$topLeft .= '<div class="tt_left_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$topLeft .= '<div class="tt_left_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$topLeft .= '<div class="tt_left_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$topLeft 		.= '</div>';

		// top center
		$topCenter 		= '<div class="tt_center">';
		if(isset($arlo_fn_option['three_lines_sorter']['top_center']) && !empty($arlo_fn_option['three_lines_sorter']['top_center'])){
			foreach($arlo_fn_option['three_lines_sorter']['top_center'] as $key => $value){
				switch($key){
					case 'extra_info': 		$topCenter .= '<div class="tt_center_item">'.$information.'</div>'; break;
					case 'helper': 			$topCenter .= '<div class="tt_center_item">'.$helperList.'</div>'; break;
					case 'social': 			$topCenter .= '<div class="tt_center_item">'.$socialList.'</div>'; break;
					case 'logo': 			$topCenter .= '<div class="tt_center_item">'.$logo.'</div>'; break;
					case 'trigger': 		$topCenter .= '<div class="tt_center_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$topCenter .= '<div class="tt_center_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$topCenter .= '<div class="tt_center_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$topCenter 		.= '</div>';

		// top right
		$topRight 		= '<div class="tt_right">';
		if(isset($arlo_fn_option['three_lines_sorter']['top_right']) && !empty($arlo_fn_option['three_lines_sorter']['top_right'])){
			foreach($arlo_fn_option['three_lines_sorter']['top_right'] as $key => $value){
				switch($key){
					case 'extra_info': 		$topRight .= '<div class="tt_right_item">'.$information.'</div>'; break;
					case 'helper': 			$topRight .= '<div class="tt_right_item">'.$helperList.'</div>'; break;
					case 'social': 			$topRight .= '<div class="tt_right_item">'.$socialList.'</div>'; break;
					case 'logo': 			$topRight .= '<div class="tt_right_item">'.$logo.'</div>'; break;
					case 'trigger': 		$topRight .= '<div class="tt_right_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$topRight .= '<div class="tt_right_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$topRight .= '<div class="tt_right_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$topRight 		.= '</div>';

		$topPartHTML			 = '<div class="third_top">';
			$topPartHTML			.= '<div class="container">';
				$topPartHTML			.= '<div class="third_top_in">';
					$topPartHTML			.= $topLeft.$topCenter.$topRight;
				$topPartHTML			.= '</div>';
			$topPartHTML			.= '</div>';
		$topPartHTML			.= '</div>';

		// ********************************************************************************************
		// get MIDDLE PART
		// ********************************************************************************************

		// middle left
		$middleLeft 		= '<div class="tt_left">';
		if(isset($arlo_fn_option['three_lines_sorter']['middle_left']) && !empty($arlo_fn_option['three_lines_sorter']['middle_left'])){
			foreach($arlo_fn_option['three_lines_sorter']['middle_left'] as $key => $value){
				switch($key){
					case 'extra_info': 		$middleLeft .= '<div class="tt_left_item">'.$information.'</div>'; break;
					case 'helper': 			$middleLeft .= '<div class="tt_left_item">'.$helperList.'</div>'; break;
					case 'social': 			$middleLeft .= '<div class="tt_left_item">'.$socialList.'</div>'; break;
					case 'logo': 			$middleLeft .= '<div class="tt_left_item">'.$logo.'</div>'; break;
					case 'trigger': 		$middleLeft .= '<div class="tt_left_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$middleLeft .= '<div class="tt_left_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$middleLeft .= '<div class="tt_left_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$middleLeft 		.= '</div>';

		// middle center
		$middleCenter 		= '<div class="tt_center">';
		if(isset($arlo_fn_option['three_lines_sorter']['middle_center']) && !empty($arlo_fn_option['three_lines_sorter']['middle_center'])){
			foreach($arlo_fn_option['three_lines_sorter']['middle_center'] as $key => $value){
				switch($key){
					case 'extra_info': 		$middleCenter .= '<div class="tt_center_item">'.$information.'</div>'; break;
					case 'helper': 			$middleCenter .= '<div class="tt_center_item">'.$helperList.'</div>'; break;
					case 'social': 			$middleCenter .= '<div class="tt_center_item">'.$socialList.'</div>'; break;
					case 'logo': 			$middleCenter .= '<div class="tt_center_item">'.$logo.'</div>'; break;
					case 'trigger': 		$middleCenter .= '<div class="tt_center_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$middleCenter .= '<div class="tt_center_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$middleCenter .= '<div class="tt_center_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$middleCenter 		.= '</div>';

		// middle right
		$middleRight 		= '<div class="tt_right">';
		if(isset($arlo_fn_option['three_lines_sorter']['middle_right']) && !empty($arlo_fn_option['three_lines_sorter']['middle_right'])){
			foreach($arlo_fn_option['three_lines_sorter']['middle_right'] as $key => $value){
				switch($key){
					case 'extra_info': 		$middleRight .= '<div class="tt_right_item">'.$information.'</div>'; break;
					case 'helper': 			$middleRight .= '<div class="tt_right_item">'.$helperList.'</div>'; break;
					case 'social': 			$middleRight .= '<div class="tt_right_item">'.$socialList.'</div>'; break;
					case 'logo': 			$middleRight .= '<div class="tt_right_item">'.$logo.'</div>'; break;
					case 'trigger': 		$middleRight .= '<div class="tt_right_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$middleRight .= '<div class="tt_right_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$middleRight .= '<div class="tt_right_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$middleRight 		.= '</div>';

		$middlePartHTML			 = '<div class="third_middle">';
			$middlePartHTML			.= '<div class="container">';
				$middlePartHTML			.= '<div class="third_middle_in">';
					$middlePartHTML			.= $middleLeft.$middleCenter.$middleRight;
				$middlePartHTML			.= '</div>';
			$middlePartHTML			.= '</div>';
		$middlePartHTML			.= '</div>';

		// ********************************************************************************************
		// get BOTTOM PART
		// ********************************************************************************************

		// bottom left
		$bottomLeft 		= '<div class="tt_left">';
		if($menuPos == 'left'){$bottomLeft .= '<div class="tt_left_item">'.$navMenu.'</div>';}
		if(isset($arlo_fn_option['three_lines_sorter']['bottom_left']) && !empty($arlo_fn_option['three_lines_sorter']['bottom_left'])){
			foreach($arlo_fn_option['three_lines_sorter']['bottom_left'] as $key => $value){
				switch($key){
					case 'extra_info': 		$bottomLeft .= '<div class="tt_left_item">'.$information.'</div>'; break;
					case 'helper': 			$bottomLeft .= '<div class="tt_left_item">'.$helperList.'</div>'; break;
					case 'social': 			$bottomLeft .= '<div class="tt_left_item">'.$socialList.'</div>'; break;
					case 'logo': 			$bottomLeft .= '<div class="tt_left_item">'.$logo.'</div>'; break;
					case 'trigger': 		$bottomLeft .= '<div class="tt_left_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$bottomLeft .= '<div class="tt_left_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$bottomLeft .= '<div class="tt_left_item">'.$extraButton2.'</div>';} break;
				}
			}
		}

		$bottomLeft 		.= '</div>';

		// bottom center
		$bottomCenter 		= '<div class="tt_center">';
		if($menuPos == 'center'){$bottomCenter .= '<div class="tt_center_item">'.$navMenu.'</div>';}
		if(isset($arlo_fn_option['three_lines_sorter']['bottom_center']) && !empty($arlo_fn_option['three_lines_sorter']['bottom_center'])){
			foreach($arlo_fn_option['three_lines_sorter']['bottom_center'] as $key => $value){
				switch($key){
					case 'extra_info': 		$bottomCenter .= '<div class="tt_center_item">'.$information.'</div>'; break;
					case 'helper': 			$bottomCenter .= '<div class="tt_center_item">'.$helperList.'</div>'; break;
					case 'social': 			$bottomCenter .= '<div class="tt_center_item">'.$socialList.'</div>'; break;
					case 'logo': 			$bottomCenter .= '<div class="tt_center_item">'.$logo.'</div>'; break;
					case 'trigger': 		$bottomCenter .= '<div class="tt_center_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$bottomCenter .= '<div class="tt_center_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$bottomCenter .= '<div class="tt_center_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$bottomCenter 		.= '</div>';

		// bottom right
		$bottomRight 		= '<div class="tt_right">';
		if($menuPos == 'right'){$bottomRight .= '<div class="tt_right_item">'.$navMenu.'</div>';}
		if(isset($arlo_fn_option['three_lines_sorter']['bottom_right']) && !empty($arlo_fn_option['three_lines_sorter']['bottom_right'])){
			foreach($arlo_fn_option['three_lines_sorter']['bottom_right'] as $key => $value){
				switch($key){
					case 'extra_info': 		$bottomRight .= '<div class="tt_right_item">'.$information.'</div>'; break;
					case 'helper': 			$bottomRight .= '<div class="tt_right_item">'.$helperList.'</div>'; break;
					case 'social': 			$bottomRight .= '<div class="tt_right_item">'.$socialList.'</div>'; break;
					case 'logo': 			$bottomRight .= '<div class="tt_right_item">'.$logo.'</div>'; break;
					case 'trigger': 		$bottomRight .= '<div class="tt_right_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$bottomRight .= '<div class="tt_right_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$bottomRight .= '<div class="tt_right_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$bottomRight 		.= '</div>';

		$bottomPartHTML			 = '<div class="third_bottom">';
			$bottomPartHTML			.= '<div class="container">';
				$bottomPartHTML			.= '<div class="third_bottom_in">';
					$bottomPartHTML			.= $bottomLeft.$bottomCenter.$bottomRight;
				$bottomPartHTML			.= '</div>';
			$bottomPartHTML			.= '</div><div class="arlo_fn_megamenu"></div>';
		$bottomPartHTML			.= '</div>';
	}

	
	
		


	

	
	$html = $topPartHTML.$middlePartHTML.$bottomPartHTML;
	

	$style = '';
	if($navigationSkin == 'custom'){
		// menu color
		$menuColor				= '#333';
		if(isset($arlo_fn_option['three_lines_menu_color'])){
			$menuColor			= $arlo_fn_option['three_lines_menu_color'];
		}
		// menu hover color
		$menuHoverColor			= '#111';
		if(isset($arlo_fn_option['three_lines_menu_hover_color'])){
			$menuHoverColor		= $arlo_fn_option['three_lines_menu_hover_color'];
		}
		// helper color
		$helperColor			= '#fff';
		if(isset($arlo_fn_option['three_lines_helper_color'])){
			$helperColor		= $arlo_fn_option['three_lines_helper_color'];
		}
		$style					 = '<style>';
		$style					.= '.arlo_fn_custom_lang_switcher span.click,.arlo_fn_custom_lang_switcher > a{color:'.$helperColor.';}';
		$style					.= '.arlo_fn_three_lines .arlo_fn_buy_nav a.buy_icon .arlo_fn_svg,.arlo_fn_three_lines .arlo_fn_search_nav a .arlo_fn_svg{color:'.$helperColor.';}';
		$style					.= '.arlo_fn_three_lines ul.nav__hor > li.menu-item-has-children > a:after{border-top-color:'.$menuColor.';}';
		$style					.= '.arlo_fn_three_lines ul.nav__hor > li > a{color: '.$menuColor.';}';
		$style 					.= '.arlo_fn_three_lines ul.nav__hor > li.opened > a, .arlo_fn_three_lines ul.nav__hor > li > a:hover{color:'.$menuHoverColor.';}';
		if(isset($paddingCSS)){
			$style				.= $paddingCSS;
		}
		$style					.= $topbarCSS.$middlebarCSS.$bottombarCSS;
		$style 					.= '</style>';
	}
		
?>

<!-- HEADER -->
<div class="arlo_fn_three_lines <?php echo esc_attr($navigationWidth);?>" style="position: <?php echo esc_attr($navigationPos);?>" data-line="<?php echo esc_attr($navigationBottomLine);?>" data-middle-logo="<?php echo esc_attr($middleLogo);?>" data-position="<?php echo esc_attr($navigationPos);?>" data-skin="<?php echo esc_attr($navigationSkin);?>">
	<?php echo $html; ?>
	<?php echo $style ;?>
</div>
<!-- /HEADER -->

<!-- SEARCH POPUP -->
<div class="arlo_fn_searchpopup">
	<div class="search_inner">
		<div class="container">
			<div class="search_box">
				<form action="<?php echo esc_url(home_url('/')); ?>" method="get" >
					<input type="text" placeholder="<?php esc_attr_e('Search', 'arlo');?>" name="s" autocomplete="off" />
					<input type="submit" class="pe-7s-search" value="" />
					<a href="#"><img class="arlo_fn_svg" src="<?php echo get_template_directory_uri();?>/framework/svg/search-new.svg" alt="<?php echo esc_attr__('svg', 'arlo');?>" /></a>
				</form>
			</div>
		</div>
		<div class="search_closer">
			<span class="s_text"><?php esc_html_e('Close', 'arlo');?></span>
			<span class="s_btn"></span>
		</div>
	</div>
</div>
<!-- /SEARCH POPUP -->