<?php 
	global $arlo_fn_option, $post;
	
	$main_nav 	= array('theme_location'  => 'main_menu','menu_class' => 'arlo_fn_main_nav vert_nav');

	$allLogos 	= arlo_fn_getLogo();
	$lightLogo	= $allLogos[0];
	$darkLogo	= $allLogos[1];
	$customLogo	= $allLogos[2];

	$sidebar_nav_alignment 		= 'left';
	if(isset($arlo_fn_option['sidebar_nav_alignment'])){
		$sidebar_nav_alignment 	= $arlo_fn_option['sidebar_nav_alignment'];
	}
	
	$sidebar_opener				= get_option('arlo_fn_sidebar_opener', 'off');
?>
 
<!-- HEADER -->
<div class="arlo_fn_header" data-align="<?php echo esc_attr($sidebar_nav_alignment); ?>">
	<div class="header_inner">
		<div class="menu_logo">
			<a href="<?php echo esc_url(home_url('/')); ?>">
				<img class="desktop_logo" src="<?php echo esc_url($lightLogo);?>" alt="<?php esc_attr(bloginfo('description')); ?>" />
				<img class="desktop_logo_dark" src="<?php echo esc_url($darkLogo);?>" alt="<?php esc_attr(bloginfo('description')); ?>" />
				<img class="desktop_logo_custom" src="<?php echo esc_url($customLogo);?>" alt="<?php esc_attr(bloginfo('description')); ?>" />
				<span><span class="span_a"></span><span class="span_b"></span></span>
			</a>
		</div>
		<div class="menu_nav">

			<?php if(has_nav_menu('main_menu')){ wp_nav_menu( $main_nav );} else{echo '<ul class="vert_nav"><li><a href="">'.esc_html__('No menu assigned', 'arlo').'</a></li></ul>';}?>

		</div>
		<div class="header_closer"></div>
		<div class="arlo_fn_tagline">
			<?php if(isset($arlo_fn_option['search_switch']) && $arlo_fn_option['search_switch'] !== 'disable'){?>
			<div class="tline_search">
				<form action="<?php echo esc_url(home_url('/')); ?>" method="get" >
					<input type="text" placeholder="<?php esc_attr_e('Search', 'arlo');?>" name="s" autocomplete="off" />
					<input type="submit" class="pe-7s-search" value="" />
					<a href="#" class="right"><img class="arlo_fn_svg" src="<?php echo get_template_directory_uri();?>/framework/svg/search.svg" alt="<?php echo esc_attr__('svg', 'arlo');?>" /></a>
					<a href="#" class="left"><img class="arlo_fn_svg" src="<?php echo get_template_directory_uri();?>/framework/svg/search.svg" alt="<?php echo esc_attr__('svg', 'arlo');?>" /></a>
				</form>
			</div>
			<?php }?>
			
			<?php echo arlo_fn_getSocialList();?>
		</div>
	</div>
</div>
<!-- /HEADER -->