<?php 
	global $arlo_fn_option, $post;
	
	$main_nav 	= array('theme_location'  => 'main_menu','menu_class' => 'arlo_fn_main_nav nav__hor', 'echo' => false, 'walker' => new arlo_fn_walker);
	

	$allLogos 	= arlo_fn_getLogo('one_line');
	$lightLogo	= $allLogos[0];
	$darkLogo	= $allLogos[1];
	$customLogo	= $allLogos[2];
	


	
	// get navigation width
	$navigationWidth			= 'full';
	if(isset($arlo_fn_option['one_line_nav_width'])){
		$navigationWidth		= $arlo_fn_option['one_line_nav_width'];
	}
	if(isset($_GET['width'])){$navigationWidth = $_GET['width'];}
	
	// get navigation padding left and right
	$paddingLeftRightSize		= 50;
	$paddingLeftRightUnit		= 'px';
	if(isset($arlo_fn_option['one_line_left_right']['width']) && isset($arlo_fn_option['one_line_left_right']['units'])){
		$paddingLeftRightSize	= (int)$arlo_fn_option['one_line_left_right']['width'];
		$paddingLeftRightUnit	= $arlo_fn_option['one_line_left_right']['units'];
	}
	if($navigationWidth == 'full'){
		if($paddingLeftRightUnit != 'px' && $paddingLeftRightUnit != '%'){$paddingLeftRightUnit = 'px';}
		$size					= $paddingLeftRightSize.$paddingLeftRightUnit;
		$paddingCSS				= '.arlo_fn_one_line.full{padding-left:'.$size.';padding-right:'.$size.';}';
	}
	
	// get navigation position
	$navigationPos				= 'relative';
	if(isset($arlo_fn_option['one_line_position'])){
		$navigationPos			= $arlo_fn_option['one_line_position'];
	}
	if(function_exists('rwmb_meta')){
		$navigationPos 			= get_post_meta(get_the_ID(),'arlo_fn_page_nav_position', true);
		if($navigationPos === 'default' && isset($arlo_fn_option['one_line_position'])){
			$navigationPos 		= $arlo_fn_option['one_line_position'];
		}
	}
	if(isset($arlo_fn_option['one_line_position'])){
		if($navigationPos === 'undefined' || $navigationPos === ''){
			$navigationPos 		= $arlo_fn_option['one_line_position'];
		}
	}
	
	// get navigation skin
	$navigationSkin				= arlo_fn_getLinesNavSkin('one_line');
	if($navigationSkin != 'dark' && $navigationSkin != 'light' && $navigationSkin != 'custom' && $navigationPos != 'fixed'){$navigationPos = 'absolute';}
	if(is_404() || is_search() || is_archive()){
		$navigationSkin = 'light';
		$navigationPos 	= 'relative';
	}

	
	// get navigation bottom line
	$navigationBottomLine		= 'enabled';
	if(isset($arlo_fn_option['one_line_border'])){
		$navigationBottomLine	= $arlo_fn_option['one_line_border'];
	}

	
	// get navigation background type
	$navigationCSS					= '';
	if($navigationSkin == 'custom'){
		$navigationBG				= 'color';
		if(isset($arlo_fn_option['one_line_bg'])){
			$navigationBG			= $arlo_fn_option['one_line_bg'];
		}
		// get navigation background style
		if($navigationBG == 'color'){
			$navigationBGColor		= '#000';
			if(isset($arlo_fn_option['one_line_bg_color'])){
				$navigationBGColor	= $arlo_fn_option['one_line_bg_color']['rgba'];
			}
			$navigationCSS			= 'background-color:'.$navigationBGColor.';';
		}else if($navigationBG == 'none'){
			$navigationCSS			= 'background-color:transparent;';
		}else if($navigationBG == 'gradient'){
			$gradientDegree			= '90';
			$gradientFrom			= '#290a59';
			$gradientTo				= '#6d1392';
			if(isset($arlo_fn_option['one_line_bg_gradient_color'])){
				$gradientFrom		= $arlo_fn_option['one_line_bg_gradient_color']['from'];
				$gradientTo			= $arlo_fn_option['one_line_bg_gradient_color']['to'];
			}
			if(isset($arlo_fn_option['one_line_bg_gradient_degree'])){
				$gradientDegree		= $arlo_fn_option['one_line_bg_gradient_degree'];
			}
			$gradientDegree			.= 'deg, ';
			$navigationCSS			= 'background: '.$gradientFrom.'; background: -webkit-linear-gradient('.$gradientDegree.$gradientFrom.', '.$gradientTo.'); background: -o-linear-gradient('.$gradientDegree.$gradientFrom.', '.$gradientTo.'); background: -moz-linear-gradient('.$gradientDegree.$gradientFrom.', '.$gradientTo.'); background: linear-gradient('.$gradientDegree	.$gradientFrom.', '.$gradientTo.');';
		}
	}
		

	
	// get navigation border
	$navigationBorder			= 'enabled';
	if(isset($arlo_fn_option['one_line_border'])){
		$navigationBorder		= $arlo_fn_option['one_line_border'];
	}


	if($navigationSkin == 'light' || $navigationSkin == 'translight' || $navigationSkin == 'nonedark'){
		$defaultLogo 	= $lightLogo;
	}else if($navigationSkin == 'dark' || $navigationSkin == 'transdark' || $navigationSkin == 'nonelight'){
		$defaultLogo 	= $darkLogo;
	}else{
		$defaultLogo 	= $customLogo;
	}
	$logo				= '<div class="fn_logo"><a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($defaultLogo).'" alt="" /></a></div>';
	$hiddenLogo			= '<div class="fn_logo" style="display:none;"><a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($defaultLogo).'" alt="" /></a></div>';

	$trigger 			= arlo_fn_getMainTrigger();
	$socialList			= arlo_fn_getSocialList();
	$helperList			= arlo_fn_getHelperLineNavigation();


	if(has_nav_menu('main_menu')){
		$menu 			= wp_nav_menu( $main_nav );
	}else{
		$menu 			= '<ul class="nav__hor"><li><a href="">'.esc_html__('No menu assigned', 'arlo').'</a></li></ul>';
	}

	$middleLogo			= false;
	$menuCount			= 1;
	if(isset($arlo_fn_option['one_line_middle_logo_in_nav'])){
		$middleLogo		= $arlo_fn_option['one_line_middle_logo_in_nav'];
	}

	
	// ********************************************************************************************
	// Extra Buttons
	// ********************************************************************************************
	$extraButton1				= '';
	$extraButton1Switcher 		= true;
	if(isset($arlo_fn_option['extra_button_1_switcher'])){
		$extraButton1Switcher	= $arlo_fn_option['extra_button_1_switcher'];
	}
	$extraButton2				= '';
	$extraButton2Switcher		= true;
	if(isset($arlo_fn_option['extra_button_2_switcher'])){
		$extraButton2Switcher	= $arlo_fn_option['extra_button_2_switcher'];
	}
	// ********************************************************************************************
	// DISABLED column
	// ********************************************************************************************
	if(isset($arlo_fn_option['one_sorter']['disabled']) && !empty($arlo_fn_option['one_sorter']['disabled'])){
		foreach($arlo_fn_option['one_sorter']['disabled'] as $key => $value){
			if($key == 'menu'){$menuCount = 0;}
			if($key == 'extra_button_1'){$extraButton1Switcher = false;}
			if($key == 'extra_button_2'){$extraButton2Switcher = false;}
		}
	}
	
	if($middleLogo && $menuCount == 1){
		$logo			= $hiddenLogo;
	}
	if($extraButton1Switcher){
		$extraButton1 	= arlo_fn_getExtraButtons(1);
	}
	if($extraButton2Switcher){
		$extraButton2 	= arlo_fn_getExtraButtons(2);
	}

	
	if(isset($_GET['middle_logo'])){
		$middleLogo		= true;
		$logo			= $hiddenLogo;
	}

	if(isset($_GET['one_line'])){
		$globalNavStructure = $_GET['one_line'];
		$extraArray        	= explode(',', $globalNavStructure);


		foreach($extraArray as $eArr){
			if(strpos($eArr, 'left:') !== false){
				$expStr 	= explode("left:",$eArr);
				$leftArr  	= array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'center:') !== false) {
				$expStr 	= explode("center:",$eArr);
				$centerArr  = array_unique(explode('.', $expStr[1]));
			}else if(strpos($eArr, 'right:') !== false) {
				$expStr 	= explode("right:",$eArr);
				$rightArr  	= array_unique(explode('.', $expStr[1]));
			}
		}
		
		$extraButton1 		= arlo_fn_getExtraButtons(1);
		$extraButton2 		= arlo_fn_getExtraButtons(2);
		
		// left
		$left 		= '<div class="tt_left">';
		if(isset($leftArr)){
			foreach($leftArr as $key){
				switch($key){
					case 'menu': 			$left .= '<div class="tt_left_item">'.$menu.'</div>'; break;
					case 'helper': 			$left .= '<div class="tt_left_item">'.$helperList.'</div>'; break;
					case 'social': 			$left .= '<div class="tt_left_item">'.$socialList.'</div>'; break;
					case 'logo': 			$left .= '<div class="tt_left_item">'.$logo.'</div>'; break;
					case 'trigger': 		$left .= '<div class="tt_left_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$left .= '<div class="tt_left_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$left .= '<div class="tt_left_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$left 		.= '</div>';
		
		// center
		$center 	= '<div class="tt_center">';
		if(isset($centerArr)){
			foreach($centerArr as $key){
				switch($key){
					case 'menu': 			$center .= '<div class="tt_center_item">'.$menu.'</div>'; break;
					case 'helper': 			$center .= '<div class="tt_center_item">'.$helperList.'</div>'; break;
					case 'social': 			$center .= '<div class="tt_center_item">'.$socialList.'</div>'; break;
					case 'logo': 			$center .= '<div class="tt_center_item">'.$logo.'</div>'; break;
					case 'trigger': 		$center .= '<div class="tt_center_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$center .= '<div class="tt_center_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$center .= '<div class="tt_center_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$center 		.= '</div>';
		
		// right
		$right 		= '<div class="tt_right">';
		if(isset($rightArr)){
			foreach($rightArr as $key){
				switch($key){
					case 'menu': 			$right .= '<div class="tt_right_item">'.$menu.'</div>'; break;
					case 'helper': 			$right .= '<div class="tt_right_item">'.$helperList.'</div>'; break;
					case 'social': 			$right .= '<div class="tt_right_item">'.$socialList.'</div>'; break;
					case 'logo': 			$right .= '<div class="tt_right_item">'.$logo.'</div>'; break;
					case 'trigger': 		$right .= '<div class="tt_right_item">'.$trigger.'</div>'; break;
					case 'extra_button_1': 	if($extraButton1 != ''){$right .= '<div class="tt_right_item">'.$extraButton1.'</div>';} break;
					case 'extra_button_2': 	if($extraButton2 != ''){$right .= '<div class="tt_right_item">'.$extraButton2.'</div>';} break;
				}
			}
		}
		$right 		.= '</div>';
		
		$globalNav = $left.$center.$right;
	}
		
	// ********************************************************************************************
	// get LEFT
	// ********************************************************************************************

	$left 		= '<div class="tt_left">';
	if(isset($arlo_fn_option['one_sorter']['left']) && !empty($arlo_fn_option['one_sorter']['left'])){
		foreach($arlo_fn_option['one_sorter']['left'] as $key => $value){
			
			
			switch($key){
				case 'menu': 			$left .= '<div class="tt_left_item">'.$menu.'</div>'; break;
				case 'helper': 			$left .= '<div class="tt_left_item">'.$helperList.'</div>'; break;
				case 'social': 			$left .= '<div class="tt_left_item">'.$socialList.'</div>'; break;
				case 'logo': 			$left .= '<div class="tt_left_item">'.$logo.'</div>'; break;
				case 'trigger': 		$left .= '<div class="tt_left_item">'.$trigger.'</div>'; break;
				case 'extra_button_1': 	if($extraButton1 != ''){$left .= '<div class="tt_left_item">'.$extraButton1.'</div>';} break;
				case 'extra_button_2': 	if($extraButton2 != ''){$left .= '<div class="tt_left_item">'.$extraButton2.'</div>';} break;
			}
		}
	}
	$left 		.= '</div>';

	// ********************************************************************************************
	// get CENTER
	// ********************************************************************************************
	$center 	= '<div class="tt_center">';
	if(isset($arlo_fn_option['one_sorter']['center']) && !empty($arlo_fn_option['one_sorter']['center'])){
		foreach($arlo_fn_option['one_sorter']['center'] as $key => $value){
			switch($key){
				case 'menu': 			$center .= '<div class="tt_center_item">'.$menu.'</div>'; break;
				case 'helper': 			$center .= '<div class="tt_center_item">'.$helperList.'</div>'; break;
				case 'social': 			$center .= '<div class="tt_center_item">'.$socialList.'</div>'; break;
				case 'logo': 			$center .= '<div class="tt_center_item">'.$logo.'</div>'; break;
				case 'trigger': 		$center .= '<div class="tt_center_item">'.$trigger.'</div>'; break;
				case 'extra_button_1': 	if($extraButton1 != ''){$center .= '<div class="tt_center_item">'.$extraButton1.'</div>';} break;
				case 'extra_button_2': 	if($extraButton2 != ''){$center .= '<div class="tt_center_item">'.$extraButton2.'</div>';} break;
			}
		}
	}
	$center 		.= '</div>';

	// ********************************************************************************************
	// get RIGHT
	// ********************************************************************************************
	$right 		= '<div class="tt_right">';
	if(isset($arlo_fn_option['one_sorter']['right']) && !empty($arlo_fn_option['one_sorter']['right'])){
		foreach($arlo_fn_option['one_sorter']['right'] as $key => $value){
			switch($key){
				case 'menu': 			$right .= '<div class="tt_right_item">'.$menu.'</div>'; break;
				case 'helper': 			$right .= '<div class="tt_right_item">'.$helperList.'</div>'; break;
				case 'social': 			$right .= '<div class="tt_right_item">'.$socialList.'</div>'; break;
				case 'logo': 			$right .= '<div class="tt_right_item">'.$logo.'</div>'; break;
				case 'trigger': 		$right .= '<div class="tt_right_item">'.$trigger.'</div>'; break;
				case 'extra_button_1': 	if($extraButton1 != ''){$right .= '<div class="tt_right_item">'.$extraButton1.'</div>';} break;
				case 'extra_button_2': 	if($extraButton2 != ''){$right .= '<div class="tt_right_item">'.$extraButton2.'</div>';} break;
			}
		}
	}
	$right 		.= '</div>';
	
	$localNav	= $left.$center.$right;
	if(isset($globalNav)){
		if($globalNav != ""){
			$localNav = $globalNav;
		}
	}
	
	$echoHTML			 = '<div class="arlo_fn_one_line '.$navigationWidth.'" style="position:'.esc_attr($navigationPos).'; '.esc_attr($navigationCSS).'" data-line="'.esc_attr($navigationBottomLine).'" data-middle-logo="'.$middleLogo.'" data-position="'.esc_attr($navigationPos).'" data-skin="'.esc_attr($navigationSkin).'">';

		$echoHTML			.= '<div class="container">';
			$echoHTML			.= '<div class="one_line_in">';
				$echoHTML			.= $localNav;
			$echoHTML			.= '</div>';
		$echoHTML			.= '</div>';

		$echoHTML			.= '<div class="arlo_fn_megamenu"></div>';
	$echoHTML			.= '</div>';
	
	
	
	$style = '';
	if($navigationSkin == 'custom'){
		// menu color
		$menuColor				= '#333';
		if(isset($arlo_fn_option['one_line_menu_color'])){
			$menuColor			= $arlo_fn_option['one_line_menu_color'];
		}
		// menu hover color
		$menuHoverColor			= '#111';
		if(isset($arlo_fn_option['one_line_menu_hover_color'])){
			$menuHoverColor		= $arlo_fn_option['one_line_menu_hover_color'];
		}
		// helper color
		$helperColor			= '#333';
		if(isset($arlo_fn_option['one_line_helper_color'])){
			$helperColor		= $arlo_fn_option['one_line_helper_color'];
		}
		$style					 = '<style>';
		$style					.= '.arlo_fn_custom_lang_switcher span.click,.arlo_fn_custom_lang_switcher > a{color:'.$helperColor.';}';
		$style					.= '.arlo_fn_buy_nav a.buy_icon .arlo_fn_svg, .arlo_fn_search_nav a .arlo_fn_svg{color:'.$helperColor.';}';
		$style					.= '.arlo_fn_one_line ul.nav__hor > li.menu-item-has-children > a:after{border-top-color:'.$menuColor.';}';
		$style					.= '.arlo_fn_one_line ul.nav__hor > li > a{color: '.$menuColor.';}';
		$style 					.= '.arlo_fn_one_line ul.nav__hor > li.opened > a, .arlo_fn_one_line ul.nav__hor > li > a:hover{color:'.$menuHoverColor.';}';
		if(isset($paddingCSS)){
			$style				.= $paddingCSS;
		}
		$style 					.= '</style>';
	}
		
?>

<?php echo $echoHTML; ?>
<?php echo $style; ?>



<!-- SEARCH POPUP -->
<div class="arlo_fn_searchpopup">
	<div class="search_inner">
		<div class="container">
			<div class="search_box">
				<form action="<?php echo esc_url(home_url('/')); ?>" method="get" >
					<input type="text" placeholder="<?php esc_attr_e('Search', 'arlo');?>" name="s" autocomplete="off" />
					<input type="submit" class="pe-7s-search" value="" />
					<a href="#"><img class="arlo_fn_svg" src="<?php echo get_template_directory_uri();?>/framework/svg/search-new.svg" alt="<?php echo esc_attr__('svg', 'arlo');?>" /></a>
				</form>
			</div>
		</div>
		<div class="search_closer">
			<span class="s_text"><?php esc_html_e('Close', 'arlo');?></span>
			<span class="s_btn"></span>
		</div>
	</div>
</div>
<!-- /SEARCH POPUP -->

