<?php
/*
Name: ArloLike
Description: Custom Love Posts
Author: Frenify
Author URI: http://themeforest.net/user/frenify
*/


class ArloLike {
	
	 function __construct()   {	
        add_action('wp_ajax_arlo_fn_like', array(&$this, 'ajax'));
		add_action('wp_ajax_nopriv_arlo_fn_like', array(&$this, 'ajax'));
	}
	
	
	
	function ajax($postID) {
		
		//  -- update
		if( isset($_POST['ID']) ) {
			$postID = str_replace('arlo_fn_like_', '', $_POST['ID']);
			echo wp_kses_post($this->like_post($postID, 'update'));
		} 
		
		//  -- get
		else {
			$postID = str_replace('arlo_fn_like_', '', $_POST['ID']);
			echo wp_kses_post($this->like_post($postID, 'get'));
		}
		
		exit;
	}
	
	
	function like_post($postID, $action = 'get') 
	{
		if(!is_numeric($postID)) return;
	
		switch($action) {
		
			case 'get':
				$likeCount = get_post_meta($postID, '_arlo_fn_like', true);
				if( !$likeCount ){
					$likeCount = 0;
					add_post_meta($postID, '_arlo_fn_like', $likeCount, true);
				}
				
				$countShort = arlo_fn_number_format_short($likeCount);
				return wp_kses_post('<span class="arlo_fn_like_count like_count">'. $countShort .'</span>');
				break;
				
			case 'update':
				$likeCount = get_post_meta($postID, '_arlo_fn_like', true);
				if( isset($_COOKIE['arlo_fn_like_'. $postID]) ) return esc_html($likeCount);
				
				$likeCount++;
				update_post_meta($postID, '_arlo_fn_like', $likeCount);
				setcookie('arlo_fn_like_'. $postID, $postID, time()*20, '/');
				
				$countShort = arlo_fn_number_format_short($likeCount);
				return wp_kses_post('<span class="arlo_fn_like_count like_count">'. $countShort .'</span>');
				break;
		
		}
	}


	function add_like($postID) {
		global $post;

		$count = $this->like_post($postID);
  
  		$class = 'arlo_fn_like not-rated';
//  		$title = esc_html__('Like this', 'arlo');
		
		$svgURL			= get_template_directory_uri().'/framework/svg/like-empty.svg';
		
		if( isset($_COOKIE['arlo_fn_like_'. $postID]) ){
			$class 		= 'arlo_fn_like liked';
//			$title 		= esc_html__('You already liked this!', 'arlo');
			$svgURL		= get_template_directory_uri().'/framework/svg/like-full.svg';
		}
		
		$title = '';
		
		$svg	= '<img class="arlo_w_fn_svg" src="'.$svgURL.'" alt="" />';
		
		return wp_kses_post('<a href="#" class="'. $class .'" id="arlo_fn_like_'. $postID .'" title="'. $title .'">'.$svg.$count.'</a>');
	}
	
}


global $arlo_fn_like;
$arlo_fn_like = new ArloLike();

// main function 
function arlo_fn_like($postID, $return = '') {
	global $arlo_fn_like;
	
	if($return == 'return') {
		return wp_kses_post($arlo_fn_like->add_like($postID)); 
	} else {
		echo wp_kses_post($arlo_fn_like->add_like($postID)); 
	}
} 
?>
