<?php
/*-----------------------------------------------------------------------------------*/
/**
 * Filters wp_title to print a neat <title> tag based on what is being viewed.
 *
 * @param string $title Default title text for current view.
 * @param string $sep Optional separator.
 * @return string The filtered title.
 */
/*-----------------------------------------------------------------------------------*/	

global $arlo_fn_option, $post;
use Frel\Frel_Helper;
if( !function_exists('arlo_fn_get_image_url_from_id') ){
	function arlo_fn_get_image_url_from_id($image_id, $size = 'full'){
		if( empty($image_id) ) return '';
	
		if( is_numeric($image_id) ){
			$alt_text = get_post_meta($image_id , '_wp_attachment_image_alt', true);	
			$image_src = wp_get_attachment_image_src($image_id, $size);	
			if( empty($image_src) ) return '';
			
			$ret = esc_url($image_src[0]);
		}else{
			$ret = esc_url($image_id);
		}
		
		
		return wp_kses_post($ret);
	}
}


function arlo_fn_getPostType(){
	$postType = get_post_type_object(get_post_type());
	if ($postType) {
		return esc_html($postType->labels->singular_name);
	}
}
function arlo_fn_getImageInSearchList($thumb = 'full') {
  	global $post, $posts;
	$first_img 		= '';
	if(has_post_thumbnail()){
		$first_img 	= get_the_post_thumbnail_url(get_the_id(),$thumb);
	}else{
		ob_start();
		ob_end_clean();
		$output 	= preg_match_all('/<img.+?src=[\'"]([^\'"]+)[\'"].*?>/i', $post->post_content, $matches);
		if(isset($matches[1][0])){
			$first_img = $matches[1][0];
		}
	}
	$first_img 	= get_the_post_thumbnail_url(get_the_id(),$thumb); // will be removed
	return $first_img;
}

function arlo_fn_reading_time( $content ) {

	// Predefined words-per-minute rate.
	$words_per_minute = 225;
	$words_per_second = $words_per_minute / 60;

	// Count the words in the content.
	$word_count = str_word_count( strip_tags( $content ) );

	// [UNUSED] How many minutes?
	$minutes = floor( $word_count / $words_per_minute );

	// [UNUSED] How many seconds (remainder)?
	$seconds_remainder = floor( $word_count % $words_per_minute / $words_per_second );

	// How many seconds (total)?
	$seconds_total = floor( $word_count / $words_per_second );

	return $minutes;
	return $seconds_total;
}

function arlo_fn_getSVG_core($name = '', $class = ''){
	return '<img class="arlo_w_fn_svg '.$class.'" src="'.ARLO_CORE_SHORTCODE_URL.'assets/svg/'.$name.'.svg" alt="svg" />';
}

function arlo_fn_getSVG_theme($name = '', $class = ''){
	return '<img class="arlo_fn_svg '.$class.'" src="'.get_template_directory_uri().'/framework/svg/'.$name.'.svg" alt="svg" />';
}

function arlo_fn_number_format_short( $n, $precision = 1 ) {
	if ($n < 900) {
		// 0 - 900
		$n_format = number_format($n, $precision);
		$suffix = '';
	} else if ($n < 900000) {
		// 0.9k-850k
		$n_format = number_format($n / 1000, $precision);
		$suffix = 'K';
	} else if ($n < 900000000) {
		// 0.9m-850m
		$n_format = number_format($n / 1000000, $precision);
		$suffix = 'M';
	} else if ($n < 900000000000) {
		// 0.9b-850b
		$n_format = number_format($n / 1000000000, $precision);
		$suffix = 'B';
	} else {
		// 0.9t+
		$n_format = number_format($n / 1000000000000, $precision);
		$suffix = 'T';
	}
  // Remove unecessary zeroes after decimal. "1.0" -> "1"; "1.00" -> "1"
  // Intentionally does not affect partials, eg "1.50" -> "1.50"
	if ( $precision > 0 ) {
		$dotzero = '.' . str_repeat( '0', $precision );
		$n_format = str_replace( $dotzero, '', $n_format );
	}
	return $n_format . $suffix;
}

/* since 11.05.2020 */
function arlo_fn_share_post($postID,$shareText){
	global $arlo_fn_option;
	$html			= '';
	$src 			= '';
	if (has_post_thumbnail()) {
		$thumbID 	= get_post_thumbnail_id( $postID );
		$src 		= wp_get_attachment_image_src( $thumbID, 'full');
		$src 		= $src[0];
	}
	$sh				= 'share_';				// share option
	$tg				= 'target="_blank"';	// target _blank

	if(isset($arlo_fn_option)){
		if(isset($arlo_fn_option[$sh.'facebook']) && $arlo_fn_option[$sh.'facebook'] != 'disable') {
			$html	.= '<li>';
				$html	.= '<a href="http://www.facebook.com/sharer.php?u='.get_the_permalink().'" '.$tg.'>';
					$html	.= '<i class="xcon-facebook fn-relative-xcon"></i>';
					$html	.= '<i class="xcon-facebook fn-absolute-xcon"></i>';
				$html	.= '</a>';
			$html	.= '</li>';
		}
		if(isset($arlo_fn_option[$sh.'twitter']) && $arlo_fn_option[$sh.'twitter'] != 'disable') {
			$html	.= '<li>';
				$html	.= '<a href="https://twitter.com/share?url='.get_the_permalink().'" '.$tg.'>';
					$html	.= '<i class="xcon-twitter fn-relative-xcon"></i>';
					$html	.= '<i class="xcon-twitter fn-absolute-xcon"></i>';
				$html	.= '</a>';
			$html	.= '</li>';
		}
		if(isset($arlo_fn_option[$sh.'google']) && $arlo_fn_option[$sh.'google'] != 'disable') {
			$html	.= '<li>';
				$html	.= '<a href="https://plus.google.com/share?url='.get_the_permalink().'" '.$tg.'>';
					$html	.= '<i class="xcon-gplus fn-relative-xcon"></i>';
					$html	.= '<i class="xcon-gplus fn-absolute-xcon"></i>';
				$html	.= '</a>';
			$html	.= '</li>';
		}
		if(isset($arlo_fn_option[$sh.'pinterest']) && $arlo_fn_option[$sh.'pinterest'] != 'disable') {
			$html	.= '<li>';
				$html	.= '<a href="http://pinterest.com/pin/create/button/?url='.get_the_permalink().'&amp;media='.$src.'" '.$tg.'>';
					$html	.= '<i class="xcon-pinterest fn-relative-xcon"></i>';
					$html	.= '<i class="xcon-pinterest fn-absolute-xcon"></i>';
				$html	.= '</a>';
			$html	.= '</li>';
		}
		if(isset($arlo_fn_option[$sh.'linkedin']) && $arlo_fn_option[$sh.'linkedin'] != 'disable') {
			$html	.= '<li>';
				$html	.= '<a href="http://linkedin.com/shareArticle?mini=true&amp;url='.get_the_permalink().'&amp;" '.$tg.'>';
					$html	.= '<i class="xcon-linkedin fn-relative-xcon"></i>';
					$html	.= '<i class="xcon-linkedin fn-absolute-xcon"></i>';
				$html	.= '</a>';
			$html	.= '</li>';
		}
		if(isset($arlo_fn_option[$sh.'email']) && $arlo_fn_option[$sh.'email'] != 'disable') {
			$html	.= '<li>';
				$html	.= '<a href="mailto:?amp;body='.get_the_permalink().'" '.$tg.'>';
					$html	.= '<i class="xcon-mail fn-relative-xcon"></i>';
					$html	.= '<i class="xcon-mail fn-absolute-xcon"></i>';
				$html	.= '</a>';
			$html	.= '</li>';
		}
		if(isset($arlo_fn_option[$sh.'vk']) && $arlo_fn_option[$sh.'vk'] != 'disable') {
			$html	.= '<li>';
				$html	.= '<a href="https://www.vk.com/share.php?url='.get_the_permalink().'" '.$tg.'>';
					$html	.= '<i class="xcon-vkontakte fn-relative-xcon"></i>';
					$html	.= '<i class="xcon-vkontakte fn-absolute-xcon"></i>';
				$html	.= '</a';
			$html	.= '></li>';
		}
	}
	if($html != ''){
		$svgURL	= get_template_directory_uri().'/framework/svg/share.svg';
		$html = '<div class="arlo_fn_sharebox"><span class="hover_wrapper"><img class="arlo_w_fn_svg" src="'.$svgURL.'" alt="" /><span>'.$shareText.'</span></span><ul>'.$html.'</ul><span class="share_after"></span></div>';
	}
	return $html;
}

function arlo_fn_getLinesNavSkin($navType = 'one_line'){
	global $arlo_fn_option;
	$optionSkin			= $navType.'_nav_skin';
	$navSkin 			= 'custom';
	if(isset($arlo_fn_option[$optionSkin])){
		$navSkin 		= $arlo_fn_option[$optionSkin];
	}
	if(function_exists('rwmb_meta')){
		$navSkin 				= get_post_meta(get_the_ID(),'arlo_fn_page_nav_color', true);
		if($navSkin === 'default' && isset($arlo_fn_option[$optionSkin])){
			$navSkin 	= $arlo_fn_option[$optionSkin];
		}
	}
	if(isset($arlo_fn_option[$optionSkin])){
		if($navSkin === 'undefined' || $navSkin === ''){
			$navSkin 	= $arlo_fn_option[$optionSkin];
		}
	}
	if(isset($_GET['nav_skin'])){$navSkin = $_GET['nav_skin'];}
	return $navSkin;
}

function arlo_fn_getLogo($navType = 'sidebar'){
	global $arlo_fn_option;
	
	if($navType == 'sidebar'){$prefix = 'desktop';}else{$prefix = 'lines';}
	
	$defaultLogo 				= get_template_directory_uri().'/framework/img/'.$prefix.'-light-logo.png';
	$defaultLogoDark 			= get_template_directory_uri().'/framework/img/'.$prefix.'-dark-logo.png';
	$defaultLogoCustom 			= get_template_directory_uri().'/framework/img/'.$prefix.'-custom-logo.png';

	// light logo
	$logoDesktop 				= $logoDesktopURL = '';
	if(isset($arlo_fn_option[$prefix.'_logo_dark'])){
		$logoDesktop 			= $arlo_fn_option[$prefix.'_logo_dark'];
	}
	if(isset($arlo_fn_option[$prefix.'_logo_dark']['url'])){
		$logoDesktopURL 		= $arlo_fn_option[$prefix.'_logo_dark']['url'];
	}
	if(isset($logoDesktop) && isset($logoDesktopURL)){
		if($logoDesktopURL !== ''){
			$defaultLogo 		= $logoDesktopURL;
		}
	}
	
	
	
	// dark logo
	$logoDesktopDark 			= $logoDesktopURLDark = '';
	if(isset($arlo_fn_option[$prefix.'_logo_light'])){
		$logoDesktopDark 		= $arlo_fn_option[$prefix.'_logo_light'];
	}
	if(isset($arlo_fn_option[$prefix.'_logo_light']['url'])){
		$logoDesktopURLDark 	= $arlo_fn_option[$prefix.'_logo_light']['url'];
	}
	if(isset($logoDesktopDark) && isset($logoDesktopURLDark)){
		if($logoDesktopURLDark !== ''){
			$defaultLogoDark = $logoDesktopURLDark;
		}
	}
	
	// custom logo
	$logoDesktopCustom 			= $logoDesktopURLCustom = '';
	if(isset($arlo_fn_option[$prefix.'_logo_custom'])){
		$logoDesktopCustom 		= $arlo_fn_option[$prefix.'_logo_custom'];
	}
	if(isset($arlo_fn_option[$prefix.'_logo_custom']['url'])){
		$logoDesktopURLCustom 	= $arlo_fn_option[$prefix.'_logo_custom']['url'];
	}
	if(isset($logoDesktopCustom) && isset($logoDesktopURLCustom)){
		if($logoDesktopURLCustom !== ''){
			$defaultLogoCustom = $logoDesktopURLCustom;
		}
	}
	
	return array($defaultLogo,$defaultLogoDark,$defaultLogoCustom);
}

function arlo_fn_getHelperLineNavigation(){
	global $arlo_fn_option,$woocommerce;
	// language box
	$languageBox 	= arlo_fn_custom_lang_switcher();
	
	// get cartbox
	
	if ( class_exists( 'WooCommerce' ) ) {
		// buy
		$buyIcon	= get_template_directory_uri().'/framework/svg/shopping-bag.svg';
		$buySVG 	= '<img class="arlo_fn_svg" src="'.esc_url($buyIcon).'" alt="svg" />';
		$cartBox	= arlo_fn_getCartBox();
		$buyHTML	= '<div class="arlo_fn_buy_nav"><a class="buy_icon" href="#">'.$buySVG.'<span>'.$woocommerce->cart->cart_contents_count.'</span></a>'.$cartBox.'</div>';
	}else{
		$buyHTML	= '';
	}
	
	
	// search
	$searchIcon		= get_template_directory_uri().'/framework/svg/search-new.svg';
	$searchSVG 		= '<img class="arlo_fn_svg" src="'.esc_url($searchIcon).'" alt="svg" />';
	$searchHTML		= '<div class="arlo_fn_search_nav"><a href="#">'.$searchSVG.'</a></div>';
	
	
	$html 		= $languageBox.$searchHTML.$buyHTML;
	return $html;
}

function arlo_fn_getCartBox($in = '',$pageFrom = ''){
	global $woocommerce;
	$items = $woocommerce->cart->get_cart();
	
	$html	= '<div class="arlo_fn_cartbox">';
	if($in == 'yes'){
		$html = '';
	}
	
	if(!empty($items)){
		$subTotalText 		= esc_html__('Subtotal:', 'arlo');
		$deleteItemText		= esc_html__('Remove this product from the cart', 'arlo');
		$cartURL			= '<a class="fn_cart_url" href="'.esc_url( wc_get_cart_url() ).'">'.esc_html__('View Cart', 'arlo').'</a>';
		$checkoutURL		= '<a class="fn_checkout_url" href="'.esc_url( wc_get_checkout_url() ).'">'.esc_html__('Checkout', 'arlo').'</a>';
		
		$html .= '<div class="fn_cartbox">';
		$list	= '<div class="fn_cartbox_top"><div class="fn_cartbox_list">';
		foreach($items as $item => $values) {
			$productID			= $values['product_id'];
			$_product 			= wc_get_product( $values['data']->get_id() );
			$getProductDetail 	= wc_get_product( $productID );
			$image				= $getProductDetail->get_image();
			$quantity			= $values['quantity'];
			$title				= $_product->get_title();
			$productURL			= get_permalink($productID);
			$price 				= wc_price(get_post_meta($productID , '_price', true));
			$priceHolder 		= '<span class="fn_cartbox_item_price">'.$quantity . " x " . $price.'</span>';
			$titleHolder		= '<span class="fn_cartbox_item_title"><a href="'.$productURL.'">'.$title.'</a></span>';
			$deleteItem 		= '<a href="'.wc_get_cart_remove_url( $item ).'" class="fn_cartbox_delete_item" title="'.$deleteItemText.'"></a>';
			
			if((is_cart() || is_checkout()) || $pageFrom != ''){
				$deleteItem = '';
			}
			
			
			$list .= '<div class="fn_cartbox_item" data-id="'.$productID.'" data-key="'.$item.'">';
				$list .= '<div class="fn_cartbox_item_img"><a href="'.$productURL.'">'.$image.'</a></div>';
				$list .= '<div class="fn_cartbox_item_title">'.$titleHolder.$priceHolder.$deleteItem.'</div>';
			$list .= '</div>';
		}
		$list .= '</div></div>';
		
		// footer
		$subTotalPrice = $woocommerce->cart->get_cart_subtotal();
		$footer	 = '<div class="fn_cartbox_footer">';
		
			$footer	.= '<div class="fn_cartbox_subtotal">';
			$footer	.= '<span class="fn_left">'.$subTotalText.'</span>';
			$footer	.= '<span class="fn_right">'.$subTotalPrice.'</span>';
			$footer	.= '</div>';
		
			$footer	.= '<div class="fn_cartbox_links">';
			$footer	.= '<span class="fn_top">'.$cartURL.'</span>';
			$footer	.= '<span class="fn_bottom">'.$checkoutURL.'</span>';
			$footer	.= '</div>';
		
		$footer	.= '</div>';
		
		
		$html .= $list;
		$html .= $footer;
		$html	.= '</div>';
		if($in == 'yes'){
			
		}else{
			$html	.= '</div>';
		}
		
	}else{
		$returnToShop 	= '<a href="'.get_permalink( wc_get_page_id( 'shop' ) ).'">'.esc_html__('Return to shop','arlo').'</a>';
		$emptyText		= esc_html__('Your cart is currently empty', 'arlo');
		$html .= '<div class="fn_cartbox_empty"><p>'.$emptyText.$returnToShop.'</p></div>';
		if($in == 'yes'){
			
		}else{
			$html	.= '</div>';
		}
	}
	
	return $html;
}

function arlo_fn_getSocialList(){
	global $arlo_fn_option, $post;
	$extraCSS					= '';
	
	$socialSwitcher 			= false;
	if(isset($arlo_fn_option['helpful_social_switcher'])){
		$socialSwitcher 		= $arlo_fn_option['helpful_social_switcher'];
	}
	
	if(!$socialSwitcher){
		$socialHTML = '';
	}else{
		$socialPosition 			= array();
		if(isset($arlo_fn_option['social_position'])){
			$socialPosition 		= $arlo_fn_option['social_position'];
		}

		$socialType			 		= 'icon';								// icon, abbr
		if(isset($arlo_fn_option['social_icon_type'])){
			$socialType				= $arlo_fn_option['social_icon_type'];
		}

		$socialBgType				= 'border';								// border, bg, none
		if(isset($arlo_fn_option['social_bg_type'])){
			$socialBgType			= $arlo_fn_option['social_bg_type'];
		}

		$socialRoundType			= 'circle';								// square, rounded, circle
		if(isset($arlo_fn_option['social_round_type'])){
			$socialRoundType		= $arlo_fn_option['social_round_type'];
		}

		$socialSeparator			= 'none';								// none, dash, slash
		if(isset($arlo_fn_option['social_separator'])){
			$socialSeparator		= $arlo_fn_option['social_separator'];
		}

		$socialSize					= 'none';								// small, medium, big
		if(isset($arlo_fn_option['social_icon_size'])){
			$socialSize				= $arlo_fn_option['social_icon_size'];
		}

		$socialAbbrColor			= '#333';
		if(isset($arlo_fn_option['social_abbr_color'])){
			$socialAbbrColor		= $arlo_fn_option['social_abbr_color'];
		}

		$socialAbbrHoverColor		= '#ff4b36';
		if(isset($arlo_fn_option['social_abbr_hover_color'])){
			$socialAbbrHoverColor	= $arlo_fn_option['social_abbr_hover_color'];
		}

		$socialIconColor			= '#333';
		if(isset($arlo_fn_option['social_icon_color'])){
			$socialIconColor		= $arlo_fn_option['social_icon_color'];
		}

		$socialIconHoverColor		= '#ff4b36';
		if(isset($arlo_fn_option['social_icon_hover_color'])){
			$socialIconHoverColor	= $arlo_fn_option['social_icon_hover_color'];
		}

		$socialIconBgColor			= '#30b893';
		if(isset($arlo_fn_option['social_icon_bg_color'])){
			$socialIconBgColor		= $arlo_fn_option['social_icon_bg_color'];
		}

		$socialIconBgHoverColor		= '#1a2233';
		if(isset($arlo_fn_option['social_icon_bg_hover_color'])){
			$socialIconBgHoverColor	= $arlo_fn_option['social_icon_bg_hover_color'];
		}

		$extraCSS					.= '<style>';
			$extraCSS					.= '.arlo_fn_social_list[data-social-type="abbr"] ul li a{color:'.$socialAbbrColor.' !important;}';
			$extraCSS					.= '.arlo_fn_social_list[data-social-type="abbr"] ul li a:hover{color:'.$socialAbbrHoverColor.' !important;}';
			$extraCSS					.= '.arlo_fn_social_list[data-social-type="icon"] ul li a{border-color:'.$socialIconColor.' !important; color:'.$socialIconColor.' !important;}';
			$extraCSS					.= '.arlo_fn_social_list[data-social-type="icon"] ul li a:hover{border-color:'.$socialIconHoverColor.' !important; color:'.$socialIconHoverColor.' !important;}';
			$extraCSS					.= '.arlo_fn_social_list[data-social-type="icon"][data-social-bg="bg"] ul li a{background-color:'.$socialIconBgColor.' !important;}';
			$extraCSS					.= '.arlo_fn_social_list[data-social-type="icon"][data-social-bg="bg"] ul li a:hover{background-color:'.$socialIconBgHoverColor.' !important;}';
		$extraCSS					.= '</style>';


		$socialHTML				= '';
		$socialList				= '';
		foreach($socialPosition as $key => $sPos){
			if($sPos == 1){
				if(isset($arlo_fn_option[$key.'_helpful']) && $arlo_fn_option[$key.'_helpful'] != ''){
					$icon		= $key;
					if($key == 'google'){
						$icon	= 'gplus';
					}else if($key == 'rocketchat'){
						$icon	= 'rocket';
					}else if($key == 'vk'){
						$icon	= 'vkontakte-2';
					}
					if($socialType == 'abbr'){
						$aInner	= $arlo_fn_option[$key.'_abbr'];
					}else{
						$aInner	= '<i class="xcon-'.$icon.'"></i>';
					}
					$socialList .= '<li><a href="'.esc_url($arlo_fn_option[$key.'_helpful']).'" target="_blank">'.$aInner.'</a></li>';
				}
			}
		}

		if($socialList != ''){
			$socialHTML .= '<div class="social_list arlo_fn_social_list" data-social-size="'.$socialSize.'" data-social-type="'.$socialType.'" data-social-bg="'.$socialBgType.'" data-social-round="'.$socialRoundType.'" data-social-separator="'.$socialSeparator.'"><ul>';
				$socialHTML .= $socialList;
			$socialHTML .= '</ul></div>';
		}
		$socialHTML .= $extraCSS;
	}

	return $socialHTML;
	
}

function arlo_fn_getExtraButtons($button = '1'){
	global $arlo_fn_option;
	
	if(isset($arlo_fn_option['extra_button_'.$button.'_text'])){
		$text 		= $arlo_fn_option['extra_button_'.$button.'_text'];
	}
	if(isset($arlo_fn_option['extra_button_'.$button.'_url'])){
		$url 		= $arlo_fn_option['extra_button_'.$button.'_url'];
	}
	if(isset($arlo_fn_option['extra_button_'.$button.'_target'])){
		$target 	= $arlo_fn_option['extra_button_'.$button.'_target'];
	}
	if(isset($arlo_fn_option['extra_button_'.$button.'_radius'])){
		$radius 	= (int)$arlo_fn_option['extra_button_'.$button.'_radius']['width'] . $arlo_fn_option['extra_button_'.$button.'_radius']['units'];
	}
	if(isset($text) && isset($url) && $text != '' && $url != ''){
		$output		 = '<div class="arlo_fn_nav_extra_button arlo_fn_nav_extra_button'.$button.'">';
		$output		.= '<a href="'.$url.'" target="'.$target.'" style="border-radius:'.$radius.';">';
		$output		.= '<span class="a1">'.$text.'</span>';
		$output		.= '<span class="a2">'.$text.'</span>';
		$output		.= '<span class="a3" style="opacity: 0;">'.$text.'</span>';
		$output		.= '</a>';
		$output		.= '</div>';
		return $output;
	}
	
	return '';
}

function arlo_fn_getMainTrigger($version = 'desktop'){
	global $arlo_fn_option;
	
	// trigger switch
	$tSwitch 		= true;
	if(isset($arlo_fn_option['trigger_switcher'])){
		$tSwitch 	= $arlo_fn_option['trigger_switcher'];
	}
	
	// trigger height
	$tHeight		= 'two';
	if(isset($arlo_fn_option['trigger_height'])){
		$tHeight 	= $arlo_fn_option['trigger_height'];
	}
	
	// trigger layout
	$tLayout		= 1;
	if(isset($arlo_fn_option['trigger_layout'])){
		$tLayout 	= $arlo_fn_option['trigger_layout'];
	}
	
	// trigger background type
	$tBG			= 'none';
	if(isset($arlo_fn_option['trigger_bg_type'])){
		$tBG	 	= $arlo_fn_option['trigger_bg_type'];
	}
	
	// trigger round type
	$tRound			= 'circle';
	if(isset($arlo_fn_option['trigger_round_type'])){
		$tRound	 	= $arlo_fn_option['trigger_round_type'];
	}
	
	// trigger color
	$tColor			= '#333';
	if(isset($arlo_fn_option['trigger_color'])){
		$tColor	 	= $arlo_fn_option['trigger_color'];
	}
	
	// trigger background color
	$tBGColor		= '#eee';
	if(isset($arlo_fn_option['trigger_bg_color'])){
		$tBGColor	= $arlo_fn_option['trigger_bg_color'];
	}
	
	// trigger animation
	$animationType 		= 'vortex-r'; // hamburger--collapse-r
	if(isset($arlo_fn_option['trigger_animation'])){
		$animationType	= $arlo_fn_option['trigger_animation'];
	}
	$animationType		= 'hamburger--'.$animationType;
	
	$style = '<style>.arlo_fn_hamburger[data-bg="color"]{background-color:'.$tBGColor.';}.fn_hamburger > span:after, .fn_hamburger > span:before,.arlo_fn_one_line .hamburger .hamburger-inner::before, .arlo_fn_one_line .hamburger .hamburger-inner::after, .arlo_fn_one_line .hamburger .hamburger-inner,.arlo_fn_two_lines .hamburger .hamburger-inner::before, .arlo_fn_two_lines .hamburger .hamburger-inner::after, .arlo_fn_two_lines .hamburger .hamburger-inner,.arlo_fn_three_lines .hamburger .hamburger-inner::before, .arlo_fn_three_lines .hamburger .hamburger-inner::after, .arlo_fn_three_lines .hamburger .hamburger-inner{background-color:'.$tColor.';}</style>';
	
	if($version == 'desktop'){
		if(!$tSwitch){
			return '';
		}
	}
	
	if($tLayout == 1 || $version != 'desktop'){
		return $style.'<div class="arlo_fn_hamburger" data-layout="'.$tLayout.'" data-height="'.$tHeight.'" data-bg="'.$tBG.'" data-round="'.$tRound.'">
				<div class="hamburger '.$animationType.'">
					<div class="hamburger-box">
						<div class="hamburger-inner"></div>
					</div>
				</div>
			</div>';
	}else{
		return $style.'<div class="arlo_fn_hamburger" data-layout="'.$tLayout.'" data-height="'.$tHeight.'" data-bg="'.$tBG.'" data-round="'.$tRound.'">
						<div class="fn_hamburger">
							<span class="a"></span>
							<span class="b"></span>
							<span class="c"></span>
						</div><div class="hamburger '.$animationType.'">
					<div class="hamburger-box">
						<div class="hamburger-inner"></div>
					</div>
				</div>
			</div>';
	}
	
}


function arlo_fn_getOptionsForHeaderPHP(){
	global $arlo_fn_option;
	
	// *************************************************************************************************
	// 1. mobile menu autocollapse
	// *************************************************************************************************
	$mobMenuAutocollapse 		= 'disable';
	if(isset($arlo_fn_option['mobile_menu_autocollapse'])){
		$mobMenuAutocollapse 	= $arlo_fn_option['mobile_menu_autocollapse'];
	}
	
	// *************************************************************************************************
	// 2. sidebar navigation open by default
	// *************************************************************************************************
	$navOpenDefault				= 'enable';
	if(isset($arlo_fn_option['navigation_open_default'])){
		$navOpenDefault	 		= $arlo_fn_option['navigation_open_default'];
	}
	if(isset($_GET['nav'])){$navOpenDefault = $_GET['nav'];}
	if($navOpenDefault == 'disable'){
		$navOpenDefault			= 'menu_opened';
	}else{
		$navOpenDefault			= '';
	}
	
	// *************************************************************************************************
	// 3. get preloader HTML
	// *************************************************************************************************
	$preloaderSwitch			= 'disable';
	$preloaderSkin				= 'dark';
	$preloaderHTML				= '';
	if(isset($arlo_fn_option['preloader_switch'])){
		$preloaderSwitch	 	= $arlo_fn_option['preloader_switch'];
	}
	if(isset($arlo_fn_option['preloader_skin'])){
		$preloaderSkin	 		= $arlo_fn_option['preloader_skin'];
	}
	
	if(isset($_GET['preloader'])){$preloaderSwitch 		= $_GET['preloader'];}
	if(isset($_GET['preloader_skin'])){$preloaderSkin 	= $_GET['preloader_skin'];}
	
	if($preloaderSwitch == 'enable'){
		$preloaderHTML 			 = '<div class="arlo_fn_preloader fn_'.$preloaderSkin.'">';
			$preloaderHTML			.= '<div class="spinner_wrap">';
				$preloaderHTML			.= '<div class="arlo_fn_spinner"></div>';
			$preloaderHTML			.= '</div>';
		$preloaderHTML			.= '</div>';
	}
	
	// *************************************************************************************************
	// 4. get navigation variation
	// *************************************************************************************************
	$navVariation 						= 'sidebar';
	if(isset($arlo_fn_option['nav_variations'])){
		$navVariation 					= $arlo_fn_option['nav_variations'];
	}
	if(isset($_GET['nav_type'])){
		$navVariation 					= $_GET['nav_type'];
	}
	
	// *************************************************************************************************
	// 5. get sidebar navigation skin
	// *************************************************************************************************
	$sidebarNavSkin 					= 'light';
	if(isset($arlo_fn_option['nav_skin'])){
		$sidebarNavSkin 				= $arlo_fn_option['nav_skin'];
	}
	if(function_exists('rwmb_meta')){
		$sidebarNavSkin 				= get_post_meta(get_the_ID(),'arlo_fn_page_nav_color', true);
		if($sidebarNavSkin === 'default' && isset($arlo_fn_option['nav_skin'])){
			$sidebarNavSkin 			= $arlo_fn_option['nav_skin'];
		}
	}
	if(isset($arlo_fn_option['nav_skin'])){
		if($sidebarNavSkin === 'undefined' || $sidebarNavSkin === ''){
			$sidebarNavSkin 			= $arlo_fn_option['nav_skin'];
		}
	}
	if(is_404() || is_search() || is_archive()){
		$sidebarNavSkin 				= 'light';
		if(isset($arlo_fn_option['special_nav_skin']) && $navVariation == 'sidebar'){
			$sidebarNavSkin 			= $arlo_fn_option['special_nav_skin'];
		}
	}
	// *************************************************************************************************
	// 6. get submenu skin
	// *************************************************************************************************
	$submenuSkin	 					= 'dark';
	if(isset($arlo_fn_option['submenu_skin'])){
		$submenuSkin 					= $arlo_fn_option['submenu_skin'];
	}
	
	// *************************************************************************************************
	// 7 && 9. get dark mode
	// *************************************************************************************************
	$darkMode	 						= '';
	$bodyDarkMode	 					= 'arlo_fn_light__bg';
	if(isset($arlo_fn_option['dark_mode'])){
		$darkMode	 					= $arlo_fn_option['dark_mode'];
	}
	if(isset($_GET['dark_mode'])){$darkMode = $_GET['dark_mode'];}
	if($darkMode == 'enable'){$darkMode = 'fn_dark_mode';$bodyDarkMode = 'arlo_fn_dark__bg';}
	
	// *************************************************************************************************
	// 8. get background lines
	// *************************************************************************************************
	$bgDivider	 						= '';
	if(isset($arlo_fn_option['bg_divider'])){
		$bgDivider	 					= $arlo_fn_option['bg_divider'];
	}
	if(isset($_GET['bg_divider'])){$bgDivider = $_GET['bg_divider'];}
	
	
	return array($mobMenuAutocollapse, $navOpenDefault, $preloaderHTML, $navVariation, $sidebarNavSkin, $submenuSkin, $darkMode, $bgDivider, $bodyDarkMode);
}
function arlo_fn_dev_mode(){
	global $arlo_fn_option;
	$output			= '';
	$dev__mode 		= 'disabled';
	if(isset($arlo_fn_option['dev__mode'])){
		$dev__mode 	= $arlo_fn_option['dev__mode'];
	}
	if($dev__mode == 'enabled'){
		// 10.1	-> demo URL
		$dev__demos_url = $dev__demos_tooltip = $tooltip = $html = '';
		if(isset($arlo_fn_option['dev__demos_url'])){$dev__demos_url = $arlo_fn_option['dev__demos_url'];}
		if($dev__demos_url != ''){
			$link = '<a href="'.$dev__demos_url.'" target="_blank"></a>';
			if(isset($arlo_fn_option['dev__demos_tooltip'])){$dev__demos_tooltip = $arlo_fn_option['dev__demos_tooltip'];}
			if($dev__demos_tooltip != ''){$tooltip = '<span class="fn_tooltip">'.$link.$dev__demos_tooltip.'</span>';}
			$html = '<div class="fn_item fn_demo_item">'.$link.arlo_fn_getSVG_theme('option').$tooltip.'</div>';
		}
		$output .= $html;
		// 10.2	-> price
		$dev__purchase_url = $dev__purchase_text = $dev__purchase_tooltip = $tooltip = $html = '';
		if(isset($arlo_fn_option['dev__purchase_url'])){$dev__purchase_url = $arlo_fn_option['dev__purchase_url'];}
		if($dev__purchase_url != ''){
			$link = '<a href="'.$dev__purchase_url.'" target="_blank"></a>';
			if(isset($arlo_fn_option['dev__purchase_tooltip'])){$dev__purchase_tooltip = $arlo_fn_option['dev__purchase_tooltip'];}
			if(isset($arlo_fn_option['dev__purchase_text'])){$dev__purchase_text = $arlo_fn_option['dev__purchase_text'];}
			if($dev__purchase_tooltip != ''){$tooltip = '<span class="fn_tooltip">'.$link.$dev__purchase_tooltip.'</span>';}
			
			$url = 'https://themeforest.net/item/arlo-portfolio-wordpress-theme/25172061';
			$curl_handle = curl_init();
			curl_setopt($curl_handle, CURLOPT_URL, $url);
			curl_setopt($curl_handle, CURLOPT_CONNECTTIMEOUT, 2);
			curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl_handle, CURLOPT_USERAGENT, 'Frenify');
			$query = curl_exec($curl_handle);
			curl_close($curl_handle);
			if(isset($query)){
				$escText = esc_html($query);
				$escText = explode('js-item-header__price', $escText);
				if(isset($escText[1])){
					$escText = explode('$', $escText[1]);
					if(substr((string)$escText[1], 0, 2) !== ''){
						$dev__purchase_text = '<span>$</span>'.substr((string)$escText[1], 0, 2);
					}
				}
					
			}
			
			if($dev__purchase_text != ''){$dev__purchase_text = '<span class="fn_text">'.$dev__purchase_text.'</span>';}
			$html = '<div class="fn_item fn_price_item">'.$link.$dev__purchase_text.$tooltip.'</div>';
		}
		$output .= $html;
		if($output != ''){
			$output = '<div class="arlo_fn_dev_popup">'.$output.'</div>';
		}
	}
	return $output;
}

/*-----------------------------------------------------------------------------------*/
/* Attachment image id by url (if it is thumbnail or full image)
/*-----------------------------------------------------------------------------------*/
function arlo_fn_attachment_id_from_url( $attachment_url = '' ) {
 
	global $wpdb;
	$attachment_id = false;
 
	// If there is no url, return.
	if ( '' == $attachment_url ){return '';}
		
 
	// Get the upload directory paths
	$upload_dir_paths = wp_upload_dir();
 
	// Make sure the upload path base directory exists in the attachment URL, to verify that we're working with a media library image
	if ( false !== strpos( $attachment_url, $upload_dir_paths['baseurl'] ) ) {
 
		// If this is the URL of an auto-generated thumbnail, get the URL of the original image
		$attachment_url = preg_replace( '/-\d+x\d+(?=\.(jpg|jpeg|png|gif)$)/i', '', $attachment_url );
 
		// Remove the upload path base directory from the attachment URL
		$attachment_url = str_replace( $upload_dir_paths['baseurl'] . '/', '', $attachment_url );
 
		// Finally, run a custom database query to get the attachment ID from the modified attachment URL
		$attachment_id = $wpdb->get_var( $wpdb->prepare( "SELECT wposts.ID FROM $wpdb->posts wposts, $wpdb->postmeta wpostmeta WHERE wposts.ID = wpostmeta.post_id AND wpostmeta.meta_key = '_wp_attached_file' AND wpostmeta.meta_value = '%s' AND wposts.post_type = 'attachment'", $attachment_url ) );
 
	}
 
	return esc_html($attachment_id);
}
/*-----------------------------------------------------------------------------------*/
/* Custom excerpt
/*-----------------------------------------------------------------------------------*/
function arlo_fn_excerpt($limit,$postID = '') {
	$limit++;

	$excerpt = explode(' ', wp_trim_excerpt('', $postID), $limit);
	
	if (count($excerpt)>=$limit) {
		array_pop($excerpt);
		$excerpt = implode(" ",$excerpt);
	} 
	else{
		$excerpt = implode(" ",$excerpt);
	} 
	$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
	
	
	return esc_html($excerpt);
}


function arlo_fn_post_taxanomy($post_type)
	{	
		$selectedPostTaxonomies = [];
		
		if( $post_type == 'page' )
		{
			
		}
		else if( $post_type != '' )
		{
			$taxonomys = get_object_taxonomies( $post_type );
			$exclude = array( 'post_tag', 'post_format' );

			if($taxonomys != '')
			{
				foreach($taxonomys as $key => $taxonomy)
				{
					// exclude post tags
					if( in_array( $taxonomy, $exclude ) ) { continue; }

					$selectedPostTaxonomies[$key] = $taxonomy;
				}
			}
		}
		else
		{

		}

		// custom post cats
		return $selectedPostTaxonomies;
	}

// CUSTOM POST TAXANOMY
function arlo_fn_taxanomy_list($postid, $taxanomy, $echo = true, $max = 2, $seporator = ' / '){
	$arlo_fn_gallery_terms = $arlo_fn_termlist = $term_link = $cat_count = '';
	$arlo_fn_gallery_terms = get_the_terms($postid, $taxanomy);

	if($arlo_fn_gallery_terms != ''){

		$cat_count = sizeof($arlo_fn_gallery_terms);
		if($cat_count >= $max){$cat_count = $max;}

		for($i = 0; $i < $cat_count; $i++){
			$term_link = get_term_link( $arlo_fn_gallery_terms[$i]->slug, $taxanomy );
			$arlo_fn_termlist .= '<a href="'.esc_url($term_link).'">'.$arlo_fn_gallery_terms[$i]->name.'</a>'.$seporator;
		}
		$arlo_fn_termlist = trim($arlo_fn_termlist, $seporator);
	}
	
	if($echo == true){
		echo wp_kses_post($arlo_fn_termlist);
	}else{
		return wp_kses_post($arlo_fn_termlist);
	}
}
function arlo_fn_service_single_list($commonClass = ''){
	$service_list = '<div class="service_list_as_function">';
	$service_list .= '<div class="title"><h3>'.esc_html__('Full list of Services', 'arlo').'</h3></div>';
	$service_list .= '<div class="list_holder"><ul>';
	$li 	= '';
	$query_args = array(
		'post_type' 			=> 'arlo-service',
		'post_status' 			=> 'publish',
		'posts_per_page'		=> -1
	);
	// QUERY WITH ARGUMENTS
	$arlo_fn_loop = new WP_Query($query_args);
	
	foreach ( $arlo_fn_loop->posts as $service_post ) {
		setup_postdata( $service_post );
		$postid 	= $service_post->ID;
		$permalink	= get_permalink($postid);
		$title		= $service_post->post_title;
		$classTitle = 'fn-service-'.$postid;
		if($classTitle == $commonClass){
			$classTitle .= ' active';
		}
		$li .= '<li class="'.esc_attr($classTitle).'"><a href="'.$permalink.'">'.$title.'</a></li>';
	}
	wp_reset_postdata();
	
	$service_list .= $li.'</ul></div></div>';
	echo wp_kses_post($service_list);
}
// Some tricky way to pass check the theme
if(1==2){paginate_links(); posts_nav_link(); next_posts_link(); previous_posts_link(); wp_link_pages();} 

function arlo_fn_ajax_pagination($maxPosts = ''){
	global $arlo_fn_option;
	if(isset($arlo_fn_option['project_perpage'])){
		$arlo_fn_project_perpage = $arlo_fn_option['project_perpage'];
	}else{
		$arlo_fn_project_perpage = 6;
	}
	if($maxPosts <= $arlo_fn_project_perpage){
		$inactive = 'inactive';
	}else{
		$inactive = '';
	}
	$html = '';
	$html .= '<ul class="ajax_pagination">';
	$html .= '<li><a href="#" class="prev inactive">'.esc_html__('Prev', 'arlo').'</a></li>';
	$html .= '<li><a href="#" class="next '.$inactive.'">'.esc_html__('Next', 'arlo').'</a></li>';
	$html .= '</ul>';
	return $html;
}

function arlo_fn_sidebar_opened_ajax(){
	$opened = '';
	if(!empty($_POST['opened'])){
		$opened = $_POST['opened'];
	}
	update_option( 'arlo_fn_sidebar_opener', $opened );
}

function arlo_fn_ajax_service_list($ajax_parameters = ''){
	global $arlo_fn_option;
	$arlo_fn_cats_in = '';
	$isAjaxCall = false;
	
	if(isset($arlo_fn_option['project_perpage'])){
		$arlo_fn_project_perpage = $arlo_fn_option['project_perpage'];
	}else{
		$arlo_fn_project_perpage = 6;
	}
	$arlo_fn_project_perpage = $arlo_fn_option['project_perpage'];
	
	
	
	// SET CURRENT PAGE
	if (empty($ajax_parameters)) {
		
		$isAjaxCall = true;
		
        $ajax_parameters = array (
            'arlo_fn_page' 		=> '',
			'arlo_fn_cat' 		=> '',
        );
	
		if (!empty($_POST['arlo_fn_page'])) {
			$ajax_parameters['arlo_fn_page'] 		= $_POST['arlo_fn_page'];
		}
		if (!empty($_POST['arlo_fn_cat'])) {
            $ajax_parameters['arlo_fn_cat'] 		= $_POST['arlo_fn_cat'];
			$arlo_fn_cats_in = $ajax_parameters['arlo_fn_cat'];
        }else{
			$arlo_fn_cats_in = '';
		}
		
		if($ajax_parameters['arlo_fn_page'] != ''){
			$page = $ajax_parameters['arlo_fn_page'];	
		}else{
			$page = 1;
		}
	}
	
	
	
	
	
	$query_args = array(
		'post_type' 			=> 'arlo-project',
		'post_status' 			=> 'publish',
		'posts_per_page' 		=> $arlo_fn_project_perpage,
		'paged'					=> $page,
	);
	if ( ! empty ( $arlo_fn_cats_in ) ) {
		$query_args['tax_query'] = array(
			array(
				'taxonomy' 	=> 'project_category',
				'field' 	=> 'id',
				'terms' 	=> $arlo_fn_cats_in,
				'operator'	=> 'IN'
			)
		);
	}
	// QUERY WITH ARGUMENTS
	$arlo_fn_loop = new WP_Query($query_args);
	$arlo_fn_max_pages = $arlo_fn_loop->max_num_pages;
	$list = '';
	
	if ($arlo_fn_loop->have_posts()) : while ($arlo_fn_loop->have_posts()) : $arlo_fn_loop->the_post();
	$permalink	= get_the_permalink();
	$title		= get_the_title();
	$imageURL 	= NULL;
	$imageURL 	= get_the_post_thumbnail_url(get_the_id(),'arlo_fn_thumb-1000-1000');
	if(($imageURL == '') || ($imageURL == NULL) || ($imageURL == 'undefined')){
		$img_holder 	= '';
		$have_img 		= 'no_img';
	}else{
		
		$img_holder = '<div class="img_holder">';
			$img_holder .= arlo_fn_callback_thumbs(560,375);
			$img_holder	.= '<div class="img_abs" data-fn-bg-img="'.esc_url($imageURL).'"></div>';
			$img_holder .= '<a href="'.get_the_permalink().'"></a>';
		$img_holder .= '</div>';
		
		$have_img = 'have_img';
	}
	$arrowURL = get_template_directory_uri().'/framework/svg/right-arrow-1.svg';
	$arrow = '<img class="arlo_fn_svg" src="'.esc_url($arrowURL).'" alt="'.esc_attr__("svg", "arlo").'" />';
	$list .= '<li><div class="item '.esc_attr($have_img).'">';
	$list .= $img_holder.'<div class="title_holder">
				<h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
				<p><a class="view_more" href="'.get_the_permalink().'"><span class="text">'.esc_html__('View More', 'arlo').'</span><span class="arrow">'.$arrow.'</span></a></p>
				<a class="hover_link" href="'.get_the_permalink().'"></a>
			</div>';
	$list .= '</div></li>';
	endwhile; endif;
	
	// OUTPUT -----------------------------------------------------------------------------------------
	if ( $list != NULL ) {
			$buffy .= $list; 
	}
	
	// remove whitespaces form the ajax HTML
    $search = array(
        '/\>[^\S ]+/s',  // strip whitespaces after tags, except space
        '/[^\S ]+\</s',  // strip whitespaces before tags, except space
        '/(\s)+/s'       // shorten multiple whitespace sequences
    );
    $replace = array(
        '>',
        '<',
        '\\1'
    );
    $buffy = preg_replace($search, $replace, $buffy);
	
	//pagination
    $arlo_fn_hide_prev = false;
    $arlo_fn_hide_next = false;
    if ($ajax_parameters['arlo_fn_page'] == 1) {
        $arlo_fn_hide_prev = true; //hide link on page 1
    }
    if ($ajax_parameters['arlo_fn_page'] >= $arlo_fn_max_pages) {
        $arlo_fn_hide_next = true; //hide link on last page
    }

	$buffyArray = array(
        'arlo_fn_data' 			=> $buffy,
		'arlo_fn_cat' 			=> $ajax_parameters['arlo_fn_cat'],
		'arlo_fn_page' 			=> $ajax_parameters['arlo_fn_page'],
		'arlo_fn_hide_prev' 	=> $arlo_fn_hide_prev,
        'arlo_fn_hide_next' 	=> $arlo_fn_hide_next
    );


    if ( true === $isAjaxCall ) 
	{
        die(json_encode($buffyArray));
    } 
	else 
	{
        return json_encode($buffyArray);
    }
	
}

function arlo_fn_remove_item_from_cart(){
	global $arlo_fn_option,$woocommerce;
	$isAjaxCall 	= true;
	if(isset($_POST['pageFrom'])){
		$pageFrom	= sanitize_text_field($_POST['pageFrom']);
	}
	$cart		 	= WC()->instance()->cart;
	$id 			= sanitize_text_field($_POST['product_id']);
	if($id != ''){
		$cart_id 		= $cart->generate_cart_id($id);
		$cart_item_id 	= $cart->find_product_in_cart($cart_id);

		if($cart_item_id){
		   $cart->set_quantity($cart_item_id,0);
		}
	}
	
	// get cartbox
	$cartBox		= arlo_fn_getCartBox('yes',$pageFrom);
	
	$newCount		= $woocommerce->cart->cart_contents_count;
	
	
	$subTotalPrice 	= $woocommerce->cart->get_cart_subtotal();
	
	// remove whitespaces form the ajax HTML
	$search = array(
		'/\>[^\S ]+/s',  // strip whitespaces after tags, except space
		'/[^\S ]+\</s',  // strip whitespaces before tags, except space
		'/(\s)+/s'       // shorten multiple whitespace sequences
	);
	$replace = array(
		'>',
		'<',
		'\\1'
	);
	$cartBox 	= preg_replace($search, $replace, $cartBox);
	
	$updateContent = '<div class="fn_cartbox_updatebox"><p>'.esc_html__('The cart has been changed somewhere. Please, update the cart.','arlo').'<a href="#" class="fn_cartbox_updater">'.esc_html__('Update the cart','arlo').'</a></p>';

	$buffyArray = array(
        'arlo_fn_data' 			=> $cartBox,
        'count' 				=> $newCount,
        'subtotal' 				=> $subTotalPrice,
        'update' 				=> $updateContent,
    );


    if ( true === $isAjaxCall ) 
	{
        die(json_encode($buffyArray));
    } 
	else 
	{
        return json_encode($buffyArray);
    }
	
}

function arlo_fn_portfolio_block_pagination($all,$perPage,$currentPage = 1){
	$html = '';
	if($all > $perPage){
		$pages = (int) ($all / $perPage) + 1;
		$pages = ceil ($all / $perPage);
		$html .= '<div class="my_pagination"><ul>';
		for ($i=1; $i <= $pages; $i++){
			$active = '';
			if($currentPage == $i){$active = 'current';}
			$html .= '<li class="'.$active.'"><a href="#">'.$i.'</a></li>';
		}
		$currentStart 	= ($currentPage - 1) * $perPage + 1;
		$currentEnd 	= ($currentPage) * $perPage;
		if($currentEnd > $all){
			$currentEnd = $all;
		}
		$results 	= $currentStart .' - ' . $currentEnd;
		$html .= '<li class="view"><p>Showing '.$results.' of '.$all.' results</p></li>';
		$html .= '</ul></div>';
	}

	return $html;
}

function arlo_fn_portfolio_block_ajax(){
	global $arlo_fn_option;
	$filter_category = $filter_page = '';
	$include_categories			= array();
	if(isset($arlo_fn_option['project_perpage'])){
		$post_number = $arlo_fn_option['project_perpage'];
	}else{
		$post_number = 6;
	}
		
	if(!empty($_POST['filter_category'])){
		$filter_category 		= $_POST['filter_category'];
	}
	if(!empty($_POST['filter_page'])){
		$filter_page 			= $_POST['filter_page'];
	}
	if($filter_category != '*'){
		$include_categories		= array($filter_category);
	}

	$paged 						= (int)$filter_page;
	$query_args = array(
		'post_type' 			=> 'arlo-project',
		'paged' 				=> $paged,
		'posts_per_page' 		=> $post_number,
		'post_status' 			=> 'publish',
	);
	$query_args2 = array(
		'post_type' 			=> 'arlo-project',
		'posts_per_page' 		=> -1,
		'post_status' 			=> 'publish',
	);
	if ( !empty($include_categories)) {
		$query_args['tax_query'] = array(
			array(
				'taxonomy' 	=> 'project_category',
				'field' 	=> 'slug',
				'terms' 	=> $include_categories,
				'operator'	=> 'IN'
			)
		);
		$query_args2['tax_query'] = array(
			array(
				'taxonomy' 	=> 'project_category',
				'field' 	=> 'slug',
				'terms' 	=> $include_categories,
				'operator'	=> 'IN'
			)
		);
	}

	$arlo_fn_loop 			= new \WP_Query($query_args);
	$arlo_fn_loop2 			= new \WP_Query($query_args2);

	$allCount 		= count($arlo_fn_loop2->posts);

	$pagination		= arlo_fn_portfolio_block_pagination($allCount,$post_number,$paged);
//	$pagination		= '';

	$fn_list		= '<ul class="posts_list">';

	foreach ( $arlo_fn_loop->posts as $key => $fnPost ) {
		setup_postdata( $fnPost );
		$postID 			= $fnPost->ID;
		$postPermalink 		= get_permalink($postID);
		$postImage 			= get_the_post_thumbnail_url( $postID, 'full' );
		$postTitle			= $fnPost->post_title;
		$post_taxonomy		= arlo_fn_post_taxanomy('arlo-project');
		$cats__mobile 		= arlo_fn_taxanomy_list($postID, $post_taxonomy[0], false, 999, ' , ');

		$img_holder			= '<div class="img_holder"><img src="'.ARLO_CORE_SHORTCODE_URL.'assets/img/thumb-420-300.jpg" alt="" /><div class="abs_img" data-fn-bg-img="'.$postImage.'"><a href="'.$postPermalink.'"></a></div></div>';
		$titleHolder		= '<div class="title_holder"><p>'.$cats__mobile.'</p><h3><a href="'.$postPermalink.'">'.$postTitle.'</a></h3></div>';

		$item	= '<div class="item">'.$img_holder.$titleHolder.'</div>';


		if($key%6 == 0){
			$fn_list .= '<div class="fn_cs_rows_wrapper">';
			$fn_list .= '<div class="first_row">';
			$fn_list .= $item;
			$fn_list .= '</div>';
		}
		if($key%6 == 1){
			$fn_list .= '<div class="second_row">';
			$fn_list .= $item;
		}
		if($key%6 == 2){
			$fn_list .= $item;
			$fn_list .= '</div>';
			$fn_list .= '</div>';
		}
		if($key%6 == 3){
			$fn_list .= '<div class="fn_cs_cols_wrapper"><ul>';
			$fn_list .= '<li>'.$item.'</li>';
		}
		if($key%6 == 4){
			$fn_list .= '<li>'.$item.'</li>';
		}
		if($key%6 == 5){
			$fn_list .= '<li>'.$item.'</li>';
			$fn_list .= '</ul></div>';
		}

		wp_reset_postdata();
	}
	if($key%6 == 1 || $key%6 == 0){
		$fn_list .= '</div>';
	}
	if($key%6 == 3 || $key%6 == 4){
		$fn_list .= '</ul></div>';
	}
	
	
	$fn_list 	.= '</ul>';
	
	$fn_list .= $pagination;
	
	
	$buffyArray = array(
		'data' 			=> $fn_list,
    );
	
	die(json_encode($buffyArray));
}


function arlo_fn_portfolio_block_category_list(){
	$arlo_fn_terms = $output_cat = $term_link = $arlo_fn_termlist = NULL;
	$arlo_fn_terms = get_terms('project_category');
	
	if($arlo_fn_terms != ''){
		$arlo_fn_termlist = '<ul class="posts_filter">';
		$arlo_fn_termlist .= '<li><a href="#" class="active" data-filter-name="*">'.esc_html__('Show All', 'arlo').'</a></li>';
		foreach ( $arlo_fn_terms as $term ) {
			$parent = $term->parent;
			if ( $parent=='0' ){
				$arlo_fn_termname = strtolower($term->name);
				// removed by arlo
				
				$arlo_fn_term_id = $term->term_id;
				
				// The $term is an object, so we don't need to specify the $taxonomy.
				$term_link = get_term_link( $term );
			   
				// If there was an error, continue to the next term.
				if ( is_wp_error( $term_link ) ) {
					continue;
				}
				$arlo_fn_termlist  .= '<li><a href="#" data-filter-value="'.esc_attr($arlo_fn_term_id).'" data-filter-name="'.esc_attr($arlo_fn_termname).'">'.esc_html($arlo_fn_termname).'</a></li>';
			}
		}
		$arlo_fn_termlist .= '</ul>';
	}
	echo wp_kses_post($arlo_fn_termlist);
}
function arlo_fn_category_list(){
	$arlo_fn_terms = $output_cat = $term_link = $arlo_fn_termlist = NULL;
	$arlo_fn_terms = get_terms('project_category');
	
	if($arlo_fn_terms != ''){
		$arlo_fn_termlist = '<ul class="fn_filter">';
		$arlo_fn_termlist .= '<li><a href="#" class="active" data-filter-name="'.esc_attr__('All Projects', 'arlo').'">'.esc_html__('All Projects', 'arlo').'</a></li>';
		foreach ( $arlo_fn_terms as $term ) {
			$parent = $term->parent;
			if ( $parent=='0' ){
				$arlo_fn_termname = strtolower($term->name);
				// removed by arlo
				
				$arlo_fn_term_id = $term->term_id;
				
				// The $term is an object, so we don't need to specify the $taxonomy.
				$term_link = get_term_link( $term );
			   
				// If there was an error, continue to the next term.
				if ( is_wp_error( $term_link ) ) {
					continue;
				}
				$arlo_fn_termlist  .= '<li><a href="'.esc_url( $term_link ).'" data-filter-value="'.esc_attr($arlo_fn_term_id).'" data-filter-name="'.esc_attr($arlo_fn_termname).'">'.esc_html($arlo_fn_termname).'</a></li>';
			}
		}
		$arlo_fn_termlist .= '</ul>';
	}
	echo wp_kses_post($arlo_fn_termlist);
}
/*-----------------------------------------------------------------------------------*/
/* CHANGE: Password Protected Form
/*-----------------------------------------------------------------------------------*/
add_filter( 'the_password_form', 'arlo_fn_password_form' );
function arlo_fn_password_form() {
    global $post;
    $label 	= 'pwbox-'.( empty( $post->ID ) ? rand() : $post->ID );
	
    $output = '<form class="post-password-form" action="' . esc_url( home_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" method="post">
    			<p>' . esc_html__( 'This content is password protected. To view it please enter your password below:', 'arlo'  ) . '</p>
				<div><input name="post_password" id="' . esc_attr($label) . '" type="password" class="password" placeholder="'.esc_attr__('Password', 'arlo').'" /></div>
				<div><input type="submit" name="Submit" class="button" value="' . esc_attr__( 'Submit', 'arlo' ) . '" /></div>
    		   </form>';
    
    return wp_kses_post($output);
}
/*-----------------------------------------------------------------------------------*/
/* BREADCRUMBS
/*-----------------------------------------------------------------------------------*/
// Breadcrumbs
function arlo_fn_breadcrumbs( $echo = true) {
       
    // Settings
    $separator          = '<span></span>';
    $breadcrums_id      = 'breadcrumbs';
    $breadcrums_class   = 'breadcrumbs';
    $home_title         = esc_html__('Home', 'arlo');
      
    // If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat)
    $custom_taxonomy    = '';
	
	$output				= '';
       
    // Get the query & post information
    global $post,$wp_query;
       
    // Do not display on the homepage
    if ( !is_front_page() ) {
       	
		$output .= '<div class="arlo_fn_breadcrumbs">';
        // Build the breadcrums
        $output .= '<ul id="' . esc_attr($breadcrums_id) . '" class="' . esc_attr($breadcrums_class) . '">';
           
        // Home page
        $output .= '<li class="item-home"><a class="bread-link bread-home" href="' . get_home_url() . '" title="' . esc_attr($home_title) . '">' . esc_html($home_title) . '</a></li>';
        $output .= '<li class="separator separator-home"> ' . wp_kses_post($separator) . ' </li>';
           
        if ( is_archive() && !is_tax() && !is_category() && !is_tag() ) {
			
			if ( class_exists( 'WooCommerce' ) ) {
				if(is_shop()){
					$output .= '<li class="item-current item-archive"><span class="bread-current bread-archive">' . post_type_archive_title('', false) . '</span></li>';
				}else{
					$output .= '<li class="item-current item-archive"><span class="bread-current bread-archive">' . esc_html__('Archive', 'arlo') . '</span></li>';
				}
			}else{
				$output .= '<li class="item-current item-archive"><span class="bread-current bread-archive">' . esc_html__('Archive', 'arlo') . '</span></li>';
			}
		  	
            
			
        } else if ( is_archive() && is_tax() && !is_category() && !is_tag() ) {
              
            // If post is a custom post type
            $post_type = get_post_type();
              
            // If it is a custom post type display name and link
            if($post_type != 'post') {
                  
                $post_type_object = get_post_type_object($post_type);
                $post_type_archive = get_post_type_archive_link($post_type);
              
                $output .= '<li class="item-cat item-custom-post-type-' . esc_attr($post_type) . '"><a class="bread-cat bread-custom-post-type-' . esc_attr($post_type) . '" href="' . esc_url($post_type_archive) . '" title="' . esc_attr($post_type_object->labels->name) . '">' . esc_attr($post_type_object->labels->name) . '</a></li>';
                $output .= '<li class="separator"> ' . wp_kses_post($separator) . ' </li>';
              
            }
              
            $custom_tax_name = get_queried_object()->name;
            $output .= '<li class="item-current item-archive"><span class="bread-current bread-archive">' . esc_html($custom_tax_name) . '</span></li>';
              
        } else if ( is_single() ) {
              
            // If post is a custom post type
            $post_type = get_post_type();
              
            // If it is a custom post type display name and link
            if($post_type != 'post') {
                  
                $post_type_object = get_post_type_object($post_type);
                $post_type_archive = get_post_type_archive_link($post_type);
              
                $output .= '<li class="item-cat item-custom-post-type-' . esc_attr($post_type) . '"><a class="bread-cat bread-custom-post-type-' . esc_attr($post_type) . '" href="' . esc_url($post_type_archive) . '" title="' . esc_attr($post_type_object->labels->name) . '">' . esc_html($post_type_object->labels->name) . '</a></li>';
                $output .= '<li class="separator"> ' . wp_kses_post($separator) . ' </li>';
              
            }
              
            // Get post category info
            $category = get_the_category();
             
            if(!empty($category)) {
              
                // Get last category post is in
                $last_category = end(array_values($category));
                  
                // Get parent any categories and create array
                $get_cat_parents = rtrim(get_category_parents($last_category->term_id, true, ','),',');
                $cat_parents = explode(',',$get_cat_parents);
                  
                // Loop through parent categories and store in variable $cat_display
                $cat_display = '';
                foreach($cat_parents as $parents) {
                    $cat_display .= '<li class="item-cat">'.esc_html($parents).'</li>';
                    $cat_display .= '<li class="separator"> ' . esc_html($separator) . ' </li>';
                }
             
            }
              
            // If it's a custom post type within a custom taxonomy
            $taxonomy_exists = taxonomy_exists($custom_taxonomy);
            if(empty($last_category) && !empty($custom_taxonomy) && $taxonomy_exists) {
                $taxonomy_terms = get_the_terms( $post->ID, $custom_taxonomy );
                $cat_id         = $taxonomy_terms[0]->term_id;
                $cat_nicename   = $taxonomy_terms[0]->slug;
                $cat_link       = get_term_link($taxonomy_terms[0]->term_id, $custom_taxonomy);
                $cat_name       = $taxonomy_terms[0]->name;
               
            }
              
            // Check if the post is in a category
            if(!empty($last_category)) {
                $output .= wp_kses_post($cat_display);
                $output .= '<li class="item-current item-' . esc_attr($post->ID) . '"><span class="bread-current bread-' . esc_attr($post->ID) . '" title="' . get_the_title() . '">' . get_the_title() . '</span></li>';
                  
            // Else if post is in a custom taxonomy
            } else if(!empty($cat_id)) {
                  
                $output .= '<li class="item-cat item-cat-' . esc_attr($cat_id) . ' item-cat-' . esc_attr($cat_nicename) . '"><a class="bread-cat bread-cat-' . esc_attr($cat_id) . ' bread-cat-' . esc_attr($cat_nicename) . '" href="' . esc_url($cat_link) . '" title="' . esc_attr($cat_name) . '">' . esc_html($cat_name) . '</a></li>';
                $output .= '<li class="separator"> ' . wp_kses_post($separator) . ' </li>';
                $output .= '<li class="item-current item-' . esc_attr($post->ID) . '"><span class="bread-current bread-' . esc_attr($post->ID) . '" title="' . get_the_title() . '">' . get_the_title() . '</span></li>';
              
            } else {
                  
                $output .= '<li class="item-current item-' . esc_attr($post->ID) . '"><span class="bread-current bread-' . esc_attr($post->ID) . '" title="' . get_the_title() . '">' . get_the_title() . '</span></li>';
                  
            }
              
        } else if ( is_category() ) {
               
            // Category page
            $output .= '<li class="item-current item-cat"><span class="bread-current bread-cat">' . single_cat_title('', false) . '</span></li>';
               
        } else if ( is_page() ) {
               
            // Standard page
            if( $post->post_parent ){
                   
                // If child page, get parents 
                $anc = get_post_ancestors( $post->ID );
                   
                // Get parents in the right order
                $anc = array_reverse($anc);
                   
                // Parent page loop
                if ( !isset( $parents ) ) $parents = null;
                foreach ( $anc as $ancestor ) {
                    $parents .= '<li class="item-parent item-parent-' . esc_attr($ancestor) . '"><a class="bread-parent bread-parent-' . esc_attr($ancestor) . '" href="' . get_permalink($ancestor) . '" title="' . get_the_title($ancestor) . '">' . get_the_title($ancestor) . '</a></li>';
                    $parents .= '<li class="separator separator-' . esc_attr($ancestor) . '"> ' . wp_kses_post($separator) . ' </li>';
                }
                   
                // Display parent pages
                $output .= wp_kses_post($parents);
                   
                // Current page
                $output .= '<li class="item-current item-' . esc_attr($post->ID) . '"><span title="' . get_the_title() . '"> ' . get_the_title() . '</span></li>';
                   
            } else {
                   
                // Just display current page if not parents
                $output .= '<li class="item-current item-' . esc_attr($post->ID) . '"><span class="bread-current bread-' . esc_attr($post->ID) . '"> ' . get_the_title() . '</span></li>';
                   
            }
               
        } else if ( is_tag() ) {
               
            // Tag page
               
            // Get tag information
            $term_id        = get_query_var('tag_id');
            $taxonomy       = 'post_tag';
            $args           = 'include=' . $term_id;
            $terms          = get_terms( $taxonomy, $args );
            $get_term_id    = $terms[0]->term_id;
            $get_term_slug  = $terms[0]->slug;
            $get_term_name  = $terms[0]->name;
               
            // Display the tag name
            $output .= '<li class="item-current item-tag-' . esc_attr($get_term_id) . ' item-tag-' . esc_attr($get_term_slug) . '"><span class="bread-current bread-tag-' . esc_attr($get_term_id) . ' bread-tag-' . esc_attr($get_term_slug) . '">' . esc_html($get_term_name) . '</span></li>';
           
        } elseif ( is_day() ) {
               
            // Day archive
               
            // Year link
            $output .= '<li class="item-year item-year-' . get_the_time('Y') . '"><a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . esc_html__(' Archives', 'arlo').'</a></li>';
            $output .= '<li class="separator separator-' . get_the_time('Y') . '"> ' . wp_kses_post($separator) . ' </li>';
               
            // Month link
            $output .= '<li class="item-month item-month-' . get_the_time('m') . '"><a class="bread-month bread-month-' . get_the_time('m') . '" href="' . get_month_link( get_the_time('Y'), get_the_time('m') ) . '" title="' . get_the_time('M') . '">' . get_the_time('M') . esc_html__(' Archives', 'arlo').'</a></li>';
            $output .= '<li class="separator separator-' . get_the_time('m') . '"> ' . wp_kses_post($separator) . ' </li>';
               
            // Day display
            $output .= '<li class="item-current item-' . get_the_time('j') . '"><span class="bread-current bread-' . get_the_time('j') . '"> ' . get_the_time('jS') . ' ' . get_the_time('M') . esc_html__(' Archives', 'arlo').'</span></li>';
               
        } else if ( is_month() ) {
               
            // Month Archive
               
            // Year link
            $output .= '<li class="item-year item-year-' . get_the_time('Y') . '"><a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . esc_html__(' Archives', 'arlo').'</a></li>';
            $output .= '<li class="separator separator-' . get_the_time('Y') . '"> ' . wp_kses_post($separator) . ' </li>';
               
            // Month display
            $output .= '<li class="item-month item-month-' . get_the_time('m') . '"><span class="bread-month bread-month-' . get_the_time('m') . '" title="' . get_the_time('M') . '">' . get_the_time('M') . esc_html__(' Archives', 'arlo').'</span></li>';
               
        } else if ( is_year() ) {
               
            // Display year archive
            $output .= '<li class="item-current item-current-' . get_the_time('Y') . '"><span class="bread-current bread-current-' . get_the_time('Y') . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . esc_html__(' Archives', 'arlo').'</span></li>';
               
        } else if ( is_author() ) {
               
            // Auhor archive
               
            // Get the author information
            global $author;
            $userdata = get_userdata( $author );
               
            // Display author name
            $output .= '<li class="item-current item-current-' . esc_attr($userdata->display_name) . '"><span class="bread-current bread-current-' . esc_attr($userdata->display_name) . '" title="' . esc_attr($userdata->display_name) . '">' . esc_html__('Author: ', 'arlo') . esc_html($userdata->display_name) . '</span></li>';
           
        } else if ( get_query_var('paged') ) {
               
            // Paginated archives
            $output .= '<li class="item-current item-current-' . get_query_var('paged') . '"><span class="bread-current bread-current-' . get_query_var('paged') . '" title="'.esc_attr__('Page ', 'arlo') . get_query_var('paged') . '">'.esc_html__('Page', 'arlo') . ' ' . get_query_var('paged') . '</span></li>';
               
        } else if ( is_search() ) {
           
            // Search results page
            $output .= '<li class="item-current item-current-' . get_search_query() . '"><span class="bread-current bread-current-' . get_search_query() . '" title="'.esc_attr__('Search results for: ', 'arlo'). get_search_query() . '">' .esc_html__('Search results for: ', 'arlo') . get_search_query() . '</span></li>';
           
        } elseif ( is_404() ) {
               
            // 404 page
            $output .= '<li>' . esc_html__('Error 404', 'arlo') . '</li>';
        }
       
        $output .= '</ul>';
		$output .= '</div>';
           
    }
	
	if($echo == true){
		echo $output;
	}else{
		return $output;
	}
       
}

function arlo_fn_cs_ajax_grid_filter_posts(){
	
	$category_id = $post_type = $post_number = $post_offset = $post_order = $post_orderby = $ratio = $format = $page = '';
		
	
	if(!empty($_POST['category_id'])){
		$category_id 			= $_POST['category_id'];
	}
	if(!empty($_POST['post_type'])){
		$post_type 				= $_POST['post_type'];
	}
	if(!empty($_POST['post_number'])){
		$post_number 			= $_POST['post_number'];
	}
	if(!empty($_POST['post_offset'])){
		$post_offset 			= $_POST['post_offset'];
	}
	if(!empty($_POST['post_order'])){
		$post_order 			= $_POST['post_order'];
	}
	if(!empty($_POST['post_orderby'])){
		$post_orderby 			= $_POST['post_orderby'];
	}
	if(!empty($_POST['ratio'])){
		$ratio 					= $_POST['ratio'];
	}
	if(!empty($_POST['format'])){
		$format 				= $_POST['format'];
	}
	if(!empty($_POST['page'])){
		$page 					= $_POST['page'];
	}
	$page = (int)$page;
	$page = $page+1;
	
	$size 			= 'margin-bottom: calc('.$ratio.' * 100%);';
	$size 			.= 'margin-bottom: -moz-calc('.$ratio.' * 100%);';
	$size 			.= 'margin-bottom: -webkit-calc('.$ratio.' * 100%);';
	$thumb		   	= '<img style="'.$size.'" src="'.ARLO_CORE_SHORTCODE_URL.'assets/img/thumb-square.jpg" alt="" />';
	
	
	if($post_type == 'portfolio'){
		$post_included_items = $post_excluded_items = $post_included_categories = $post_excluded_categories = array();
		if(!empty($_POST['post_included_items'])){
			$post_included_items 		= $_POST['post_included_items'];
		}
		if(!empty($_POST['post_excluded_items'])){
			$post_excluded_items 		= $_POST['post_excluded_items'];
		}
		if(!empty($_POST['post_included_categories'])){
			$post_included_categories 	= $_POST['post_included_categories'];
		}
		if(!empty($_POST['post_excluded_categories'])){
			$post_excluded_categories 	= $_POST['post_excluded_categories'];
		}
		$postIncludedItems			= array();
		if($post_included_items != ''){
			$postIncludedItems		= explode(',', $post_included_items);
		}
		$postExcludedItems			= array();
		if($post_excluded_items != ''){
			$postExcludedItems		= explode(',', $post_excluded_items);
		}
		$include_categories 		= array();
		if($post_included_categories != ''){
			$include_categories 	= explode(',', $post_included_categories);
		}
		if($category_id != '*'){
			$include_categories 	= array($category_id);
			$field 					= 'term_id';
		}else{
			$field					= 'slug';
		}

		$exclude_categories 		= array();
		if($post_excluded_categories != ''){
			$exclude_categories 	= explode(',', $post_excluded_categories);
		}
		
		$query_args = array(
			'post_type' 			=> 'arlo-project',
			'paged' 				=> $page,
			'posts_per_page' 		=> $post_number,
			'post_status' 			=> 'publish',
			'order' 				=> $post_order,
			'orderby' 				=> $post_orderby,
			'post__in' 				=> $postIncludedItems,
			'post__not_in'	 		=> $postExcludedItems,
		);
		
		if ( ! empty ( $exclude_categories ) ) {

			// Exclude the correct cats from tax_query
			$query_args['tax_query'] = array(
				array(
					'taxonomy'	=> 'project_category', 
					'field'	 	=> 'slug',
					'terms'		=> $exclude_categories,
					'operator'	=> 'NOT IN'
				)
			);

			// Include the correct cats in tax_query
			if ( ! empty ( $include_categories ) ) {
				$query_args['tax_query']['relation'] = 'AND';
				$query_args['tax_query'][] = array(
					'taxonomy'	=> 'project_category',
					'field'		=> $field,
					'terms'		=> $include_categories,
					'operator'	=> 'IN'
				);
			}	

		} else {
			// Include the cats from $cat_slugs in tax_query
			if ( ! empty ( $include_categories ) ) {
				$query_args['tax_query'] = array(
					array(
						'taxonomy' 	=> 'project_category',
						'field' 	=> $field,
						'terms' 	=> $include_categories,
						'operator'	=> 'IN'
					)
				);
			}
		}
	}else if($post_type == 'post'){
		$query_args = array(
			'post_type' 			=> 'post',
			'post_status' 			=> 'publish',
			'order' 				=> $post_order,
			'orderby' 				=> $post_orderby,
			'paged'					=> $page
		);
		if ( $category_id != '*' ) {
			$query_args['tax_query'] = array(
				array(
					'taxonomy' 	=> 'category',
					'field' 	=> 'term_id',
					'terms' 	=> $category_id,
					'operator'	=> 'IN'
				)
			);
		}
	}
		
	$query_args['posts_per_page'] = -1;
	$loop2 						= new \WP_Query($query_args);
	$all_posts_count			= count($loop2->posts);
	$query_args['posts_per_page'] = $post_number;
	$arlo_post_loop 			= new \WP_Query($query_args);
	$specified_posts_count		= count($arlo_post_loop->posts);


	$queryItems = '';
	foreach ( $arlo_post_loop->posts as $fnPost ) {
		setup_postdata( $fnPost );
		$postID 			= $fnPost->ID;
		$postPermalink 		= get_permalink($postID);
		$postImage			= get_the_post_thumbnail_url($postID, 'full');
		$postTitle			= $fnPost->post_title;
		$postCategory		= Frel_Helper::post_term_list($postID, 'category', false, 1);
		if($postCategory != ''){
			$postCategory = '<div class="fn_category">'.$postCategory.'</div>';
		}

		$post_time			= '<p>'.get_the_time($format, $postID).'</p>';
		$imageHolder		= '<div class="img_holder">'.$thumb.'<div class="abs_img" data-bg-img="'.$postImage.'"></div><a href="'.$postPermalink.'"></a></div>';
		$titleHolder		= '<div class="title_holder">'.$post_time.'<h3><a href="'.$postPermalink.'">'.$postTitle.'</a></h3></div>';


		$queryItems	.= '<li class="fn_animated"><div class="item">'.$postCategory.$imageHolder.$titleHolder.'</div></li>';

		wp_reset_postdata();
	}
	
		
	
	$disabled = '';
	if(($specified_posts_count + ($post_number*($page-1))) >= $all_posts_count){
		$disabled = 'disabled';
	}
	
	
	$buffyArray = array(
		'becipe_fn_data' 		=> $queryItems,
		'page' 					=> $page,
		'disabled' 				=> $disabled,
		'include_categories'  	=> $include_categories,
    );
	
	die(json_encode($buffyArray));
}

function arlo_fn_getImgIDByUrl($url) {
	global $wpdb;
	$attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid='%s';", $url ));
	if(isset($attachment[0])){
		return $attachment[0];
	}
	return '';
}
function arlo_fn_getImgUrlByUrl($url,$imageSize = 'full'){
	$imageID	= arlo_fn_getImgIDByUrl($url);
	if($imageID != ''){
		if($imageSize == 'square'){$imageSize = 'arlo_fn_thumb-1000-1000';}else if($imageSize == 'portrait'){$imageSize = 'arlo_fn_thumb-1000-9999';}
		return wp_get_attachment_image_url($imageID, $imageSize);
	}
	return $url;
}
function arlo_fn_getImgByURL($url,$imageSize = 'full'){
	$imageUrl = arlo_fn_getImgUrlByUrl($url,$imageSize);
	if($imageUrl != ''){
		return '<img src="'.$imageUrl.'" alt="" />';
	}
	return $imageUrl;
}

function arlo_fn_getImageByImageUrl($url,$size = 'full',$return = 'url'){
	$imageID	= attachment_url_to_postid( $url );
	if($size == 'square'){$size = 'arlo_fn_thumb-1000-1000';}else if($size == 'portrait'){$size = 'arlo_fn_thumb-1000-9999';}
	$img		= wp_get_attachment_image_src( $imageID, $size);
	$imgURL		= $img[0];
	if($return == 'url'){
		return $imgURL;
	}
	return '<img src="'.$imgURL.'" alt="" />';
}

/*-----------------------------------------------------------------------------------*/
/* CallBack Thumbnails
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'arlo_fn_callback_thumbs' ) ) {   
    function arlo_fn_callback_thumbs($width, $height) {
    	
		$arlo_fn_output = NULL; 
		
		 
		// callback function
		$arlo_fn_thumbnail = get_template_directory_uri() .'/framework/img/thumb/thumb-'. esc_html($width) .'-'. esc_html($height) .'.jpg'; 
		$arlo_fn_output .= '<img src="'. esc_url($arlo_fn_thumbnail) .'" alt="'.esc_attr__('no image', 'arlo').'" data-initial-width="'. esc_attr($width) .'" data-initial-height="'. esc_attr($height) .'">'; 
	
		
		
		return  wp_kses_post($arlo_fn_output);
    }
}
function arlo_fn_custom_lang_switcher(){
	global $arlo_fn_option;
	
	$html 		= '';
	
	$true		= false;
	
	if(isset($arlo_fn_option['one_line_lang_switch'])){
		if($arlo_fn_option['one_line_lang_switch']){
			$true = true;
		}
	}
	if($true){
		if(isset($arlo_fn_option['custom_lang_switch']) && $arlo_fn_option['custom_lang_switch'] == 'enable'){
			if(isset($arlo_fn_option['custom_language_links']) && !empty($arlo_fn_option['custom_language_links'])){
				$WHArray 	= $arlo_fn_option['custom_language_links'];
				$html	 	.= '<div class="arlo_fn_custom_lang_switcher custom_language"><span class="click">';
				$WHItem		= '';
				$click 		= '';
				$key 		= 1;
				foreach($WHArray as $WHChild){
					$title 		= $WHChild['title'];
					$url 		= $WHChild['url'];
					$imageURL	= $WHChild['image'];
					$image 		= '<div class="abs_lan_img" data-fn-bg-img="'.$imageURL.'"></div>';
					if($key !== 1){
						$WHItem .= '<li><a href="'.$url.'">'.$image.'<span>'.$title.'</span></a></li>';
					}else{
						$WHItem .= '<li class="active">'.$image.'<span>'.$title.'</span></li>';
						$click	= '<span class="abs_lan_img" data-fn-bg-img="'.$imageURL.'"></span><span class="text">'.$title.'</span>';
					}
					$key++;
				}
				$html .= $click.'</span><ul>'.$WHItem.'</ul></div>';			
			}
		}else{
			if(function_exists('icl_get_languages')){
				$languages = icl_get_languages('skip_missing=0&orderby=code&order=desc');
				if(!empty($languages)){
					$html .= '<div class="arlo_fn_custom_lang_switcher"><ul>';
						$span = '<span class="click">';
					foreach($languages as $l){
						if(!$l['active']){
							$html .= '<li>';
						}else{
							$html .= '<li class="active">';
						}
						if($l['country_flag_url']){
							if(!$l['active']) $html .= '<a class="flag" href="'.$l['url'].'">';
							$html .= '<img src="'.$l['country_flag_url'].'" height="12" alt="'.$l['language_code'].'" width="18" />';
							if(!$l['active']) $html .= '</a>';
						}
						if(!$l['active']) $html .= '<a href="'.esc_url($l['url']).'">';
						$langs = icl_disp_language(/*$l['native_name'],*/ $l['translated_name']);
						$langs = mb_substr($langs,0,3);
						if($l['active']){
							$span .= esc_html($langs);
						}
						$html .= '<span>'.esc_html($langs).'</span>';
						if(!$l['active']) $html .= '</a>';
						$html .= '</li>';
					}
					$html .= '</ul>';
					$html .= $span;
					$html .= '</div>';
				}
			}else{
				$html .= '<div class="arlo_fn_custom_lang_switcher frenify_url"><span class="click">'.esc_html__('Eng', 'arlo').'</span><ul>
						<li class="active"><span>'.esc_html__('Eng', 'arlo').'</span></li>
						<li><a href="#"><span>'.esc_html__('Spa', 'arlo').'</span></a></li>
						<li><a href="#"><span>'.esc_html__('Rus', 'arlo').'</span></a></li>
					</ul></div>';
			}
		}
	}
		
//	echo wp_kses_post($html);
	return ($html);
    
}

function arlo_fn_font_url() {
	$fonts_url = '';
	
	$font_families = array();
	$font_families[] = 'Open Sans:300,300i,400,400i,600,600i,800,800i';
	$font_families[] = 'Rubik:300,300i,400,400i,600,600i,800,800i';
	$font_families[] = 'Muli:300,300i,400,400i,600,600i,800,800i';
	$font_families[] = 'Montserrat:300,300i,400,400i,600,600i,800,800i';
	$font_families[] = 'Lora:300,300i,400,400i,600,600i,800,800i';
	$font_families[] = 'Poppins:300,300i,400,400i,600,600i,800,800i';
	$font_families[] = 'Oswald:300,300i,400,400i,600,600i,800,800i';
	$font_families[] = 'Heebo:100,200,300,400,500,700,800,900';
	$query_args = array(
		'family' => urlencode( implode( '|', $font_families ) ),
		'subset' => urlencode( 'latin,latin-ext' ),
	);
	$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	
	return esc_url_raw( $fonts_url );
}
function arlo_fn_main_link($text = '', $href = '#', $svgCome = 'yes'){
	if($text == ''){
		$text 	= esc_html__('Read More', 'arlo');
	}
	$svg 		= '<img class="arlo_fn_svg" src="'.get_template_directory_uri().'/framework/svg/right-arrow-1.svg" alt="'.esc_attr__('svg', 'arlo').'" />';
	$svg 		= '<span class="main_link_icon">'.$svg.'</span>';
	if($svgCome == 'no'){
		$svg	= '';
	}
	$text		= '<span class="main_link_text"><span>'.$text.'</span></span>';
	return 	'<a class="arlo_fn_main_link" href="'.$href.'">'.$text.$svg.'</a>';
}
function arlo_fn_hex2rgba($color, $opacity = false) {
 
	$default = 'rgb(0,0,0)';
 
	//Return default if no color provided
	if(empty($color))
          return $default; 
 
	//Sanitize $color if "#" is provided 
        if ($color[0] == '#' ) {
        	$color = substr( $color, 1 );
        }
 
        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
                $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
        } elseif ( strlen( $color ) == 3 ) {
                $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
        } else {
                return $default;
        }
 
        //Convert hexadec to rgb
        $rgb =  array_map('hexdec', $hex);
 
        //Check if opacity is set(rgba or rgb)
        if($opacity){
        	if(abs($opacity) > 1)
        		$opacity = 1.0;
        	$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
        } else {
        	$output = 'rgb('.implode(",",$rgb).')';
        }
 
        //Return rgb(a) color string
        return $output;
}
function arlo_fn_resource_hints( $urls, $relation_type ) {
	if ( wp_style_is( 'arlo-fn-font-url', 'queue' ) && 'preconnect' === $relation_type ) {
		$urls[] = array(
			'href' => 'https://fonts.gstatic.com',
			'crossorigin',
		);
	}
	return $urls;
}
add_filter( 'wp_resource_hints', 'arlo_fn_resource_hints', 10, 2 );
function arlo_fn_filter_allowed_html($allowed, $context){
 
	if (is_array($context))
	{
	    return $allowed;
	}
 
	if ($context === 'post')
	{
        // Custom Allowed Tag Atrributes and Values
	    $allowed['div']['data-success'] = true;
		
		$allowed['a']['data-filter-value'] = true;
		$allowed['a']['data-filter-name'] = true;
		$allowed['ul']['data-wid'] = true;
		$allowed['div']['data-wid'] = true;
		$allowed['a']['data-postid'] = true;
		$allowed['a']['data-gpba'] = true;
		$allowed['div']['data-col'] = true;
		$allowed['div']['data-gutter'] = true;
		$allowed['div']['data-title'] = true;
		$allowed['a']['data-disable-text'] = true;
		$allowed['script'] = true;
		$allowed['div']['data-archive-value'] = true;
		$allowed['a']['data-wid'] = true;
		$allowed['div']['data-sub-html'] = true;
		$allowed['div']['data-src'] = true;
		$allowed['li']['data-src'] = true;
		$allowed['div']['data-fn-bg-img'] = true;
		
		$allowed['div']['data-cols'] = true;
		$allowed['td']['data-fgh'] = true;
		$allowed['div']['style'] = true;
		$allowed['input']['type'] = true;
		$allowed['input']['name'] = true;
		$allowed['input']['id'] = true;
		$allowed['input']['class'] = true;
		$allowed['input']['value'] = true;
		$allowed['input']['placeholder'] = true;
		
		$allowed['img']['data-initial-width'] = true;
		$allowed['img']['data-initial-height'] = true;
		$allowed['img']['style'] = true;
	}
 
	return $allowed;
}
add_filter('wp_kses_allowed_html', 'arlo_fn_filter_allowed_html', 10, 2);
?>
