<!DOCTYPE html >
<html <?php language_attributes(); ?>><head>
<?php global $arlo_fn_option, $post; ?>

<meta charset="<?php esc_attr(bloginfo( 'charset' )); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

<?php wp_head(); ?>

</head>

<?php 
		
	// header extra options: improved since 2.0
	$headerExtraOptions			= arlo_fn_getOptionsForHeaderPHP();
	$mobMenuAutocollapse		= $headerExtraOptions[0];
	$navOpenDefault				= $headerExtraOptions[1];
	$preloaderHTML				= $headerExtraOptions[2];
	$navVariation				= $headerExtraOptions[3];
	$sidebarNavSkin				= $headerExtraOptions[4];
	$submenuSkin				= $headerExtraOptions[5];
	$darkMode					= $headerExtraOptions[6];
	$bgDivider					= $headerExtraOptions[7];
	$bodyDarkModeExtraClass		= $headerExtraOptions[8];
	
?>
	
<body <?php body_class($bodyDarkModeExtraClass);?>>


<!-- WRAPPER ALL -->
<div class="arlo_fn_wrapper_all <?php echo esc_attr($darkMode);?> <?php echo esc_attr($navOpenDefault);?>" 
	data-nav-skin="<?php echo esc_attr($sidebarNavSkin); ?>" 
	data-mobile-autocollapse="<?php echo esc_attr($mobMenuAutocollapse); ?>" 
	data-nav-type="<?php echo esc_attr($navVariation); ?>" 
	data-submenu-skin="<?php echo esc_attr($submenuSkin); ?>" 
	>
	
	<!-- get moving submenu if sidebar navigation is selected -->
	<?php if($navVariation == 'sidebar'){ ?>
		<div id="arlo_fn_fixedsub">
			<ul></ul>
		</div>
	<?php }?>
	
	<div id="arlo_fn_moving_trigger">
		<ul></ul>
	</div>
		
	
	<!-- get preloader if preloader is enabled from Theme Options-->
	<?php echo wp_kses_post($preloaderHTML);?>
	
	<?php if($bgDivider == 'enable'){ ?>
	<div class="arlo_fn_line">
		<span class="fn_line_a"></span>
		<span class="fn_line_b"></span>
		<span class="fn_line_c"></span>
	</div>
	<?php }?>

	<!-- WRAPPER -->
	<div class="arlo_fn_wrapper">
		
	
		<?php echo wp_kses(arlo_fn_dev_mode(), 'post'); ?>
		
		<?php if(isset($_GET['nav_type'])){$navVariation = $_GET['nav_type'];} ?>
		<!-- get selected navigation from source file -->
		<?php get_template_part('inc/nav/nav-'.$navVariation); ?>
		
		
		<!-- get trigger menu -->
		<?php get_template_part('inc/nav/trigger-menu');?>
		
		
		<!-- get mobile menu -->
		<?php get_template_part('inc/nav/nav-mobile');?>
		
		<!-- get sticky navigation -->
		<?php get_template_part( 'inc/nav/nav-sticky');?>
				
		
		<!-- WRAPPER for HEIGHT -->
		<div class="arlo_fn_wfh">