<?php

	add_action( 'after_setup_theme', 'arlo_fn_setup', 50 );

	function arlo_fn_setup(){

			// REGISTER THEME MENU
			if(function_exists('register_nav_menus')){
				register_nav_menus(array('main_menu' 		=> esc_html__('Main Menu','arlo')));
				register_nav_menus(array('mobile_menu' 		=> esc_html__('Mobile Menu','arlo')));
				register_nav_menus(array('trigger_menu' 	=> esc_html__('Trigger Menu','arlo')));
			}

			// This theme styles the visual editor with editor-style.css to match the theme style.
			add_action( 'wp_enqueue_scripts', 'arlo_fn_scripts', 100 ); 
			add_action( 'wp_enqueue_scripts', 'arlo_fn_styles', 100 );
			add_action( 'wp_enqueue_scripts', 'arlo_fn_inline_styles', 150 );
			add_action( 'admin_enqueue_scripts', 'arlo_fn_admin_scripts' );
		
			// Actions
			add_action( 'tgmpa_register', 'arlo_fn_register_required_plugins' );
		
			// Post Format support. You can also use the legacy "gallery" or "asides" (note the plural) categories.
			add_theme_support( 'post-formats', array('video','audio','gallery','image','link','quote') );
		
			// This theme uses post thumbnails
			add_theme_support( 'post-thumbnails' );
		
			set_post_thumbnail_size( 300, 300, true ); 							// Normal post thumbnails
		
			add_image_size( 'arlo_fn_thumb-1000-1000', 1000, 1000, true);		// Portfolio Categories
			add_image_size( 'arlo_fn_thumb-1000-9999', 1000, 9999, false);		// Portfolio Page
			add_image_size( 'arlo_fn_thumb-300-300', 300, 300, true);			// Clients, Commentary
		
			//Load Translation Text Domain
			load_theme_textdomain( 'arlo', get_template_directory() . '/languages' );
		
		
			add_action( 'admin_notices', 'arlo_fn_compare_core_and_theme', 999 );
		
		
		
			// Firing Title Tag Function
			arlo_fn_theme_slug_setup();
		
			add_filter(	'widget_tag_cloud_args', 'arlo_fn_tag_cloud_args');
		
			if ( ! isset( $content_width ) ) $content_width = 1170;
		
			// Add default posts and comments RSS feed links to head
			add_theme_support( 'automatic-feed-links' );
			add_theme_support( 'wp_list_comments' );
		
			add_editor_style();
		
			// for ajax
			add_action( 'wp_ajax_nopriv_arlo_fn_portfolio_block_ajax', 'arlo_fn_portfolio_block_ajax' );
			add_action( 'wp_ajax_arlo_fn_portfolio_block_ajax', 'arlo_fn_portfolio_block_ajax' );
			
			// for ajax
			add_action( 'wp_ajax_nopriv_arlo_fn_ajax_service_list', 'arlo_fn_ajax_service_list' );
			add_action( 'wp_ajax_arlo_fn_ajax_service_list', 'arlo_fn_ajax_service_list' );
			
			// for ajax woocommerce
			add_action( 'wp_ajax_nopriv_arlo_fn_remove_item_from_cart', 'arlo_fn_remove_item_from_cart' );
			add_action( 'wp_ajax_arlo_fn_remove_item_from_cart', 'arlo_fn_remove_item_from_cart' );
			
			// for ajax
			add_action( 'wp_ajax_nopriv_arlo_fn_sidebar_opened_ajax', 'arlo_fn_sidebar_opened_ajax' );
			add_action( 'wp_ajax_arlo_fn_sidebar_opened_ajax', 'arlo_fn_sidebar_opened_ajax' );
			
			$my_theme 		= wp_get_theme( 'arlo' );
			$version		= '1.0';
			if ( $my_theme->exists() ){
				$version 	= (string)$my_theme->get( 'Version' );
			}
			$version		= 'ver_'.$version;
			define('ARLO_VERSION', $version);
			define('ARLO_THEME_URL', get_template_directory_uri());
			define('ARLO_CSS', ARLO_THEME_URL . '/framework/css/');
			define('ARLO_JS', ARLO_THEME_URL . '/framework/js/');
		/* ------------------------------------------------------------------------ */
		/*  Inlcudes
		/* ------------------------------------------------------------------------ */
			include_once( get_template_directory().'/inc/arlo_fn_functions.php'); 				// Custom Functions
			include_once( get_template_directory().'/inc/arlo_fn_googlefonts.php'); 			// Google Fonts Init
			include_once( get_template_directory().'/inc/arlo_fn_css.php'); 					// Inline CSS
			include_once( get_template_directory().'/inc/arlo_fn_sidebars.php'); 				// Widget Area
			include_once( get_template_directory().'/inc/arlo_fn_like.php'); 					// Like Post
			include_once( get_template_directory().'/inc/arlo_fn_megamenu.php');	 			// Megamenu
			include_once( get_template_directory().'/inc/arlo_fn_pagination.php'); 				// Pagination
			include_once( get_template_directory().'/config/config-woo/config.php'); 			// WooCommerce	
		

	}

 function arlo_fn_compare_core_and_theme() {
	 	if(wp_get_theme()->get('Name') == 'Arlo'){
			$my_theme 			= wp_get_theme( 'Arlo' );
			if ( $my_theme->exists() ){
				$themeVersion 	= esc_html( $my_theme->get('Version') );
				$arloCore		= 'Arlo Core';
				require_once ABSPATH . 'wp-admin/includes/plugin.php' ;
				if(is_plugin_active('arlo-core/arlo-core.php')){
					$pluginInfo 	= get_plugin_data( ABSPATH . 'wp-content/plugins/arlo-core/arlo-core.php' );
					$pluginVersion 	= $pluginInfo['Version'];
					if ( version_compare( $pluginVersion, '2.6', '>' ) ){
						if(version_compare($themeVersion,  $pluginVersion) != 0){
							$class 		= 'notice notice-warning is-dismissible';
							$pluginsURI = get_dashboard_url().'plugins.php';
							$title		= '<br /><strong>Warning! Update "'.$arloCore.'" plugin.</strong><br />';
							$pluginsURL = '<strong><a href="'.$pluginsURI.'">'.$pluginsURI.'</a></strong>';
							printf( '<div class="%1$s">%5$s<p>Please, make sure that you have updated %6$s for Arlo Theme. Because, you have installed <strong>%6$s</strong> version <u><strong>%2$s</strong></u>, but your <strong>Arlo theme</strong> has version <u><strong>%3$s</strong></u><br /> Just disable and remove %6$s from your plugins %4$s and install required plugin. Otherwise, new shortcodes and innovations will not be possible with old version of the plugin.</p><br /></div>', esc_attr( $class ), esc_html( $pluginVersion ), esc_html( $themeVersion ), $pluginsURL, $title, $arloCore );
						}
					}
				}
			}
		}
	}




/* ----------------------------------------------------------------------------------- */
/*  ENQUEUE STYLES AND SCRIPTS
/* ----------------------------------------------------------------------------------- */
	function arlo_fn_scripts() {
		wp_enqueue_script('modernizr-custom', ARLO_JS.'modernizr.custom.js', array('jquery'), ARLO_VERSION, FALSE);
		wp_enqueue_script('theia-sticky-sidebar', ARLO_JS.'theia.sticky.sidebar.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_enqueue_script('isotope', ARLO_JS.'isotope.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_enqueue_script('select2', ARLO_JS.'select2.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_enqueue_script('nicescroll', ARLO_JS.'nicescroll.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_enqueue_script('justified', ARLO_JS.'justified.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_enqueue_script('lightgallery', ARLO_JS.'lightgallery.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_enqueue_script('magnific-popup', ARLO_JS.'magnific.popup.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_enqueue_script('owl-carousel', ARLO_JS.'owl.carousel.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_enqueue_script('arlo-fn-woocommerce', ARLO_THEME_URL.'/config/config-woo/woocommerce.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_enqueue_script('arlo-fn-init', ARLO_JS.'init.js', array('jquery'), ARLO_VERSION, TRUE);
		wp_localize_script( 'arlo-fn-init', 'fn_ajax_object', array( 
			'fn_ajax_url' 	=> admin_url( 'admin-ajax.php' ),
			'siteurl' 		=> site_url() // added since v4.0
		));
		
		if ( is_singular() ) wp_enqueue_script( 'comment-reply' );
	}
	
	function arlo_fn_admin_scripts() {
		wp_enqueue_script('arlo-fn-widget-upload', ARLO_JS.'widget.upload.js', array('jquery'), ARLO_VERSION, FALSE);
		wp_enqueue_script('arlo-fn-meta-sortable', ARLO_JS.'meta.sortable.js', array('jquery'), ARLO_VERSION, FALSE);
		wp_enqueue_style('arlo-fn-meta-sortable', ARLO_CSS.'meta.sortable.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('arlo-fn-admin-style', ARLO_CSS.'admin.style.css', array(), ARLO_VERSION, 'all');
	}

	function arlo_fn_styles(){
		wp_enqueue_style( 'arlo-fn-font-url', arlo_fn_font_url(), array(), null );
		wp_enqueue_style('arlo-fn-base', ARLO_CSS.'base.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('arlo-fn-skeleton', ARLO_CSS.'skeleton.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('fontello', ARLO_CSS.'fontello.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('justified', ARLO_CSS.'justified.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('select2', ARLO_CSS.'select2.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('magnific-popup', ARLO_CSS.'magnific.popup.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('lightgallery', ARLO_CSS.'lightgallery.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('owl-carousel', ARLO_CSS.'owl.carousel.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('owl-theme-default', ARLO_CSS.'owl.theme.default.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('arlo-fn-woocommerce', ARLO_THEME_URL.'/config/config-woo/woocommerce.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('arlo-fn-rtl-stylesheet', ARLO_CSS.'rtl.style.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('arlo-fn-navigation', ARLO_CSS.'navigation.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('arlo-fn-hamburger', ARLO_CSS.'hamburger.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('arlo-fn-theme-style', ARLO_CSS.'theme-style.css', array(), ARLO_VERSION, 'all');
		wp_enqueue_style('arlo-fn-stylesheet', get_stylesheet_uri(), array(), ARLO_VERSION, 'all' ); // Main Stylesheet
	}





/* ----------------------------------------------------------------------------------- */
/*  Title tag: works WordPress v4.1 and above
/* ----------------------------------------------------------------------------------- */
	function arlo_fn_theme_slug_setup() {
		add_theme_support( 'title-tag' );
	}
/* ----------------------------------------------------------------------------------- */
/*  Tagcloud widget
/* ----------------------------------------------------------------------------------- */
	
	function arlo_fn_tag_cloud_args($args)
	{
		
		$my_args = array('smallest' => 14, 'largest' => 14, 'unit'=>'px', 'orderby'=>'count', 'order'=>'DESC' );
		$args = wp_parse_args( $args, $my_args );
		return $args;
	}

	
/*-----------------------------------------------------------------------------------*/
/*	TGM Plugin Activation
/*-----------------------------------------------------------------------------------*/

require_once get_template_directory().'/plugin/class-tgm-plugin-activation.php';

function arlo_fn_register_required_plugins() {
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(

		// This is an example of how to include a plugin bundled with a theme.
		array(
			'name'               => 'Arlo Core', // The plugin name.
			'slug'               => 'arlo-core', // The plugin slug (typically the folder name).
			'source'             => get_template_directory() . '/plugin/arlo-core.zip', // The plugin source.
			'required'           => true, // If false, the plugin is only 'recommended' instead of required.
			'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
			'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
			'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			'external_url'       => '', // If set, overrides default API URL and points to an external URL.
			'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
		),
		array(
			'name'               => 'Redux Vendor Support', // The plugin name.
			'slug'               => 'redux-vendor-support-master', // The plugin slug (typically the folder name).
			'source'             => 'https://github.com/reduxframework/redux-vendor-support/archive/master.zip', // The plugin source.
			'required'           => true, // If false, the plugin is only 'recommended' instead of required.
			'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
			'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
			'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			'external_url'       => 'https://github.com/reduxframework/redux-vendor-support/archive/master.zip', // If set, overrides default API URL and points to an external URL.
			'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
		),
		array(
			'name'               => 'Contact Form 7', // The plugin name.
			'slug'               => 'contact-form-7', // The plugin slug (typically the folder name).
			'required'           => false, // If false, the plugin is only 'recommended' instead of required.
			'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
			'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
			'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
		),
		array(
			'name'               => 'Elementor', // The plugin name.
			'slug'               => 'elementor', // The plugin slug (typically the folder name).
			'required'           => true, // If false, the plugin is only 'recommended' instead of required.
			'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
			'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
			'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
		),
		array(
			'name'               => 'Categorify', // The plugin name.
			'slug'               => 'categorify', // The plugin slug (typically the folder name).
			'required'           => false, // If false, the plugin is only 'recommended' instead of required.
			'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
			'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
			'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
		),

	);

	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	$config = array(
		'id'           => 'arlo',          	 	 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}



?>