<?php
namespace BearsthemesAddons\Widgets\Give_Form\Skins;

use Elementor\Widget_Base;
use Elementor\Skin_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Skin_Changtse extends Skin_Base {

	protected function _register_controls_actions() {
		add_action( 'elementor/element/be-give-form/section_layout/before_section_end', [ $this, 'register_layout_section_controls' ] );
		add_action( 'elementor/element/be-give-form/section_design_layout/after_section_end', [ $this, 'register_design_box_section_controls' ] );
		add_action( 'elementor/element/be-give-form/section_design_layout/after_section_end', [ $this, 'register_design_content_section_controls' ] );

	}

	public function get_id() {
		return 'skin-changtse';
	}


	public function get_title() {
		return __( 'Changtse', 'bearsthemes-addons' );
	}


	public function register_layout_section_controls( Widget_Base $widget ) {
		$this->parent = $widget;

		$this->parent->start_injection( [
			'at' => 'before',
			'of' => 'form_id',
		] );

		$this->add_control(
			'header_title',
			[
				'label' => __( 'Title', 'bearsthemes-addons' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Coronavirus Relief Fund', 'bearsthemes-addons' ),
			]
		);

		$this->add_control(
			'header_desc',
			[
				'label' => __( 'Description', 'bearsthemes-addons' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( 'Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'bearsthemes-addons' ),
			]
		);

		$this->parent->end_injection();

	}

	public function register_design_box_section_controls( Widget_Base $widget ) {
		$this->parent = $widget;

		$this->start_controls_section(
			'section_design_box',
			[
				'label' => __( 'Box', 'bearsthemes-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'box_border_width',
			[
				'label' => __( 'Border Width', 'bearsthemes-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-give-form' => 'border-style: solid; border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'box_border_radius',
			[
				'label' => __( 'Border Radius', 'bearsthemes-addons' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-give-form' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'box_padding',
			[
				'label' => __( 'Padding', 'bearsthemes-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-give-form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'box_bg_color',
			[
				'label' => __( 'Background Color', 'bearsthemes-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-give-form' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'box_border_color',
			[
				'label' => __( 'Border Color', 'bearsthemes-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-give-form' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	public function register_design_content_section_controls( Widget_Base $widget ) {
		$this->parent = $widget;

		$this->start_controls_section(
			'section_design_content',
			[
				'label' => __( 'Content', 'bearsthemes-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_header_title_style',
			[
				'label' => __( 'Title', 'bearsthemes-addons' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'header_title_color',
			[
				'label' => __( 'Color', 'bearsthemes-addons' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .elementor-gf-header__title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_title_typography',
				'label' => __( 'Typography', 'bearsthemes-addons' ),
				'default' => '',
				'selector' => '{{WRAPPER}} .elementor-gf-header__title',
			]
		);

		$this->add_control(
			'header_title_spacing',
			[
				'label' => __( 'Spacing', 'bearsthemes-addons' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-gf-header__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'heading_header_desc_style',
			[
				'label' => __( 'Description', 'bearsthemes-addons' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'header_desc_color',
			[
				'label' => __( 'Color', 'bearsthemes-addons' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .elementor-gf-header__desc' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_desc_typography',
				'label' => __( 'Typography', 'bearsthemes-addons' ),
				'default' => '',
				'selector' => '{{WRAPPER}} .elementor-gf-header__desc',
			]
		);

		$this->add_control(
			'heading_form',
			[
				'label' => __( 'Give Form', 'bearsthemes-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'form_id!'=> '',
				],
			]
		);

		$this->add_control(
			'form_main_color',
			[
				'label' => __( 'Main Color', 'bearsthemes-addons' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .elementor-gf-form form[id*=give-form] #give-donation-level-button-wrap .give-btn:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .elementor-gf-form form[id*=give-form] .give-btn,
					 {{WRAPPER}} .elementor-gf-form form[id*=give-form] .give-total-wrap .give-currency-symbol,
					 {{WRAPPER}} .elementor-gf-form form[id*=give-form] #give-donation-level-button-wrap .give-btn:before,
					 {{WRAPPER}} .elementor-gf-form form[id*=give-form] #give-donation-level-button-wrap .give-btn.give-default-level,
					 {{WRAPPER}} .elementor-gf-form form[id*=give-form] #give-donation-level-button-wrap .give-btn.give-default-level:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .elementor-gt-form form[id*=give-form] #give-donation-level-button-wrap .give-btn:not(.give-default-level)' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .elementor-gf-form form[id*=give-form] #give-donation-level-button-wrap .give-btn.give-default-level:hover' => 'color: #FFFFFF;',
					'.give-modal .give-form #give-gateway-radio-list > li.give-gateway-option-selected label,
					 .give-modal .give-form #give-gateway-radio-list > li label:hover,
					 .give-modal .give-form .give-total-wrap #give-amount,
					 .give-modal .give-form #give-final-total-wrap #give-amount,
					 .give-modal .give-form .give-total-wrap .give-final-total-amount,
					 .give-modal .give-form #give-final-total-wrap .give-final-total-amount' => 'color: {{VALUE}};',
					'.give-modal .give-form .give-total-wrap .give-currency-symbol,
					 .give-modal .give-form #give-final-total-wrap .give-currency-symbol,
					 .give-modal .give-form #give-gateway-radio-list > li label:after,
					 .give-modal .give-form .give-total-wrap .give-donation-total-label,
					 .give-modal .give-form #give-final-total-wrap .give-donation-total-label,
					 .give-modal .give-form > .give-btn,
					 .give-modal .give-form .give-submit' => 'background-color: {{VALUE}};',
					'.give-modal .give-form #give-donation-level-button-wrap .give-btn.give-default-level' => 'background-color: {{VALUE}}; border-color: {{VALUE}};',
					'.give-modal .give-form #give-donation-level-button-wrap .give-btn:hover' => 'color: {{VALUE}}; border-color: {{VALUE}};',
					'.give-modal .give-form .give_terms_links' => 'color: {{VALUE}}; -webkit-box-shadow: 0px 1px 0px {{VALUE}}; box-shadow: 0px 1px 0px {{VALUE}};',
					'.give-modal .give-form .give_terms_links:hover' => '-webkit-box-shadow: 0px 2px 0px {{VALUE}}; box-shadow: 0px 2px 0px {{VALUE}};',
				],
				'condition' => [
					'form_id!'=> '',
				],
			]
		);

		$this->add_control(
			'form_secondary_color',
			[
				'label' => __( 'Secondary Color', 'bearsthemes-addons' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .elementor-gf-form form[id*=give-form] .give-btn:hover' => 'background-color: {{VALUE}};',
					'.give-modal .give-form  > .give-btn:hover,
					 .give-modal .give-form  .give-submit:hover' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'form_id!'=> '',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'form_typography',
				'label' => __( 'Typography', 'bearsthemes-addons' ),
				'default' => '',
				'selector' => '{{WRAPPER}} form[id*=give-form],
											 {{WRAPPER}} form[id*=give-form] #give-donation-level-button-wrap .give-btn,
							 				 .give-modal .give-form',
				'condition' => [
					'form_id!'=> '',
				],
			]
		);

		$this->end_controls_section();
	}

	public function render() {
		$settings = $this->parent->get_settings_for_display();

		$atts = array(
			'id' => $settings['form_id'],  // integer.
			'show_title' => false, // boolean.
			'show_goal' => false, // boolean.
			'show_content' => 'none', //above, below, or none
			'display_style' => 'modal', //modal, button, and reveal
			'continue_button_title' => '' //string

		);

		$this->parent->render_loop_header();

		?>
		<div class="elementor-gf-header">
			<?php

				if( $this->parent->get_instance_value_skin('header_title') ) {
					echo '<h2 class="elementor-gf-header__title">' . $this->parent->get_instance_value_skin('header_title') . '</h2>';
				}

				if( $this->parent->get_instance_value_skin('header_desc') ) {
					echo '<div class="elementor-gf-header__desc">' . $this->parent->get_instance_value_skin('header_desc') . '</div>';
				}

			?>
		</div>

			<div class="elementor-gf-form">

				<?php echo give_get_donation_form( $atts ); ?>

			</div>

		<?php

		$this->parent->render_loop_footer();

	}

	protected function _content_template() {

	}

}
