<?php
/**
 * Generate custom CSS
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

// Return CSS with custom colors and fonts
if (!function_exists('alisha_williams_customizer_get_css')) {

	function alisha_williams_customizer_get_css($colors=null, $fonts=null, $remove_spaces=true, $only_scheme='') {

		$css = array(
			'fonts' => '',
			'colors' => ''
		);
		
		// Theme fonts
		//---------------------------------------------
		if ($fonts === null) {
			$fonts = alisha_williams_get_theme_fonts();
		}
		
		if ($fonts) {

			// Make theme-specific fonts rules
			$fonts = alisha_williams_customizer_add_theme_fonts($fonts);

			$rez = array();
			$rez['fonts'] = <<<CSS

body {
	{$fonts['p_font-family']}
	{$fonts['p_font-size']}
	{$fonts['p_font-weight']}
	{$fonts['p_font-style']}
	{$fonts['p_line-height']}
	{$fonts['p_text-decoration']}
	{$fonts['p_text-transform']}
	{$fonts['p_letter-spacing']}
}
p, ul, ol, dl, blockquote, address {
	{$fonts['p_margin-top']}
	{$fonts['p_margin-bottom']}
}

h1 {
	{$fonts['h1_font-family']}
	{$fonts['h1_font-size']}
	{$fonts['h1_font-weight']}
	{$fonts['h1_font-style']}
	{$fonts['h1_line-height']}
	{$fonts['h1_text-decoration']}
	{$fonts['h1_text-transform']}
	{$fonts['h1_letter-spacing']}
	{$fonts['h1_margin-top']}
	{$fonts['h1_margin-bottom']}
}
h2 {
	{$fonts['h2_font-family']}
	{$fonts['h2_font-size']}
	{$fonts['h2_font-weight']}
	{$fonts['h2_font-style']}
	{$fonts['h2_line-height']}
	{$fonts['h2_text-decoration']}
	{$fonts['h2_text-transform']}
	{$fonts['h2_letter-spacing']}
	{$fonts['h2_margin-top']}
	{$fonts['h2_margin-bottom']}
}
h3 {
	{$fonts['h3_font-family']}
	{$fonts['h3_font-size']}
	{$fonts['h3_font-weight']}
	{$fonts['h3_font-style']}
	{$fonts['h3_line-height']}
	{$fonts['h3_text-decoration']}
	{$fonts['h3_text-transform']}
	{$fonts['h3_letter-spacing']}
	{$fonts['h3_margin-top']}
	{$fonts['h3_margin-bottom']}
}
h4 {
	{$fonts['h4_font-family']}
	{$fonts['h4_font-size']}
	{$fonts['h4_font-weight']}
	{$fonts['h4_font-style']}
	{$fonts['h4_line-height']}
	{$fonts['h4_text-decoration']}
	{$fonts['h4_text-transform']}
	{$fonts['h4_letter-spacing']}
	{$fonts['h4_margin-top']}
	{$fonts['h4_margin-bottom']}
}
h5 {
	{$fonts['h5_font-family']}
	{$fonts['h5_font-size']}
	{$fonts['h5_font-weight']}
	{$fonts['h5_font-style']}
	{$fonts['h5_line-height']}
	{$fonts['h5_text-decoration']}
	{$fonts['h5_text-transform']}
	{$fonts['h5_letter-spacing']}
	{$fonts['h5_margin-top']}
	{$fonts['h5_margin-bottom']}
}
h6 {
	{$fonts['h6_font-family']}
	{$fonts['h6_font-size']}
	{$fonts['h6_font-weight']}
	{$fonts['h6_font-style']}
	{$fonts['h6_line-height']}
	{$fonts['h6_text-decoration']}
	{$fonts['h6_text-transform']}
	{$fonts['h6_letter-spacing']}
	{$fonts['h6_margin-top']}
	{$fonts['h6_margin-bottom']}
}

input[type="text"],
input[type="number"],
input[type="email"],
input[type="tel"],
input[type="search"],
input[type="password"],
textarea,
textarea.wp-editor-area,
.select_container,
select,
.select_container select {
	{$fonts['input_font-family']}
	{$fonts['input_font-size']}
	{$fonts['input_font-weight']}
	{$fonts['input_font-style']}
	{$fonts['input_line-height']}
	{$fonts['input_text-decoration']}
	{$fonts['input_text-transform']}
	{$fonts['input_letter-spacing']}
}

button,
input[type="button"],
input[type="reset"],
input[type="submit"],
.theme_button,
.gallery_preview_show .post_readmore,
.more-link,
.alisha_williams_tabs .alisha_williams_tabs_titles li a {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}

.top_panel .slider_engine_revo .slide_title {
	{$fonts['h1_font-family']}
}

blockquote,
mark, ins,
.logo_text,
.post_price.price,
.theme_scroll_down {
	{$fonts['h5_font-family']}
}

.post_meta {
	{$fonts['info_font-family']}
	{$fonts['info_font-size']}
	{$fonts['info_font-weight']}
	{$fonts['info_font-style']}
	{$fonts['info_line-height']}
	{$fonts['info_text-decoration']}
	{$fonts['info_text-transform']}
	{$fonts['info_letter-spacing']}
	{$fonts['info_margin-top']}
	{$fonts['info_margin-bottom']}
}

em, i,
.post-date, .rss-date 
.post_date, .post_meta_item, .post_counters_item,
.comments_list_wrap .comment_date,
.comments_list_wrap .comment_time,
.comments_list_wrap .comment_counters,
.top_panel .slider_engine_revo .slide_subtitle,
.logo_slogan,
fieldset legend,
figure figcaption,
.wp-caption .wp-caption-text,
.wp-caption .wp-caption-dd,
.wp-caption-overlay .wp-caption .wp-caption-text,
.wp-caption-overlay .wp-caption .wp-caption-dd,
.format-audio .post_featured .post_audio_author,
.trx_addons_audio_player .audio_author,
.post_item_single .post_content .post_meta,
.author_bio .author_link,
.comments_list_wrap .comment_posted,
.comments_list_wrap .comment_reply {
	{$fonts['info_font-family']}
}
.wpgdprc, .comment-form .wpgdprc-checkbox label,
.widget_calendar .wp-calendar-nav a,
.wp-block-calendar .wp-calendar-nav a,
.search_wrap .search_results .post_meta_item,
.search_wrap .search_results .post_counters_item {
	{$fonts['p_font-family']}
}

.logo_text {
	{$fonts['logo_font-family']}
	{$fonts['logo_font-size']}
	{$fonts['logo_font-weight']}
	{$fonts['logo_font-style']}
	{$fonts['logo_line-height']}
	{$fonts['logo_text-decoration']}
	{$fonts['logo_text-transform']}
	{$fonts['logo_letter-spacing']}
}
.logo_footer_text {
	{$fonts['logo_font-family']}
}

.menu_main_nav_area {
	{$fonts['menu_font-size']}
	{$fonts['menu_line-height']}
}
.menu_main_nav > li,
.menu_main_nav > li > a {
	{$fonts['menu_font-family']}
	{$fonts['menu_font-weight']}
	{$fonts['menu_font-style']}
	{$fonts['menu_text-decoration']}
	{$fonts['menu_text-transform']}
	{$fonts['menu_letter-spacing']}
}
.menu_main_nav > li ul,
.menu_main_nav > li ul > li,
.menu_main_nav > li ul > li > a {
	{$fonts['submenu_font-family']}
	{$fonts['submenu_font-size']}
	{$fonts['submenu_font-weight']}
	{$fonts['submenu_font-style']}
	{$fonts['submenu_line-height']}
	{$fonts['submenu_text-decoration']}
	{$fonts['submenu_text-transform']}
	{$fonts['submenu_letter-spacing']}
}
.menu_mobile .menu_mobile_nav_area > ul > li,
.menu_mobile .menu_mobile_nav_area > ul > li > a {
	{$fonts['menu_font-family']}
}
.menu_mobile .menu_mobile_nav_area > ul > li li,
.menu_mobile .menu_mobile_nav_area > ul > li li > a {
	{$fonts['submenu_font-family']}
}


/* Custom Headers */
.sc_layouts_row,
.sc_layouts_row input[type="text"] {
	{$fonts['menu_font-family']}
	{$fonts['menu_font-size']}
	{$fonts['menu_font-weight']}
	{$fonts['menu_font-style']}
	{$fonts['menu_line-height']}
}
.sc_layouts_row .sc_button_wrap .sc_button {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
.sc_layouts_menu_nav > li,
.sc_layouts_menu_nav > li > a {
	{$fonts['menu_font-family']}
	{$fonts['menu_font-size']}
	{$fonts['menu_font-weight']}
	{$fonts['menu_font-style']}
	{$fonts['menu_text-decoration']}
	{$fonts['menu_text-transform']}
	{$fonts['menu_letter-spacing']}
}
.sc_layouts_menu_popup .sc_layouts_menu_nav > li,
.sc_layouts_menu_popup .sc_layouts_menu_nav > li > a,
.sc_layouts_menu_nav > li ul,
.sc_layouts_menu_nav > li ul > li,
.sc_layouts_menu_nav > li ul > li > a {
	{$fonts['submenu_font-family']}
	{$fonts['submenu_font-size']}
	{$fonts['submenu_font-weight']}
	{$fonts['submenu_font-style']}
	{$fonts['submenu_line-height']}
	{$fonts['submenu_text-decoration']}
	{$fonts['submenu_text-transform']}
	{$fonts['submenu_letter-spacing']}
}

#sb_instagram .sb_instagram_header h3 {
	{$fonts['extrafont_font-family']}
}

CSS;
			$rez = apply_filters('alisha_williams_filter_get_css', $rez, false, $fonts, '');
			$css['fonts'] = $rez['fonts'];

			
			// Border radius
			//--------------------------------------
			$rad = alisha_williams_get_border_radius();
			$rad50 = ' '.$rad != ' 0' ? '50%' : 0;
			$css['fonts'] .= <<<CSS

/* Buttons */
button,
input[type="button"],
input[type="reset"],
input[type="submit"],
.theme_button,
.post_item .more-link,
.gallery_preview_show .post_readmore,

/* Fields */
input[type="text"],
input[type="number"],
input[type="email"],
input[type="tel"],
input[type="password"],
input[type="search"],
select,
.select_container,
textarea,

/* Search fields */
.widget_search .search-field,
.widget_display_search #bbp_search,
#bbpress-forums #bbp-search-form #bbp_search,

/* Comment fields */
.comments_wrap .comments_field input,
.comments_wrap .comments_field textarea,

/* Select 2 */
.select2-container .select2-choice,
.select2-container .select2-selection,

/* Tags cloud */
.widget_product_tag_cloud a,
.widget_tag_cloud a {
}
.select_container:before {
}
textarea.wp-editor-area {
}

/* Radius 50% or 0 */
.widget li a img {
}

CSS;
		}


		// Theme colors
		//--------------------------------------
		if ($colors !== false) {
			$schemes = empty($only_scheme) ? array_keys(alisha_williams_get_list_schemes()) : array($only_scheme);
	
			if (count($schemes) > 0) {
				$rez = array();
				foreach ($schemes as $scheme) {
					// Prepare colors
					if (empty($only_scheme)) $colors = alisha_williams_get_scheme_colors($scheme);
	
					// Make theme-specific colors and tints
					$colors = alisha_williams_customizer_add_theme_colors($colors);
			
					// Make styles
					$rez['colors'] = <<<CSS

/* Common tags */
body {
	background-color: {$colors['bg_color']};
}
body.custom-background.disable_body_custom_background {
	background: {$colors['bg_color']}!important;
}
body.custom-background.disable_body_custom_background > #page > #content {
	background: {$colors['bg_color']};
}
.scheme_self {
	color: {$colors['text']};
}
h1, h2, h3, h4, h5, h6,
h1 a, h2 a, h3 a, h4 a, h5 a, h6 a,
li a {
	color: {$colors['text_dark']};
}
h1 a:hover, h2 a:hover, h3 a:hover, h4 a:hover, h5 a:hover, h6 a:hover,
li a:hover {
	color: {$colors['text_link']};
}

dt, mark, ins {	
	color: {$colors['text']};
}
s, strike, del {	
	color: {$colors['text_light']};
}

code {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bd_color']};
}
code a {
	color: {$colors['alter_link']};
}
code a:hover {
	color: {$colors['alter_hover']};
}

a {
	color: {$colors['text_link']};
}
a:hover {
	color: {$colors['text_hover']};
}

blockquote {
	color: {$colors['extra_dark']};
	background-color: {$colors['extra_bg_color']};
}
blockquote:after {
	border-color: {$colors['text_dark']};
}
blockquote:before {
	color: {$colors['extra_link']};
}
blockquote > a, blockquote > p > a,
blockquote > cite, blockquote > p > cite,
blockquote a {
	color: {$colors['text_link']};
}
blockquote a:hover {
	color: {$colors['extra_hover']};
}

table th a {
	color: {$colors['inverse_link']};
}
table th a:hover {
	color: {$colors['inverse_link_07']} !important;
}
table td, 
table th + td, 
table td + td, 
.wp-block-table .has-fixed-layout td, 
.wp-block-table .has-fixed-layout th {
	color: {$colors['alter_dark']};
	border-color: {$colors['bd_color']};
}
table th {
	color: {$colors['bg_color']};
	background-color: {$colors['text_hover']};
}
table th, table th + th, table td + th  {
}
table > tbody > tr:nth-child(2n+1) > td {
	background-color: {$colors['alter_bg_color']};
}
table > tbody > tr:nth-child(2n) > td {
	background-color: {$colors['alter_bg_color']};
}
table th a:hover {
	color: {$colors['bg_color']};
}

hr {
	border-color: {$colors['bd_color']};
}
figure figcaption,
.wp-caption .wp-caption-text,
.wp-caption .wp-caption-dd,
.wp-caption-overlay .wp-caption .wp-caption-text,
.wp-caption-overlay .wp-caption .wp-caption-dd {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link_08']};
}
ul > li:before {
	color: {$colors['text_link']};
}

figcaption a {
    color: {$colors['text_hover']};
}

figcaption a:hover {
    color: {$colors['text_link2']};
}
.gallery .gallery-item .gallery-caption::-webkit-scrollbar,
.blocks-gallery-grid .blocks-gallery-image figcaption::-webkit-scrollbar, 
.blocks-gallery-grid .blocks-gallery-item figcaption::-webkit-scrollbar, 
.wp-block-gallery .blocks-gallery-image figcaption::-webkit-scrollbar, 
.wp-block-gallery .blocks-gallery-item figcaption::-webkit-scrollbar {
    background-color: {$colors['alter_bd_color']};
}
.gallery .gallery-item .gallery-caption::-webkit-scrollbar-thumb,
.blocks-gallery-grid .blocks-gallery-image figcaption::-webkit-scrollbar-thumb, 
.blocks-gallery-grid .blocks-gallery-item figcaption::-webkit-scrollbar-thumb, 
.wp-block-gallery .blocks-gallery-image figcaption::-webkit-scrollbar-thumb, 
.wp-block-gallery .blocks-gallery-item figcaption::-webkit-scrollbar-thumb {
	background-color: {$colors['alter_bd_hover']};
}
.wp-block-button .wp-block-button__link {
    color: {$colors['inverse_link']};
    background-color: {$colors['text_link']};
}

.wp-block-button .wp-block-button__link:hover,
.wp-block-button .wp-block-button__link:focus {
    color: {$colors['inverse_link']};    
    background-color: {$colors['text_hover']};
}
.is-style-outline > .wp-block-button__link, 
.wp-block-button__link.is-style-outline {
	color: {$colors['text_link']};
	border-color: {$colors['text_link']};
	background-color: {$colors['bg_color_0']};
}
.is-style-outline > .wp-block-button__link:hover, 
.wp-block-button__link.is-style-outline:hover,
.is-style-outline > .wp-block-button__link:focus, 
.wp-block-button__link.is-style-outline:focus {
	color: {$colors['text_link']};
	border-color: {$colors['text_hover']};
	background-color: {$colors['bg_color_0']};
}
/* Form fields
-------------------------------------------------- */
.widget_search form:after,
.widget_display_search form:after,
#bbpress-forums #bbp-search-form:after {
	color: {$colors['input_light']};
}
.widget_search form:hover:after,
.widget_display_search form:hover:after,
#bbpress-forums #bbp-search-form:hover:after {
	color: {$colors['input_dark']};
}
.wp-block-search .wp-block-search__button {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.wp-block-search .wp-block-search__button:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_hover']};
}
/* Field set */
fieldset {
	border-color: {$colors['bd_color']};
}
fieldset legend {
	color: {$colors['text_dark']};
	background-color: {$colors['bg_color']};
}

/* Text fields */
::-webkit-input-placeholder { color: {$colors['text_light']}; }
::-moz-placeholder          { color: {$colors['text_light']}; }
:-ms-input-placeholder      { color: {$colors['text_light']}; }

input[type="text"],
input[type="number"],
input[type="email"],
input[type="tel"],
input[type="search"],
input[type="password"],
.select_container,
.select2-container .select2-choice,
.select2-container .select2-selection,
textarea,
textarea.wp-editor-area,
/* BB Press */
#buddypress .dir-search input[type="search"],
#buddypress .dir-search input[type="text"],
#buddypress .groups-members-search input[type="search"],
#buddypress .groups-members-search input[type="text"],
#buddypress .standard-form input[type="color"],
#buddypress .standard-form input[type="date"],
#buddypress .standard-form input[type="datetime-local"],
#buddypress .standard-form input[type="datetime"],
#buddypress .standard-form input[type="email"],
#buddypress .standard-form input[type="month"],
#buddypress .standard-form input[type="number"],
#buddypress .standard-form input[type="password"],
#buddypress .standard-form input[type="range"],
#buddypress .standard-form input[type="search"],
#buddypress .standard-form input[type="tel"],
#buddypress .standard-form input[type="text"],
#buddypress .standard-form input[type="time"],
#buddypress .standard-form input[type="url"],
#buddypress .standard-form input[type="week"],
#buddypress .standard-form select,
#buddypress .standard-form textarea,
#buddypress form#whats-new-form textarea,
/* Booked */
#booked-page-form input[type="email"],
#booked-page-form input[type="text"],
#booked-page-form input[type="password"],
#booked-page-form textarea,
.booked-upload-wrap,
.booked-upload-wrap input,
.wp-block-search .wp-block-search__input,
.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper {
	color: {$colors['input_text']};
	border-color: {$colors['input_bd_color']};
	background-color: {$colors['input_bg_color']};
}
input[type="text"]:focus,
input[type="number"]:focus,
input[type="email"]:focus,
input[type="tel"]:focus,
input[type="search"]:focus,
input[type="password"]:focus,
.select_container:hover,
select option:hover,
select option:focus,
.select2-container .select2-choice:hover,
textarea:focus,
textarea.wp-editor-area:focus,
/* BB Press */
#buddypress .dir-search input[type="search"]:focus,
#buddypress .dir-search input[type="text"]:focus,
#buddypress .groups-members-search input[type="search"]:focus,
#buddypress .groups-members-search input[type="text"]:focus,
#buddypress .standard-form input[type="color"]:focus,
#buddypress .standard-form input[type="date"]:focus,
#buddypress .standard-form input[type="datetime-local"]:focus,
#buddypress .standard-form input[type="datetime"]:focus,
#buddypress .standard-form input[type="email"]:focus,
#buddypress .standard-form input[type="month"]:focus,
#buddypress .standard-form input[type="number"]:focus,
#buddypress .standard-form input[type="password"]:focus,
#buddypress .standard-form input[type="range"]:focus,
#buddypress .standard-form input[type="search"]:focus,
#buddypress .standard-form input[type="tel"]:focus,
#buddypress .standard-form input[type="text"]:focus,
#buddypress .standard-form input[type="time"]:focus,
#buddypress .standard-form input[type="url"]:focus,
#buddypress .standard-form input[type="week"]:focus,
#buddypress .standard-form select:focus,
#buddypress .standard-form textarea:focus,
#buddypress form#whats-new-form textarea:focus,
/* Booked */
#booked-page-form input[type="email"]:focus,
#booked-page-form input[type="text"]:focus,
#booked-page-form input[type="password"]:focus,
#booked-page-form textarea:focus,
.booked-upload-wrap:hover,
.booked-upload-wrap input:focus {
	color: {$colors['input_dark']};
	border-color: {$colors['input_bd_hover']};
	background-color: {$colors['input_bg_hover']};
}

/* Select containers */
.select_container:before {
	color: {$colors['input_text']};
	background-color: {$colors['input_bg_color']};
}
.select_container:focus:before,
.select_container:hover:before {
	color: {$colors['input_dark']};
	background-color: {$colors['input_bg_hover']};
}
.select_container:after {
	color: {$colors['input_text']};
}
.select_container:focus:after,
.select_container:hover:after {
	color: {$colors['input_dark']};
}
.select_container select {
	color: {$colors['input_text']};
	background: {$colors['input_bg_color']} !important;
}
.select_container select:focus {
	color: {$colors['input_dark']};
	background-color: {$colors['input_bg_hover']} !important;
}

.select2-results {
	color: {$colors['input_text']};
	border-color: {$colors['input_bd_hover']};
	background: {$colors['input_bg_color']};
}
.select2-results .select2-highlighted {
	color: {$colors['input_dark']};
	background: {$colors['input_bg_hover']};
}

input[type="radio"] + span:before,
input[type="radio"] + label:before,
input[type="checkbox"] + span:before,
input[type="checkbox"] + label:before {
	border-color: {$colors['input_bd_color']};
	background-color: {$colors['input_bg_color']};
}


input[type="search"]::-webkit-input-placeholder {opacity: 1; color:{$colors['input_light']}; }
input[type="search"]::-moz-placeholder          {opacity: 1; color:{$colors['input_light']}; }
input[type="search"]:-moz-placeholder           {opacity: 1; color:{$colors['input_light']}; }
input[type="search"]:-ms-input-placeholder      {opacity: 1; color:{$colors['input_light']}; }


button[disabled],
input[type="submit"][disabled],
input[type="button"][disabled] {
    background-color: {$colors['text_light']} !important;
    color: {$colors['text']} !important;
}

/* Simple button */
.sc_button_simple:not(.sc_button_bg_image),
.sc_button_simple:not(.sc_button_bg_image):before,
.sc_button_simple:not(.sc_button_bg_image):after {
	color:{$colors['text_link']};
}
.sc_button_simple:not(.sc_button_bg_image):hover,
.sc_button_simple:not(.sc_button_bg_image):hover:before,
.sc_button_simple:not(.sc_button_bg_image):hover:after {
	color:{$colors['text_hover']} !important;
}


/* Bordered button */
.sc_button_bordered:not(.sc_button_bg_image) {
	color:{$colors['text_link']};
	border-color:{$colors['text_link']};
}
.sc_button_bordered:not(.sc_button_bg_image):hover {
	color:{$colors['text_hover']} !important;
	border-color:{$colors['text_hover']} !important;
}

/* Normal button */
button,
input[type="reset"],
input[type="submit"],
input[type="button"],
.more-link,
/* BB & Buddy Press */
#buddypress .comment-reply-link,
#buddypress .generic-button a,
#buddypress a.button,
#buddypress button,
#buddypress input[type="button"],
#buddypress input[type="reset"],
#buddypress input[type="submit"],
#buddypress ul.button-nav li a,
a.bp-title-button,
/* ThemeREX Addons */
.sc_button_default,
.sc_button:not(.sc_button_bg_image),
.sc_action_item_link,
.socials_share:not(.socials_type_drop) .social_icon,
/* Tribe Events */
#tribe-bar-form .tribe-bar-submit input[type="submit"],
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"],
#tribe-bar-views li.tribe-bar-views-option a,
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a,
#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a{
	color: {$colors['inverse_link']};
	background-color: transparent;
}
/* Booked */
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button,
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons .google-cal-button > a,
body #booked-profile-page input[type="submit"],
body #booked-profile-page button,
body .booked-list-view input[type="submit"],
body .booked-list-view button,
body table.booked-calendar input[type="submit"],
body table.booked-calendar button,
body div.booked-calendar .booked-appt-list .timeslot .timeslot-people button,
body .booked-modal input[type="submit"],
body .booked-modal button {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link2']};
}

input[type="submit"] {
	background-color: {$colors['text_link3']};
}
input[type="submit"]:hover {
	background-color: {$colors['text_hover3']};
}

.comments_wrap .form-submit input[type="submit"]{
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.comments_wrap .form-submit input[type="submit"]:hover{
	color: {$colors['inverse_link']};
	background-color: {$colors['text_hover']};
}



/* Normal button */
/* ThemeREX Addons */
.sc_button_default.button_color_1:before,
.sc_button.button_color_1:not(.sc_button_bg_image):before,
.sc_action_item_link:before{
	background-color: {$colors['text_link']};
}
.sc_button_default.button_color_2:before,
.sc_button.button_color_2:not(.sc_button_bg_image):before{
	background-color: {$colors['text_link2']};
}
.sc_button_default.button_color_3:before,
.sc_button.button_color_3:not(.sc_button_bg_image):before{
	background-color: {$colors['text_link3']};
}
.sc_button_default.button_color_4:before,
.sc_button.button_color_4:not(.sc_button_bg_image):before{
	background-color: {$colors['text_link4']};
}


.sc_button_default:after,
.sc_button:not(.sc_button_bg_image):after,
.sc_action_item_link:after{
	border-color: {$colors['text_dark']};
}

.sc_button_default.alter:before{
	background-color: {$colors['text_link4']};
}

.sc_button.sc_button_underline {
	color: {$colors['text_dark']};
	border-color: {$colors['text_link']} !important;
}
.sc_button.sc_button_underline:hover {
	color: {$colors['text_link']};
}
.sc_button.sc_button_underline.style_2 {
	color: {$colors['text_dark']};
	border-color: {$colors['text_link2']} !important;
}
.sc_button.sc_button_underline.style_2:hover {
	color: {$colors['text_link2']};
}
.sc_button.sc_button_underline.style_3 {
	color: {$colors['text_dark']};
	border-color: {$colors['text_link3']} !important;
}
.sc_button.sc_button_underline.style_3:hover {
	color: {$colors['text_link3']};
}
.sc_button.sc_button_underline.style_4 {
	color: {$colors['text_dark']};
	border-color: {$colors['text_link4']} !important;
}
.sc_button.sc_button_underline.style_4:hover {
	color: {$colors['text_link4']};
}

.sc_button.sc_button_style_2,
.sc_button_style_2.button_color_1{
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.sc_buttonsc_button_style_2:hover,
.sc_button_style_2.button_color_1:hover{
	background-color: {$colors['text_hover']};
}
.sc_button_style_2.button_color_2{
	color: {$colors['inverse_dark']};
	background-color: {$colors['text_link2']};
}
.sc_button_style_2.button_color_2:hover{
	background-color: {$colors['text_hover2']};
}
.sc_button_style_2.button_color_3{
	color: {$colors['inverse_dark']};
	background-color: {$colors['text_link3']};
}
.sc_button_style_2.button_color_3:hover{
	background-color: {$colors['text_hover3']};
}
.sc_button_style_2.button_color_4{
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link4']};
}
.sc_button_style_4.button_color_4:hover{
	background-color: {$colors['text_hover4']};
}


.sc_button.sc_button_style_2.alter{
	color: {$colors['inverse_hover']};
	background-color: {$colors['text_link3']};
}
.sc_button.sc_button_style_2.alter:hover{
	color: {$colors['inverse_hover']};
	background-color: {$colors['text_hover3']};
}

.sc_item_button.sc_button_wrap .sc_button.sc_button_default.button_color_1:hover,
.sc_promo_text .sc_promo_content .sc_button.sc_button_default.button_color_1:hover,
.sc_item_button.sc_button_wrap .sc_button.sc_button_default.button_color_4:hover,
.sc_content .sc_content_container .sc_button.sc_button_default.button_color_4:hover,
.wpb_wrapper .vc_row .sc_button.sc_button_default.button_color_4:hover{
    color: {$colors['bg_color']};
}





.theme_button {
	color: {$colors['inverse_link']} !important;
	background-color: {$colors['text_link']} !important;
}
.sc_price_link {
	color: {$colors['inverse_link']};
	background-color: {$colors['extra_link']};
}
button:hover,
button:focus,
input[type="submit"]:hover,
input[type="submit"]:focus,
input[type="reset"]:hover,
input[type="reset"]:focus,
input[type="button"]:hover,
input[type="button"]:focus,
.more-link:hover,
.comments_wrap .form-submit input[type="submit"]:hover,
.comments_wrap .form-submit input[type="submit"]:focus,
/* BB & Buddy Press */
#buddypress .comment-reply-link:hover,
#buddypress .generic-button a:hover,
#buddypress a.button:hover,
#buddypress button:hover,
#buddypress input[type="button"]:hover,
#buddypress input[type="reset"]:hover,
#buddypress input[type="submit"]:hover,
#buddypress ul.button-nav li a:hover,
a.bp-title-button:hover,
/* Booked */
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button:hover,
body #booked-profile-page .booked-profile-appt-list .appt-block .booked-cal-buttons .google-cal-button > a:hover,
body #booked-profile-page input[type="submit"]:hover,
body #booked-profile-page button:hover,
body .booked-list-view input[type="submit"]:hover,
body .booked-list-view button:hover,
body table.booked-calendar input[type="submit"]:hover,
body table.booked-calendar button:hover,
body .booked-modal input[type="submit"]:hover,
body .booked-modal button:hover,
/* ThemeREX Addons */
.sc_button_default:hover,
.sc_button:not(.sc_button_simple):not(.sc_button_bordered):not(.sc_button_bg_image):hover,
.sc_action_item_link:hover,
.socials_share:not(.socials_type_drop) .social_icon:hover,
/* Tribe Events */
#tribe-bar-form .tribe-bar-submit input[type="submit"]:hover,
#tribe-bar-form .tribe-bar-submit input[type="submit"]:focus,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:hover,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:focus,
#tribe-bar-views li.tribe-bar-views-option a:hover,
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a:hover,
#tribe-events .tribe-events-button:hover,
.tribe-events-button:hover,
.tribe-events-cal-links a:hover,
.tribe-events-sub-nav li a:hover{
	color: {$colors['inverse_hover']};
	background-color: {$colors['text_hover']};
}
.theme_button:hover,
.theme_button:focus {
	color: {$colors['inverse_hover']} !important;
	background-color: {$colors['text_link_blend']} !important;
}
.sc_price:hover .sc_price_link,
.sc_price_link:hover {
	color: {$colors['inverse_hover']};
	background-color: {$colors['extra_hover']};
}


/* Buttons in sidebars */

/* MailChimp */
.mc4wp-form input[type="submit"]{
	color: {$colors['inverse_link']};
	background-color: {$colors['alter_link']};
}
/* MailChimp */
.mc4wp-form input[type="submit"]:hover,
.mc4wp-form input[type="submit"]:focus{
	color: {$colors['inverse_hover']};
	background-color: {$colors['alter_hover']};
}

/* Buttons in WP Editor */
.wp-editor-container input[type="button"] {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bd_color']};
	color: {$colors['alter_dark']};
	-webkit-box-shadow: 0 1px 0 0 {$colors['alter_bd_hover']};
	    -ms-box-shadow: 0 1px 0 0 {$colors['alter_bd_hover']};
			box-shadow: 0 1px 0 0 {$colors['alter_bd_hover']};	
}
.wp-editor-container input[type="button"]:hover,
.wp-editor-container input[type="button"]:focus {
	background-color: {$colors['alter_bg_hover']};
	border-color: {$colors['alter_bd_hover']};
	color: {$colors['alter_link']};
}



/* WP Standard classes */
.sticky {
	border-color: {$colors['bd_color']};
}
.sticky .label_sticky {
	border-top-color: {$colors['text_link']};
}
	

/* Page */
#page_preloader,
.scheme_self.header_position_under .page_content_wrap,
.page_wrap {
	background-color: {$colors['bg_color']};
}
.preloader_wrap > div {
	background-color: {$colors['text_link']};
}

/* Header */
.scheme_self.top_panel.with_bg_image:before {
	background-color: {$colors['bg_color_07']};
}
.scheme_self.top_panel .slider_engine_revo .slide_subtitle,
.top_panel .slider_engine_revo .slide_subtitle {
	color: {$colors['text_link']};
}
.top_panel_default .top_panel_navi,
.scheme_self.top_panel_default .top_panel_navi {
	background-color: {$colors['bg_color']};
}
.top_panel_default .top_panel_title,
.scheme_self.top_panel_default .top_panel_title {
	background-color: {$colors['alter_bg_color']};
}


/* Tabs */
.alisha_williams_tabs .alisha_williams_tabs_titles li a {
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_bg_color']};
}
.alisha_williams_tabs .alisha_williams_tabs_titles li a:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.alisha_williams_tabs .alisha_williams_tabs_titles li.ui-state-active a {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}

/* Post layouts */
.post_item {
	color: {$colors['text']};
}
.post_meta,
.post_meta_item,
.post_meta_item a,
.post_meta_item:before,
.post_meta_item:after,
.post_meta_item:hover:before,
.post_meta_item:hover:after,
.post_date a,
.post_date:before,
.post_date:after,
.post_info .post_info_item,
.post_info .post_info_item a,
.post_info_counters .post_counters_item,
.post_counters .socials_share .socials_caption:before,
.post_counters .socials_share .socials_caption:hover:before {
	color: {$colors['text_light']};
}
.post_date a:hover,
a.post_meta_item:hover,
a.post_meta_item:hover:before,
.post_meta_item a:hover,
.post_meta_item a:hover:before,
.post_info .post_info_item a:hover,
.post_info .post_info_item a:hover:before,
.post_info_counters .post_counters_item:hover,
.post_info_counters .post_counters_item:hover:before {
	color: {$colors['text_link']};
}
.post_item .post_title a:hover,
 .post_item .post_title a:hover *{
	color: {$colors['text_link']};
}


.scheme_self.sidebar .post_date a,
.scheme_self.sidebar a.post_meta_item,
.scheme_self.sidebar a.post_meta_item:before,
.scheme_self.sidebar .post_meta_item a,
.scheme_self.sidebar .post_meta_item a:before,
.scheme_self.sidebar .post_info .post_info_item a,
.scheme_self.sidebar .post_info .post_info_item a:before,
.scheme_self.sidebar .post_info_counters .post_counters_item,
.scheme_self.sidebar .post_info_counters .post_counters_item:before {
	color: {$colors['alter_light']};
}
.self_scheme.sidebar .post_item .post_title a {
	color: {$colors['alter_dark']};
}
.scheme_self.sidebar .post_date a:hover,
.scheme_self.sidebar a.post_meta_item:hover,
.scheme_self.sidebar a.post_meta_item:hover:before,
.scheme_self.sidebar .post_meta_item a:hover,
.scheme_self.sidebar .post_meta_item a:hover:before,
.scheme_self.sidebar .post_info .post_info_item a:hover,
.scheme_self.sidebar .post_info .post_info_item a:hover:before,
.scheme_self.sidebar .post_info_counters .post_counters_item:hover,
.scheme_self.sidebar .post_info_counters .post_counters_item:hover:before {
	color: {$colors['alter_hover']};
}
.self_scheme.sidebar .post_item .post_title a:hover {
	color: {$colors['alter_hover']};
}
.scheme_self.sidebar input[type="search"]{
	border-color: {$colors['extra_bd_hover']};
	background-color: {$colors['extra_bd_hover']};
}


.post_meta_item.post_categories,
.post_meta_item.post_categories a {
	color: {$colors['text_link']};
}
.post_meta_item.post_categories a:hover {
	color: {$colors['text_hover']};
}

.post_meta_item .socials_share .social_items {
	background-color: {$colors['bg_color']};
}
.post_meta_item .social_items,
.post_meta_item .social_items:before {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bd_color']};
	color: {$colors['text_light']};
}

.post_layout_excerpt:not(.sticky) + .post_layout_excerpt:not(.sticky) {
	border-color: {$colors['bd_color']};
}
.post_layout_classic {
	border-color: {$colors['bd_color']};
	background-color: {$colors['alter_bd_color']};
}

.scheme_self.gallery_preview:before {
	background-color: {$colors['bg_color']};
}
.scheme_self.gallery_preview {
	color: {$colors['text']};
}


/* Post Formats */

/* Audio */
.trx_addons_audio_player .audio_author {
	color: {$colors['text']};
}
.format-audio .post_featured.without_thumb .post_audio_author {
	color: {$colors['inverse_link_05']};
}
.format-audio .post_featured.without_thumb .post_audio {
	border-color: {$colors['text_link4']};
	background-color: {$colors['text_link4']};
}
.format-audio .post_featured.with_thumb .post_audio_title{
	color: {$colors['text_dark']};
}
.format-audio .post_featured.without_thumb .post_audio_title{
	color: {$colors['inverse_link']};
}
.post_item .post_featured .post_audio .audio_frame .mejs-container .mejs-controls .mejs-time, 
.trx_addons_audio_player .mejs-container .mejs-controls .mejs-time,
.without_thumb .mejs-controls .mejs-currenttime,
.without_thumb .mejs-controls .mejs-duration {
	color: {$colors['inverse_link']};
}

.trx_addons_audio_player.without_cover {
	border-color: {$colors['text_link4']};
	background-color: {$colors['text_link4']};
}
.trx_addons_audio_player.with_cover .audio_caption {
	color: {$colors['text_dark']};
}
.trx_addons_audio_player.without_cover .audio_author {
	color: {$colors['text']};
}
.trx_addons_audio_player .mejs-container .mejs-controls .mejs-time {
	color: {$colors['inverse_link']};
}
.trx_addons_audio_player.with_cover .mejs-container .mejs-controls .mejs-time {
	color: {$colors['inverse_link']};
}
.post_item .post_featured .post_audio  .audio_frame,
.trx_addons_audio_player .audio_frame {
	background-color: {$colors['text_link4']};
}

.trx_addons_audio_player.without_cover .audio_caption {
	color: {$colors['inverse_link']};
}
.trx_addons_audio_player.without_cover .audio_author {
	color: {$colors['inverse_link_05']};
}



.mejs-container .mejs-controls,
.mejs-embed,
.mejs-embed body {
	background: {$colors['text_dark_07']};
}

.mejs-controls .mejs-button,
.mejs-controls .mejs-time-rail .mejs-time-current,
.mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current {
	color: {$colors['inverse_link']};
}
.mejs-controls .mejs-button:hover {
	color: {$colors['text_link']};
}
.mejs-controls .mejs-time-rail .mejs-time-total,
.mejs-controls .mejs-time-rail .mejs-time-loaded,
.mejs-container .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-total {
	background: {$colors['bg_color_03']};
}

.mejs-controls .mejs-time-rail .mejs-time-current {
	background: {$colors['bg_color']} !important;
}

/* Aside */
.format-aside .post_content_inner {
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_bg_color']};
}

/* Link and Status */
.format-link .post_content_inner,
.format-status .post_content_inner {
	color: {$colors['text_dark']};
}

/* Chat */
.format-chat p > b,
.format-chat p > strong {
	color: {$colors['text_dark']};
}

/* Video */
.trx_addons_video_player.with_cover .video_mask {
	background-color: {$colors['inverse_dark_05']};
}

.trx_addons_video_player.with_cover .video_hover,
.format-video .post_featured.with_thumb .post_video_hover {
	color: {$colors['text_link']};
}
.trx_addons_video_player.with_cover .video_hover,
.format-video .post_featured.with_thumb .post_video_hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['inverse_link_07']};
}

.sidebar_inner .trx_addons_video_player.with_cover .video_hover {
	color: {$colors['alter_link']};
}
.sidebar_inner .trx_addons_video_player.with_cover .video_hover:hover {
	color: {$colors['inverse_hover']};
	background-color: {$colors['alter_link']};
}

.trx_addons_video_player.with_cover .video_hover:before,
.format-video .post_featured.with_thumb .post_video_hover:before {
	color: {$colors['text_link']};
}
.trx_addons_video_player.with_cover .video_hover:after,
.format-video .post_featured.with_thumb .post_video_hover:after {
	color: {$colors['inverse_dark']};
}

/* Chess */
.post_layout_chess .post_content_inner:after {
	background: linear-gradient(to top, {$colors['bg_color']} 0%, {$colors['bg_color_0']} 100%) no-repeat scroll right top / 100% 100% {$colors['bg_color_0']};
}
.post_layout_chess_1 .post_meta:before {
	background-color: {$colors['bd_color']};
}

/* Pagination */
.nav-links-old {
	color: {$colors['text_dark']};
}
.nav-links-old a:hover {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}

.page_links > a,
.comments_pagination .page-numbers,
.nav-links .page-numbers {
	color: {$colors['text']};
	border-color: transparent;
}

.page_links > a:hover,
.page_links > span:not(.page_links_title),
.comments_pagination a.page-numbers:hover,
.nav-links a.page-numbers:hover {
	color: {$colors['text_link']};
	border-color: {$colors['text_link4']};
}

.page_links > a.prev:hover,
.page_links > span.prev:not(.page_links_title),
.comments_pagination a.prev:hover,
.nav-links a.prev:hover,
.page_links > a.next:hover,
.page_links > span.next:not(.page_links_title),
.comments_pagination a.next:hover,
.nav-links a.next:hover {
	border-color: transparent;
}

.post_item_single .page_links .current,
.comments_pagination .page-numbers.current,
.nav-links .page-numbers.current {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link4']};
	border-color: {$colors['text_link4']};
}

/* Single post */
.post_item_single .post_header .post_date {
	color: {$colors['text_light']};
}
.post_item_single .post_header .post_categories,
.post_item_single .post_header .post_categories a {
	color: {$colors['text_link']};
}
.post_item_single .post_header .post_meta_item,
.post_item_single .post_header .post_meta_item:before,
.post_item_single .post_header .post_meta_item:hover:before,
.post_item_single .post_header .post_meta_item a,
.post_item_single .post_header .post_meta_item a:before,
.post_item_single .post_header .post_meta_item a:hover:before,
.post_item_single .post_header .post_meta_item .socials_caption,
.post_item_single .post_header .post_meta_item .socials_caption:before,
.post_item_single .post_header .post_edit a {
	color: {$colors['text_light']};
}
.post_item_single .post_meta_item:hover,
.post_item_single .post_meta_item > a:hover,
.post_item_single .post_meta_item .socials_caption:hover,
.post_item_single .post_edit a:hover {
	color: {$colors['text_hover']};
}
.post_item_single .post_header .post_meta_item.post_categories a{
	color: {$colors['text_link']};
}
.post_item_single .post_header .post_meta_item.post_categories a:hover{
	color: {$colors['text_hover']};
}

.post_item_single .post_content .post_meta_label,
.post_item_single .post_content .post_meta_item:hover .post_meta_label {
	color: {$colors['text_dark']};
}
.post_item_single .post_content .post_tags,
.post_item_single .post_content .post_tags a {
	color: {$colors['text_link']};
}
.post_item_single .post_content .post_tags a:hover {
	color: {$colors['text_hover']};
}

.post_item_single .post_content .post_meta .post_share .social_item .social_icon {
	color: {$colors['inverse_link']} !important;
}
.post_item_single .post_content .post_meta .post_share .social_item:hover .social_icon {
	color: {$colors['inverse_link']} !important;
}

.post-password-form input[type="submit"] {
	border-color: {$colors['text_dark']};
}
.post-password-form input[type="submit"]:hover,
.post-password-form input[type="submit"]:focus {
	color: {$colors['bg_color']};
}

/* Single post navi */
.nav-links-single .nav-links {
	border-color: {$colors['bd_color']};
}
.nav-links-single .nav-links a .meta-nav {
	color: {$colors['text_light']};
}
.nav-links-single .nav-links a .post_date {
	color: {$colors['text_light']};
}
.nav-links-single .nav-links a:hover .meta-nav,
.nav-links-single .nav-links a:hover .post_date {
	color: {$colors['text_dark']};
}
.nav-links-single .nav-links a:hover .post-title {
	color: {$colors['text_link']};
}

/* Author info */
.author_container {
	border-color: {$colors['bd_color']};
}
.scheme_self.author_info {
	color: {$colors['text']};
	background-color: {$colors['alter_bg_color']};
}
.scheme_self.author_info .author_subtitle {
	color: {$colors['text_link']};
}
.scheme_self.author_info .author_title {
	color: {$colors['text_dark']};
}
.scheme_self.author_info a {
	color: {$colors['text_dark']};
}
.scheme_self.author_info a:hover {
	color: {$colors['text_link']};
}
.scheme_self.author_info .socials_wrap .social_item .social_icon {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.scheme_self.author_info .socials_wrap .social_item:hover .social_icon {
	color: {$colors['inverse_hover']};
	background-color: {$colors['text_hover']};
}

/* Related posts */
.related_wrap {
	border-color: {$colors['bd_color']};
}
.related_wrap .related_item_style_1 .post_header {
	background-color: {$colors['bg_color_07']};
}
.related_wrap .related_item_style_1:hover .post_header {
	background-color: {$colors['bg_color']};
}
.related_wrap .related_item_style_1 .post_date a {
	color: {$colors['text']};
}
.related_wrap .related_item_style_1:hover .post_date a {
	color: {$colors['text_light']};
}
.related_wrap .related_item_style_1:hover .post_date a:hover {
	color: {$colors['text_dark']};
}

/* Comments */
.comments_list_wrap,
.comments_list_wrap > ul {
	border-color: {$colors['bd_color']};
}
.comments_list_wrap li + li,
.comments_list_wrap li ul {
	border-color: {$colors['bd_color']};
}
.comments_list_wrap .comment_body {
	background-color: {$colors['alter_bg_color']};
}
.comments_list_wrap .comment_info {
	color: {$colors['text_dark']};
}
.comments_list_wrap .comment_counters a {
	color: {$colors['text_link']};
}
.comments_list_wrap .comment_counters a:before {
	color: {$colors['text_link']};
}
.comments_list_wrap .comment_counters a:hover:before,
.comments_list_wrap .comment_counters a:hover {
	color: {$colors['text_hover']};
}
.comments_list_wrap .comment_text {
	color: {$colors['text']};
}
.comments_list_wrap .comment_reply a {
	color: {$colors['text_link']};
}
.comments_list_wrap .comment_reply a:hover {
	color: {$colors['text_hover']};
}
.comments_form_wrap {
	border-color: {$colors['bd_color']};
}
.comments_wrap .comments_notes {
	color: {$colors['text_light']};
}

.comments_list_wrap .comment_posted {
	color: {$colors['text_light']};
}

.comments_wrap .comments_field .sc_form_field_wrap:after {
	border-color: transparent;
}
.comments_wrap .comments_field .sc_form_field_wrap.field_focus:after {
	border-color: {$colors['text_dark']};
}
.comment-form .comments_field.label_accent .sc_form_field_title{
	color: {$colors['text_link']};
}




/* Page 404 */
.post_item_404 .page_title {
	color: {$colors['text_light']};
}
.post_item_404 .page_description {
	color: {$colors['text_link']};
}
.post_item_404 .go_home {
	border-color: {$colors['text_dark']};
}

.post_item_none_search .search_wrap .search_submit, 
.post_item_none_archive .search_wrap .search_submit {
	color: {$colors['text_dark']};
}

/* Sidebar */
.scheme_self.sidebar .sidebar_inner {
	background-color: {$colors['alter_bg_color']};
	color: {$colors['alter_text']};
}
.sidebar_inner .widget + .widget {
	border-color: {$colors['bd_color']};
}
.scheme_self.sidebar .widget + .widget {
	border-color: {$colors['bd_color']};
}
.scheme_self.sidebar h1, .scheme_self.sidebar h2, .scheme_self.sidebar h3, .scheme_self.sidebar h4, .scheme_self.sidebar h5, .scheme_self.sidebar h6,
.scheme_self.sidebar h1 a, .scheme_self.sidebar h2 a, .scheme_self.sidebar h3 a, .scheme_self.sidebar h4 a, .scheme_self.sidebar h5 a, .scheme_self.sidebar h6 a {
	color: {$colors['alter_dark']};
}
.scheme_self.sidebar h1 a:hover, .scheme_self.sidebar h2 a:hover, .scheme_self.sidebar h3 a:hover, .scheme_self.sidebar h4 a:hover, .scheme_self.sidebar h5 a:hover, .scheme_self.sidebar h6 a:hover {
	color: {$colors['alter_link']};
}


/* Widgets */
.widget ul > li:before {
	background-color: {$colors['alter_link']};
}
.widget ul > li:after {
	border-color: {$colors['alter_dark']};
}
.scheme_self.sidebar ul > li:before {
	background-color: {$colors['alter_link']};
}
.scheme_self.sidebar a {
	color: {$colors['alter_link']};
}
.scheme_self.sidebar a:hover {
	color: {$colors['alter_hover']};
}
.scheme_self.sidebar li > a,
.scheme_self.sidebar .post_title > a {
	color: {$colors['alter_dark']};
}
.scheme_self.sidebar li > a:hover,
.scheme_self.sidebar .post_title > a:hover {
	color: {$colors['alter_link']};
}

/* Archive */
.scheme_self.sidebar .widget_archive li {
	color: {$colors['alter_dark']};
}

/* Calendar */
.wp-block-calendar caption,
.widget_calendar caption,
.wp-block-calendar tbody td a,
.widget_calendar tbody td a,
.wp-block-calendar th,
.widget_calendar th {
	color: {$colors['text_dark']};
}
.scheme_self.sidebar .wp-block-calendar caption,
.scheme_self.sidebar .widget_calendar caption {
	color: {$colors['alter_dark']};
}
.scheme_self.sidebar .wp-block-calendar tbody td a,
.scheme_self.sidebar .widget_calendar tbody td a,
.scheme_self.sidebar .wp-block-calendar th,
.scheme_self.sidebar .widget_calendar th {
	color: {$colors['alter_link']};
}
.wp-block-calendar tbody td,
.widget_calendar tbody td {
	color: {$colors['alter_dark']};
}
.scheme_self.sidebar .wp-block-calendar tbody td,
.scheme_self.sidebar .widget_calendar tbody td {
	color: {$colors['alter_dark']};
}
.wp-block-calendar tbody td a,
.widget_calendar tbody td a {
	color: {$colors['text_link']};
}
.wp-block-calendar tbody td a:hover,
.widget_calendar tbody td a:hover {
	color: {$colors['text_hover']};
}

.wp-block-calendar tbody td a:after,
.widget_calendar tbody td a:after {
	background-color: {$colors['text_link']};
}
.scheme_self.sidebar .wp-block-calendar tbody td a:after,
.scheme_self.sidebar .widget_calendar tbody td a:after {
	background-color: {$colors['alter_link']};
}
.wp-block-calendar td#today,
.widget_calendar td#today {
	color: {$colors['inverse_link']} !important;
}
.wp-block-calendar td#today a,
.widget_calendar td#today a {
	color: {$colors['inverse_link']};
}
.wp-block-calendar td#today a:hover,
.widget_calendar td#today a:hover {
	color: {$colors['text_link']};
}
.wp-block-calendar td#today:before,
.widget_calendar td#today:before {
	background-color: {$colors['text_hover']};
}
.scheme_self.sidebar .wp-block-calendar td#today:before,
.scheme_self.sidebar .widget_calendar td#today:before {
	background-color: {$colors['alter_hover']};
}
.wp-block-calendar td#today a:after,
.widget_calendar td#today a:after {
	background-color: {$colors['inverse_link']};
}
.wp-block-calendar td#today a:hover:after,
.widget_calendar td#today a:hover:after {
	background-color: {$colors['inverse_hover']};
}
.wp-block-calendar #prev a,
.widget_calendar #prev a,
.wp-block-calendar #next a,
.widget_calendar #next a {
	color: {$colors['text_link']};
}
.scheme_self.sidebar .wp-block-calendar #prev a,
.scheme_self.sidebar .widget_calendar #prev a,
.scheme_self.sidebar .wp-block-calendar #next a,
.scheme_self.sidebar .widget_calendar #next a {
	color: {$colors['alter_link']};
}
.wp-block-calendar #prev a:hover,
.widget_calendar #prev a:hover,
.wp-block-calendar #next a:hover,
.widget_calendar #next a:hover {
	color: {$colors['text_hover']};
}
.scheme_self.sidebar .wp-block-calendar #prev a:hover,
.scheme_self.sidebar .widget_calendar #prev a:hover,
.scheme_self.sidebar .wp-block-calendar #next a:hover,
.scheme_self.sidebar .widget_calendar #next a:hover {
	color: {$colors['alter_hover']};
}
.wp-block-calendar td#prev a:before,
.widget_calendar td#prev a:before,
.wp-block-calendar td#next a:before,
.widget_calendar td#next a:before {
	background-color: {$colors['bg_color']};
}
.scheme_self.sidebar .wp-block-calendar td#prev a:before,
.scheme_self.sidebar .widget_calendar td#prev a:before,
.scheme_self.sidebar .wp-block-calendar td#next a:before,
.scheme_self.sidebar .widget_calendar td#next a:before {
	background-color: {$colors['alter_bg_color']};
}

/* Categories */
.widget_categories li {
	color: {$colors['text_dark']};
}
.scheme_self.sidebar .widget_categories li {
	color: {$colors['alter_dark']};
}

/* Tag cloud */
.widget_product_tag_cloud a,
.widget_tag_cloud a {
	color: {$colors['text_link']};
}
.scheme_self.sidebar .widget_product_tag_cloud a,
.scheme_self.sidebar .widget_tag_cloud a {
	color: {$colors['alter_link']};
}
.widget_product_tag_cloud a:hover,
.widget_tag_cloud a:hover {
	color: {$colors['text_hover']} !important;
}
.scheme_self.sidebar .widget_product_tag_cloud a:hover,
.scheme_self.sidebar .widget_tag_cloud a:hover {
	color: {$colors['alter_hover']} !important;
}
.widget_product_tag_cloud a:after, 
.widget_tag_cloud a:after {
	color: {$colors['alter_light']} !important;
}

/* RSS */
.widget_rss .widget_title a:first-child {
	color: {$colors['text_link']};
}
.scheme_self.sidebar .widget_rss .widget_title a:first-child {
	color: {$colors['alter_link']};
}
.widget_rss .widget_title a:first-child:hover {
	color: {$colors['text_hover']};
}
.scheme_self.sidebar .widget_rss .widget_title a:first-child:hover {
	color: {$colors['alter_hover']};
}
.widget_rss .rss-date {
	color: {$colors['text_light']};
}
.scheme_self.sidebar .widget_rss .rss-date {
	color: {$colors['alter_light']};
}

/* Footer */
.scheme_self.footer_wrap,
.footer_wrap .scheme_self.vc_row {
	background-color: {$colors['alter_bg_color']};
	color: {$colors['alter_text']};
}
.scheme_self.footer_wrap .widget,
.scheme_self.footer_wrap .sc_content .wpb_column,
.footer_wrap .scheme_self.vc_row .widget,
.footer_wrap .scheme_self.vc_row .sc_content .wpb_column {
	border-color: {$colors['alter_bd_color']};
}
.scheme_self.footer_wrap h1, .scheme_self.footer_wrap h2, .scheme_self.footer_wrap h3,
.scheme_self.footer_wrap h4, .scheme_self.footer_wrap h5, .scheme_self.footer_wrap h6,
.scheme_self.footer_wrap h1 a, .scheme_self.footer_wrap h2 a, .scheme_self.footer_wrap h3 a,
.scheme_self.footer_wrap h4 a, .scheme_self.footer_wrap h5 a, .scheme_self.footer_wrap h6 a,
.footer_wrap .scheme_self.vc_row h1, .footer_wrap .scheme_self.vc_row h2, .footer_wrap .scheme_self.vc_row h3,
.footer_wrap .scheme_self.vc_row h4, .footer_wrap .scheme_self.vc_row h5, .footer_wrap .scheme_self.vc_row h6,
.footer_wrap .scheme_self.vc_row h1 a, .footer_wrap .scheme_self.vc_row h2 a, .footer_wrap .scheme_self.vc_row h3 a,
.footer_wrap .scheme_self.vc_row h4 a, .footer_wrap .scheme_self.vc_row h5 a, .footer_wrap .scheme_self.vc_row h6 a {
	color: {$colors['alter_dark']};
}
.scheme_self.footer_wrap h1 a:hover, .scheme_self.footer_wrap h2 a:hover, .scheme_self.footer_wrap h3 a:hover,
.scheme_self.footer_wrap h4 a:hover, .scheme_self.footer_wrap h5 a:hover, .scheme_self.footer_wrap h6 a:hover,
.footer_wrap .scheme_self.vc_row h1 a:hover, .footer_wrap .scheme_self.vc_row h2 a:hover, .footer_wrap .scheme_self.vc_row h3 a:hover,
.footer_wrap .scheme_self.vc_row h4 a:hover, .footer_wrap .scheme_self.vc_row h5 a:hover, .footer_wrap .scheme_self.vc_row h6 a:hover {
	color: {$colors['alter_link']};
}
.scheme_self.footer_wrap .widget li:before,
.footer_wrap .scheme_self.vc_row .widget li:before {
	background-color: {$colors['alter_link']};
}
.scheme_self.footer_wrap a,
.footer_wrap .scheme_self.vc_row a {
	color: {$colors['alter_dark']};
}
.scheme_self.footer_wrap a:hover,
.footer_wrap .scheme_self.vc_row a:hover {
	color: {$colors['inverse_link']};
}

.footer_logo_inner {
	border-color: {$colors['alter_bd_color']};
}
.footer_logo_inner:after {
	background-color: {$colors['alter_text']};
}
.footer_socials_inner .social_item .social_icon {
	color: {$colors['alter_text']};
}
.footer_socials_inner .social_item:hover .social_icon {
	color: {$colors['alter_dark']};
}
.menu_footer_nav_area ul li a {
	color: {$colors['alter_dark']};
}
.menu_footer_nav_area ul li a:hover {
	color: {$colors['alter_link']};
}
.menu_footer_nav_area ul li+li:before {
	border-color: {$colors['alter_light']};
}

.footer_copyright_inner {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bd_color']};
	color: {$colors['text_dark']};
}
.footer_copyright_inner a {
	color: {$colors['text_dark']};
}
.footer_copyright_inner a:hover {
	color: {$colors['text_link']};
}
.footer_copyright_inner .copyright_text {
	color: {$colors['text']};
}


/* Third-party plugins */

.mfp-bg {
	background-color: {$colors['bg_color_07']};
}
.mfp-image-holder .mfp-close,
.mfp-iframe-holder .mfp-close,
.mfp-close-btn-in .mfp-close {
	color: {$colors['text_dark']};
	background-color: transparent;
}
.mfp-image-holder .mfp-close:hover,
.mfp-iframe-holder .mfp-close:hover,
.mfp-close-btn-in .mfp-close:hover {
	color: {$colors['text_link']};
}

/* Essential Grid */
.theme_skin .esg-filterbutton,
.theme_skin .esg-navigationbutton,
.theme_skin .esg-sortbutton,
.theme_skin .esg-cartbutton {
	color: {$colors['text']};
	border-color: transparent;
}
.theme_skin .esg-filterbutton:hover,
.theme_skin .esg-navigationbutton:hover,
.theme_skin .esg-sortbutton:hover,
.theme_skin .esg-cartbutton:hover {
	color: {$colors['text_link']};
	border-color: {$colors['text_link4']};
}
.theme_skin .esg-filterbutton.selected,
.theme_skin .esg-navigationbutton.selected,
.theme_skin .esg-sortbutton.selected,
.theme_skin .esg-cartbutton.selected {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link4']};
	border-color: {$colors['text_link4']};
}

/* instagram */

#sb_instagram .sb_instagram_header h3.sbi_no_bio {
	color: {$colors['text_link2']};
}

#sb_instagram .sb_instagram_header a:hover h3.sbi_no_bio {
	color: {$colors['text_link']};
}
.widget_instagram_images_item:before,
#sb_instagram .sbi_item a:before {
	background-color: {$colors['text_link_08']};
}
#sb_instagram .sbi_item a:after {
	color: {$colors['inverse_link']};
}



.post_item.post_layout_classic.post_layout_classic_2 .sc_button.sc_button_underline:hover,
.post_item.post_layout_classic.post_layout_classic_3 .sc_button.sc_button_underline:hover {
    background-color: transparent;
    color: {$colors['text_link']};
}


.widget_calendar .wp-calendar-nav a:before,
.wp-block-calendar .wp-calendar-nav a:before {
	background: {$colors['bg_color']};
}

.scheme_self.sidebar .sidebar_inner .widget_calendar .wp-calendar-nav a:before,
.scheme_self.sidebar .wp-block-calendar .wp-calendar-nav a:before {
	background-color: {$colors['alter_bg_color']};
}

.comment-form .wpgdprc-checkbox label,
.wpgdprc {
	color: {$colors['text']};
}

CSS;
				
					$rez = apply_filters('alisha_williams_filter_get_css', $rez, $colors, false, $scheme);
					$css['colors'] .= $rez['colors'];
				}
			}
		}
				
		$css_str = (!empty($css['fonts']) ? $css['fonts'] : '')
				. (!empty($css['colors']) ? $css['colors'] : '');
		return apply_filters( 'alisha_williams_filter_prepare_css', $css_str, $remove_spaces );
	}
}
?>