<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0.22
 */

// Theme init priorities:
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
if ( !function_exists('alisha_williams_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'alisha_williams_customizer_theme_setup1', 1 );
	function alisha_williams_customizer_theme_setup1() {
		
		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		
		alisha_williams_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Rubik',
				'family' => 'sans-serif',
				'styles' => '300,300i,400,400i,500,500i,700,700i,900,900i'		// Parameter 'style' used only for the Google fonts
				),
			// Font-face packed with theme
			array(
				'name'   => 'Playlist',
				'family' => ''
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		alisha_williams_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		alisha_williams_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'alisha-williams'),
				'description'		=> esc_html__('Font settings of the main text of the site', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '1rem',
				'font-weight'		=> '300',
				'font-style'		=> 'normal',
				'line-height'		=> '1.6em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0.35px',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '1.15em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '4.167rem',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.15px',
				'margin-top'		=> '1.26em',
				'margin-bottom'		=> '0.97em'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '3.611rem',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.21em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '1.17em',
				'margin-bottom'		=> '0.87em'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '2.5rem',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '1.82em',
				'margin-bottom'		=> '1.36em'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '1.944rem',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.21em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '1.81em',
				'margin-bottom'		=> '1.25em'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '1.5rem',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.3em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '1.7em',
				'margin-bottom'		=> '1.2em'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '1.167rem',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '2.25em',
				'margin-bottom'		=> '1.3em'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'alisha-williams'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '1.8em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1px'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '18px',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.4px'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'alisha-williams'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'alisha-williams'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '14px',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.944rem',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0.25px',
				'margin-top'		=> '0.4em',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'alisha-williams'),
				'description'		=> esc_html__('Font settings of the main menu items', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '18px',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'alisha-williams'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'alisha-williams'),
				'font-family'		=> 'Rubik, sans-serif',
				'font-size' 		=> '18px',
				'font-weight'		=> '500',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0.45px'
				),
			'extrafont' => array(
				'title'				=> esc_html__('Extra Font', 'alisha-williams'),
				'description'		=> esc_html__('Font for some text', 'alisha-williams'),
				'font-family'		=> 'Playlist',
				'font-size' 		=> '16px',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		alisha_williams_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> esc_html__ ('Main', 'alisha-williams'),
							'description'	=> esc_html__ ('Colors of the main content area', 'alisha-williams')
							),
			'alter'	=> array(
							'title'			=> esc_html__ ('Alter', 'alisha-williams'),
							'description'	=> esc_html__ ('Colors of the alternative blocks (sidebars, etc.)', 'alisha-williams')
							),
			'extra'	=> array(
							'title'			=> esc_html__ ('Extra', 'alisha-williams'),
							'description'	=> esc_html__ ('Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'alisha-williams')
							),
			'inverse' => array(
							'title'			=> esc_html__ ('Inverse', 'alisha-williams'),
							'description'	=> esc_html__ ('Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'alisha-williams')
							),
			'input'	=> array(
							'title'			=> esc_html__ ('Input', 'alisha-williams'),
							'description'	=> esc_html__ ('Colors of the form fields (text field, textarea, select, etc.)', 'alisha-williams')
							),
			)
		);
		alisha_williams_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> esc_html__ ('Background color', 'alisha-williams'),
							'description'	=> esc_html__ ('Background color of this block in the normal state', 'alisha-williams')
							),
			'bg_hover'	=> array(
							'title'			=> esc_html__ ('Background hover', 'alisha-williams'),
							'description'	=> esc_html__ ('Background color of this block in the hovered state', 'alisha-williams')
							),
			'bd_color'	=> array(
							'title'			=> esc_html__ ('Border color', 'alisha-williams'),
							'description'	=> esc_html__ ('Border color of this block in the normal state', 'alisha-williams')
							),
			'bd_hover'	=>  array(
							'title'			=> esc_html__ ('Border hover', 'alisha-williams'),
							'description'	=> esc_html__ ('Border color of this block in the hovered state', 'alisha-williams')
							),
			'text'		=> array(
							'title'			=> esc_html__ ('Text', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the plain text inside this block', 'alisha-williams')
							),
			'text_dark'	=> array(
							'title'			=> esc_html__ ('Text dark', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the dark text (bold, header, etc.) inside this block', 'alisha-williams')
							),
			'text_light'=> array(
							'title'			=> esc_html__ ('Text light', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the light text (post meta, etc.) inside this block', 'alisha-williams')
							),
			'text_link'	=> array(
							'title'			=> esc_html__ ('Link', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the links inside this block', 'alisha-williams')
							),
			'text_hover'=> array(
							'title'			=> esc_html__ ('Link hover', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the hovered state of links inside this block', 'alisha-williams')
							),
			'text_link2'=> array(
							'title'			=> esc_html__ ('Link 2', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the accented texts (areas) inside this block', 'alisha-williams')
							),
			'text_hover2'=> array(
							'title'			=> esc_html__ ('Link 2 hover', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the hovered state of accented texts (areas) inside this block', 'alisha-williams')
							),
			'text_link3'=> array(
							'title'			=> esc_html__ ('Link 3', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the other accented texts (buttons) inside this block', 'alisha-williams')
							),
			'text_hover3'=> array(
							'title'			=> esc_html__ ('Link 3 hover', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the hovered state of other accented texts (buttons) inside this block', 'alisha-williams')
							),
			'text_link4'=> array(
							'title'			=> esc_html__ ('Link 4', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the other accented texts (buttons) inside this block', 'alisha-williams')
							),
			'text_hover4'=> array(
							'title'			=> esc_html__ ('Link 4 hover', 'alisha-williams'),
							'description'	=> esc_html__ ('Color of the hovered state of other accented texts (buttons) inside this block', 'alisha-williams')
							)
			)
		);
		alisha_williams_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'alisha-williams'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'				=> '#ffffff',
					'bd_color'				=> '#efefef',
		
					// Text and links colors
					'text'					=> '#494949',
					'text_light'			=> '#929292',
					'text_dark'				=> '#15151a',
					'text_link'				=> '#ff2c5f',
					'text_hover'			=> '#531796',
					'text_link2'			=> '#00e2de',
					'text_hover2'			=> '#e6ec2f',
					'text_link3'			=> '#e6ec2f',
					'text_hover3'			=> '#00e2de',
					'text_link4'			=> '#531796',
					'text_hover4'			=> '#ff2c5f',
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'		=> '#f6f6f6',
					'alter_bg_hover'		=> '#efefef',
					'alter_bd_color'		=> '#eeeeee',
					'alter_bd_hover'		=> '#15151a',
					'alter_text'			=> '#494949',
					'alter_light'			=> '#929292',
					'alter_dark'	 		=> '#1d1d1d',
					'alter_link'			=> '#ff2c5f',
					'alter_hover'			=> '#531796',
					'alter_link2'			=> '#15151a',
					'alter_hover2'			=> '#ff2c5f',
					'alter_link3'			=> '#ff2b5f',
					'alter_hover3'			=> '#00e2de',
 		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'		=> '#531796',
					'extra_bg_hover'		=> '#f3f5f7',
					'extra_bd_color'		=> '#666666',
					'extra_bd_hover'		=> '#d7d7d7',
					'extra_text'			=> '#ffffff',
					'extra_light'			=> '#afafaf',
					'extra_dark'			=> '#ffffff',
					'extra_link'			=> '#ffffff',
					'extra_hover'			=> '#ffffff',
					'extra_link2'			=> '#ff2c5f',
					'extra_hover2'			=> '#8be77c',
					'extra_link3'			=> '#2a2a38',
					'extra_hover3'			=> '#eec432',
					'extra_link4'			=> '#ddb837',
					'extra_hover4'			=> '#eec432',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'		=> '#eeeeee',
					'input_bg_hover'		=> '#eeeeee',
					'input_bd_color'		=> '#eeeeee',
					'input_bd_hover'		=> '#15151a',
					'input_text'			=> '#000000', 
					'input_light'			=> '#929292',
					'input_dark'			=> '#15151a',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'		=> '#67bcc1',
					'inverse_bd_hover'		=> '#5aa4a9',
					'inverse_text'			=> '#494949',
					'inverse_light'			=> '#333333',
					'inverse_dark'			=> '#000000',
					'inverse_link'			=> '#ffffff',
					'inverse_hover'			=> '#15151a' //
		
				
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'alisha-williams'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#0d0d13',
					'bd_color'			=> '#15151a',
		
					// Text and links colors
					'text'				=> '#929292',
					'text_light'		=> '#494949',
					'text_dark'			=> '#ffffff',
					'text_link'			=> '#00e2de',
					'text_hover'		=> '#e6ec2f',
					'text_link2'		=> '#e6ec2f',
					'text_hover2'		=> '#00e2de',
					'text_link3'		=> '#ff2c5f',
					'text_hover3'		=> '#00e2de',
					'text_link4'		=> '#531796',
					'text_hover4'		=> '#00e2de',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#000000',
					'alter_bg_hover'	=> '#28272e',
					'alter_bd_color'	=> '#353439',
					'alter_bd_hover'	=> '#3d3d3d',
					'alter_text'		=> '#929292',
					'alter_light'		=> '#494949',
					'alter_dark'		=> '#ffffff',
					'alter_link'		=> '#e6ec2f',
					'alter_hover'		=> '#00e2de',
					'alter_link2'		=> '#ffffff',
					'alter_hover2'		=> '#e6ec2f',
					'alter_link3'		=> '#e6ec2f',
					'alter_hover3'		=> '#ff2b5f',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#00e2de',
					'extra_bg_hover'	=> '#020202',
					'extra_bd_color'	=> '#666666',
					'extra_bd_hover'	=> '#d7d7d7',
					'extra_text'		=> '#ffffff',
					'extra_light'		=> '#5f5f5f',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#ffffff',
					'extra_hover'		=> '#ffffff',
					'extra_link2'		=> '#00e2de',
					'extra_hover2'		=> '#e6ec2f',
					'extra_link3'		=> '#2a2a38',
					'extra_hover3'		=> '#eec432',
					'extra_link4'		=> '#ddb837',
					'extra_hover4'		=> '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#252429',
					'input_bg_hover'	=> '#252429',
					'input_bd_color'	=> '#252429',
					'input_bd_hover'	=> '#353439',
					'input_text'		=> '#ffffff',
					'input_light'		=> '#5f5f5f',
					'input_dark'		=> '#ffffff',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#ffffff',
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#15151a' //
		
				)
			)
		
		));
	}
}

			
// Additional (calculated) theme-specific colors
// Attention! Don't forget setup custom colors also in the theme.customizer.color-scheme.js
if (!function_exists('alisha_williams_customizer_add_theme_colors')) {
	function alisha_williams_customizer_add_theme_colors($colors) {
		if (substr($colors['text'], 0, 1) == '#') {
			$colors['bg_color_0']  = alisha_williams_hex2rgba( $colors['bg_color'], 0 );
			$colors['bg_color_01']  = alisha_williams_hex2rgba( $colors['bg_color'], 0.1 );
			$colors['bg_color_02']  = alisha_williams_hex2rgba( $colors['bg_color'], 0.2 );
			$colors['bg_color_03']  = alisha_williams_hex2rgba( $colors['bg_color'], 0.3 );
			$colors['bg_color_04']  = alisha_williams_hex2rgba( $colors['bg_color'], 0.4 );
			$colors['bg_color_05']  = alisha_williams_hex2rgba( $colors['bg_color'], 0.5 );
			$colors['bg_color_07']  = alisha_williams_hex2rgba( $colors['bg_color'], 0.7 );
			$colors['bg_color_08']  = alisha_williams_hex2rgba( $colors['bg_color'], 0.8 );
			$colors['bg_color_09']  = alisha_williams_hex2rgba( $colors['bg_color'], 0.9 );
			$colors['text_link_08']  = alisha_williams_hex2rgba( $colors['text_link'], 0.8 );
			$colors['alter_bg_color_07']  = alisha_williams_hex2rgba( $colors['alter_bg_color'], 0.7 );
			$colors['alter_bg_color_04']  = alisha_williams_hex2rgba( $colors['alter_bg_color'], 0.4 );
			$colors['alter_bg_color_02']  = alisha_williams_hex2rgba( $colors['alter_bg_color'], 0.2 );
			$colors['alter_bd_color_02']  = alisha_williams_hex2rgba( $colors['alter_bd_color'], 0.2 );
			$colors['extra_bg_color_07']  = alisha_williams_hex2rgba( $colors['extra_bg_color'], 0.7 );
			$colors['text_dark_07']  = alisha_williams_hex2rgba( $colors['text_dark'], 0.7 );
			$colors['text_link_02']  = alisha_williams_hex2rgba( $colors['text_link'], 0.2 );
			$colors['text_link_07']  = alisha_williams_hex2rgba( $colors['text_link'], 0.7 );
			$colors['text_link_08']  = alisha_williams_hex2rgba( $colors['text_link'], 0.8 );
			$colors['text_link2_08']  = alisha_williams_hex2rgba( $colors['text_link2'], 0.8 );
			$colors['inverse_link_025']  = alisha_williams_hex2rgba( $colors['inverse_link'], 0.25 );
			$colors['inverse_link_05']  = alisha_williams_hex2rgba( $colors['inverse_link'], 0.5 );
			$colors['inverse_link_07']  = alisha_williams_hex2rgba( $colors['inverse_link'], 0.7 );
			$colors['inverse_dark_05']  = alisha_williams_hex2rgba( $colors['inverse_dark'], 0.5 );
			$colors['text_link_blend'] = alisha_williams_hsb2hex(alisha_williams_hex2hsb( $colors['text_link'], 2, -5, 5 ));
			$colors['alter_link_blend'] = alisha_williams_hsb2hex(alisha_williams_hex2hsb( $colors['alter_link'], 2, -5, 5 ));
		} else {
			$colors['bg_color_0'] = '{{ data.bg_color_0 }}';
			$colors['bg_color_02'] = '{{ data.bg_color_02 }}';
			$colors['bg_color_03'] = '{{ data.bg_color_03 }}';
			$colors['bg_color_04'] = '{{ data.bg_color_04 }}';
			$colors['bg_color_07'] = '{{ data.bg_color_07 }}';
			$colors['bg_color_08'] = '{{ data.bg_color_08 }}';
			$colors['bg_color_09'] = '{{ data.bg_color_09 }}';
			$colors['alter_bg_color_07'] = '{{ data.alter_bg_color_07 }}';
			$colors['alter_bg_color_04'] = '{{ data.alter_bg_color_04 }}';
			$colors['alter_bg_color_02'] = '{{ data.alter_bg_color_02 }}';
			$colors['alter_bd_color_02'] = '{{ data.alter_bd_color_02 }}';
			$colors['extra_bg_color_07'] = '{{ data.extra_bg_color_07 }}';
			$colors['text_dark_07'] = '{{ data.text_dark_07 }}';
			$colors['text_link_02'] = '{{ data.text_link_02 }}';
			$colors['text_link_07'] = '{{ data.text_link_07 }}';
			$colors['text_link_08'] = '{{ data.text_link_08 }}';
			$colors['text_link2_08'] = '{{ data.text_link2_08 }}';
			$colors['inverse_link_025'] = '{{ data.inverse_link_025 }}';
			$colors['inverse_link_05'] = '{{ data.inverse_link_05 }}';
			$colors['inverse_link_07'] = '{{ data.inverse_link_07 }}';
			$colors['inverse_dark_05'] = '{{ data.inverse_dark_05 }}';
			$colors['text_link_blend'] = '{{ data.text_link_blend }}';
			$colors['alter_link_blend'] = '{{ data.alter_link_blend }}';
		}
		return $colors;
	}
}


			
// Additional theme-specific fonts rules
// Attention! Don't forget setup fonts rules also in the theme.customizer.color-scheme.js
if (!function_exists('alisha_williams_customizer_add_theme_fonts')) {
	function alisha_williams_customizer_add_theme_fonts($fonts) {
		$rez = array();	
		foreach ($fonts as $tag => $font) {
			if (substr($font['font-family'], 0, 2) != '{{') {
				$rez[$tag.'_font-family'] 		= !empty($font['font-family']) && !alisha_williams_is_inherit($font['font-family'])
														? 'font-family:' . trim($font['font-family']) . ';' 
														: '';
				$rez[$tag.'_font-size'] 		= !empty($font['font-size']) && !alisha_williams_is_inherit($font['font-size'])
														? 'font-size:' . alisha_williams_prepare_css_value($font['font-size']) . ";"
														: '';
				$rez[$tag.'_line-height'] 		= !empty($font['line-height']) && !alisha_williams_is_inherit($font['line-height'])
														? 'line-height:' . trim($font['line-height']) . ";"
														: '';
				$rez[$tag.'_font-weight'] 		= !empty($font['font-weight']) && !alisha_williams_is_inherit($font['font-weight'])
														? 'font-weight:' . trim($font['font-weight']) . ";"
														: '';
				$rez[$tag.'_font-style'] 		= !empty($font['font-style']) && !alisha_williams_is_inherit($font['font-style'])
														? 'font-style:' . trim($font['font-style']) . ";"
														: '';
				$rez[$tag.'_text-decoration'] 	= !empty($font['text-decoration']) && !alisha_williams_is_inherit($font['text-decoration'])
														? 'text-decoration:' . trim($font['text-decoration']) . ";"
														: '';
				$rez[$tag.'_text-transform'] 	= !empty($font['text-transform']) && !alisha_williams_is_inherit($font['text-transform'])
														? 'text-transform:' . trim($font['text-transform']) . ";"
														: '';
				$rez[$tag.'_letter-spacing'] 	= !empty($font['letter-spacing']) && !alisha_williams_is_inherit($font['letter-spacing'])
														? 'letter-spacing:' . trim($font['letter-spacing']) . ";"
														: '';
				$rez[$tag.'_margin-top'] 		= !empty($font['margin-top']) && !alisha_williams_is_inherit($font['margin-top'])
														? 'margin-top:' . alisha_williams_prepare_css_value($font['margin-top']) . ";"
														: '';
				$rez[$tag.'_margin-bottom'] 	= !empty($font['margin-bottom']) && !alisha_williams_is_inherit($font['margin-bottom'])
														? 'margin-bottom:' . alisha_williams_prepare_css_value($font['margin-bottom']) . ";"
														: '';
			} else {
				$rez[$tag.'_font-family']		= '{{ data["'.$tag.'_font-family"] }}';
				$rez[$tag.'_font-size']			= '{{ data["'.$tag.'_font-size"] }}';
				$rez[$tag.'_line-height']		= '{{ data["'.$tag.'_line-height"] }}';
				$rez[$tag.'_font-weight']		= '{{ data["'.$tag.'_font-weight"] }}';
				$rez[$tag.'_font-style']		= '{{ data["'.$tag.'_font-style"] }}';
				$rez[$tag.'_text-decoration']	= '{{ data["'.$tag.'_text-decoration"] }}';
				$rez[$tag.'_text-transform']	= '{{ data["'.$tag.'_text-transform"] }}';
				$rez[$tag.'_letter-spacing']	= '{{ data["'.$tag.'_letter-spacing"] }}';
				$rez[$tag.'_margin-top']		= '{{ data["'.$tag.'_margin-top"] }}';
				$rez[$tag.'_margin-bottom']		= '{{ data["'.$tag.'_margin-bottom"] }}';
			}
		}
		return $rez;
	}
}


//-------------------------------------------------------
//-- Thumb sizes
//-------------------------------------------------------

if ( !function_exists('alisha_williams_customizer_theme_setup') ) {
	add_action( 'after_setup_theme', 'alisha_williams_customizer_theme_setup' );
	function alisha_williams_customizer_theme_setup() {

		// Enable support for Post Thumbnails
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size(370, 0, false);
		
		// Add thumb sizes
		// ATTENTION! If you change list below - check filter's names in the 'trx_addons_filter_get_thumb_size' hook
		$thumb_sizes = apply_filters('alisha_williams_filter_add_thumb_sizes', array(
			'alisha_williams-thumb-huge'		=> array(1170, 658, true),
			'alisha_williams-thumb-big' 		=> array( 813, 487, true),
			'alisha_williams-thumb-med' 		=> array( 370, 208, true),
			'alisha_williams-thumb-tiny' 		=> array(  90,  90, true),
			'alisha_williams-thumb-masonry-big' => array( 760,   0, false),		// Only downscale, not crop
			'alisha_williams-thumb-masonry'		=> array( 370,   0, false),		// Only downscale, not crop
			)
		);
		$mult = alisha_williams_get_theme_option('retina_ready', 1);
		if ($mult > 1) $GLOBALS['content_width'] = apply_filters( 'alisha_williams_filter_content_width', 1170*$mult);
		foreach ($thumb_sizes as $k=>$v) {
			// Add Original dimensions
			add_image_size( $k, $v[0], $v[1], $v[2]);
			// Add Retina dimensions
			if ($mult > 1) add_image_size( $k.'-@retina', $v[0]*$mult, $v[1]*$mult, $v[2]);
		}

	}
}

if ( !function_exists('alisha_williams_customizer_image_sizes') ) {
	add_filter( 'image_size_names_choose', 'alisha_williams_customizer_image_sizes' );
	function alisha_williams_customizer_image_sizes( $sizes ) {
		$thumb_sizes = apply_filters('alisha_williams_filter_add_thumb_sizes', array(
			'alisha_williams-thumb-huge'		=> esc_html__( 'Fullsize image', 'alisha-williams' ),
			'alisha_williams-thumb-big'			=> esc_html__( 'Large image', 'alisha-williams' ),
			'alisha_williams-thumb-med'			=> esc_html__( 'Medium image', 'alisha-williams' ),
			'alisha_williams-thumb-tiny'		=> esc_html__( 'Small square avatar', 'alisha-williams' ),
			'alisha_williams-thumb-masonry-big'	=> esc_html__( 'Masonry Large (scaled)', 'alisha-williams' ),
			'alisha_williams-thumb-masonry'		=> esc_html__( 'Masonry (scaled)', 'alisha-williams' ),
			)
		);
		$mult = alisha_williams_get_theme_option('retina_ready', 1);
		foreach($thumb_sizes as $k=>$v) {
			$sizes[$k] = $v;
			if ($mult > 1) $sizes[$k.'-@retina'] = $v.' '.esc_html__('@2x', 'alisha-williams' );
		}
		return $sizes;
	}
}

// Remove some thumb-sizes from the ThemeREX Addons list
if ( !function_exists( 'alisha_williams_customizer_trx_addons_add_thumb_sizes' ) ) {
	add_filter( 'trx_addons_filter_add_thumb_sizes', 'alisha_williams_customizer_trx_addons_add_thumb_sizes');
	function alisha_williams_customizer_trx_addons_add_thumb_sizes($list=array()) {
		if (is_array($list)) {
			foreach ($list as $k=>$v) {
				if (in_array($k, array(
								'trx_addons-thumb-huge',
								'trx_addons-thumb-big',
								'trx_addons-thumb-medium',
								'trx_addons-thumb-tiny',
								'trx_addons-thumb-masonry-big',
								'trx_addons-thumb-masonry',
								)
							)
						) unset($list[$k]);
			}
		}
		return $list;
	}
}

// and replace removed styles with theme-specific thumb size
if ( !function_exists( 'alisha_williams_customizer_trx_addons_get_thumb_size' ) ) {
	add_filter( 'trx_addons_filter_get_thumb_size', 'alisha_williams_customizer_trx_addons_get_thumb_size');
	function alisha_williams_customizer_trx_addons_get_thumb_size($thumb_size='') {
		return str_replace(array(
							'trx_addons-thumb-huge',
							'trx_addons-thumb-huge-@retina',
							'trx_addons-thumb-big',
							'trx_addons-thumb-big-@retina',
							'trx_addons-thumb-medium',
							'trx_addons-thumb-medium-@retina',
							'trx_addons-thumb-tiny',
							'trx_addons-thumb-tiny-@retina',
							'trx_addons-thumb-masonry-big',
							'trx_addons-thumb-masonry-big-@retina',
							'trx_addons-thumb-masonry',
							'trx_addons-thumb-masonry-@retina',
							),
							array(
							'alisha_williams-thumb-huge',
							'alisha_williams-thumb-huge-@retina',
							'alisha_williams-thumb-big',
							'alisha_williams-thumb-big-@retina',
							'alisha_williams-thumb-med',
							'alisha_williams-thumb-med-@retina',
							'alisha_williams-thumb-tiny',
							'alisha_williams-thumb-tiny-@retina',
							'alisha_williams-thumb-masonry-big',
							'alisha_williams-thumb-masonry-big-@retina',
							'alisha_williams-thumb-masonry',
							'alisha_williams-thumb-masonry-@retina',
							),
							$thumb_size);
	}
}
?>