<?php
/**
 * Default Theme Options and Internal Theme Settings
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

// Theme init priorities:
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)

if ( !function_exists('alisha_williams_options_theme_setup1') ) {
	add_action( 'after_setup_theme', 'alisha_williams_options_theme_setup1', 1 );
	function alisha_williams_options_theme_setup1() {
		
		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		alisha_williams_storage_set('settings', array(
			
			'disable_jquery_ui'		=> false,		// Prevent loading custom jQuery UI libraries in the third-party plugins
		
			'max_load_fonts'		=> 3,			// Max fonts number to load from Google fonts or from uploaded fonts
		
			'use_mediaelements'		=> true,		// Load script "Media Elements" to play video and audio
		
			'max_excerpt_length'	=> 30,			// Max words number for the excerpt in the blog style 'Excerpt'.
													// For style 'Classic' - get half from this value
			'comment_maxlength'		=> 1000,		// Max length of the message from contact form

			'comment_after_name'	=> true			// Place 'comment' field before the 'name' and 'email'
			
		));
	}
}


// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('alisha_williams_options_create')) {

	function alisha_williams_options_create() {

		alisha_williams_storage_set('options', array(
		
			// Section 'Title & Tagline' - add theme options in the standard WP section
			'title_tagline' => array(
				"title" => esc_html__('Title, Tagline & Site icon', 'alisha-williams'),
				"desc" => wp_kses_data( __('Specify site title and tagline (if need) and upload the site icon', 'alisha-williams') ),
				"type" => "section"
				),
		
		
			// Section 'Header' - add theme options in the standard WP section
			'header_image' => array(
				"title" => esc_html__('Header', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload logo images, select header type and widgets set for the header', 'alisha-williams') )
							. '<br>'
							. wp_kses_data( __('<b>Attention!</b> Some of these options can be overridden in the following sections (Homepage, Blog archive, Shop, Events, etc.) or in the settings of individual pages', 'alisha-williams') ),
				"type" => "section"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'alisha-williams'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'alisha-williams')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_style' => array(
				"title" => esc_html__('Header style', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select style to display the site header', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'alisha-williams')
				),
				"std" => 'header-default',
				"options" => array(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'alisha-williams')
				),
				"std" => 'default',
				"options" => array(),
				"type" => "select"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select color scheme to decorate header area', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'alisha-williams')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'menu_info' => array(
				"title" => esc_html__('Menu settings', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select main menu style, position, color scheme and other parameters', 'alisha-williams') ),
				"type" => "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'alisha-williams')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'alisha-williams'),
					'left'	=> esc_html__('Left',	'alisha-williams'),
					'right'	=> esc_html__('Right',	'alisha-williams')
				),
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Menu Color Scheme', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select color scheme to decorate main menu area', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'alisha-williams')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'alisha-williams'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'alisha-williams') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'alisha-williams'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'alisha-williams') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'alisha-williams'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'alisha-williams') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'logo_info' => array(
				"title" => esc_html__('Logo settings', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select logo images for the normal and Retina displays', 'alisha-williams') ),
				"type" => "info"
				),
			'logo' => array(
				"title" => esc_html__('Logo', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload site logo', 'alisha-williams') ),
				"std" => '',
				"type" => "image"
				),
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'alisha-williams') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse' => array(
				"title" => esc_html__('Logo inverse', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it on the dark background', 'alisha-williams') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse_retina' => array(
				"title" => esc_html__('Logo inverse for Retina', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'alisha-williams') ),
				"std" => '',
				"type" => "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'alisha-williams') ),
				"std" => '',
				"type" => "image"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'alisha-williams') ),
				"std" => '',
				"type" => "image"
				),
			'logo_text' => array(
				"title" => esc_html__('Logo from Site name', 'alisha-williams'),
				"desc" => wp_kses_data( __('Do you want use Site name and description as Logo if images above are not selected?', 'alisha-williams') ),
				"std" => 1,
				"type" => "checkbox"
				),
			'header_phone' => array(
				"title" => esc_html__('Phone', 'alisha-williams'),
				"desc" => wp_kses_data( __('Phone for default header', 'alisha-williams') ),
				"dependency" => array(
					'header_style' => array('header-default')
				),
				"std" => "",
				"refresh" => false,
				"type" => "text"
				),
			'title_image' => array(
				"title" => esc_html__('Image for title', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload image for title', 'alisha-williams') ),
				"dependency" => array(
					'header_style' => array('header-default')
				),
				"std" => '',
				"type" => "image"
				),			
		
		
			// Section 'Content'
			'content' => array(
				"title" => esc_html__('Content', 'alisha-williams'),
				"desc" => wp_kses_data( __('Options for the content area.', 'alisha-williams') )
							. '<br>'
							. wp_kses_data( __('<b>Attention!</b> Some of these options can be overridden in the following sections (Homepage, Blog archive, Shop, Events, etc.) or in the settings of individual pages', 'alisha-williams') ),
				"type" => "section",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select width of the body content', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => array(
					'boxed'		=> esc_html__('Boxed',		'alisha-williams'),
					'wide'		=> esc_html__('Wide',		'alisha-williams')
				),
				"type" => "select"
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select color scheme to decorate whole site. Attention! Case "Inherit" can be used only for custom pages, not for root site content in the Appearance - Customize', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'alisha-williams'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'alisha-williams'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'alisha-williams'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'alisha-williams') ),
				"std" => 0,
				"type" => "checkbox"
				),
            'privacy_text' => array(
                "title" => esc_html__("Text with Privacy Policy link", 'alisha-williams'),
                "desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'alisha-williams') ),
                "std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'alisha-williams'), 'alisha_williams_kses_content' ),
                "type"  => "text"
            ),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'alisha-williams') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"std" => '',
				"type" => "image"
				),
			'no_image' => array(
				"title" => esc_html__('No image placeholder', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload image, used as placeholder for the posts without featured image', 'alisha-williams') ),
				"std" => '',
				"type" => "image"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'alisha-williams')
				),
				"std" => 'sidebar_widgets',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Sidebar Color Scheme', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select color scheme to decorate sidebar', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'alisha-williams')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'alisha-williams')
				),
				"refresh" => false,
				"std" => 'right',
				"options" => array(),
				"type" => "select"
				),
		
		
		
			// Section 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select set of widgets and columns number for the site footer', 'alisha-williams') )
							. '<br>'
							. wp_kses_data( __('<b>Attention!</b> Some of these options can be overridden in the following sections (Homepage, Blog archive, Shop, Events, etc.) or in the settings of individual pages', 'alisha-williams') ),
				"type" => "section"
				),
			'footer_style' => array(
				"title" => esc_html__('Footer style', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select style to display the site footer', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Footer', 'alisha-williams')
				),
				"std" => 'footer-default',
				"options" => array(),
				"type" => "select"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'alisha-williams')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'alisha-williams'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'alisha-williams') ),
				'refresh' => false,
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'alisha-williams') ),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'alisha-williams') ),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'alisha-williams'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'alisha-williams') ),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'alisha-williams'),
				"desc" => wp_kses_data( __('Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'alisha-williams') ),
				"std" => esc_html__('AxiomThemes &copy; {Y}. All rights reserved.', 'alisha-williams'),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"refresh" => false,
				"type" => "textarea"
				),
		
		
		
			// Section 'Homepage' - settings for home page
			'homepage' => array(
				"title" => esc_html__('Homepage', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select blog style and widgets to display on the homepage', 'alisha-williams') ),
				"type" => "section"
				),
			'expand_content_home' => array(
				"title" => esc_html__('Expand content', 'alisha-williams'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the Homepage', 'alisha-williams') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style_home' => array(
				"title" => esc_html__('Blog style', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select posts style for the homepage', 'alisha-williams') ),
				"std" => 'excerpt',
				"options" => array(),
				"type" => "select"
				),
			'first_post_large_home' => array(
				"title" => esc_html__('First post large', 'alisha-williams'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of the Homepage', 'alisha-williams') ),
				"dependency" => array(
					'blog_style_home' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_style_home' => array(
				"title" => esc_html__('Header style', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select style to display the site header on the homepage', 'alisha-williams') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'header_position_home' => array(
				"title" => esc_html__('Header position', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select position to display the site header on the homepage', 'alisha-williams') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_widgets_home' => array(
				"title" => esc_html__('Sidebar widgets', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select sidebar to show on the homepage', 'alisha-williams') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_position_home' => array(
				"title" => esc_html__('Sidebar position', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the homepage', 'alisha-williams') ),
				"refresh" => false,
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
		
		
			// Section 'Blog archive'
			'blog' => array(
				"title" => esc_html__('Blog archive', 'alisha-williams'),
				"desc" => wp_kses_data( __('Options for the blog archive', 'alisha-williams') ),
				"type" => "section",
				),
			'expand_content_blog' => array(
				"title" => esc_html__('Expand content', 'alisha-williams'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the blog archive', 'alisha-williams') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style' => array(
				"title" => esc_html__('Blog style', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select posts style for the blog archive', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => 'classic_3',
				"options" => array(),
				"type" => "select"
				),
			'blog_columns' => array(
				"title" => esc_html__('Blog columns', 'alisha-williams'),
				"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'alisha-williams') ),
				"std" => 2,
				"options" => alisha_williams_get_list_range(2,4),
				"type" => "hidden"
				),
			'post_type' => array(
				"title" => esc_html__('Post type', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"linked" => 'parent_cat',
				"refresh" => false,
				"hidden" => true,
				"std" => 'post',
				"options" => array(),
				"type" => "select"
				),
			'parent_cat' => array(
				"title" => esc_html__('Category to show', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select category to show in the blog archive', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"refresh" => false,
				"hidden" => true,
				"std" => '0',
				"options" => array(),
				"type" => "select"
				),
			'posts_per_page' => array(
				"title" => esc_html__('Posts per page', 'alisha-williams'),
				"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"hidden" => true,
				"std" => '10',
				"type" => "text"
				),
			"blog_pagination" => array( 
				"title" => esc_html__('Pagination style', 'alisha-williams'),
				"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"std" => "pages",
				"options" => array(
					'pages'	=> esc_html__("Page numbers", 'alisha-williams'),
					'links'	=> esc_html__("Older/Newest", 'alisha-williams'),
					'more'	=> esc_html__("Load more", 'alisha-williams'),
					'infinite' => esc_html__("Infinite scroll", 'alisha-williams')
				),
				"type" => "select"
				),
			'show_filters' => array(
				"title" => esc_html__('Show filters', 'alisha-williams'),
				"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
					'blog_style' => array('portfolio', 'gallery')
				),
				"hidden" => true,
				"std" => 0,
				"type" => "checkbox"
				),
			'first_post_large' => array(
				"title" => esc_html__('First post large', 'alisha-williams'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of blog archive', 'alisha-williams') ),
				"dependency" => array(
					'blog_style' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			"blog_content" => array( 
				"title" => esc_html__('Posts content', 'alisha-williams'),
				"desc" => wp_kses_data( __("Show full post's content in the blog or only post's excerpt", 'alisha-williams') ),
				"std" => "excerpt",
				"options" => array(
					'excerpt'	=> esc_html__('Excerpt',	'alisha-williams'),
					'fullpost'	=> esc_html__('Full post',	'alisha-williams')
				),
				"type" => "select"
				),
			'time_diff_before' => array(
				"title" => esc_html__('Time difference', 'alisha-williams'),
				"desc" => wp_kses_data( __("How many days show time difference instead post's date", 'alisha-williams') ),
				"std" => 5,
				"type" => "text"
				),
			'sticky_style' => array(
				"title" => esc_html__('Sticky posts style', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select style of the sticky posts output', 'alisha-williams') ),
				"std" => 'inherit',
				"options" => array(
					'inherit' => esc_html__('Decorated posts', 'alisha-williams'),
					'columns' => esc_html__('Mini-cards',	'alisha-williams')
				),
				"type" => "select"
				),
			"blog_animation" => array( 
				"title" => esc_html__('Animation for the posts', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'alisha-williams')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => "none",
				"options" => array(),
				"type" => "select"
				),
			'header_style_blog' => array(
				"title" => esc_html__('Header style', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select style to display the site header on the blog archive', 'alisha-williams') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'header_position_blog' => array(
				"title" => esc_html__('Header position', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select position to display the site header on the blog archive', 'alisha-williams') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_widgets_blog' => array(
				"title" => esc_html__('Sidebar widgets', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select sidebar to show on the blog archive', 'alisha-williams') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_position_blog' => array(
				"title" => esc_html__('Sidebar position', 'alisha-williams'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the blog archive', 'alisha-williams') ),
				"refresh" => false,
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'hide_sidebar_on_single_blog' => array(
				"title" => esc_html__('Hide sidebar on the single post', 'alisha-williams'),
				"desc" => wp_kses_data( __("Hide sidebar on the single post", 'alisha-williams') ),
				"std" => 0,
				"type" => "checkbox"
				),
		
		
			// Section 'Colors' - choose color scheme and customize separate colors from it
			'scheme' => array(
				"title" => esc_html__('* Color scheme editor', 'alisha-williams'),
				"desc" => esc_html__("Modify colors and preview changes on your site", 'alisha-williams'),
				"priority" => 1000,
				"type" => "section"
				),
		
			'scheme_storage' => array(
				"title" => esc_html__('Color schemes', 'alisha-williams'),
				"desc" => esc_html__('Select color scheme to modify. Attention! Only those sections will be changed which this scheme was assigned to', 'alisha-williams'),
				"std" => '$alisha_williams_get_scheme_storage',
				"refresh" => false,
				"type" => "scheme_editor"
				),


			// Section 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'alisha-williams'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'alisha-williams') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'alisha-williams')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'alisha-williams'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'alisha-williams') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'alisha-williams')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// Panel 'Fonts' - manage fonts loading and set parameters of the base theme elements
			'fonts' => array(
				"title" => esc_html__('* Fonts settings', 'alisha-williams'),
				"desc" => '',
				"priority" => 1500,
				"type" => "panel"
				),

			// Section 'Load_fonts'
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'alisha-williams'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'alisha-williams') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'alisha-williams') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'alisha-williams'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'alisha-williams') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'alisha-williams') ),
				"refresh" => false,
				"std" => '$alisha_williams_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=alisha_williams_get_theme_setting('max_load_fonts'); $i++) {
			$fonts["load_fonts-{$i}-info"] = array(
				"title" => esc_html(sprintf(__('Font %s', 'alisha-williams'), $i)),
				"desc" => '',
				"type" => "info",
				);
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'alisha-williams'),
				"desc" => '',
				"refresh" => false,
				"std" => '$alisha_williams_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'alisha-williams'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'alisha-williams') )
							: '',
				"refresh" => false,
				"std" => '$alisha_williams_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'alisha-williams'),
					'serif' => esc_html__('serif', 'alisha-williams'),
					'sans-serif' => esc_html__('sans-serif', 'alisha-williams'),
					'monospace' => esc_html__('monospace', 'alisha-williams'),
					'cursive' => esc_html__('cursive', 'alisha-williams'),
					'fantasy' => esc_html__('fantasy', 'alisha-williams')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'alisha-williams'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'alisha-williams') )
											. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'alisha-williams') )
							: '',
				"refresh" => false,
				"std" => '$alisha_williams_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Sections with font's attributes for each theme element
		$theme_fonts = alisha_williams_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								: esc_html(sprintf(__('%s settings', 'alisha-williams'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								: wp_kses( sprintf(__('Font settings of the "%s" tag.', 'alisha-williams'), $tag), 'alisha_williams_kses_content' ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = array();
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'alisha-williams'),
						'100' => esc_html__('100 (Light)', 'alisha-williams'), 
						'200' => esc_html__('200 (Light)', 'alisha-williams'), 
						'300' => esc_html__('300 (Thin)',  'alisha-williams'),
						'400' => esc_html__('400 (Normal)', 'alisha-williams'),
						'500' => esc_html__('500 (Semibold)', 'alisha-williams'),
						'600' => esc_html__('600 (Semibold)', 'alisha-williams'),
						'700' => esc_html__('700 (Bold)', 'alisha-williams'),
						'800' => esc_html__('800 (Black)', 'alisha-williams'),
						'900' => esc_html__('900 (Black)', 'alisha-williams')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'alisha-williams'),
						'normal' => esc_html__('Normal', 'alisha-williams'), 
						'italic' => esc_html__('Italic', 'alisha-williams')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'alisha-williams'),
						'none' => esc_html__('None', 'alisha-williams'), 
						'underline' => esc_html__('Underline', 'alisha-williams'),
						'overline' => esc_html__('Overline', 'alisha-williams'),
						'line-through' => esc_html__('Line-through', 'alisha-williams')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'alisha-williams'),
						'none' => esc_html__('None', 'alisha-williams'), 
						'uppercase' => esc_html__('Uppercase', 'alisha-williams'),
						'lowercase' => esc_html__('Lowercase', 'alisha-williams'),
						'capitalize' => esc_html__('Capitalize', 'alisha-williams')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"refresh" => false,
					"std" => '$alisha_williams_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters into Theme Options
		alisha_williams_storage_merge_array('options', '', $fonts);

		// Add Header Video if WP version < 4.7
		if (!function_exists('get_header_video_url')) {
			alisha_williams_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'alisha-williams'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'alisha-williams') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'alisha-williams')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}
	}
}


// Return lists with choises when its need in the admin mode
if (!function_exists('alisha_williams_options_get_list_choises')) {
	add_filter('alisha_williams_filter_options_get_list_choises', 'alisha_williams_options_get_list_choises', 10, 2);
	function alisha_williams_options_get_list_choises($list, $id) {
		if (is_array($list) && count($list)==0) {
			if (strpos($id, 'header_style')===0)
				$list = alisha_williams_get_list_header_styles(strpos($id, 'header_style_')===0);
			else if (strpos($id, 'header_position')===0)
				$list = alisha_williams_get_list_header_positions(strpos($id, 'header_position_')===0);
			else if (strpos($id, 'header_widgets')===0)
				$list = alisha_williams_get_list_sidebars(strpos($id, 'header_widgets_')===0, true);
			else if (strpos($id, 'header_scheme')===0 
					|| strpos($id, 'menu_scheme')===0
					|| strpos($id, 'color_scheme')===0
					|| strpos($id, 'sidebar_scheme')===0
					|| strpos($id, 'footer_scheme')===0)
				$list = alisha_williams_get_list_schemes($id!='color_scheme');
			else if (strpos($id, 'sidebar_widgets')===0)
				$list = alisha_williams_get_list_sidebars(strpos($id, 'sidebar_widgets_')===0, true);
			else if (strpos($id, 'sidebar_position')===0)
				$list = alisha_williams_get_list_sidebars_positions(strpos($id, 'sidebar_position_')===0);
			else if (strpos($id, 'widgets_above_page')===0)
				$list = alisha_williams_get_list_sidebars(strpos($id, 'widgets_above_page_')===0, true);
			else if (strpos($id, 'widgets_above_content')===0)
				$list = alisha_williams_get_list_sidebars(strpos($id, 'widgets_above_content_')===0, true);
			else if (strpos($id, 'widgets_below_page')===0)
				$list = alisha_williams_get_list_sidebars(strpos($id, 'widgets_below_page_')===0, true);
			else if (strpos($id, 'widgets_below_content')===0)
				$list = alisha_williams_get_list_sidebars(strpos($id, 'widgets_below_content_')===0, true);
			else if (strpos($id, 'footer_style')===0)
				$list = alisha_williams_get_list_footer_styles(strpos($id, 'footer_style_')===0);
			else if (strpos($id, 'footer_widgets')===0)
				$list = alisha_williams_get_list_sidebars(strpos($id, 'footer_widgets_')===0, true);
			else if (strpos($id, 'blog_style')===0)
				$list = alisha_williams_get_list_blog_styles(strpos($id, 'blog_style_')===0);
			else if (strpos($id, 'post_type')===0)
				$list = alisha_williams_get_list_posts_types();
			else if (strpos($id, 'parent_cat')===0)
				$list = alisha_williams_array_merge(array(0 => esc_html__('- Select category -', 'alisha-williams')), alisha_williams_get_list_categories());
			else if (strpos($id, 'blog_animation')===0)
				$list = alisha_williams_get_list_animations_in();
			else if ($id == 'color_scheme_editor')
				$list = alisha_williams_get_list_schemes();
			else if (strpos($id, '_font-family') > 0)
				$list = alisha_williams_get_list_load_fonts(true);
		}
		return $list;
	}
}




// -----------------------------------------------------------------
// -- Create and manage Theme Options
// -----------------------------------------------------------------

// Theme init priorities:
// 2 - create Theme Options
if (!function_exists('alisha_williams_options_theme_setup2')) {
	add_action( 'after_setup_theme', 'alisha_williams_options_theme_setup2', 2 );
	function alisha_williams_options_theme_setup2() {
		alisha_williams_options_create();
	}
}

// Step 1: Load default settings and previously saved mods
if (!function_exists('alisha_williams_options_theme_setup5')) {
	add_action( 'after_setup_theme', 'alisha_williams_options_theme_setup5', 5 );
	function alisha_williams_options_theme_setup5() {
		alisha_williams_storage_set('options_reloaded', false);
		alisha_williams_load_theme_options();
	}
}

// Step 2: Load current theme customization mods
if (is_customize_preview()) {
	if (!function_exists('alisha_williams_load_custom_options')) {
		add_action( 'wp_loaded', 'alisha_williams_load_custom_options' );
		function alisha_williams_load_custom_options() {
			if (!alisha_williams_storage_get('options_reloaded')) {
				alisha_williams_storage_set('options_reloaded', true);
				alisha_williams_load_theme_options();
			}
		}
	}
}

// Load current values for each customizable option
if ( !function_exists('alisha_williams_load_theme_options') ) {
	function alisha_williams_load_theme_options() {
		$options = alisha_williams_storage_get('options');
		$reset = (int) get_theme_mod('reset_options', 0);
		foreach ($options as $k=>$v) {
			if (isset($v['std'])) {
				if (strpos($v['std'], '$alisha_williams_')!==false) {
					$func = substr($v['std'], 1);
					if (function_exists($func)) {
						$v['std'] = $func($k);
					}
				}
				$value = $v['std'];
				if (!$reset) {
					if (isset($_GET[$k]))
						$value = sanitize_text_field($_GET[$k]);
					else {
						$tmp = get_theme_mod($k, -987654321);
						if ($tmp != -987654321) $value = $tmp;
					}
				}
				alisha_williams_storage_set_array2('options', $k, 'val', $value);
				if ($reset) remove_theme_mod($k);
			}
		}
		if ($reset) {
			// Unset reset flag
			set_theme_mod('reset_options', 0);
			// Regenerate CSS with default colors and fonts
			alisha_williams_customizer_save_css();
		} else {
			do_action('alisha_williams_action_load_options');
		}
	}
}

// Override options with stored page/post meta
if ( !function_exists('alisha_williams_override_theme_options') ) {
	add_action( 'wp', 'alisha_williams_override_theme_options', 1 );
	function alisha_williams_override_theme_options($query=null) {
		if (is_page_template('blog.php')) {
			alisha_williams_storage_set('blog_archive', true);
			alisha_williams_storage_set('blog_template', get_the_ID());
		}
		alisha_williams_storage_set('blog_mode', alisha_williams_detect_blog_mode());
		if (is_singular()) {
			alisha_williams_storage_set('options_meta', get_post_meta(get_the_ID(), 'alisha_williams_options', true));
		}
	}
}


// Return customizable option value
if (!function_exists('alisha_williams_get_theme_option')) {
	function alisha_williams_get_theme_option($name, $defa='', $strict_mode=false, $post_id=0) {
		$rez = $defa;
		$from_post_meta = false;
		if ($post_id > 0) {
			if (!alisha_williams_storage_isset('post_options_meta', $post_id))
				alisha_williams_storage_set_array('post_options_meta', $post_id, get_post_meta($post_id, 'alisha_williams_options', true));
			if (alisha_williams_storage_isset('post_options_meta', $post_id, $name)) {
				$tmp = alisha_williams_storage_get_array('post_options_meta', $post_id, $name);
				if (!alisha_williams_is_inherit($tmp)) {
					$rez = $tmp;
					$from_post_meta = true;
				}
			}
		}
		if (!$from_post_meta && alisha_williams_storage_isset('options')) {
			if ( !alisha_williams_storage_isset('options', $name) ) {
				$rez = $tmp = '_not_exists_';
				if (function_exists('trx_addons_get_option'))
					$rez = trx_addons_get_option($name, $tmp, false);
				if ($rez === $tmp) {
					if ($strict_mode) {
						$s = debug_backtrace();
						$s = array_shift($s);
						echo '<pre>' . sprintf(esc_html__('Undefined option "%s" called from:', 'alisha-williams'), $name);
						if (function_exists('alisha_williams_dco')) alisha_williams_dco($s);
						else print_r($s);
						echo '</pre>';
                        wp_die();
					} else
						$rez = $defa;
				}
			} else {
				$blog_mode = alisha_williams_storage_get('blog_mode');
				// Override option from GET or POST for current blog mode
				if (!empty($blog_mode) && isset($_REQUEST[$name . '_' . $blog_mode])) {
					$rez = sanitize_text_field($_REQUEST[$name . '_' . $blog_mode]);
				// Override option from GET
				} else if (isset($_REQUEST[$name])) {
					$rez = sanitize_text_field($_REQUEST[$name]);
				// Override option from current page settings (if exists)
				} else if (alisha_williams_storage_isset('options_meta', $name) && !alisha_williams_is_inherit(alisha_williams_storage_get_array('options_meta', $name))) {
					$rez = alisha_williams_storage_get_array('options_meta', $name);
				// Override option from current blog mode settings: 'home', 'search', 'page', 'post', 'blog', etc. (if exists)
				} else if (!empty($blog_mode) && alisha_williams_storage_isset('options', $name . '_' . $blog_mode, 'val') && !alisha_williams_is_inherit(alisha_williams_storage_get_array('options', $name . '_' . $blog_mode, 'val'))) {
					$rez = alisha_williams_storage_get_array('options', $name . '_' . $blog_mode, 'val');
				// Get saved option value
				} else if (alisha_williams_storage_isset('options', $name, 'val')) {
					$rez = alisha_williams_storage_get_array('options', $name, 'val');
				// Get ThemeREX Addons option value
				} else if (function_exists('trx_addons_get_option')) {
					$rez = trx_addons_get_option($name, $defa, false);
				}
			}
		}
		return $rez;
	}
}


// Check if customizable option exists
if (!function_exists('alisha_williams_check_theme_option')) {
	function alisha_williams_check_theme_option($name) {
		return alisha_williams_storage_isset('options', $name);
	}
}


// Get dependencies list from the Theme Options
if ( !function_exists('alisha_williams_get_theme_dependencies') ) {
	function alisha_williams_get_theme_dependencies() {
		$options = alisha_williams_storage_get('options');
		$depends = array();
		foreach ($options as $k=>$v) {
			if (isset($v['dependency'])) 
				$depends[$k] = $v['dependency'];
		}
		return $depends;
	}
}

// Return internal theme setting value
if (!function_exists('alisha_williams_get_theme_setting')) {
	function alisha_williams_get_theme_setting($name) {
		return alisha_williams_storage_isset('settings', $name) ? alisha_williams_storage_get_array('settings', $name) : false;
	}
}

// Set theme setting
if ( !function_exists( 'alisha_williams_set_theme_setting' ) ) {
	function alisha_williams_set_theme_setting($option_name, $value) {
		if (alisha_williams_storage_isset('settings', $option_name))
			alisha_williams_storage_set_array('settings', $option_name, $value);
	}
}
?>