<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

$alisha_williams_post_id    = get_the_ID();
$alisha_williams_post_date  = alisha_williams_get_date();
$alisha_williams_post_title = get_the_title();
$alisha_williams_post_link  = get_permalink();
$alisha_williams_post_author_id   = get_the_author_meta('ID');
$alisha_williams_post_author_name = get_the_author_meta('display_name');
$alisha_williams_post_author_url  = get_author_posts_url($alisha_williams_post_author_id, '');

$alisha_williams_args = get_query_var('alisha_williams_args_widgets_posts');
$alisha_williams_show_date = isset($alisha_williams_args['show_date']) ? (int) $alisha_williams_args['show_date'] : 1;
$alisha_williams_show_image = isset($alisha_williams_args['show_image']) ? (int) $alisha_williams_args['show_image'] : 1;
$alisha_williams_show_author = isset($alisha_williams_args['show_author']) ? (int) $alisha_williams_args['show_author'] : 1;
$alisha_williams_show_counters = isset($alisha_williams_args['show_counters']) ? (int) $alisha_williams_args['show_counters'] : 1;
$alisha_williams_show_categories = isset($alisha_williams_args['show_categories']) ? (int) $alisha_williams_args['show_categories'] : 1;

$alisha_williams_output = alisha_williams_storage_get('alisha_williams_output_widgets_posts');

$alisha_williams_post_counters_output = '';
if ( $alisha_williams_show_counters ) {
	$alisha_williams_post_counters_output = '<span class="post_info_item post_info_counters">'
								. alisha_williams_get_post_counters('comments')
							. '</span>';
}


$alisha_williams_output .= '<article class="post_item with_thumb">';

if ($alisha_williams_show_image) {
	$alisha_williams_post_thumb = get_the_post_thumbnail($alisha_williams_post_id, alisha_williams_get_thumb_size('tiny'), array(
		'alt' => get_the_title()
	));
	if ($alisha_williams_post_thumb) $alisha_williams_output .= '<div class="post_thumb">' . ($alisha_williams_post_link ? '<a href="' . esc_url($alisha_williams_post_link) . '">' : '') . ($alisha_williams_post_thumb) . ($alisha_williams_post_link ? '</a>' : '') . '</div>';
}

$alisha_williams_output .= '<div class="post_content">'
			. ($alisha_williams_show_categories 
					? '<div class="post_categories">'
						. alisha_williams_get_post_categories()
						. $alisha_williams_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($alisha_williams_post_link ? '<a href="' . esc_url($alisha_williams_post_link) . '">' : '') . ($alisha_williams_post_title) . ($alisha_williams_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('alisha_williams_filter_get_post_info', 
								'<div class="post_info">'
									. ($alisha_williams_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($alisha_williams_post_link ? '<a href="' . esc_url($alisha_williams_post_link) . '" class="post_info_date">' : '') 
											. esc_html($alisha_williams_post_date) 
											. ($alisha_williams_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($alisha_williams_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'alisha-williams') . ' ' 
											. ($alisha_williams_post_link ? '<a href="' . esc_url($alisha_williams_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($alisha_williams_post_author_name) 
											. ($alisha_williams_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$alisha_williams_show_categories && $alisha_williams_post_counters_output
										? $alisha_williams_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
alisha_williams_storage_set('alisha_williams_output_widgets_posts', $alisha_williams_output);
?>