<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

// Header sidebar
$alisha_williams_header_name = alisha_williams_get_theme_option('header_widgets');
$alisha_williams_header_present = !alisha_williams_is_off($alisha_williams_header_name) && is_active_sidebar($alisha_williams_header_name);
if ($alisha_williams_header_present) { 
	alisha_williams_storage_set('current_sidebar', 'header');
	$alisha_williams_header_wide = alisha_williams_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($alisha_williams_header_name) ) {
		dynamic_sidebar($alisha_williams_header_name);
	}
	$alisha_williams_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($alisha_williams_widgets_output)) {
		$alisha_williams_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $alisha_williams_widgets_output);
		$alisha_williams_need_columns = strpos($alisha_williams_widgets_output, 'columns_wrap')===false;
		if ($alisha_williams_need_columns) {
			$alisha_williams_columns = max(0, (int) alisha_williams_get_theme_option('header_columns'));
			if ($alisha_williams_columns == 0) $alisha_williams_columns = min(6, max(1, substr_count($alisha_williams_widgets_output, '<aside ')));
			if ($alisha_williams_columns > 1)
				$alisha_williams_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($alisha_williams_columns).' widget ', $alisha_williams_widgets_output);
			else
				$alisha_williams_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($alisha_williams_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$alisha_williams_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($alisha_williams_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'alisha_williams_action_before_sidebar' );
				alisha_williams_show_layout($alisha_williams_widgets_output);
				do_action( 'alisha_williams_action_after_sidebar' );
				if ($alisha_williams_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$alisha_williams_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>