<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0.14
 */
$alisha_williams_header_video = alisha_williams_get_header_video();
$alisha_williams_embed_video = '';
if (!empty($alisha_williams_header_video) && !alisha_williams_is_from_uploads($alisha_williams_header_video)) {
	if (alisha_williams_is_youtube_url($alisha_williams_header_video) && preg_match('/[=\/]([^=\/]*)$/', $alisha_williams_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$alisha_williams_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($alisha_williams_header_video) . '[/embed]' ));
			$alisha_williams_embed_video = alisha_williams_make_video_autoplay($alisha_williams_embed_video);
		} else {
			$alisha_williams_header_video = str_replace('/watch?v=', '/embed/', $alisha_williams_header_video);
			$alisha_williams_header_video = alisha_williams_add_to_url($alisha_williams_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url('/'),
				'widgetid' => 1
			));
			$alisha_williams_embed_video = '<iframe src="' . esc_url($alisha_williams_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php alisha_williams_show_layout($alisha_williams_embed_video); ?></div><?php
	}
}
?>