<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

// Page (category, tag, archive, author) title

if ( alisha_williams_need_page_title() ) {
	alisha_williams_sc_layouts_showed('title', true);
	alisha_williams_sc_layouts_showed('postmeta', false);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$alisha_williams_blog_title = alisha_williams_get_blog_title();
							$alisha_williams_blog_title_text = $alisha_williams_blog_title_class = $alisha_williams_blog_title_link = $alisha_williams_blog_title_link_text = '';
							if (is_array($alisha_williams_blog_title)) {
								$alisha_williams_blog_title_text = $alisha_williams_blog_title['text'];
								$alisha_williams_blog_title_class = !empty($alisha_williams_blog_title['class']) ? ' '.$alisha_williams_blog_title['class'] : '';
								$alisha_williams_blog_title_link = !empty($alisha_williams_blog_title['link']) ? $alisha_williams_blog_title['link'] : '';
								$alisha_williams_blog_title_link_text = !empty($alisha_williams_blog_title['link_text']) ? $alisha_williams_blog_title['link_text'] : '';
							} else
								$alisha_williams_blog_title_text = $alisha_williams_blog_title;
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr($alisha_williams_blog_title_class); ?>"><?php
								$alisha_williams_top_icon = alisha_williams_get_category_icon();
								if (!empty($alisha_williams_top_icon)) {
									$alisha_williams_attr = alisha_williams_getimagesize($alisha_williams_top_icon);
									?><img src="<?php echo esc_url($alisha_williams_top_icon); ?>" alt="<?php esc_attr__('Image', 'alisha-williams')?>" <?php if (!empty($alisha_williams_attr[3])) alisha_williams_show_layout($alisha_williams_attr[3]);?>><?php
								}
								echo wp_kses($alisha_williams_blog_title_text, 'alisha_williams_kses_content');
							?></h1>
							<?php
							if (!empty($alisha_williams_blog_title_link) && !empty($alisha_williams_blog_title_link_text)) {
								?><a href="<?php echo esc_url($alisha_williams_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($alisha_williams_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'alisha_williams_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>