<?php
/**
 * The template to display the featured image in the single post
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

if ( get_query_var('alisha_williams_header_image')=='' && is_singular() && has_post_thumbnail() && in_array(get_post_type(), array('post', 'page')) )  {
	$alisha_williams_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
	if (!empty($alisha_williams_src[0])) {
		alisha_williams_sc_layouts_showed('featured', true);
		?><div class="sc_layouts_featured with_image <?php echo esc_attr(alisha_williams_add_inline_css_class('background-image:url('.esc_url($alisha_williams_src[0]).');')); ?>"></div><?php
	}
}
?>