<?php
/**
 * The template to display the main menu
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */
$alisha_williams_header_phone = alisha_williams_prepare_macros(alisha_williams_get_theme_option('header_phone'));
?>
<div class="top_panel_navi sc_layouts_row sc_layouts_row_type_compact sc_layouts_row_fixed 
			scheme_<?php echo esc_attr(alisha_williams_is_inherit(alisha_williams_get_theme_option('menu_scheme')) 
												? (alisha_williams_is_inherit(alisha_williams_get_theme_option('header_scheme')) 
													? alisha_williams_get_theme_option('color_scheme') 
													: alisha_williams_get_theme_option('header_scheme')) 
												: alisha_williams_get_theme_option('menu_scheme')); ?>">
	<div class="content_wrap">
		<div class="columns_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_left sc_layouts_column_icons_position_left column-1_2">
				<?php
				// Logo
				?><div class="sc_layouts_item"><?php
					get_template_part( 'templates/header-logo' );
				?></div>
			</div><?php
			
			// Attention! Don't place any spaces between columns!
			?><div class="sc_layouts_column sc_layouts_column_align_right sc_layouts_column_icons_position_left column-1_2">
				<?php if (!empty($alisha_williams_header_phone)) { ?>
				<div class="sc_layouts_item">
					<div class="sc_layouts_iconed_text">
						<span class="sc_layouts_item_icon sc_layouts_iconed_text_icon icon-phone-3"></span>
						<span class="sc_layouts_item_details sc_layouts_iconed_text_details">
							<span class="sc_layouts_item_details_line1 sc_layouts_iconed_text_line1"><?php alisha_williams_show_layout($alisha_williams_header_phone); ?></span>
						</span>
					</div>
				</div><?php } ?><div class="sc_layouts_item">
					<div class="sc_layouts_iconed_text sc_layouts_menu_mobile_button">
						<a class="sc_layouts_item_link sc_layouts_iconed_text_link" href="#">
							<span class="sc_layouts_item_icon sc_layouts_iconed_text_icon trx_addons_icon-menu"></span>
						</a>
					</div>
				</div>
			</div>
		</div><!-- /.sc_layouts_row -->
	</div><!-- /.content_wrap -->
</div><!-- /.top_panel_navi -->