<?php
/**
 * The template to display the side menu
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */
?>
<div class="menu_side_wrap scheme_<?php echo esc_attr(alisha_williams_is_inherit(alisha_williams_get_theme_option('menu_scheme')) 
																	? (alisha_williams_is_inherit(alisha_williams_get_theme_option('header_scheme')) 
																		? alisha_williams_get_theme_option('color_scheme') 
																		: alisha_williams_get_theme_option('header_scheme')) 
																	: alisha_williams_get_theme_option('menu_scheme'));
			echo " menu_side_".esc_attr(alisha_williams_get_theme_option('menu_side_icons') > 0 ? 'icons' : 'dots');
			?>">
	<span class="menu_side_button icon-burger_menu"></span>

	<div class="menu_side_inner <?php  ?>">
		<?php
		// Logo
		set_query_var('alisha_williams_logo_args', array('type' => 'side'));
		get_template_part( 'templates/header-logo' );
		set_query_var('alisha_williams_logo_args', array());
		// Main menu button
		?>
		<div class="toc_menu_item">
			<a href="#" class="toc_menu_description menu_mobile_description"><span class="toc_menu_description_title"><?php esc_html_e('Main menu', 'alisha-williams'); ?></span></a>
			<a class="menu_mobile_button toc_menu_icon icon-burger_menu" href="#"></a>
		</div>		
	</div>
	<?php

		if (alisha_williams_get_theme_option('menu_side_icons') == 0) {
			alisha_williams_show_layout(alisha_williams_get_socials_links(), '<div class="toc_menu_socials">', '</div>');
		}
	?>
</div><!-- /.menu_side_wrap -->