<?php
/**
 * The template to show mobile menu
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */
?>
<div class="menu_mobile_overlay"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr(alisha_williams_get_theme_option('menu_mobile_fullscreen') > 0 ? 'fullscreen' : 'narrow'); ?> scheme_dark">
	<div class="menu_mobile_inner">
		<a class="menu_mobile_close icon-cancel"></a><?php

		// Logo
		set_query_var('alisha_williams_logo_args', array('type' => 'inverse'));
		get_template_part( 'templates/header-logo' );
		set_query_var('alisha_williams_logo_args', array());

		// Mobile menu
		$alisha_williams_menu_mobile = alisha_williams_get_nav_menu('menu_mobile');
		if (empty($alisha_williams_menu_mobile)) {
			$alisha_williams_menu_mobile = apply_filters('alisha_williams_filter_get_mobile_menu', '');
			if (empty($alisha_williams_menu_mobile)) $alisha_williams_menu_mobile = alisha_williams_get_nav_menu('menu_main');
			if (empty($alisha_williams_menu_mobile)) $alisha_williams_menu_mobile = alisha_williams_get_nav_menu();
		}
		if (!empty($alisha_williams_menu_mobile)) {
			if (!empty($alisha_williams_menu_mobile))
				$alisha_williams_menu_mobile = str_replace(
					array('menu_main', 'id="menu-', 'sc_layouts_menu_nav', 'sc_layouts_hide_on_mobile', 'hide_on_mobile'),
					array('menu_mobile', 'id="menu_mobile-', '', '', ''),
					$alisha_williams_menu_mobile
					);
			if (strpos($alisha_williams_menu_mobile, '<nav ')===false)
				$alisha_williams_menu_mobile = sprintf('<nav class="menu_mobile_nav_area">%s</nav>', $alisha_williams_menu_mobile);
			alisha_williams_show_layout(apply_filters('alisha_williams_filter_menu_mobile_layout', $alisha_williams_menu_mobile));
		}

		// Social icons
		alisha_williams_show_layout(alisha_williams_get_socials_links(), '<div class="socials_mobile">', '</div>');
		?>
	</div>
</div>
<div class="menu_mobile header-bg-layer"></div>