<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

$alisha_williams_args = get_query_var('alisha_williams_logo_args');

// Site logo
$alisha_williams_logo_image  = alisha_williams_get_logo_image(isset($alisha_williams_args['type']) ? $alisha_williams_args['type'] : '');
$alisha_williams_logo_text   = alisha_williams_is_on(alisha_williams_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$alisha_williams_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($alisha_williams_logo_image) || !empty($alisha_williams_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url(home_url('/')); ?>"><?php
		if (!empty($alisha_williams_logo_image)) {
			$alisha_williams_attr = alisha_williams_getimagesize($alisha_williams_logo_image);
			echo '<img src="'.esc_url($alisha_williams_logo_image).'" alt="'.esc_attr__('Image', 'alisha-williams').'"'.(!empty($alisha_williams_attr[3]) ? sprintf(' %s', $alisha_williams_attr[3]) : '').'>' ;
		} else {
			alisha_williams_show_layout(alisha_williams_prepare_macros($alisha_williams_logo_text), '<span class="logo_text">', '</span>');
			alisha_williams_show_layout(alisha_williams_prepare_macros($alisha_williams_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>