<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */


$alisha_williams_header_css = $alisha_williams_header_image = '';
if (empty($alisha_williams_title_image)) 
	$alisha_williams_title_image = alisha_williams_get_theme_option( 'title_image' );
$alisha_williams_header_video = alisha_williams_get_header_video();
if (true || empty($alisha_williams_header_video)) {
	$alisha_williams_header_image = get_header_image();
	if (alisha_williams_is_on(alisha_williams_get_theme_option('header_image_override')) && apply_filters('alisha_williams_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($alisha_williams_cat_img = alisha_williams_get_category_image()) != '')
				$alisha_williams_header_image = $alisha_williams_cat_img;
		} else if (is_singular() || alisha_williams_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$alisha_williams_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($alisha_williams_header_image)) $alisha_williams_header_image = $alisha_williams_header_image[0];
			} else
				$alisha_williams_header_image = '';
		}
	}
}

?><header class="top_panel top_panel_default<?php
					echo !empty($alisha_williams_header_image) || !empty($alisha_williams_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($alisha_williams_header_video!='') echo ' with_bg_video';
					if ($alisha_williams_header_image!='') echo ' '.esc_attr(alisha_williams_add_inline_css_class('background-image: url('.esc_url($alisha_williams_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (alisha_williams_is_on(alisha_williams_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
					?> scheme_<?php echo esc_attr(alisha_williams_is_inherit(alisha_williams_get_theme_option('header_scheme')) 
													? alisha_williams_get_theme_option('color_scheme') 
													: alisha_williams_get_theme_option('header_scheme'));
					?>  default_image<?php if ($alisha_williams_title_image!='') echo ' '.esc_attr(alisha_williams_add_inline_css_class('background-image: url('.esc_url($alisha_williams_title_image).') !important;'));?>"><?php

	// Background video
	if (!empty($alisha_williams_header_video)) {
		get_template_part( 'templates/header-video' );
	}
	
	// Main menu
	if (alisha_williams_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

?></header>