<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0.10
 */

// Footer sidebar
$alisha_williams_footer_name = alisha_williams_get_theme_option('footer_widgets');
$alisha_williams_footer_present = !alisha_williams_is_off($alisha_williams_footer_name) && is_active_sidebar($alisha_williams_footer_name);
if ($alisha_williams_footer_present) { 
	alisha_williams_storage_set('current_sidebar', 'footer');
	$alisha_williams_footer_wide = alisha_williams_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($alisha_williams_footer_name) ) {
		dynamic_sidebar($alisha_williams_footer_name);
	}
	$alisha_williams_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($alisha_williams_out)) {
		$alisha_williams_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $alisha_williams_out);
		$alisha_williams_need_columns = true;
		if ($alisha_williams_need_columns) {
			$alisha_williams_columns = max(0, (int) alisha_williams_get_theme_option('footer_columns'));
			if ($alisha_williams_columns == 0) $alisha_williams_columns = min(4, max(1, substr_count($alisha_williams_out, '<aside ')));
			if ($alisha_williams_columns > 1)
				$alisha_williams_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($alisha_williams_columns).' widget ', $alisha_williams_out);
			else
				$alisha_williams_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($alisha_williams_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row  sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$alisha_williams_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($alisha_williams_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'alisha_williams_action_before_sidebar' );
				alisha_williams_show_layout($alisha_williams_out);
				do_action( 'alisha_williams_action_after_sidebar' );
				if ($alisha_williams_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$alisha_williams_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>