<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0.10
 */

// Logo
if (alisha_williams_is_on(alisha_williams_get_theme_option('logo_in_footer'))) {
	$alisha_williams_logo_image = '';
	if (alisha_williams_get_retina_multiplier(2) > 1)
		$alisha_williams_logo_image = alisha_williams_get_theme_option( 'logo_footer_retina' );
	if (empty($alisha_williams_logo_image)) 
		$alisha_williams_logo_image = alisha_williams_get_theme_option( 'logo_footer' );
	$alisha_williams_logo_text   = get_bloginfo( 'name' );
	if (!empty($alisha_williams_logo_image) || !empty($alisha_williams_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($alisha_williams_logo_image)) {
					$alisha_williams_attr = alisha_williams_getimagesize($alisha_williams_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($alisha_williams_logo_image).'" class="logo_footer_image" alt="'.esc_attr__('Image', 'alisha-williams').'"'.(!empty($alisha_williams_attr[3]) ? sprintf(' %s', $alisha_williams_attr[3]) : '').'></a>' ;
				} else if (!empty($alisha_williams_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($alisha_williams_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>