<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0.10
 */

$alisha_williams_footer_scheme =  alisha_williams_is_inherit(alisha_williams_get_theme_option('footer_scheme')) ? alisha_williams_get_theme_option('color_scheme') : alisha_williams_get_theme_option('footer_scheme');
$alisha_williams_footer_id = str_replace('footer-custom-', '', alisha_williams_get_theme_option("footer_style"));
$alisha_williams_footer_meta = get_post_meta($alisha_williams_footer_id, 'trx_addons_options', true);
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($alisha_williams_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($alisha_williams_footer_id))); 
						if (!empty($alisha_williams_footer_meta['margin']) != '') 
							echo ' '.esc_attr(alisha_williams_add_inline_css_class('margin-top: '.esc_attr(alisha_williams_prepare_css_value($alisha_williams_footer_meta['margin'])).';'));
						?> scheme_<?php echo esc_attr($alisha_williams_footer_scheme); 
						?>">
	<?php
    // Custom footer's layout
    do_action('alisha_williams_action_show_layout', $alisha_williams_footer_id);
	?>
</footer><!-- /.footer_wrap -->
