<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0.10
 */

// Copyright area
$alisha_williams_footer_scheme =  alisha_williams_is_inherit(alisha_williams_get_theme_option('footer_scheme')) ? alisha_williams_get_theme_option('color_scheme') : alisha_williams_get_theme_option('footer_scheme');
$alisha_williams_copyright_scheme = alisha_williams_is_inherit(alisha_williams_get_theme_option('copyright_scheme')) ? $alisha_williams_footer_scheme : alisha_williams_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($alisha_williams_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php

				$alisha_williams_copyright = alisha_williams_prepare_macros(alisha_williams_get_theme_option('copyright'));
				if (!empty($alisha_williams_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $alisha_williams_copyright, $alisha_williams_matches)) {
						$alisha_williams_copyright = str_replace($alisha_williams_matches[1], date(str_replace(array('{', '}'), '', $alisha_williams_matches[1])), $alisha_williams_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($alisha_williams_copyright));
				}
			?></div>
		</div>
	</div>
</div>
