<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */
?>
<div class="author_container">
	<div class="author_info scheme_default author vcard" itemprop="author" itemscope itemtype="http://schema.org/Person">

		<div class="author_avatar" itemprop="image">
			<?php 
			$alisha_williams_mult = alisha_williams_get_retina_multiplier();
			echo get_avatar( get_the_author_meta( 'user_email' ), 120*$alisha_williams_mult ); 
			?>
		</div><!-- .author_avatar -->

		<div class="author_description">
            <div class="author_label"><?php esc_html_e( 'Written by', 'alisha-williams' ); ?></div>
            <h5 class="author_title" itemprop="name"><span class="fn"><?php the_author(); ?></span></h5>

			<div class="author_bio" itemprop="description">
				<?php echo wp_kses(wpautop(get_the_author_meta( 'description' )), 'alisha_williams_kses_content'); ?>
				<?php do_action('alisha_williams_action_user_meta'); ?>
			</div><!-- .author_bio -->

		</div><!-- .author_description -->

	</div><!-- .author_info -->
</div>