<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0.1
 */
?>
<div class="update-nag" id="alisha_williams_admin_notice">
	<h3 class="alisha_williams_notice_title"><?php echo sprintf(esc_html__('Welcome to %s', 'alisha-williams'), wp_get_theme()->name); ?></h3>
	<?php
	if (!alisha_williams_exists_trx_addons()) {
		?><p><?php echo wp_kses_data(__('<b>Attention!</b> Plugin "ThemeREX Addons is required! Please, install and activate it!', 'alisha-williams')); ?></p><?php
	}
	?><p><?php
		if (alisha_williams_get_value_gp('page')!='tgmpa-install-plugins') {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=tgmpa-install-plugins'); ?>" class="button-primary"><i class="dashicons dashicons-admin-plugins"></i> <?php esc_html_e('Install plugins', 'alisha-williams'); ?></a>
			<?php
		}
		if (function_exists('alisha_williams_exists_trx_addons') && alisha_williams_exists_trx_addons()) {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=trx_importer'); ?>" class="button-primary"><i class="dashicons dashicons-download"></i> <?php esc_html_e('One Click Demo Data', 'alisha-williams'); ?></a>
			<?php
		}
		?>
        <a href="<?php echo esc_url(admin_url().'customize.php'); ?>" class="button-primary"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Customizer', 'alisha-williams'); ?></a>
        <a href="#" class="button alisha_williams_hide_notice"><i class="dashicons dashicons-dismiss"></i> <?php esc_html_e('Hide Notice', 'alisha-williams'); ?></a>
	</p>
</div>