<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

$alisha_williams_sidebar_position = alisha_williams_get_theme_option('sidebar_position');
if (alisha_williams_sidebar_present()) {
	ob_start();
	$alisha_williams_sidebar_name = alisha_williams_get_theme_option('sidebar_widgets');
	alisha_williams_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($alisha_williams_sidebar_name) ) {
		dynamic_sidebar($alisha_williams_sidebar_name);
	}
	$alisha_williams_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($alisha_williams_out)) {
		?>
		<div class="sidebar <?php echo esc_attr($alisha_williams_sidebar_position); ?> widget_area<?php if (!alisha_williams_is_inherit(alisha_williams_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(alisha_williams_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'alisha_williams_action_before_sidebar' );
				alisha_williams_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $alisha_williams_out));
				do_action( 'alisha_williams_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>