<?php
/* ThemeREX Updater support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('alisha_williams_trx_updater_theme_setup9')) {
    add_action( 'after_setup_theme', 'alisha_williams_trx_updater_theme_setup9', 9 );
    function alisha_williams_trx_updater_theme_setup9() {
        if (is_admin()) {
            add_filter( 'alisha_williams_filter_tgmpa_required_plugins',		'alisha_williams_trx_updater_tgmpa_required_plugins' );
        }
    }
}

// Check if plugin installed and activated
if ( !function_exists( 'alisha_williams_exists_trx_updater' ) ) {
    function alisha_williams_exists_trx_updater() {
        return function_exists( 'trx_updater_load_plugin_textdomain' );
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'alisha_williams_trx_updater_tgmpa_required_plugins' ) ) {
    function alisha_williams_trx_updater_tgmpa_required_plugins($list=array()) {
        if (in_array('trx_updater', alisha_williams_storage_get('required_plugins'))) {
            $path = alisha_williams_get_file_dir('plugins/trx_updater/trx_updater.zip');
            $list[] = array(
                'name' 		=> esc_html__('ThemeREX Updater', 'alisha-williams'),
                'slug' 		=> 'trx_updater',
                'source'	=> !empty($path) ? $path : 'upload://trx_updater.zip',
                'required' 	=> false,
                'version'	=> '2.0.0',
            );
        }
        return $list;
    }
}

?>