<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('alisha_williams_trx_addons_get_css')) {
	add_filter('alisha_williams_filter_get_css', 'alisha_williams_trx_addons_get_css', 10, 4);
	function alisha_williams_trx_addons_get_css($css, $colors, $fonts, $scheme='') {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

.sc_skills_pie.sc_skills_compact_off .sc_skills_item_title,
.sc_dishes_compact .sc_services_item_title,
.sc_services_iconed .sc_services_item_title {
	{$fonts['p_font-family']}
}
.toc_menu_item .toc_menu_description,
.sc_recent_news .post_item .post_footer .post_counters .post_counters_item,
.sc_item_subtitle.sc_item_title_style_shadow,
.sc_icons_item_title,
.sc_price_title, .sc_price_price,
.sc_courses_default .sc_courses_item_price,
.sc_courses_default .trx_addons_hover_content .trx_addons_hover_links a,
.sc_promo_modern .sc_promo_link2 span+span,
.sc_skills_counter .sc_skills_total,
.sc_skills_pie.sc_skills_compact_off .sc_skills_total,
.slider_swiper .slide_info.slide_info_large .slide_title,
.slider_style_modern .slider_controls_label span + span,
.slider_pagination_wrap,
.sc_slider_controller_info {
	{$fonts['h5_font-family']}
}
.sc_recent_news .post_item .post_meta,
.sc_action_item_description,
.sc_price_description,
.sc_price_details,
.sc_courses_default .sc_courses_item_date,
.courses_single .courses_page_meta,
.sc_promo_modern .sc_promo_link2 span,
.sc_skills_counter .sc_skills_item_title,
.slider_style_modern .slider_controls_label span,
.slider_titles_outside_wrap .slide_cats,
.slider_titles_outside_wrap .slide_subtitle,
.sc_team .sc_team_item_subtitle,
.sc_dishes .sc_dishes_item_subtitle,
.sc_services .sc_services_item_subtitle,
.team_member_page .team_member_brief_info_text,
.sc_testimonials_item_author_title,
.sc_testimonials_item_content:before {
	{$fonts['info_font-family']}
}
.sc_button,
.sc_button_simple,
.sc_form button,
.sc_action_item_link,
.sc_price_link {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}

.sc_action_item_default .sc_action_item_subtitle,
.post_featured_date .post_featured_date_month,
.sc_blogger_classic .post_featured_date .post_featured_date_month,
.sc_item_subtitle,
.sc_price_label,
ol.trx_addons_list_number > li:before,
ul.trx_addons_list_number > li:before,
.trx_addons_dropcap.trx_addons_dropcap_style_2 {
	{$fonts['extrafont_font-family']}
}
.widget_instagram_wrap .widget_instagram_follow_link {
	{$fonts['extrafont_font-family']}
}
CSS;

			$rad = alisha_williams_get_border_radius();
			$rad4 = ' '.$rad != ' 0' ? '4px' : 0;
			$rad50 = ' '.$rad != ' 0' ? '50%' : 0;
			$css['fonts'] .= <<<CSS

.properties_search_form .properties_search_basic,
.cars_search_form .cars_search_basic,
.sc_slider_controls .slider_controls_wrap > a,
.slider_swiper.slider_controls_side .slider_controls_wrap > a,
.slider_outer_controls_side .slider_controls_wrap > a,
.slider_outer_controls_top .slider_controls_wrap > a,
.slider_outer_controls_bottom .slider_controls_wrap > a {
}
.sc_button,
.sc_form button,
.sc_price_link,
.sc_action_item_link,
.sc_matches_item_pair .sc_matches_item_player .post_featured > img {
}
.trx_addons_scroll_to_top,
.socials_wrap .social_item .social_icon,
.sc_matches_other .sc_matches_item_logo1 img,
.sc_matches_other .sc_matches_item_logo2 img,
.sc_points_table .sc_points_table_logo img {
}

CSS;
		}

		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS


/* Custom layouts
--------------------------------- */
.sc_layouts_row,
.scheme_self.sc_layouts_row {
	color: {$colors['text']};
	background-color: {$colors['bg_color']};
}
.header_position_over .sc_layouts_row:not(.sc_layouts_row_fixed_on),
.header_position_over .scheme_self.sc_layouts_row:not(.sc_layouts_row_fixed_on) {
	color: {$colors['text']};
	background-color: transparent;
}

.sc_layouts_row_delimiter,
.scheme_self.sc_layouts_row_delimiter {
	border-color: {$colors['bd_color']};
}
.footer_wrap .sc_layouts_row_delimiter,
.footer_wrap .scheme_self.vc_row .sc_layouts_row_delimiter,
.footer_wrap .scheme_self.sc_layouts_row_delimiter,
.scheme_self.footer_wrap .sc_layouts_row_delimiter {
	border-color: {$colors['alter_bd_color']};
}

.sc_layouts_item_icon {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.sc_layouts_item_details_line1 {
	color: {$colors['text_link']};
}
.sc_layouts_item_details_line2 {
	color: {$colors['text_dark']};
}
.sc_layouts_menu_mobile_button .sc_layouts_item_icon {
	color: {$colors['text_link2']};
}
.sc_layouts_menu_mobile_button a .sc_layouts_item_icon {
	background-color: transparent !important;
}
.sc_layouts_menu_mobile_button a:hover .sc_layouts_item_icon {
	color: {$colors['text_link']} !important;
}

.sc_layouts_row_fixed_on {
	background-color: {$colors['bg_color_07']} !important;
}

.sc_layouts_row_type_normal .sc_layouts_login_icon {
	background-color: {$colors['text_link3']};
}
.sc_layouts_row_type_normal a:hover .sc_layouts_login_icon {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_hover3']};

}
.sc_layouts_row_type_compact .sc_layouts_item_icon {
	background-color: transparent;
}

/* Row type: Narrow */
.sc_layouts_row.sc_layouts_row_type_narrow,
.scheme_self.sc_layouts_row.sc_layouts_row_type_narrow {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
}
.sc_layouts_row_type_narrow .sc_layouts_item,
.scheme_self.sc_layouts_row_type_narrow .sc_layouts_item {
	color: {$colors['alter_dark']};
}
.sc_layouts_row_type_narrow .sc_layouts_item a,
.scheme_self.sc_layouts_row_type_narrow .sc_layouts_item a {
	color: {$colors['alter_dark']};
}
.sc_layouts_row_type_narrow .sc_layouts_item a:hover,
.sc_layouts_row_type_narrow .sc_layouts_item a:hover .sc_layouts_item_icon,
.scheme_self.sc_layouts_row_type_narrow .sc_layouts_item a:hover,
.scheme_self.sc_layouts_row_type_narrow .sc_layouts_item a:hover .sc_layouts_item_icon {
	color: {$colors['alter_dark']};
}

.sc_layouts_row_type_narrow .sc_layouts_item_icon,
.scheme_self.sc_layouts_row_type_narrow .sc_layouts_item_icon {
	color: {$colors['alter_hover']};
	background-color: transparent;
}
.sc_layouts_row_type_narrow [class*="sc_layouts_menu"] .sc_layouts_item_icon,
.scheme_self.sc_layouts_row_type_narrow [class*="sc_layouts_menu"] .sc_layouts_item_icon {
	color: {$colors['alter_link']};
}
.sc_layouts_row_type_narrow .sc_layouts_item_details_line1,
.sc_layouts_row_type_narrow .sc_layouts_item_details_line2,
.scheme_self.sc_layouts_row_type_narrow .sc_layouts_item_details_line1,
.scheme_self.sc_layouts_row_type_narrow .sc_layouts_item_details_line2 {
	color: {$colors['alter_dark']};
}

.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+1) .social_icon,
.scheme_self.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+1) .social_icon {
	background-color: transparent;
	color: {$colors['text_link2']};
}
.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+1):hover .social_icon,
.scheme_self.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+1):hover .social_icon {
	background-color: transparent;
	color: {$colors['text_hover2']};
}
.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+2) .social_icon,
.scheme_self.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+2) .social_icon {
	background-color: transparent;
	color: {$colors['text_link']};
}
.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+2):hover .social_icon,
.scheme_self.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+2):hover .social_icon {
	background-color: transparent;
	color: {$colors['text_hover']};
}
.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+3) .social_icon,
.scheme_self.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+3) .social_icon {
	background-color: transparent;
	color: {$colors['text_link3']};
}
.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+3):hover .social_icon,
.scheme_self.sc_layouts_row_type_narrow .socials_wrap .social_item:nth-child(3n+3):hover .social_icon {
	background-color: transparent;
	color: {$colors['text_link2']};
}

.sc_layouts_row_type_narrow .sc_button_wrap .sc_button,
.scheme_self.sc_layouts_row_type_narrow .sc_button_wrap .sc_button {
	background-color: transparent;
	border-color: {$colors['alter_link']};
	color: {$colors['alter_link']};
}
.sc_layouts_row_type_narrow .sc_button_wrap .sc_button:hover,
.scheme_self.sc_layouts_row_type_narrow .sc_button_wrap .sc_button:hover {
	background-color: transparent;
	border-color: {$colors['alter_hover']};
	color: {$colors['alter_hover']} !important;
}

.sc_layouts_row_type_narrow .search_wrap .search_submit,
.scheme_self.sc_layouts_row_type_narrow .search_wrap .search_submit {
	background-color: transparent;
	color: {$colors['alter_hover']};
}
.sc_layouts_row_type_narrow .search_wrap .search_field,
.scheme_self.sc_layouts_row_type_narrow .search_wrap .search_field {
	color: {$colors['alter_dark']};
}
.sc_layouts_row_type_narrow .search_wrap .search_field::-webkit-input-placeholder,
.scheme_self.sc_layouts_row_type_narrow .search_wrap .search_field::-webkit-input-placeholder {
	color: {$colors['alter_dark']};
}
.sc_layouts_row_type_narrow .search_wrap .search_field::-moz-placeholder,
.scheme_self.sc_layouts_row_type_narrow .search_wrap .search_field::-moz-placeholder {
	color: {$colors['alter_dark']};
}
.sc_layouts_row_type_narrow .search_wrap .search_field:-ms-input-placeholder,
.scheme_self.sc_layouts_row_type_narrow .search_wrap .search_field:-ms-input-placeholder {
	color: {$colors['alter_dark']};
}
.sc_layouts_row_type_narrow .search_wrap .search_field:focus,
.scheme_self.sc_layouts_row_type_narrow .search_wrap .search_field:focus {
	color: {$colors['alter_dark']};
}


/* Row type: Compact */
.sc_layouts_row_type_compact .sc_layouts_item,
.scheme_self.sc_layouts_row_type_compact .sc_layouts_item {
	color: {$colors['text']};
}
.sc_layouts_row_type_compact .sc_layouts_item a:not(.sc_button):not(.button),
.scheme_self.sc_layouts_row_type_compact .sc_layouts_item a:not(.sc_button):not(.button) {
	color: {$colors['text_dark']};
}
.sc_layouts_row_type_compact .sc_layouts_item a:not(.sc_button):not(.button):hover,
.scheme_self.sc_layouts_row_type_compact .sc_layouts_item a:not(.sc_button):not(.button):hover{
	color: {$colors['text_link']} !important;
}
.sc_layouts_row_type_compact .sc_layouts_item a:hover .sc_layouts_item_icon,
.scheme_self.sc_layouts_row_type_compact .sc_layouts_item a:hover .sc_layouts_item_icon {
	color: {$colors['text_dark']} !important;
}
.sc_layouts_row_type_compact .sc_layouts_item_icon,
.scheme_self.sc_layouts_row_type_compact .sc_layouts_item_icon {
	color: {$colors['alter_link3']};
}
.sc_layouts_row_type_compact .sc_layouts_item_details_line1,
.sc_layouts_row_type_compact .sc_layouts_item_details_line2,
.scheme_self.sc_layouts_row_type_compact .sc_layouts_item_details_line1,
.scheme_self.sc_layouts_row_type_compact .sc_layouts_item_details_line2 {
	color: {$colors['text_dark']};
}

.sc_layouts_row_type_compact .search_wrap .search_submit,
.scheme_self.sc_layouts_row_type_compact .search_wrap .search_submit {
	background-color: transparent;
	color: {$colors['alter_link3']};
}
.sc_layouts_row_type_compact .search_wrap .search_submit:hover,
.scheme_self.sc_layouts_row_type_compact .search_wrap .search_submit:hover {
	background-color: transparent;
	color: {$colors['text_hover']};
}
.sc_layouts_row_type_compact .search_wrap.search_style_normal .search_submit,
.scheme_self.sc_layouts_row_type_compact .search_wrap.search_style_normal .search_submit {
	color: {$colors['text_link']};
}
.sc_layouts_row_type_compact .search_wrap.search_style_normal .search_submit:hover,
.scheme_self.sc_layouts_row_type_compact .search_wrap.search_style_normal .search_submit:hover {
	color: {$colors['text_hover']};
}

.sc_layouts_row_type_compact .search_wrap .search_field::-webkit-input-placeholder,
.scheme_self.sc_layouts_row_type_compact .search_wrap .search_field::-webkit-input-placeholder {
	color: {$colors['text']};
}
.sc_layouts_row_type_compact .search_wrap .search_field::-moz-placeholder,
.scheme_self.sc_layouts_row_type_compact .search_wrap .search_field::-moz-placeholder {
	color: {$colors['text']};
}
.sc_layouts_row_type_compact .search_wrap .search_field:-ms-input-placeholder,
.scheme_self.sc_layouts_row_type_compact .search_wrap .search_field:-ms-input-placeholder {
	color: {$colors['text']};
}


/* Row type: Normal */
.sc_layouts_row_type_normal .sc_layouts_item,
.scheme_self.sc_layouts_row_type_normal .sc_layouts_item {
	color: {$colors['text_dark']};
}
.sc_layouts_row_type_normal .sc_layouts_item a:not(.sc_button),
.scheme_self.sc_layouts_row_type_normal .sc_layouts_item a:not(.sc_button) {
	color: {$colors['text_dark']};
}
.sc_layouts_row_type_normal .sc_layouts_item a:not(.sc_button):hover,
.scheme_self.sc_layouts_row_type_normal .sc_layouts_item a:not(.sc_button):hover,
.sc_layouts_row_type_normal .sc_layouts_item a:not(.sc_button):hover .sc_layouts_item_icon,
.scheme_self.sc_layouts_row_type_normal .sc_layouts_item a:not(.sc_button):hover .sc_layouts_item_icon {
	color: {$colors['inverse_link']};
}

.sc_layouts_row_type_normal .search_wrap .search_submit,
.scheme_self.sc_layouts_row_type_normal .search_wrap .search_submit {
	background-color: transparent;
	color: {$colors['input_text']};
}
.sc_layouts_row_type_normal .search_wrap .search_submit:hover,
.scheme_self.sc_layouts_row_type_normal .search_wrap .search_submit:hover {
	background-color: transparent;
	color: {$colors['input_dark']};
}

.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+1) .social_icon,
.scheme_self.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+1) .social_icon {
	background-color: {$colors['text_link2']};
	color: {$colors['inverse_link']};
}
.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+1):hover .social_icon,
.scheme_self.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+1):hover .social_icon {
	background-color: {$colors['text_hover2']};
}
.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+2) .social_icon,
.scheme_self.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+2) .social_icon {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+2):hover .social_icon,
.scheme_self.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+2):hover .social_icon {
	background-color: {$colors['text_hover']};
}
.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+3) .social_icon,
.scheme_self.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+3) .social_icon {
	background-color: {$colors['text_link3']};
	color: {$colors['inverse_link']};
}
.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+3):hover .social_icon,
.scheme_self.sc_layouts_row_type_normal .socials_wrap .social_item:nth-child(3n+3):hover .social_icon {
	background-color: {$colors['text_link2']};
}

/* Logo */
.sc_layouts_logo b {
	color: {$colors['text_dark']};
}
.sc_layouts_logo i {
	color: {$colors['text_link']};
}
.sc_layouts_logo_text {
	color: {$colors['text_link']};
}
.sc_layouts_logo a:hover .logo_text,
.sc_layouts_logo:hover .logo_text {
	color: {$colors['text_link']};
}
.logo_slogan {
	color: {$colors['text_dark']};
}


/* Search style 'Expand' */
.search_style_expand.search_opened {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bd_color']};
}
.search_style_expand.search_opened .search_submit {
	color: {$colors['text']};
}
.search_style_expand .search_submit:hover,
.search_style_expand .search_submit:focus {
	color: {$colors['text_dark']};
}


/* Search style 'Fullscreen' */
.search_style_fullscreen.search_opened .search_form_wrap {
	background-color: {$colors['bg_color_09']};
}
.search_style_fullscreen.search_opened .search_form {
	border-color: {$colors['text_dark']};
}
.search_style_fullscreen.search_opened .search_close,
.search_style_fullscreen.search_opened .search_field,
.search_style_fullscreen.search_opened .search_submit {
	color: {$colors['text_dark']};
}
.search_style_fullscreen.search_opened .search_close:hover,
.search_style_fullscreen.search_opened .search_field:hover,
.search_style_fullscreen.search_opened .search_field:focus,
.search_style_fullscreen.search_opened .search_submit:hover,
.search_style_fullscreen.search_opened .search_submit:focus {
	color: {$colors['text']};
}
.search_style_fullscreen.search_opened .search_field::-webkit-input-placeholder {color:{$colors['text_light']}; opacity: 1;}
.search_style_fullscreen.search_opened .search_field::-moz-placeholder          {color:{$colors['text_light']}; opacity: 1;}/* Firefox 19+ */
.search_style_fullscreen.search_opened .search_field:-moz-placeholder           {color:{$colors['text_light']}; opacity: 1;}/* Firefox 18- */
.search_style_fullscreen.search_opened .search_field:-ms-input-placeholder      {color:{$colors['text_light']}; opacity: 1;}


/* Search results */
.search_wrap .search_results {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bd_color']};
}
.search_wrap .search_results:after {
	background-color: {$colors['bg_color']};
	border-left-color: {$colors['bd_color']};
	border-top-color: {$colors['bd_color']};
}
.search_wrap .search_results .search_results_close {
	color: {$colors['text_light']};
}
.search_wrap .search_results .search_results_close:hover {
	color: {$colors['text_dark']};
}
.search_results.widget_area .post_item + .post_item {
	border-top-color: {$colors['bd_color']};
}


/* Page title and breadcrumbs */
.sc_layouts_title .sc_layouts_title_meta,
.sc_layouts_title .post_meta,
.sc_layouts_title .post_meta_item,
.sc_layouts_title .post_meta_item a,
.sc_layouts_title .post_meta_item:before,
.sc_layouts_title .post_meta_item:after,
.sc_layouts_title .post_meta_item:hover:before,
.sc_layouts_title .post_meta_item:hover:after,
.sc_layouts_title .post_meta_item.post_categories,
.sc_layouts_title .post_meta_item.post_categories a,
.sc_layouts_title .post_date a,
.sc_layouts_title .post_date:before,
.sc_layouts_title .post_date:after,
.sc_layouts_title .post_info .post_info_item,
.sc_layouts_title .post_info .post_info_item a,
.sc_layouts_title .post_info_counters .post_counters_item,
.sc_layouts_title .post_counters .socials_share .socials_caption:before,
.sc_layouts_title .post_counters .socials_share .socials_caption:hover:before {
	color: {$colors['text_dark']};
}
.sc_layouts_title .post_date a:hover,
.sc_layouts_title .post_date:hover:after,
.sc_layouts_title a.post_meta_item:hover,
.sc_layouts_title a.post_meta_item:hover:before,
.sc_layouts_title .post_meta_item a:hover,
.sc_layouts_title .post_meta_item a:hover:before,
.sc_layouts_title .post_meta_item.post_categories a:hover,
.sc_layouts_title .post_info .post_info_item a:hover,
.sc_layouts_title .post_info_counters .post_counters_item:hover {
	color: {$colors['text_light']};
}

.sc_layouts_title .sc_layouts_title_description {
	color: {$colors['text_dark']};
}
.sc_layouts_title_breadcrumbs {
	color: {$colors['text']};
}
.sc_layouts_title_breadcrumbs a {
	color: {$colors['text_link2']} !important;
}
.sc_layouts_title_breadcrumbs a:hover {
	color: {$colors['text_hover2']} !important;
}


/* Menu */
.sc_layouts_menu_nav > li > a {
	color: {$colors['text_dark']};
}
.sc_layouts_menu_nav > li > a:hover,
.sc_layouts_menu_nav > li.sfHover > a {
	color: {$colors['text_dark']} !important;
}
.sc_layouts_menu_nav > li.current-menu-item > a,
.sc_layouts_menu_nav > li.current-menu-parent > a,
.sc_layouts_menu_nav > li.current-menu-ancestor > a {
	color: {$colors['text_dark']} !important;
}
.sc_layouts_menu_nav .menu-collapse > a:before {
	color: {$colors['alter_text']};
}
.sc_layouts_menu_nav .menu-collapse > a:after {
	background-color: {$colors['alter_bg_color']};
}
.sc_layouts_menu_nav .menu-collapse > a:hover:before {
	color: {$colors['alter_link']};
}
.sc_layouts_menu_nav .menu-collapse > a:hover:after {
	background-color: {$colors['alter_bg_hover']};
}

.sc_layouts_menu_nav > li.current-menu-item > a span:after, 
.sc_layouts_menu_nav > li > a:hover span:after, 
.sc_layouts_menu_nav > li.current-menu-parent > a span:after, 
.sc_layouts_menu_nav > li.current-menu-ancestor > a span:after {
	border-color: {$colors['text_link']} !important;
}
/* Submenu */
.sc_layouts_menu_popup .sc_layouts_menu_nav,
.sc_layouts_menu_nav > li ul {
	background-color: {$colors['extra_bg_hover']};
}
.sc_layouts_menu_popup .sc_layouts_menu_nav > li > a,
.sc_layouts_menu_nav > li li > a {
}
.sc_layouts_menu_popup .sc_layouts_menu_nav > li > a:hover,
.sc_layouts_menu_popup .sc_layouts_menu_nav > li.sfHover > a,
.sc_layouts_menu_nav > li li > a:hover,
.sc_layouts_menu_nav > li li.sfHover > a {
	color: {$colors['extra_link2']} !important;
}
.sc_layouts_menu_nav li[class*="columns-"] li.menu-item-has-children > a:hover,
.sc_layouts_menu_nav li[class*="columns-"] li.menu-item-has-children.sfHover > a {
	color: {$colors['extra_text']} !important;
	background-color: transparent;
}
.sc_layouts_menu_nav > li li[class*="icon-"]:before {
	color: {$colors['extra_hover']};
}
.sc_layouts_menu_nav > li li[class*="icon-"]:hover:before,
.sc_layouts_menu_nav > li li[class*="icon-"].shHover:before {
	color: {$colors['extra_hover']};
}
.sc_layouts_menu_nav > li li.current-menu-item > a,
.sc_layouts_menu_nav > li li.current-menu-parent > a,
.sc_layouts_menu_nav > li li.current-menu-ancestor > a {
	color: {$colors['extra_link2']} !important;
}
.sc_layouts_menu_nav > li li.current-menu-item:before,
.sc_layouts_menu_nav > li li.current-menu-parent:before,
.sc_layouts_menu_nav > li li.current-menu-ancestor:before {
	color: {$colors['extra_link2']} !important;
}

/* Mobile menu */
.menu_mobile.header-bg-layer {
	background: {$colors['text_link2']};
}
.scheme_self.menu_side_wrap .menu_side_button {
	color: {$colors['alter_dark']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color_07']};
}
.scheme_self.menu_side_wrap .menu_side_button:hover {
	color: {$colors['inverse_hover']};
	border-color: {$colors['alter_hover']};
	background-color: {$colors['alter_link']};
}
.menu_side_inner,
.menu_mobile_inner {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
}
.menu_mobile_button {
	color: {$colors['text_dark']};
}
.menu_mobile_button:hover {
	color: {$colors['text_link']};
}
.menu_mobile_close:before,
.menu_mobile_close:after {
	border-color: {$colors['alter_dark']};
}
.menu_mobile_close:hover:before,
.menu_mobile_close:hover:after {
	border-color: {$colors['alter_link']};
}
.menu_mobile_inner a,
.menu_mobile_inner .menu_mobile_nav_area li:before {
	color: {$colors['alter_dark']};
}
.menu_mobile_inner a:hover,
.menu_mobile_inner .current-menu-ancestor > a,
.menu_mobile_inner .current-menu-item > a,
.menu_mobile_inner .menu_mobile_nav_area li:hover:before,
.menu_mobile_inner .menu_mobile_nav_area li.current-menu-ancestor:before,
.menu_mobile_inner .menu_mobile_nav_area li.current-menu-item:before {
	color: {$colors['alter_link']};
}
.menu_mobile_inner .search_mobile .search_submit {
	color: {$colors['input_light']};
}
.menu_mobile_inner .search_mobile .search_submit:focus,
.menu_mobile_inner .search_mobile .search_submit:hover {
	color: {$colors['input_dark']};
}

.menu_mobile_inner .social_item .social_icon {
	color: {$colors['alter_link']};
}
.menu_mobile_inner .social_item:hover .social_icon {
	color: {$colors['alter_dark']};
}


/* Menu hovers */

/* fade box */
.menu_hover_fade_box .sc_layouts_menu_nav > a:hover,
.menu_hover_fade_box .sc_layouts_menu_nav > li > a:hover,
.menu_hover_fade_box .sc_layouts_menu_nav > li.sfHover > a {
	color: {$colors['alter_link']};
	background-color: {$colors['alter_bg_color']};
}

/* slide_line */
.menu_hover_slide_line .sc_layouts_menu_nav > li#blob {
	background-color: {$colors['text_link']};
}

/* slide_box */
.menu_hover_slide_box .sc_layouts_menu_nav > li#blob {
	background-color: {$colors['alter_bg_color']};
}

/* zoom_line */
.menu_hover_zoom_line .sc_layouts_menu_nav > li > a:before {
	background-color: {$colors['text_link']};
}

/* path_line */
.menu_hover_path_line .sc_layouts_menu_nav > li:before,
.menu_hover_path_line .sc_layouts_menu_nav > li:after,
.menu_hover_path_line .sc_layouts_menu_nav > li > a:before,
.menu_hover_path_line .sc_layouts_menu_nav > li > a:after {
	background-color: {$colors['text_link']};
}

/* roll_down */
.menu_hover_roll_down .sc_layouts_menu_nav > li > a:before {
	background-color: {$colors['text_link']};
}

/* color_line */
.menu_hover_color_line .sc_layouts_menu_nav > li > a:before {
	background-color: {$colors['text_dark']};
}
.menu_hover_color_line .sc_layouts_menu_nav > li > a:after,
.menu_hover_color_line .sc_layouts_menu_nav > li.menu-item-has-children > a:after {
	background-color: {$colors['text_link']};
}
.menu_hover_color_line .sc_layouts_menu_nav > li.sfHover > a,
.menu_hover_color_line .sc_layouts_menu_nav > li > a:hover,
.menu_hover_color_line .sc_layouts_menu_nav > li > a:focus {
	color: {$colors['text_link']};
}


/* VC Separator */
.scheme_self.sc_layouts_row .vc_separator.vc_sep_color_grey .vc_sep_line,
.sc_layouts_row .vc_separator.vc_sep_color_grey .vc_sep_line {
	border-color: {$colors['alter_bd_color']};
}

/* Cart */
.sc_layouts_cart_items_short {
	background-color: {$colors['text_dark']};
	color: {$colors['bg_color']};
}
.sc_layouts_cart_widget {
	border-color: {$colors['bd_color']};
	background-color: {$colors['bg_color']};
	color: {$colors['text']};
}
.sc_layouts_cart_widget:after {
	border-color: {$colors['bd_color']};
	background-color: {$colors['bg_color']};
}
.sc_layouts_cart_widget .sc_layouts_cart_widget_close {
	color: {$colors['text_light']};
}
.sc_layouts_cart_widget .sc_layouts_cart_widget_close:hover {
	color: {$colors['text_dark']};
}

/* Currency Switcher */


.sc_layouts_currency .chosen-container .chosen-results{
	background: {$colors['alter_bg_color']};
	color: {$colors['alter_dark']};
}
.sc_layouts_currency .chosen-container .chosen-results li {
	color: {$colors['alter_dark']};
}
.sc_layouts_currency .chosen-container .active-result.highlighted,
.sc_layouts_currency .chosen-container .active-result.result-selected{
	color: {$colors['alter_link']} !important;
}


/* User styles
------------------------------------------ */
.trx_addons_copyright a{
	color: {$colors['text_link']};
}

.trx_addons_accent,
.trx_addons_accent > a,
.trx_addons_accent > * {
	color: {$colors['text_link']};
}
.trx_addons_accent_2,
.trx_addons_accent_2 > a,
.trx_addons_accent_2 > * {
	color: {$colors['text_link2']};
}
.trx_addons_accent_3,
.trx_addons_accent_3 > a,
.trx_addons_accent_3 > * {
	color: {$colors['text_link3']};
}
.trx_addons_accent_4,
.trx_addons_accent_4 > a,
.trx_addons_accent_4 > * {
	color: {$colors['text_link4']};
}
.trx_addons_accent > a:hover {
	color: {$colors['text_dark']};
}
.sidebar .trx_addons_accent,
.scheme_self.sidebar .trx_addons_accent,
.sidebar .trx_addons_accent > a,
.scheme_self.sidebar .trx_addons_accent > a,
.sidebar .trx_addons_accent > *,
.scheme_self.sidebar .trx_addons_accent > *,
.footer_wrap .trx_addons_accent,
.scheme_self.footer_wrap .trx_addons_accent,
.footer_wrap .trx_addons_accent > a,
.scheme_self.footer_wrap .trx_addons_accent > a,
.footer_wrap .trx_addons_accent > *,
.scheme_self.footer_wrap .trx_addons_accent > * {
}
.sidebar .trx_addons_accent > a:hover,
.scheme_self.sidebar .trx_addons_accent > a:hover,
.footer_wrap .trx_addons_accent > a:hover,
.scheme_self.footer_wrap .trx_addons_accent > a:hover {
}

.trx_addons_hover,
.trx_addons_hover > * {
	color: {$colors['text_hover']};
}
.trx_addons_accent {
	color: {$colors['text_link']};
}
.trx_addons_accent_hover {
	color: {$colors['text_hover']};
}
.trx_addons_accent_bg {
	background-color: {$colors['text_link']};
	color: {$colors['inverse_link']};
}
.trx_addons_accent_2_bg {
	color: {$colors['inverse_hover']};
	background-color: {$colors['text_link2']};
}
.trx_addons_accent_3_bg {
	background-color: {$colors['text_link3']};
	color: {$colors['inverse_hover']};
}
.trx_addons_accent_4_bg {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link4']};
}
.trx_addons_inverse {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
.trx_addons_dark,
.trx_addons_dark > a {
	color: {$colors['text_dark']};
}
.trx_addons_dark > a:hover {
	color: {$colors['text_link']};
}

.trx_addons_inverse,
.trx_addons_inverse > a {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
.trx_addons_inverse > a:hover {
	color: {$colors['inverse_hover']};
}

.trx_addons_dropcap_style_1 {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.trx_addons_dropcap_style_2 {
	color: {$colors['text_link4']};
	background-color: transparent;
}


.trx_addons_list_number > li:before{
	color: {$colors['text_link']};
}
ul.trx_addons_list_triangle > li:before{
	border-color: transparent transparent {$colors['text_link2']} transparent;
}
ul.trx_addons_list_circles > li:after {
	border-color: {$colors['text_dark']};
}
ul.trx_addons_list_circles > li:before {
	background-color: {$colors['text_link']};
}
ul[class*="trx_addons_list"] > li:before {
	color: {$colors['text_link']};
}
ul[class*="trx_addons_list"][class*="_circled"] > li:before {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.trx_addons_list_parameters > li + li {
	border-color: {$colors['bd_color']};
}

.trx_addons_tooltip {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}
.trx_addons_tooltip:before {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
.trx_addons_tooltip:after {
	border-top-color: {$colors['text_dark']};
}

blockquote.trx_addons_blockquote_style_1:before,
blockquote.trx_addons_blockquote_style_1 {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
blockquote.trx_addons_blockquote_style_1 b {
	color: {$colors['bg_color']};
}
blockquote.trx_addons_blockquote_style_1 a,
blockquote.trx_addons_blockquote_style_1 cite {
	color: {$colors['text_link']};
}
blockquote.trx_addons_blockquote_style_1 a:hover {
	color: {$colors['bg_color']};
}
blockquote.trx_addons_blockquote_style_2 {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
blockquote.trx_addons_blockquote_style_2:before,
blockquote.trx_addons_blockquote_style_2 a,
blockquote.trx_addons_blockquote_style_2 cite {
	color: {$colors['inverse_link']};
}
blockquote.trx_addons_blockquote_style_2 a:hover {
	color: {$colors['inverse_hover']};
}

.trx_addons_hover_mask {
	background-color: {$colors['extra_bg_color_07']};
}
.trx_addons_hover_title {
	color: {$colors['extra_dark']};
}
.trx_addons_hover_text {
	color: {$colors['extra_text']};
}
.trx_addons_hover_icon,
.trx_addons_hover_links a {
	color: {$colors['inverse_link']};
	background-color: {$colors['extra_link']};
}
.trx_addons_hover_icon:hover,
.trx_addons_hover_links a:hover {
	color: {$colors['inverse_hover']} !important;
	background-color: {$colors['extra_hover']};
}


/* Tabs */
.widget .trx_addons_tabs .trx_addons_tabs_titles li a {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bd_color']};
}
.widget .trx_addons_tabs .trx_addons_tabs_titles li.ui-state-active a,
.widget .trx_addons_tabs .trx_addons_tabs_titles li a:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['alter_link']};
}


/* Posts slider */
.slider_swiper .slide_info.slide_info_large {
	background-color: {$colors['bg_color_07']};
}
.slider_swiper .slide_info.slide_info_large:hover {
	background-color: {$colors['bg_color']};
}
.slider_swiper .slide_info.slide_info_large .slide_cats a {
	color: {$colors['text_link']};
}
.slider_swiper .slide_info.slide_info_large .slide_title a {
	color: {$colors['text_dark']};
}
.slider_swiper .slide_info.slide_info_large .slide_date {
	color: {$colors['text']};
}
.slider_swiper .slide_info.slide_info_large:hover .slide_date {
	color: {$colors['text_light']};
}
.slider_swiper .slide_info.slide_info_large .slide_cats a:hover,
.slider_swiper .slide_info.slide_info_large .slide_title a:hover {
	color: {$colors['text_hover']};
}
.slider_swiper.slider_multi .slide_cats a:hover,
.slider_swiper.slider_multi .slide_title a:hover,
.slider_swiper.slider_multi a:hover .slide_title {
	color: {$colors['text_hover']};
}

.sc_slider_controls .slider_controls_wrap > a,
.slider_swiper.slider_controls_side .slider_controls_wrap > a,
.slider_outer_controls_side .slider_controls_wrap > a {
	color: {$colors['inverse_link']};
	background-color: {$colors['extra_bd_hover']};
	border-color: {$colors['extra_bd_hover']};
}
.sc_slider_controls .slider_controls_wrap > a:hover,
.slider_swiper.slider_controls_side .slider_controls_wrap > a:hover,
.slider_outer_controls_side .slider_controls_wrap > a:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}

.post_format_gallery .sc_slider_controls .slider_controls_wrap > a,
.post_format_gallery .slider_swiper.slider_controls_side .slider_controls_wrap > a,
.post_format_gallery .slider_outer_controls_side .slider_controls_wrap > a,
.sc_widget_slider .sc_slider_controls .slider_controls_wrap > a,
.sc_widget_slider .slider_swiper.slider_controls_side .slider_controls_wrap > a,
.sc_widget_slider .slider_outer_controls_side .slider_controls_wrap > a {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}
.post_format_gallery .sc_slider_controls .slider_controls_wrap > a:hover,
.post_format_gallery .slider_swiper.slider_controls_side .slider_controls_wrap > a:hover,
.post_format_gallery .slider_outer_controls_side .slider_controls_wrap > a:hover,
.sc_widget_slider .sc_slider_controls .slider_controls_wrap > a:hover,
.sc_widget_slider .slider_swiper.slider_controls_side .slider_controls_wrap > a:hover,
.sc_widget_slider .slider_outer_controls_side .slider_controls_wrap > a:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link2']};
	border-color: {$colors['text_link2']};
}

.slider_swiper.slider_controls_top .slider_controls_wrap > a,
.slider_swiper.slider_controls_bottom .slider_controls_wrap > a,
.slider_outer_controls_top .slider_controls_wrap > a,
.slider_outer_controls_bottom .slider_controls_wrap > a {
	color: {$colors['inverse_link']};
	background-color: {$colors['extra_bd_hover']};
	border-color: {$colors['extra_bd_hover']};
}
.slider_swiper.slider_controls_top .slider_controls_wrap > a:hover,
.slider_swiper.slider_controls_bottom .slider_controls_wrap > a:hover,
.slider_outer_controls_top .slider_controls_wrap > a:hover,
.slider_outer_controls_bottom .slider_controls_wrap > a:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}

.slider_swiper .slider_pagination_wrap .swiper-pagination-bullet,
.slider_swiper_outer .slider_pagination_wrap .swiper-pagination-bullet,
.swiper-pagination-custom .swiper-pagination-button {
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.swiper-pagination-custom .swiper-pagination-button.swiper-pagination-button-active,
.slider_swiper .slider_pagination_wrap .swiper-pagination-bullet.swiper-pagination-bullet-active,
.slider_swiper_outer .slider_pagination_wrap .swiper-pagination-bullet.swiper-pagination-bullet-active,
.slider_swiper .slider_pagination_wrap .swiper-pagination-bullet:hover,
.slider_swiper_outer .slider_pagination_wrap .swiper-pagination-bullet:hover {
	border-color: {$colors['text_link']};
	background-color: {$colors['text_link']};
}
.slider_swiper .swiper-pagination-progress .swiper-pagination-progressbar,
.slider_swiper_outer .swiper-pagination-progress .swiper-pagination-progressbar {
	background-color: {$colors['text_link']};
}
.slider_swiper_outer > .swiper-pagination-fraction {
	color: {$colors['text_dark']};
}

.slider_titles_outside_wrap .slide_title a {
	color: {$colors['text_dark']};
}
.slider_titles_outside_wrap .slide_title a:hover {
	color: {$colors['text_link']};
}
.slider_titles_outside_wrap .slide_cats,
.slider_titles_outside_wrap .slide_subtitle {
	color: {$colors['text_link']};
}

.slider_style_modern .slider_controls_label {
	color: {$colors['bg_color']};
}
.slider_style_modern .slider_pagination_wrap {
	color: {$colors['text_light']};
}
.slider_style_modern .swiper-pagination-current {
	color: {$colors['text_dark']};
}

.sc_slider_controller .swiper-slide.swiper-slide-active {
	border-color: {$colors['text_link']};
}
.sc_slider_controller_titles .swiper-slide {
	background-color: {$colors['alter_bg_color']};
}
.sc_slider_controller_titles .swiper-slide:after {
	background-color: {$colors['alter_bd_color']};
}
.sc_slider_controller_titles .swiper-slide.swiper-slide-active {
	background-color: {$colors['bg_color']};
}
.sc_slider_controller_titles .sc_slider_controller_info_title {
	color: {$colors['alter_dark']};
}
.sc_slider_controller_titles .sc_slider_controller_info_number {
	color: {$colors['alter_light']};
}
.sc_slider_controller_titles .slider_controls_wrap > a {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.sc_slider_controller_titles .slider_controls_wrap > a:hover {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}


/* Widgets 
--------------------------------------------------- */

/* Categories list */
.widget_categories_list .categories_list_style_2 .categories_list_title a:hover {
	color: {$colors['text_dark']};
}

/* Contacts */
.widget_contacts .contacts_info {
	color: {$colors['text_dark']};
}
.widget_contacts .contacts_info span:before {
	color: {$colors['alter_link']};
}
.widget_contacts .contacts_info span a {
	color: {$colors['alter_dark']};
}
.widget_contacts .contacts_info span a:hover {
	color: {$colors['alter_link']};
}
.widget_contacts .contacts_label {
	color: {$colors['text_dark']};
}

/* Recent News */
/* Attention! This widget placed in the content area and should use main text colors */
.sc_recent_news_header {
	border-color: {$colors['text_dark']};
}
.sc_recent_news_header_category_item_more {
	color: {$colors['text_link']};
}
.sc_recent_news_header_more_categories {
	border-color: {$colors['extra_bd_color']};
	background-color:{$colors['extra_bg_color']};
}
.sc_recent_news_header_more_categories > a {
	color:{$colors['extra_link']};
}
.sc_recent_news_header_more_categories > a:hover {
	color:{$colors['extra_hover']};
	background-color:{$colors['extra_bg_hover']};
}
.sc_recent_news .post_counters_item,
.sc_recent_news .post_counters .post_counters_edit a {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link']};
}
.sc_recent_news .post_counters_item:hover,
.sc_recent_news .post_counters .post_counters_edit a:hover {
	color:{$colors['bg_color']};
	background-color:{$colors['text_dark']};
}
.sidebar_inner .sc_recent_news .post_counters_item:hover,
.sidebar_inner .sc_recent_news .post_counters .post_counters_edit a:hover {
	color:{$colors['alter_dark']};
	background-color:{$colors['alter_bg_color']};
}
.sc_recent_news_style_news-magazine .post_accented_border {
	border-color: {$colors['bd_color']};
}
.sc_recent_news_style_news-excerpt .post_item {
	border-color: {$colors['bd_color']};
}

/* Twitter */
.widget_twitter .widget_content .sc_twitter_item,
.widget_twitter .widget_content li {
	color: {$colors['text']};
}
.widget_twitter .widget_content .sc_twitter_item .sc_twitter_item_icon {
	color: {$colors['text_link']} !important;
}
.widget_twitter .swiper-pagination-bullet {
	background-color: {$colors['text_light']};
}
.widget_twitter .swiper-pagination-bullet-active {
	background-color: {$colors['text_link']};
}

.widget_twitter .widget_content .sc_twitter_list li {
	color: {$colors['alter_text']};
}
.widget_twitter .widget_content .sc_twitter_list li:before {
	color: {$colors['alter_link']} !important;
}


/* Shortcodes
--------------------------------------------------- */

.sc_item_subtitle {
	color:{$colors['text_link']};
}
.sc_item_subtitle.sc_item_title_style_shadow {
	color:{$colors['text_light']};
}

.theme_scroll_down:hover {
	color: {$colors['text_link']};
}

.sc_title_alter .sc_item_subtitle {
	color:{$colors['text_link3']};
}

.sc_item_undertitle.subtitle_accent1,
.sc_item_subtitle.subtitle_accent1 {
	color:{$colors['text_link']};
}
.sc_item_undertitle.subtitle_accent2,
.sc_item_subtitle.subtitle_accent2 {
	color:{$colors['text_link2']};
}
.sc_item_undertitle.subtitle_accent3,
.sc_item_subtitle.subtitle_accent3 {
	color:{$colors['text_link3']};
}
.sc_item_undertitle.subtitle_accent4,
.sc_item_subtitle.subtitle_accent4 {
	color:{$colors['text_link4']};
}
.sc_title.sc_title_default .sc_item_descr {
	color:{$colors['inverse_text']};
}

.sc_title.sc_title_huge .sc_item_descr,
.sc_item_title_style_huge + .sc_item_descr {
	color:{$colors['text_dark']};
}

.sc_item_title_style_big + .sc_item_button .sc_button {
	background-color:{$colors['text_link3']};
}
.sc_item_title_style_big + .sc_item_button .sc_button:hover {
	background-color:{$colors['text_hover3']};
}


/* Alter */
.sc_item_button_default.title_alter .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link']};
}
.sc_item_button_default.title_alter .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover']};
}
.sc_item_button_default.title_alter.sc_item_button.button_accent2 .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link2']};
}
.sc_item_button_default.title_alter.sc_item_button.button_accent2 .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover2']};
}
.sc_item_button_default.title_alter.sc_item_button.button_accent3 .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link3']};
}
.sc_item_button_default.title_alter.sc_item_button.button_accent3 .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover3']};
}
.sc_item_button_default.title_alter.sc_item_button.button_accent4 .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link4']};
}
.sc_item_button_default.title_alter.sc_item_button.button_accent4 .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover4']};
}

/* H1 style */
.h1_size.button_accent1 .sc_button {
	color:{$colors['inverse_link']};
}
.h1_size.button_accent1 .sc_button:before {
	background-color:{$colors['text_link']};
}
.h1_size.button_accent2 .sc_button {
	color:{$colors['inverse_dark']};
}
.h1_size.button_accent2 .sc_button:before {
	background-color:{$colors['text_link2']};
}
.h1_size.button_accent3 .sc_button {
	color:{$colors['inverse_dark']};
}
.h1_size.button_accent3 .sc_button:before {
	background-color:{$colors['text_link3']};
}
.h1_size.button_accent4 .sc_button {
	color:{$colors['inverse_link']};
}
.h1_size.button_accent4 .sc_button:before {
	background-color:{$colors['text_link4']};
}


/* style 2 */
.h1_size.style_2 .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link']};
}
.h1_size.style_2 .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover']};
}
.h1_size.style_2.sc_item_button.button_accent2 .sc_button {
	color:{$colors['inverse_dark']};
	background-color:{$colors['text_link2']};
}
.h1_size.style_2.sc_item_button.button_accent2 .sc_button:hover {
	color:{$colors['inverse_dark']};
	background-color:{$colors['text_hover2']};
}
.h1_size.style_2.sc_item_button.button_accent3 .sc_button {
	color:{$colors['inverse_dark']};
	background-color:{$colors['text_link3']};
}
.h1_size.style_2.sc_item_button.button_accent3 .sc_button:hover {
	color:{$colors['inverse_dark']};
	background-color:{$colors['text_hover3']};
}
.h1_size.style_2.sc_item_button.button_accent4 .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link4']};
}
.h1_size.style_2.sc_item_button.button_accent4 .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover4']};
}

/* Modern */
.title_huge .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link']};
}
.title_huge .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover']};
}
.title_huge.sc_item_button.button_accent2 .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link2']};
}
.title_huge.sc_item_button.button_accent2 .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover2']};
}
.title_huge.sc_item_button.button_accent3 .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link3']};
}
.title_huge.sc_item_button.button_accent3 .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover3']};
}
.title_huge.sc_item_button.button_accent4 .sc_button {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_link4']};
}
.title_huge.sc_item_button.button_accent4 .sc_button:hover {
	color:{$colors['inverse_link']};
	background-color:{$colors['text_hover4']};
}

/* Action */
.sc_action_item_default.with_image:after {
	background-color:{$colors['text_link_08']};
}

.sc_action_item_default .sc_action_item_subtitle {
	color:{$colors['text_link3']};
}

.sc_action_item_simple .sc_action_item_subtitle {
	color:{$colors['text_link']};
}

.sc_action_item_simple.with_image  .sc_action_item_subtitle {
	color:{$colors['inverse_link']};
}
.sc_action_item_simple.with_image .sc_action_item_date,
.sc_action_item_simple.with_image .sc_action_item_info {
	color:{$colors['inverse_link']};
	border-color:{$colors['inverse_link']};
}
.sc_action_item_simple.with_image .sc_action_item_description {
	color:{$colors['inverse_link']};
}
.sc_action_item_simple.with_image .sc_action_item_description {
	color:{$colors['inverse_link']};
}
.sc_action_item_event.with_image .sc_action_item_inner {
	background-color:{$colors['bg_color']};
}

.sc_action .sc_action_item_link{
    background-color: transparent;
}
.sc_action.sc_action_simple .sc_action_item_link:hover{
    color: {$colors['inverse_link']};
}
.sc_action.sc_action_simple .sc_action_item_link:before{
    background-color: {$colors['text_link4']};
}
.sc_action.sc_action_simple .sc_action_item_link:after{
    border-color: {$colors['text_dark']};
}

.sc_action_item_simple.with_image:after {
	background-color:{$colors['text_link_08']};
}


/* Anchor */
.scheme_self.menu_side_icons .toc_menu_item .toc_menu_icon,
.menu_side_inner > .toc_menu_item .toc_menu_icon {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['bd_color']};
	color: {$colors['text_link2']};
}
.scheme_self.menu_side_icons .toc_menu_item:hover .toc_menu_icon,
.scheme_self.menu_side_icons .toc_menu_item_active .toc_menu_icon,
.menu_side_inner > .toc_menu_item:hover .toc_menu_icon,
.menu_side_inner > .toc_menu_item_active .toc_menu_icon {
	color: {$colors['inverse_link']};
}
.scheme_self.menu_side_icons .toc_menu_icon_default:before,
.menu_side_inner > .toc_menu_icon_default:before {
	background-color: {$colors['alter_link']};
}
.scheme_self.menu_side_icons .toc_menu_item:hover .toc_menu_icon_default:before,
.scheme_self.menu_side_icons .toc_menu_item_active .toc_menu_icon_default:before,
.menu_side_inner > .toc_menu_item:hover .toc_menu_icon_default:before,
.menu_side_inner > .toc_menu_item_active .toc_menu_icon_default:before {
	background-color: {$colors['alter_dark']};
}
.scheme_self.menu_side_icons .toc_menu_item .toc_menu_description,
.menu_side_inner > .toc_menu_item .toc_menu_description {
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_link']};
}

.scheme_self.menu_side_dots #toc_menu .toc_menu_item .toc_menu_icon {
	background-color: {$colors['alter_bg_color']};
	color: {$colors['alter_text']};
}
.scheme_self.menu_side_dots #toc_menu .toc_menu_item:hover .toc_menu_icon,
.scheme_self.menu_side_dots #toc_menu .toc_menu_item_active .toc_menu_icon {
	color: {$colors['alter_link']};
}
.menu_side_dots .toc_menu_description,
.scheme_self.menu_side_dots .toc_menu_description {
	color: {$colors['inverse_hover']};
	background-color: {$colors['alter_link']};
}
.toc_menu_item .toc_menu_description:after,
.scheme_self.toc_menu_item .toc_menu_description:after {
	border-color: transparent transparent transparent {$colors['alter_link']};
}
.scheme_self.menu_side_dots #toc_menu .toc_menu_item .toc_menu_icon:before {
	border-color: {$colors['extra_bd_color']};
	background-color: transparent;
}
.scheme_self.menu_side_dots #toc_menu .toc_menu_item:hover .toc_menu_icon:before,
.scheme_self.menu_side_dots #toc_menu .toc_menu_item_active .toc_menu_icon:before {
	border-color: {$colors['alter_link']};
	background-color: transparent;
}

.menu_side_dots .toc_menu_socials > a,
.scheme_self.menu_side_dots .toc_menu_socials > a {
	color: {$colors['extra_bd_color']};
}
.menu_side_dots .toc_menu_socials > a:hover,
.scheme_self.menu_side_dots .toc_menu_socials > a:hover {
	color: {$colors['alter_link']};
}

/* Blogger */
.sc_blogger.slider_swiper .swiper-pagination-bullet {
	border-color: {$colors['text_light']};
}

.sc_blogger_item {
	background-color: {$colors['alter_bg_color']};
}
.sc_blogger_post_meta {
	color: {$colors['alter_light']};
}
.sc_blogger_item_title a {
	color: {$colors['alter_dark']};
}
.sc_blogger_item_title a:hover {
	color: {$colors['alter_link']};
}
.sc_blogger_post_meta {
	color: {$colors['alter_light']};
}
.sc_blogger_item_content {
	color: {$colors['alter_text']};
}
.sc_blogger_item .more-link {
	color: {$colors['alter_link']};
}
.sc_blogger_item .more-link:hover {
	color: {$colors['alter_dark']};
}

.sc_blogger_classic .sc_blogger_item {
	background-color: {$colors['bg_color']};
}

.post_featured_date:after,
.sc_blogger_classic .post_featured_date:after{
	border-color: {$colors['text_dark']};

}
.post_featured_date:before,
.sc_blogger_classic .post_featured_date:before {
	background-color: {$colors['text_link4']};
}

.post_featured_date .post_featured_date_day,
.post_featured_date .post_featured_date_month,
.sc_blogger_classic .post_featured_date .post_featured_date_day,
.sc_blogger_classic .post_featured_date .post_featured_date_month {
	color: {$colors['inverse_link']};
}

/* button */
.more-link {
	color: {$colors['inverse_link']};
}

.more-link:before,
.sc_button_default.button_color_1:before {
	background-color: {$colors['text_link']};
}

.more-link:after,
.sc_button.sc_button_default:after {
	border-color: {$colors['text_dark']};
}

.more-link:hover {
	color: {$colors['inverse_link']};
}

.sc_action.sc_action_simple .sc_action_item_link, 
.sc_button.sc_button_default {
	color: {$colors['inverse_link']};
}

.sc_button_default.button_color_2:before{
	background-color: {$colors['text_link2']};
}
.sc_button_default.button_color_3:before{
	background-color: {$colors['text_link3']};
}
.sc_button_default.button_color_4:before{
	background-color: {$colors['text_link4']};
}

/* Cars */
.sc_cars_columns_1 .sc_cars_item {
	background-color: {$colors['alter_bg_color']};
}
.sc_cars_item_status > a,
.sc_cars_item_type > a,
.sc_cars_item_compare {
	color: {$colors['text_light']};
}
.sc_cars_item_compare.in_compare_list {
	color: {$colors['text_link']};
}
.sc_cars_item_status > a:hover,
.sc_cars_item_type > a:hover,
.sc_cars_item_compare:hover,
.sc_cars_item_compare.in_compare_list:hover {
	color: {$colors['text_dark']};
}
.sc_cars_item_options .sc_cars_item_row_address,
.sc_cars_item_options .sc_cars_item_row_meta {
	color: {$colors['text_light']};
}
.cars_page_title .cars_page_status > a {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.cars_page_title .cars_page_status > a:hover {
	color: {$colors['inverse_hover']};
	background-color: {$colors['text_link_blend']};
}
.cars_page_title_address {
	color: {$colors['text_light']};
}
.cars_price {
	color: {$colors['text_light']};
}
.cars_page_attachments_list > a:before,
.cars_page_features_list > a:before {
	color: {$colors['text_link']};
}
.cars_page_tabs.trx_addons_tabs .trx_addons_tabs_titles {
	border-color: {$colors['alter_bd_color']};
}
.cars_page_tabs.trx_addons_tabs .trx_addons_tabs_titles li > a {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bg_color']};
	border-bottom-color: {$colors['alter_bd_color']};
}
.cars_page_tabs.trx_addons_tabs .trx_addons_tabs_titles li.ui-state-active > a {
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['bg_color']};
	border-bottom-color: {$colors['bg_color']};
}
.cars_page_tabs.trx_addons_tabs .trx_addons_tabs_titles li:not(.ui-state-active) > a:hover {
	background-color: {$colors['alter_bg_hover']};
	border-color: {$colors['alter_bg_hover']} {$colors['alter_bg_hover']} {$colors['alter_bd_color']};
}

.cars_page_agent_info_position {
	color: {$colors['text_light']};
}
.cars_page_agent_info_address:before,
.cars_page_agent_info_phones > span:before {
	color: {$colors['text_dark']};
}
.cars_page_agent_info_profiles.socials_wrap .social_item .social_icon {
	color: {$colors['text']};
}

.cars_search_form .cars_search_basic .cars_search_show_advanced {
	color: {$colors['input_text']};
}
.cars_search_form .cars_search_basic .cars_search_show_advanced:hover {
	color: {$colors['input_dark']};
}

.sc_cars_compare_data .cars_feature_present {
	color: {$colors['text_link']};
}


/* Content area */
.sc_content_number {
	color: {$colors['alter_bg_hover']};
}


/* Countdown */
.sc_countdown_default .sc_countdown_digits span {
	color: {$colors['inverse_link']};
	border-color: {$colors['text_hover']};
	background-color: {$colors['text_link']};
}
.sc_countdown_circle .sc_countdown_digits {
	color: {$colors['alter_link']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}

/* Courses */
.sc_courses.slider_swiper .swiper-pagination-bullet {
	border-color: {$colors['text_light']};
}

.sc_courses_default .sc_courses_item {
	background-color: {$colors['alter_bg_color']};
}
.sc_courses_default .sc_courses_item_categories {
	background-color: {$colors['alter_dark']};
}
.sc_courses_default .sc_courses_item_categories a {
	color: {$colors['bg_color']};
}
.sc_courses_default .sc_courses_item_categories a:hover {
	color: {$colors['alter_link']};
}
.sc_courses_default .sc_courses_item_meta {
	color: {$colors['alter_light']};
}
.sc_courses_default .sc_courses_item_date {
	color: {$colors['alter_dark']};
}
.sc_courses_default .sc_courses_item_price {
	color: {$colors['alter_link']};
}
.sc_courses_default .sc_courses_item_period {
	color: {$colors['alter_light']};
}
.courses_single .courses_page_meta {
	color: {$colors['text_light']};
}
.courses_single .courses_page_meta_item_date {
	color: {$colors['text_dark']};
}
.courses_single .courses_page_period {
	color: {$colors['text_light']};
}


/* Dishes */
.sc_dishes_default .sc_dishes_item {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
}
.sc_dishes_default .sc_dishes_item_subtitle,
.sc_dishes_default .sc_dishes_item_subtitle a {
	color: {$colors['alter_link']};
}
.sc_dishes_default .sc_dishes_item_subtitle a:hover {
	color: {$colors['alter_hover']};
}
.sc_dishes_default .sc_dishes_item_featured_left,
.sc_dishes_default .sc_dishes_item_featured_right {
	color: {$colors['text']};
	background-color: transparent;
}
.sc_dishes_default .sc_dishes_item_featured_left .sc_dishes_item_subtitle,
.sc_dishes_default .sc_dishes_item_featured_right .sc_dishes_item_subtitle {
	color: {$colors['text_link']};
}

.sc_dishes_compact .sc_dishes_item {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
}
.sc_dishes_compact .sc_dishes_item_header {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
.sc_dishes_compact .sc_dishes_item_price,
.sc_dishes_compact .sc_dishes_item_subtitle a {
	color: {$colors['bg_color']};
}
.sc_dishes_compact .sc_dishes_item_price:hover,
.sc_dishes_compact .sc_dishes_item:hover .sc_dishes_item_price,
.sc_dishes_compact .sc_dishes_item_subtitle a:hover,
.sc_dishes_compact .sc_dishes_item:hover .sc_dishes_item_subtitle a {
	color: {$colors['text_link']};
}
.sc_dishes_compact .sc_dishes_item_title a {
	color: {$colors['text_link']};
}
.sc_dishes_compact .sc_dishes_item_title a:hover,
.sc_dishes_compact .sc_dishes_item:hover .sc_dishes_item_title a {
	color: {$colors['bg_color']};
}
.sc_dishes.slider_swiper .swiper-pagination-bullet {
	border-color: {$colors['text_light']};
}


/* Events */
.sc_events.slider_swiper .swiper-pagination-bullet {
	border-color: {$colors['text_light']};
}

.sc_events_default .sc_events_item {
	background-color: {$colors['alter_bg_color']};
}
.sc_events_default .sc_events_item_date {
	background-color: {$colors['alter_link']};
	color: {$colors['inverse_link']};
}
.sc_events_default .sc_events_item:hover .sc_events_item_date {
	background-color: {$colors['alter_dark']};
}
.sc_events_default .sc_events_item_title {
	color: {$colors['alter_dark']};
}
.sc_events_default .sc_events_item:hover .sc_events_item_title {
	color: {$colors['alter_link']};
}
.sc_events_default .sc_events_item_button {
	color: {$colors['alter_link']};
}
.sc_events_default .sc_events_item:hover .sc_events_item_button {
	color: {$colors['alter_dark']};
}

.sc_events_detailed .sc_events_item,
.sc_events_detailed .sc_events_item_date_wrap,
.sc_events_detailed .sc_events_item_time_wrap:before,
.sc_events_detailed .sc_events_item_button_wrap:before {
	border-color: {$colors['text_link']};
}
.sc_events_detailed .sc_events_item_date,
.sc_events_detailed .sc_events_item_button {
	color: {$colors['text_link']};
}
.sc_events_detailed .sc_events_item_title {
	color: {$colors['text_dark']};
}
.sc_events_detailed .sc_events_item_time {
	color: {$colors['text']};
}
.sc_events_detailed .sc_events_item:hover {
	background-color: {$colors['text_link']};
	color: {$colors['inverse_link']};
}
.sc_events_detailed .sc_events_item:hover,
.sc_events_detailed .sc_events_item:hover .sc_events_item_date,
.sc_events_detailed .sc_events_item:hover .sc_events_item_button,
.sc_events_detailed .sc_events_item:hover .sc_events_item_title,
.sc_events_detailed .sc_events_item:hover .sc_events_item_time {
	color: {$colors['inverse_hover']};
}
.sc_events_detailed .sc_events_item:hover,
.sc_events_detailed .sc_events_item:hover .sc_events_item_date_wrap,
.sc_events_detailed .sc_events_item:hover .sc_events_item_time_wrap:before,
.sc_events_detailed .sc_events_item:hover .sc_events_item_button_wrap:before {
	border-color: {$colors['inverse_hover']};
}

/* Form */
.scheme_self.sc_form {
	background-color: {$colors['bg_color']};
}
.sc_form_field_title {
	color: {$colors['text_dark']};
}
.sc_form .sc_form_info_icon {
	color: {$colors['text_link']};
}
.sc_form .sc_form_info_data > a,
.sc_form .sc_form_info_data > span {
	color: {$colors['text_dark']};
}
.sc_form .sc_form_info_data > a:hover {
	color: {$colors['text_link']};
}

.wpcf7-form .wpcf7-form-control-wrap:after,
.sc_form_default .sc_form_field_wrap:after {
	border-color: transparent;
}
.sc_form_default .sc_form_field_wrap.field_focus:after {
	border-color: {$colors['text_dark']};
}

.wpcf7-form .label_accent .cf7_field_title,
.sc_form_default .label_accent .sc_form_field_title{
	color: {$colors['text_link']};
}

.wpcf7-form input[type="submit"],
.sc_form_default .sc_form_field_button button:before {
	background-color: {$colors['text_link']};
}
.sc_form_default .sc_form_field_button button:after{
	border-color: {$colors['text_dark']};
}

.wpcf7-form input[type="submit"][disabled] {
    border-color: {$colors['text_dark']} !important;
}

.wpcf7-form input[type="submit"] {
    border-color: {$colors['text_link']} !important;
}

.wpcf7-form input[type="submit"]:hover {
    border-color: {$colors['text_dark']} !important;
    color: {$colors['bg_color']};
}

/* input hovers */
[class*="sc_input_hover_"] .sc_form_field_content {
	color: {$colors['text_dark']};
}
.sc_input_hover_accent input[type="text"]:focus,
.sc_input_hover_accent input[type="number"]:focus,
.sc_input_hover_accent input[type="email"]:focus,
.sc_input_hover_accent input[type="password"]:focus,
.sc_input_hover_accent input[type="search"]:focus,
.sc_input_hover_accent select:focus,
.sc_input_hover_accent textarea:focus {
	border-color: {$colors['text_link']} !important;
}
.sc_input_hover_accent .sc_form_field_hover:before {
	color: {$colors['text_link_02']};
}

.sc_input_hover_path .sc_form_field_graphic {
	stroke: {$colors['input_bd_color']};
}

.sc_input_hover_jump .sc_form_field_content {
	color: {$colors['input_dark']};
}
.sc_input_hover_jump .sc_form_field_content:before {
	color: {$colors['text_link']};
}
.sc_input_hover_jump input[type="text"],
.sc_input_hover_jump input[type="number"],
.sc_input_hover_jump input[type="email"],
.sc_input_hover_jump input[type="password"],
.sc_input_hover_jump input[type="search"],
.sc_input_hover_jump textarea {
	border-color: {$colors['input_bd_color']};
}
.sc_input_hover_jump input[type="text"]:focus,
.sc_input_hover_jump input[type="number"]:focus,
.sc_input_hover_jump input[type="email"]:focus,
.sc_input_hover_jump input[type="password"]:focus,
.sc_input_hover_jump input[type="search"]:focus,
.sc_input_hover_jump textarea:focus {
	border-color: {$colors['text_link']} !important;
}

.sc_input_hover_underline .sc_form_field_hover:before {
	background-color: {$colors['input_bd_color']};
}
.sc_input_hover_underline input:focus + .sc_form_field_hover:before,
.sc_input_hover_underline textarea:focus + .sc_form_field_hover:before,
.sc_input_hover_underline input.filled + .sc_form_field_hover:before,
.sc_input_hover_underline textarea.filled + .sc_form_field_hover:before {
	background-color: {$colors['text_link']};
}
.sc_input_hover_underline .sc_form_field_content {
	color: {$colors['input_dark']};
}
.sc_input_hover_underline input:focus,
.sc_input_hover_underline textarea:focus,
.sc_input_hover_underline input.filled,
.sc_input_hover_underline textarea.filled,
.sc_input_hover_underline input:focus + .sc_form_field_hover > .sc_form_field_content,
.sc_input_hover_underline textarea:focus + .sc_form_field_hover > .sc_form_field_content,
.sc_input_hover_underline input.filled + .sc_form_field_hover > .sc_form_field_content,
.sc_input_hover_underline textarea.filled + .sc_form_field_hover > .sc_form_field_content {
	color: {$colors['text_link']} !important;
}

.sc_input_hover_iconed .sc_form_field_hover {
	color: {$colors['input_text']};
}
.sc_input_hover_iconed input:focus + .sc_form_field_hover,
.sc_input_hover_iconed textarea:focus + .sc_form_field_hover,
.sc_input_hover_iconed input.filled + .sc_form_field_hover,
.sc_input_hover_iconed textarea.filled + .sc_form_field_hover {
	color: {$colors['input_dark']};
}

/* Googlemap */
.sc_googlemap_content,
.scheme_self.sc_googlemap_content {
	color: {$colors['text']};
	background-color: {$colors['bg_color']};
}
.sc_googlemap_content b,
.sc_googlemap_content strong,
.scheme_self.sc_googlemap_content b,
.scheme_self.sc_googlemap_content strong {
	color: {$colors['text_dark']};
}
.sc_googlemap_content_detailed:before {
	color: {$colors['text_link']};
}

/* Icons */
.sc_icons .sc_icons_icon {
	color: {$colors['text_link']};
}
.sc_icons .sc_icons_item_linked:hover .sc_icons_icon {
	color: {$colors['text_dark']};
}
.sc_icons .sc_icons_item_title {
	color: {$colors['text_link']};
}
.scheme_self.footer_wrap .sc_icons .sc_icons_item_title {
	color: {$colors['text_dark']};
}
.scheme_self.footer_wrap .sc_icons .sc_icons_item_description {
	color: {$colors['text']};
}
.sc_icons_item_description,
.sc_icons_modern .sc_icons_item_description {
	color: {$colors['text_dark']};
}


/* Sports: Matches and Players */
.sc_sport_default .sc_sport_item_subtitle .sc_sport_item_date {
	color: {$colors['text_light']};
}

.sc_matches_main .swiper-pagination .swiper-pagination-bullet {
	border-color: {$colors['bd_color']};
}
.sc_matches_main .sc_matches_item_score a {
	color: {$colors['text_dark']};
}
.sc_matches_main .sc_matches_item_score a:hover {
	color: {$colors['text_link']};
}

.sc_matches_other .sc_matches_item_link {
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_bg_color']};
}
.sc_matches_other .sc_matches_item_club {
	color: {$colors['alter_light']};
}
.sc_matches_other .sc_matches_item_date {
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_bd_color']};
}
.sc_matches_other .sc_matches_item_link:hover {
	background-color: {$colors['alter_bg_hover']};
}
.sc_matches_other .sc_matches_item_link:hover .sc_matches_item_date {
	background-color: {$colors['alter_bd_hover']};
}

.sc_points_table td a {
	color: {$colors['alter_dark']};
}
.sc_points_table tr:hover td {
	background-color: {$colors['alter_hover']} !important;
}
.sc_points_table tr:hover a,
.sc_points_table td a:hover {
	color: {$colors['inverse_hover']} !important;
}
.sc_points_table tr.sc_points_table_accented_top td {
	background-color: {$colors['text_link_07']};
}
.sc_points_table tr.sc_points_table_accented_bottom td {
	background-color: {$colors['alter_bg_color']};
}


/* Price */
.sc_price {
	color: {$colors['text']};
	background-color: {$colors['bg_color']};
}
.scheme_self.sc_price {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
}
.sc_price .sc_price_icon {
	color: {$colors['extra_link']};
}
.sc_price:hover .sc_price_icon {
	color: {$colors['extra_hover']};
}
.sc_price .sc_price_label {
	background-color: {$colors['text_link']};
	color: {$colors['inverse_link']};
}
.sc_price .sc_price_label:after {
	border-color: {$colors['text_dark']};
}
.sc_price:hover .sc_price_label {
	background-color: {$colors['text_link']};
	color: {$colors['inverse_link']};
}
.sc_price_info .sc_price_subtitle {
	color: {$colors['extra_dark']};
}
.sc_price .sc_price_bg_title[class*="sc_price_bg_"] a:hover{
	color: {$colors['inverse_link']};
}
.sc_price .sc_price_bg_title.sc_price_bg_default{
	background-color: {$colors['inverse_dark']};
}
.sc_price .sc_price_bg_title.sc_price_bg_default a:hover{
	background-color: {$colors['text_link']};
}
.sc_price .sc_price_bg_title.sc_price_bg_1{
	background-color: {$colors['text_link']};
}
.sc_price .sc_price_bg_title.sc_price_bg_1 a:hover{
	background-color: {$colors['text_hover']};
}
.sc_price .sc_price_bg_title.sc_price_bg_2{
	background-color: {$colors['text_link2']};
}
.sc_price .sc_price_bg_title.sc_price_bg_2 a:hover{
	background-color: {$colors['text_hover2']};
}
.sc_price .sc_price_bg_title.sc_price_bg_3{
	background-color: {$colors['text_link3']};
}
.sc_price .sc_price_bg_title.sc_price_bg_3 a:hover{
	background-color: {$colors['text_hover3']};
}
.sc_price .sc_price_bg_title.sc_price_bg_4{
	background-color: {$colors['text_link4']};
}
.sc_price .sc_price_bg_title.sc_price_bg_4 a:hover{
	background-color: {$colors['text_hover4']};
}

.sc_price .sc_price_title,
.sc_price .sc_price_title a {
	color: {$colors['extra_text']};
}
.sc_price .sc_price_title a:hover {
	color: {$colors['text_dark']};
}
.sc_price_info .sc_price_price {
	color: {$colors['text_dark']};
}
.sc_price_info .sc_price_description,
.sc_price_info .sc_price_details {
	color: {$colors['text']};
}

/* Promo */
.sc_promo_icon {
	color:{$colors['text_link']};
}
.sc_promo .sc_promo_title,
.sc_promo .sc_promo_descr {
	color:{$colors['text_dark']};
}
.sc_promo .sc_promo_content {
	color:{$colors['text']};
}
.sc_promo_modern .sc_promo_link2 {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']} !important;
}
.sc_promo_modern .sc_promo_link2:hover {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
.scheme_self.sc_promo .sc_promo_text.trx_addons_stretch_height,
.scheme_self.sc_promo .sc_promo_text_inner {
	background-color: {$colors['alter_bg_color']};
}
.scheme_self.sc_promo .sc_promo_title {
	color:{$colors['alter_link']};
}
.scheme_self.sc_promo .sc_promo_subtitle {
	color:{$colors['alter_hover']};
}
.scheme_self.sc_promo .sc_promo_descr {
	color:{$colors['alter_dark']};
}
.scheme_self.sc_promo .sc_promo_content {
	color:{$colors['alter_text']};
}


/* Properties */
.sc_properties_columns_1 .sc_properties_item {
	background-color: {$colors['alter_bg_color']};
}
.sc_properties_item_status > a,
.sc_properties_item_type > a,
.sc_properties_item_compare {
	color: {$colors['text_light']};
}
.sc_properties_item_compare.in_compare_list {
	color: {$colors['text_link']};
}
.sc_properties_item_status > a:hover,
.sc_properties_item_type > a:hover,
.sc_properties_item_compare:hover,
.sc_properties_item_compare.in_compare_list:hover {
	color: {$colors['text_dark']};
}
.sc_properties_item_options .sc_properties_item_row_address,
.sc_properties_item_options .sc_properties_item_row_meta {
	color: {$colors['text_light']};
}
.properties_page_title .properties_page_status > a {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
.properties_page_title .properties_page_status > a:hover {
	color: {$colors['inverse_hover']};
	background-color: {$colors['text_link_blend']};
}
.properties_page_title_address {
	color: {$colors['text_light']};
}
.properties_price {
	color: {$colors['text_light']};
}
.properties_page_attachments_list > a:before,
.properties_page_features_list > a:before {
	color: {$colors['text_link']};
}
.properties_page_tabs.trx_addons_tabs .trx_addons_tabs_titles {
	border-color: {$colors['alter_bd_color']};
}
.properties_page_tabs.trx_addons_tabs .trx_addons_tabs_titles li > a {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bg_color']};
	border-bottom-color: {$colors['alter_bd_color']};
}
.properties_page_tabs.trx_addons_tabs .trx_addons_tabs_titles li.ui-state-active > a {
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['bg_color']};
	border-bottom-color: {$colors['bg_color']};
}
.properties_page_tabs.trx_addons_tabs .trx_addons_tabs_titles li:not(.ui-state-active) > a:hover {
	background-color: {$colors['alter_bg_hover']};
	border-color: {$colors['alter_bg_hover']} {$colors['alter_bg_hover']} {$colors['alter_bd_color']};
}

.properties_page_agent_info_position {
	color: {$colors['text_light']};
}
.properties_page_agent_info_address:before,
.properties_page_agent_info_phones > span:before {
	color: {$colors['text_dark']};
}
.properties_page_agent_info_profiles.socials_wrap .social_item .social_icon {
	color: {$colors['text']};
}

.properties_search_form .properties_search_basic .properties_search_show_advanced {
	color: {$colors['input_text']};
}
.properties_search_form .properties_search_basic .properties_search_show_advanced:hover {
	color: {$colors['input_dark']};
}

.sc_properties_compare_data .properties_feature_present {
	color: {$colors['text_link']};
}


/* Services */
.sc_services .sc_services_item_number {
	color: {$colors['alter_bg_hover']};
}

.sc_services_default .sc_services_item {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
}
.sc_services_default .sc_services_item_icon {
	color: {$colors['alter_link']};
	border-color: {$colors['alter_link']};
}
.sc_services_default .sc_services_item:hover .sc_services_item_icon {
	color: {$colors['inverse_dark']};
	background-color: {$colors['alter_link']};
	border-color: {$colors['alter_link']};
}
.sc_services_default .sc_services_item_subtitle {
	color: {$colors['alter_link']};
}
.sc_services_default .sc_services_item_featured_left,
.sc_services_default .sc_services_item_featured_right,
.sc_services_list .sc_services_item {
	color: {$colors['text']};
	background-color: transparent;
}
.sc_services_default .sc_services_item_featured_left .sc_services_item_icon,
.sc_services_default .sc_services_item_featured_right .sc_services_item_icon,
.sc_services_list .sc_services_item_icon {
	color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}
.sc_services_list .sc_services_item:hover .sc_services_item_icon {
	color: {$colors['text_hover']};
}
.sc_services_default .sc_services_item_featured_left:hover .sc_services_item_icon,
.sc_services_default .sc_services_item_featured_right:hover .sc_services_item_icon,
.sc_services_list .sc_services_item_featured_left:hover .sc_services_item_icon,
.sc_services_list .sc_services_item_featured_right:hover .sc_services_item_icon {
	color: {$colors['inverse_dark']};
	background-color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}
.sc_services_default .sc_services_item_featured_left .sc_services_item_subtitle,
.sc_services_default .sc_services_item_featured_right .sc_services_item_subtitle {
	color: {$colors['text_link']};
}

.sc_services_light .sc_services_item_icon {
	color: {$colors['text_dark']};
}
.sc_services_light .sc_services_item:hover .sc_services_item_icon {
	color: {$colors['text_link']};
}

.sc_services_light .sc_button.sc_button_underline{
	border-color: {$colors['text_link4']} !important;
	background-color: {$colors['bg_color_0']} !important;
}
.sc_services_light .sc_button.sc_button_underline:hover{
	color: {$colors['text_link4']}!important;
}

.sc_services_callouts .sc_services_item {
	background-color:{$colors['alter_bg_color']};
}
.sc_services_callouts .sc_services_item_marker {
	border-color: {$colors['bg_color']};
	background-color:{$colors['alter_link']};
	color: {$colors['inverse_link']};
}
.sc_services_callouts .sc_services_item .sc_services_item_marker_back {
	border-color: {$colors['bg_color']};
	background-color:{$colors['alter_hover']};
	color: {$colors['inverse_hover']};
}
.sc_services_callouts .sc_services_item_marker_bg {
	border-color: {$colors['bg_color']};
	background-color:{$colors['bg_color']};
}

.sc_services_timeline .sc_services_item_timeline {
	border-color: {$colors['bd_color']};
}
.sc_services_timeline .sc_services_item_marker {
	border-color: {$colors['text_link']};
	background-color:{$colors['text_link']};
	color: {$colors['inverse_link']};
}
.sc_services_timeline .sc_services_item:hover .sc_services_item_marker {
	border-color: {$colors['text_hover']};
	background-color:{$colors['text_hover']};
	color: {$colors['inverse_hover']};
}

.sc_services_iconed .sc_services_item {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
}
.sc_services_iconed .sc_services_item_icon:hover,
.sc_services_iconed .sc_services_item:hover .sc_services_item_icon,
.sc_services_iconed .sc_services_item_header .sc_services_item_subtitle a:hover,
.sc_services_iconed .sc_services_item:hover .sc_services_item_header .sc_services_item_subtitle a {
	color: {$colors['text_link']};
}
.sc_services_iconed .sc_services_item_header .sc_services_item_title a {
	color: {$colors['text_link']};
}
.sc_services_iconed .sc_services_item_header .sc_services_item_title a:hover,
.sc_services_iconed .sc_services_item:hover .sc_services_item_header .sc_services_item_title a {
	color: #fff;
}
.sc_services_iconed .sc_services_item .sc_services_item_header .sc_services_item_subtitle a {
	color: #fff;
}
.sc_services_iconed .sc_services_item:hover .sc_services_item_header .sc_services_item_subtitle a,
.sc_services_iconed .sc_services_item .sc_services_item_header .sc_services_item_subtitle a:hover {
	color: {$colors['text_link']};
}
.sc_services_iconed .sc_services_item_content .sc_services_item_title a {
	color: {$colors['alter_dark']};
}
.sc_services_iconed .sc_services_item_content .sc_services_item_title a:hover,
.sc_services_iconed .sc_services_item:hover .sc_services_item_content .sc_services_item_title a {
	color: {$colors['alter_link']};
}
.sc_services.slider_swiper .swiper-pagination-bullet {
	border-color: {$colors['text_light']};
}

.sc_services_list .sc_services_item_featured_left .sc_services_item_number,
.sc_services_list .sc_services_item_featured_right .sc_services_item_number {
	color: {$colors['text_light']};
}

.sc_services_hover .sc_services_item_icon,
.sc_services_hover .sc_services_item_title a:hover,
.sc_services_hover .sc_services_item_subtitle a:hover {
	color: {$colors['text_link']};
}
.sc_services_hover [class*="column-"]:nth-child(2n) .sc_services_item.with_image .sc_services_item_header.without_image,
.sc_services_hover .swiper-slide:nth-child(2n) .sc_services_item.with_image .sc_services_item_header.without_image {
	background-color:{$colors['alter_bg_hover']};
}
.sc_services_hover [class*="column-"]:nth-child(2n+1) .sc_services_item.with_image .sc_services_item_header.without_image,
.sc_services_hover .swiper-slide:nth-child(2n+1) .sc_services_item.with_image .sc_services_item_header.without_image {
	background-color:{$colors['alter_bg_color']};
}
.sc_services_hover .sc_services_item.with_image .sc_services_item_header.without_image .sc_services_item_icon,
.sc_services_hover .sc_services_item.with_image .sc_services_item_header.without_image .sc_services_item_number {
	color: {$colors['alter_light']};
}
.sc_services_hover .sc_services_item.with_image .sc_services_item_header.without_image .sc_services_item_title a {
	color: {$colors['alter_dark']};
}
.sc_services_hover .sc_services_item.with_image:hover .sc_services_item_header.without_image .sc_services_item_title a,
.sc_services_hover .sc_services_item.with_image .sc_services_item_header.without_image .sc_services_item_title a:hover {
	color: {$colors['alter_link']};
}
.sc_services_hover .sc_services_item.with_image .sc_services_item_header.without_image .sc_services_item_subtitle a {
	color: {$colors['alter_link']};
}
.sc_services_hover .sc_services_item.with_image:hover .sc_services_item_header.without_image .sc_services_item_subtitle a,
.sc_services_hover .sc_services_item.with_image .sc_services_item_header.without_image .sc_services_item_subtitle a:hover {
	color: {$colors['alter_dark']};
}
.sc_services_hover .sc_services_item.with_image .sc_services_item_header.without_image .sc_services_item_text {
	color: {$colors['alter_text']};
}

.sc_services_chess .sc_services_item {
	color:{$colors['alter_text']};
	background-color:{$colors['alter_bg_color']};
}
.sc_services_chess .sc_services_item_title a {
	color:{$colors['alter_dark']};
}
.sc_services_chess .sc_services_item_title a:hover {
	color:{$colors['alter_link']};
}
.sc_services_chess .sc_services_item:hover {
	color:{$colors['text_light']};
	background-color:{$colors['text_dark']};
}
.sc_services_chess .sc_services_item:hover .sc_services_item_title a {
	color:{$colors['bg_color']};
}
.sc_services_chess .sc_services_item:hover .sc_services_item_title a:hover {
	color:{$colors['text_link']};
}


.sc_services_tabs_simple .sc_services_item_icon {
	color: {$colors['text_link']};
}
.sc_services_tabs_simple .sc_services_item:hover .sc_services_item_icon,
.sc_services_tabs_simple .sc_services_item:hover .sc_services_item_title,
.sc_services_tabs_simple .sc_services_item:hover .sc_services_item_subtitle,
.sc_services_tabs_simple .sc_services_tabs_list_item_active .sc_services_item_icon,
.sc_services_tabs_simple .sc_services_tabs_list_item_active .sc_services_item_title,
.sc_services_tabs_simple .sc_services_tabs_list_item_active .sc_services_item_subtitle {
	color: {$colors['text_hover']};
}

.sc_services_tabs .sc_services_item_content {
	color:{$colors['alter_text']};
	background-color:{$colors['alter_bg_color']};
}
.sc_services_tabs .sc_services_item_title a {
	color:{$colors['alter_dark']};
}
.sc_services_tabs .sc_services_item_title a:hover {
	color:{$colors['alter_link']};
}
.sc_services_tabs .sc_services_tabs_list_item .sc_services_item_icon {
	color: {$colors['alter_link']};
}
.sc_services_tabs .sc_services_tabs_list_item .sc_services_item_number {
	color: {$colors['alter_light']};
}
.sc_services_tabs .sc_services_tabs_list_item {
	background-color:{$colors['alter_bg_color']};
}
.sc_services_tabs .sc_services_tabs_list_item:nth-child(2n+2) {
	background-color:{$colors['alter_bg_hover']};
}
.sc_services_tabs .sc_services_tabs_list_item:hover,
.sc_services_tabs .sc_services_tabs_list_item:nth-child(2n+2):hover {
	background-color:{$colors['alter_bd_hover']};
}
.sc_services_tabs .sc_services_tabs_list_item .sc_services_item_title {
	color:{$colors['alter_dark']};
}
.sc_services_tabs .sc_services_tabs_list_item:hover .sc_services_item_title {
	color:{$colors['alter_link']};
}
.sc_services_tabs .sc_services_tabs_list_item:hover .sc_services_item_icon {
	color:{$colors['alter_hover']};
}
.sc_services_tabs .sc_services_tabs_list_item:hover .sc_services_item_number {
	color: {$colors['alter_text']};
}
.sc_services_tabs .sc_services_tabs_list_item.sc_services_tabs_list_item_active {
	background-color:{$colors['alter_dark']} !important;
}
.sc_services_tabs .sc_services_tabs_list_item.sc_services_tabs_list_item_active .sc_services_item_title {
	color: {$colors['bg_color']};
}
.sc_services_tabs .sc_services_tabs_list_item.sc_services_tabs_list_item_active .sc_services_item_icon {
	color: {$colors['alter_link']};
}
.sc_services_tabs .sc_services_tabs_list_item.sc_services_tabs_list_item_active .sc_services_item_number {
	color: {$colors['alter_link']};
}


.sc_services.sc_services_slider_type .sc_item_slider.slider_outer_controls_top > .slider_controls_wrap > a, 
.sc_services.sc_services_slider_type .sc_item_slider.slider_outer_controls_bottom > .slider_controls_wrap > a {
	background-color: {$colors['extra_bd_hover']};
}
.sc_services.sc_services_slider_type .sc_item_slider.slider_outer_controls_top > .slider_controls_wrap > a:hover, 
.sc_services.sc_services_slider_type .sc_item_slider.slider_outer_controls_bottom > .slider_controls_wrap > a:hover {
	background-color: {$colors['text_link']};
}

.sc_services.sc_services_slider_type .sc_services_item .sc_services_item_number {
	color: {$colors['inverse_link_025']};
}

.sc_services.sc_services_slider_type .sc_services_item .services_bg {
	background-color: {$colors['text_link']};
}

.sc_services.sc_services_slider_type .sc_services_item .sc_services_item_info{
	background-color: {$colors['bg_color']};
}
.sc_services.sc_services_slider_type .sc_services_item .sc_services_item_info a:hover{
	color: {$colors['text_link']};
}
.sc_services.sc_services_slider_type .sc_services_item .sc_services_item_info .sc_button.sc_button_underline{
	border-color: {$colors['text_link']} !important;
}
.sc_services.sc_services_slider_type .sc_services_item .sc_services_item_info .sc_button.sc_button_underline:hover{
	color: {$colors['text_link']};
	background-color: transparent;
}

.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+2) .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="1"] .sc_services_item .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="5"] .sc_services_item .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="9"] .sc_services_item .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="13"] .sc_services_item .services_bg{
	background-color: {$colors['text_link2']};
}
.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+2) .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="1"] .sc_services_item .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="5"] .sc_services_item .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="9"] .sc_services_item .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="13"] .sc_services_item .sc_services_item_info a:hover{
	color: {$colors['text_link2']};
}
.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+2) .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="1"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="5"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="9"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="13"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline{
	border-color: {$colors['text_link2']} !important;
}
.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+2) .sc_services_item_info .sc_button.sc_button_underline:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="1"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="5"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="9"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="13"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline:hover{
	color: {$colors['text_link2']};
}

.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+3) .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="2"] .sc_services_item .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="6"] .sc_services_item .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="10"] .sc_services_item .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="14"] .sc_services_item .services_bg{
	background-color: {$colors['text_link3']};
}
.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+3) .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="2"] .sc_services_item .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="6"] .sc_services_item .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="10"] .sc_services_item .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="14"] .sc_services_item .sc_services_item_info a:hover{
	color: {$colors['text_link3']};
}
.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+3) .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="2"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="6"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="10"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="14"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline{
	border-color: {$colors['text_link3']} !important;
}
.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+3) .sc_services_item_info .sc_button.sc_button_underline:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="2"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="6"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="10"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="14"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline:hover{
	color: {$colors['text_link3']};
}

.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+4) .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="3"] .sc_services_item .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="7"] .sc_services_item .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="11"] .sc_services_item .services_bg,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="15"] .sc_services_item .services_bg{
	background-color: {$colors['text_link4']};
}
.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+4) .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="3"] .sc_services_item .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="7"] .sc_services_item .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="11"] .sc_services_item .sc_services_item_info a:hover,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="15"] .sc_services_item .sc_services_item_info a:hover{
	color: {$colors['text_link4']};
}
.sc_services.sc_services_slider_type > .sc_services_content > .sc_services_item:nth-child(4n+4) .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="3"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="7"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="11"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline,
.sc_services.sc_services_slider_type .swiper-slide[data-slide-number="15"] .sc_services_item .sc_services_item_info .sc_button.sc_button_underline{
	border-color: {$colors['text_link4']} !important;
}


.sc_services_light .sc_services_columns .sc_services_item .sc_services_item_info .sc_services_item_button .sc_button_underline:hover {
    color: {$colors['text_hover']};
    border-color: {$colors['text_hover']} !important;
    background-color: transparent;
}

/* Skills (Counters) */
.sc_skills.sc_skills_counter .sc_skills_item_wrap {
	background-color:{$colors['extra_link3']};
}

.sc_skills.sc_skills_counter .sc_skills_item_title,
.sc_skills.sc_skills_counter .sc_skills_icon {
	color:{$colors['inverse_link']};
}
.sc_skills .sc_skills_total {
	color:{$colors['text_link2']};
}
.sc_skills .sc_skills_item_title,
.sc_skills .sc_skills_legend_title,
.sc_skills .sc_skills_legend_value {
	color:{$colors['text_dark']};
}
.sc_skills_counter .sc_skills_column + .sc_skills_column:before {
	background-color: {$colors['bd_color']};
}
.sc_skills_pie.sc_skills_compact_off .sc_skills_total {
	color:{$colors['alter_dark']};
}

/* Socials */
.socials_wrap .social_item .social_icon {
	background-color: {$colors['alter_bg_color']};
}
.socials_wrap .social_item .social_icon,
.socials_wrap .social_item .social_icon i {
	color: {$colors['alter_dark']};
}
.socials_wrap .social_item:hover .social_icon {
	background-color: {$colors['alter_bg_hover']};
}
.socials_wrap .social_item:hover .social_icon,
.socials_wrap .social_item:hover .social_icon i {
	color: {$colors['alter_link']};
}
.sidebar_inner .socials_wrap .social_item .social_icon {
	background-color: {$colors['alter_bg_hover']};
}
.sidebar_inner .socials_wrap .social_item:hover .social_icon {
	background-color: {$colors['alter_hover']};
}
.sidebar_inner .socials_wrap .social_item:hover .social_icon,
.sidebar_inner .socials_wrap .social_item:hover .social_icon i {
	color: {$colors['inverse_link']};
}

.socials_wrap .social_item .social_icon{
	color: {$colors['inverse_link']};
}
.socials_wrap .social_item:hover .social_icon,
.socials_wrap .social_item .social_icon:hover{
	color: {$colors['inverse_link']};
}
.socials_wrap .social_item:nth-child(3n+1) .social_icon{
	background-color: {$colors['text_link2']};
}
.socials_wrap .social_item:nth-child(3n+1):hover .social_icon{
	background-color: {$colors['text_hover2']};
}
.socials_wrap .social_item:nth-child(3n+2) .social_icon {
	background-color: {$colors['text_link3']};
}
.socials_wrap .social_item:nth-child(3n+2):hover .social_icon {
	background-color: {$colors['text_link2']};
}
.socials_wrap .social_item:nth-child(3n+3) .social_icon {
	background-color: {$colors['text_link']};
}
.socials_wrap .social_item:nth-child(3n+3):hover .social_icon {
	background-color: {$colors['text_hover']};
}


.top_panel .sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+1) .social_icon,
.top_panel .scheme_self.sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+1) .social_icon {
	background-color: transparent;
	color: {$colors['text_link2']};
}
.top_panel .sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+1):hover .social_icon,
.top_panel .scheme_self.sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+1):hover .social_icon {
	background-color: transparent;
	color: {$colors['text_hover2']};
}
.top_panel .sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+2) .social_icon,
.top_panel .scheme_self.sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+2) .social_icon {
	background-color: transparent;
	color: {$colors['text_link']};
}
.top_panel .sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+2):hover .social_icon,
.top_panel .scheme_self.sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+2):hover .social_icon {
	background-color: transparent;
	color: {$colors['text_hover']};
}
.top_panel .sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+3) .social_icon,
.top_panel .scheme_self.sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+3) .social_icon {
	background-color: transparent;
	color: {$colors['text_link3']};
}
.top_panel .sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+3):hover .social_icon,
.top_panel .scheme_self.sc_layouts_row_type_compact .socials_wrap .social_item:nth-child(3n+3):hover .social_icon {
	background-color: transparent;
	color: {$colors['text_link2']};
}

.footer_wrap .socials_wrap .social_item .social_icon,
.scheme_self.footer_wrap .socials_wrap .social_item .social_icon {
	color: {$colors['inverse_link']};
	background-color: {$colors['alter_link']};
}
.footer_wrap .socials_wrap .social_item:hover .social_icon,
.scheme_self.footer_wrap .socials_wrap .social_item:hover .social_icon {
	color: {$colors['inverse_hover']};
	background-color: {$colors['alter_hover']};
}
.footer_wrap .sc_layouts_row_type_compact .socials_wrap .social_item .social_icon,
.scheme_self.footer_wrap .sc_layouts_row_type_compact .socials_wrap .social_item .social_icon {
	color: {$colors['text_dark']};
	background-color: transparent;
}
.footer_wrap .sc_layouts_row_type_compact .socials_wrap .social_item:hover .social_icon,
.scheme_self.footer_wrap .sc_layouts_row_type_compact .socials_wrap .social_item:hover .social_icon {
	color: {$colors['text_link']};
	background-color: transparent;
}

/* Share */
.socials_share.socials_type_drop .social_item > .social_icon > i {
	color: {$colors['text_light']};
}
.socials_share.socials_type_drop .social_item:hover > .social_icon > i {
	color: {$colors['text_dark']};
}


/* Testimonials */
.sc_testimonials_item_content {
	color: {$colors['text']};
}
.sc_testimonials_item_content:before {
	color: {$colors['alter_bd_color']};
}
.sc_testimonials_item_author_title {
	color: {$colors['text_dark']};
}
.sc_testimonials_item_author_subtitle {
	color: {$colors['text_light']};
}
.sc_testimonials_simple .sc_testimonials_item_author_data:before  {
	background-color: {$colors['text_light']};
}
.sc_testimonials_simple [class*="column"] .sc_testimonials_item_author_data {
	border-color: {$colors['text_light']};
}

/* Team */
.sc_team_default .sc_team_item {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']};
}
.sc_team_default .sc_team_item_subtitle {
	color: {$colors['alter_link']};
}
.sc_team_default .sc_team_item_socials .social_item .social_icon,
.team_member_page .team_member_socials .social_item .social_icon {
	color: {$colors['inverse_link']};
	background-color: {$colors['alter_link']};
}
.sc_team_default .sc_team_item_socials .social_item:hover .social_icon,
.team_member_page .team_member_socials .social_item:hover .social_icon {
	color: {$colors['alter_bg_color']};
	background-color: {$colors['alter_dark']};
}
.sc_team .sc_team_item_thumb .sc_team_item_socials .social_item .social_icon {
	color: {$colors['inverse_link']};
	border-color: {$colors['inverse_link']};
}
.sc_team .sc_team_item_thumb .sc_team_item_socials .social_item:hover .social_icon {
	color: {$colors['text_link']};
	background-color: {$colors['inverse_link']};
}
.team_member_page .team_member_featured .team_member_avatar {
	border-color: {$colors['bd_color']};
}
.sc_team_short .sc_team_item_thumb {
	border-color: {$colors['text_link']};
}
.sc_team.slider_swiper .swiper-pagination-bullet {
	border-color: {$colors['text_light']};
}



/* CPT Sport
--------------------------------------------------- */

.sport_page_list {
	border-color: {$colors['bd_color']};
}
.sport_page_list li+li {
	border-color: {$colors['bd_color']};
}
.sport_page_list li:nth-child(2n+1) {
	background-color: {$colors['alter_bg_color']};
	color: {$colors['alter_text']};
}


/* Utils
--------------------------------------------------- */

/* Scroll to top */
.trx_addons_scroll_to_top,
.trx_addons_cv .trx_addons_scroll_to_top {
	color: {$colors['inverse_link']};
	border-color: {$colors['text_link']};
	background-color: {$colors['text_link']};
}
.trx_addons_scroll_to_top:hover,
.trx_addons_cv .trx_addons_scroll_to_top:hover {
	color: {$colors['inverse_link']};
	border-color: {$colors['text_hover']};
	background-color: {$colors['text_hover']};
}


/* Login and Register */
.trx_addons_popup {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bd_color']};
	color: {$colors['alter_text']};
}
.trx_addons_popup button.mfp-close {
	background-color: {$colors['alter_bg_hover']};
	border-color: {$colors['alter_bd_hover']};
	color:{$colors['alter_text']};
}
.trx_addons_popup button.mfp-close:hover {
	background-color: {$colors['alter_dark']};
	color: {$colors['alter_bg_color']};
}
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title {
	background-color:{$colors['alter_bg_hover']};
	border-color: {$colors['alter_bd_hover']};
}
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title.ui-tabs-active {
	background-color:{$colors['alter_bg_color']};
	border-bottom-color: transparent;
}
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title a,
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title a > i {
	color:{$colors['alter_text']};
}
.trx_addons_popup li.trx_addons_tabs_title a:hover,
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title a:hover > i {
	color:{$colors['alter_link']};
}
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title[data-disabled="true"] a,
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title[data-disabled="true"] a > i,
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title[data-disabled="true"] a:hover,
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title[data-disabled="true"] a:hover > i {
	color:{$colors['alter_light']};
}
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title.ui-tabs-active a,
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title.ui-tabs-active a > i,
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title.ui-tabs-active a:hover,
.trx_addons_popup .trx_addons_tabs_titles li.trx_addons_tabs_title.ui-tabs-active a:hover > i {
	color:{$colors['alter_dark']};
}

/* Profiler */
.trx_addons_profiler {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bd_hover']};
}
.trx_addons_profiler_title {
	color: {$colors['alter_dark']};
}
.trx_addons_profiler table td,
.trx_addons_profiler table th {
	border-color: {$colors['alter_bd_color']};
}
.trx_addons_profiler table td {
	color: {$colors['alter_text']};
}
.trx_addons_profiler table th {
	background-color: {$colors['alter_bg_hover']};
	color: {$colors['alter_dark']};
}


/* CV */
.trx_addons_cv,
.trx_addons_cv_body_wrap {
	color: {$colors['alter_text']};
	background-color:{$colors['alter_bg_color']};
}
.trx_addons_cv a {
	color: {$colors['alter_link']};
}
.trx_addons_cv a:hover {
	color: {$colors['alter_hover']};
}

.trx_addons_cv_header {
	background-color: {$colors['bg_color']};
}
.trx_addons_cv_header_image img {
	border-color: {$colors['text_dark']};
}
.trx_addons_cv_header .trx_addons_cv_header_letter,
.trx_addons_cv_header .trx_addons_cv_header_text {
	color: {$colors['text_dark']};
}
.trx_addons_cv_header .trx_addons_cv_header_socials .social_item > .social_icon {
	color: {$colors['text_dark_07']};	
}
.trx_addons_cv_header .trx_addons_cv_header_socials .social_item:hover > .social_icon {
	color: {$colors['text_dark']};	
}

.trx_addons_cv_header_letter,
.trx_addons_cv_header_text,
.trx_addons_cv_header_socials .social_item > .social_icon {
	text-shadow: 1px 1px 6px {$colors['bg_color']};
}

.trx_addons_cv_tint_dark .trx_addons_cv_header_letter,
.trx_addons_cv_tint_dark .trx_addons_cv_header_text,
.trx_addons_cv_tint_dark .trx_addons_cv_header_socials .social_item > .social_icon {
	color: {$colors['bg_color']};	
	text-shadow: 1px 1px 3px {$colors['text_dark']};
}
.trx_addons_cv_tint_dark .trx_addons_cv_header_socials .social_item:hover > .social_icon {
	color: {$colors['text_hover']};	
}

.trx_addons_cv_navi_buttons .trx_addons_cv_navi_buttons_area .trx_addons_cv_navi_buttons_item {
	color: {$colors['alter_light']};
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['bg_color']};
}
.trx_addons_cv_navi_buttons .trx_addons_cv_navi_buttons_area .trx_addons_cv_navi_buttons_item_active,
.trx_addons_cv_navi_buttons .trx_addons_cv_navi_buttons_area .trx_addons_cv_navi_buttons_item:hover {
	color: {$colors['alter_dark']};
	border-color: {$colors['alter_bg_color']};
}


.trx_addons_cv .trx_addons_cv_section_title,
.trx_addons_cv .trx_addons_cv_section_title a {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_section_title.ui-state-active {
	border-color: {$colors['alter_dark']};
}
.trx_addons_cv_section_content .trx_addons_tabs .trx_addons_tabs_titles li > a {
	color: {$colors['alter_light']};
}
.trx_addons_cv_section_content .trx_addons_tabs .trx_addons_tabs_titles li.ui-state-active > a,
.trx_addons_cv_section_content .trx_addons_tabs .trx_addons_tabs_titles li > a:hover {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_section .trx_addons_pagination > * {
	color:{$colors['alter_text']};
}
.trx_addons_cv_section .trx_addons_pagination > a:hover {
	color: {$colors['alter_dark']};
}
.trx_addons_pagination > span.active {
	color: {$colors['alter_dark']};
	border-color: {$colors['alter_dark']};
}
.trx_addons_cv_breadcrumbs .trx_addons_cv_breadcrumbs_item {
	color: {$colors['alter_light']};
}
.trx_addons_cv_breadcrumbs a.trx_addons_cv_breadcrumbs_item:hover {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_single .trx_addons_cv_single_title {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_single .trx_addons_cv_single_subtitle {
	color: {$colors['alter_light']};
}

.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_2 .trx_addons_cv_resume_column:nth-child(2n+2) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+2) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+3) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+2) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+3) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+4) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_2 .trx_addons_cv_resume_column:nth-child(2n+3) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_2 .trx_addons_cv_resume_column:nth-child(2n+4) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+4) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+5) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+6) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+5) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+6) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+7) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+8) .trx_addons_cv_resume_item {
	border-color: {$colors['alter_bd_color']};
}
.trx_addons_cv_resume_item_meta {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_item .trx_addons_cv_resume_item_title,
.trx_addons_cv_resume_item .trx_addons_cv_resume_item_title a {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_item .trx_addons_cv_resume_item_title a:hover {
	color: {$colors['alter_link']};
}
.trx_addons_cv_resume_item_subtitle {
	color: {$colors['alter_light']};
}
.trx_addons_cv_resume_style_skills .trx_addons_cv_resume_item_skills {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_style_skills .trx_addons_cv_resume_item_skill:after {
	border-color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_style_education .trx_addons_cv_resume_item_number {
	color: {$colors['alter_light']};
}
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_icon {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_icon:hover,
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_text a:hover {
	color: {$colors['text_hover']};
}
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_title > a:hover:after {
	border-color: {$colors['text_hover']};
}
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_title > a:after {
	border-top-color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_text a {
	color: {$colors['alter_dark']};
}

.trx_addons_cv_portfolio_item .trx_addons_cv_portfolio_item_title,
.trx_addons_cv_portfolio_item .trx_addons_cv_portfolio_item_title a {
	color: {$colors['alter_dark']};
}

.trx_addons_cv_testimonials_item .trx_addons_cv_testimonials_item_title,
.trx_addons_cv_testimonials_item .trx_addons_cv_testimonials_item_title a {
	color: {$colors['alter_dark']};
}

.trx_addons_cv_certificates_item .trx_addons_cv_certificates_item_title,
.trx_addons_cv_certificates_item .trx_addons_cv_certificates_item_title a {
	color: {$colors['alter_dark']};
}

/* Contact form */
.trx_addons_cv .trx_addons_contact_form .trx_addons_contact_form_title {
	color: {$colors['alter_dark']};
}
.trx_addons_cv .trx_addons_contact_form_field_title {
	color: {$colors['alter_dark']};
}
.trx_addons_contact_form .trx_addons_contact_form_field input[type="text"],
.trx_addons_contact_form .trx_addons_contact_form_field textarea {
	border-color: {$colors['alter_bd_color']};
	color: {$colors['alter_text']};
}
.trx_addons_contact_form .trx_addons_contact_form_field input[type="text"]:focus,
.trx_addons_contact_form .trx_addons_contact_form_field textarea:focus {
	background-color: {$colors['alter_bg_hover']};
	color: {$colors['alter_dark']};
}
.trx_addons_contact_form_field button {
	background-color: {$colors['alter_dark']};
	border-color: {$colors['alter_dark']};
	color: {$colors['bg_color']};
}
.trx_addons_contact_form_field button:hover {
	color: {$colors['alter_dark']};
}
.trx_addons_contact_form_info_icon {
	color: {$colors['alter_light']};
}
.trx_addons_contact_form_info_area {
	color: {$colors['alter_dark']};
}
.trx_addons_contact_form_info_item_phone .trx_addons_contact_form_info_data {
	color: {$colors['alter_dark']} !important;
}

/* Page About Me */
.trx_addons_cv_about_page .trx_addons_cv_single_title {
	color: {$colors['alter_dark']};
}


/* Additional attributes for Variations */
.trx_addons_attrib_item.trx_addons_attrib_button,
.trx_addons_attrib_item.trx_addons_attrib_image,
.trx_addons_attrib_item.trx_addons_attrib_color {
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.trx_addons_attrib_item.trx_addons_attrib_button:hover,
.trx_addons_attrib_item.trx_addons_attrib_image:hover,
.trx_addons_attrib_item.trx_addons_attrib_color:hover {
	border-color: {$colors['alter_bd_hover']};
	background-color: {$colors['alter_bg_hover']};
}
.trx_addons_attrib_item.trx_addons_attrib_selected {
	border-color: {$colors['alter_link']} !important;
	background-color: {$colors['alter_bg_hover']};
}
.trx_addons_attrib_item.trx_addons_attrib_disabled span:before,
.trx_addons_attrib_item.trx_addons_attrib_disabled span:after {
	background-color: {$colors['alter_hover']};
}

/* TRX Socials */
.widget_instagram_wrap .widget_instagram_follow_link {
	color: {$colors['text_dark']};
}
.widget_instagram_wrap .widget_instagram_follow_link:hover {
	color: {$colors['text_hover']};
}

/* Range slider */
.trx_addons_range_slider_label_min {
	color: {$colors['alter_text']};
}
.trx_addons_range_slider_label_max {
	color: {$colors['alter_text']};
}
div.ui-slider {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bd_color']};
}
div.ui-slider .ui-slider-handle {
	border-color: {$colors['alter_bd_hover']};
	background-color: {$colors['alter_bg_hover']};
}
div.ui-slider .ui-slider-range {
	background-color: {$colors['alter_bg_hover']};
}


CSS;
		}

		return $css;
	}
}
?>