<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('alisha_williams_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'alisha_williams_revslider_theme_setup9', 9 );
	function alisha_williams_revslider_theme_setup9() {
		if (alisha_williams_exists_revslider()) {
			add_action( 'wp_enqueue_scripts', 					'alisha_williams_revslider_frontend_scripts', 1100 );
			add_filter( 'alisha_williams_filter_merge_styles',			'alisha_williams_revslider_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'alisha_williams_filter_tgmpa_required_plugins','alisha_williams_revslider_tgmpa_required_plugins' );
		}
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'alisha_williams_exists_revslider' ) ) {
	function alisha_williams_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'alisha_williams_revslider_tgmpa_required_plugins' ) ) {
	function alisha_williams_revslider_tgmpa_required_plugins($list=array()) {
		if (in_array('revslider', alisha_williams_storage_get('required_plugins'))) {
			$path = alisha_williams_get_file_dir('plugins/revslider/revslider.zip');
			$list[] = array(
					'name' 		=> esc_html__('Revolution Slider', 'alisha-williams'),
					'slug' 		=> 'revslider',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'required' 	=> false,
					'version'   => '6.6.11',
			);
		}
		return $list;
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'alisha_williams_revslider_frontend_scripts' ) ) {
	function alisha_williams_revslider_frontend_scripts() {
		if (alisha_williams_is_on(alisha_williams_get_theme_option('debug_mode')) && alisha_williams_get_file_dir('plugins/revslider/revslider.css')!='')
			wp_enqueue_style( 'alisha-williams-revslider',  alisha_williams_get_file_url('plugins/revslider/revslider.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'alisha_williams_revslider_merge_styles' ) ) {
	function alisha_williams_revslider_merge_styles($list) {
		$list[] = 'plugins/revslider/revslider.css';
		return $list;
	}
}
?>