<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('alisha_williams_essential_grid_theme_setup9')) {
	add_action( 'after_setup_theme', 'alisha_williams_essential_grid_theme_setup9', 9 );
	function alisha_williams_essential_grid_theme_setup9() {
		if (alisha_williams_exists_essential_grid()) {
			add_action( 'wp_enqueue_scripts', 							'alisha_williams_essential_grid_frontend_scripts', 1100 );
			add_filter( 'alisha_williams_filter_merge_styles',					'alisha_williams_essential_grid_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'alisha_williams_filter_tgmpa_required_plugins',		'alisha_williams_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'alisha_williams_exists_essential_grid' ) ) {
	function alisha_williams_exists_essential_grid() {
		return defined('EG_PLUGIN_PATH') || defined( 'ESG_PLUGIN_PATH' );
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'alisha_williams_essential_grid_tgmpa_required_plugins' ) ) {
	function alisha_williams_essential_grid_tgmpa_required_plugins($list=array()) {
		if (in_array('essential-grid', alisha_williams_storage_get('required_plugins'))) {
			$path = alisha_williams_get_file_dir('plugins/essential-grid/essential-grid.zip');
			$list[] = array(
						'name' 		=> esc_html__('Essential Grid', 'alisha-williams'),
						'slug' 		=> 'essential-grid',
						'source'	=> !empty($path) ? $path : 'upload://essential-grid.zip',
						'required' 	=> false,
						'version'   => '3.0.17.1',
			);
		}
		return $list;
	}
}
	
// Enqueue plugin's custom styles
if ( !function_exists( 'alisha_williams_essential_grid_frontend_scripts' ) ) {
	function alisha_williams_essential_grid_frontend_scripts() {
		if (alisha_williams_is_on(alisha_williams_get_theme_option('debug_mode')) && alisha_williams_get_file_dir('plugins/essential-grid/essential-grid.css')!='')
			wp_enqueue_style( 'alisha-williams-essential-grid',  alisha_williams_get_file_url('plugins/essential-grid/essential-grid.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'alisha_williams_essential_grid_merge_styles' ) ) {
	function alisha_williams_essential_grid_merge_styles($list) {
		$list[] = 'plugins/essential-grid/essential-grid.css';
		return $list;
	}
}
?>