<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'alisha_williams_cf7_feed_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'alisha_williams_cf7_theme_setup9', 9 );
    function alisha_williams_cf7_theme_setup9() {
			add_filter('wpcf7_autop_or_not', '__return_false');
        if ( is_admin() ) {
            add_filter( 'alisha_williams_filter_tgmpa_required_plugins', 'alisha_williams_cf7_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'alisha_williams_cf7_tgmpa_required_plugins' ) ) {
    function alisha_williams_cf7_tgmpa_required_plugins( $list = array() ) {
        if (in_array('contact-form-7', alisha_williams_storage_get('required_plugins'))) {
            $list[] = array(
                'name' 		=> esc_html__('Contact Form 7', 'alisha-williams'),
                'slug'     => 'contact-form-7',
                'required' => false,
            );
        }
        return $list;
    }
}

// Check if this plugin installed and activated
if ( ! function_exists( 'alisha_williams_exists_cf7' ) ) {
    function alisha_williams_exists_cf7() {
        return class_exists( 'WPCF7' );
    }
}
