<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('alisha_williams_booked_get_css')) {
	add_filter('alisha_williams_filter_get_css', 'alisha_williams_booked_get_css', 10, 4);
	function alisha_williams_booked_get_css($css, $colors, $fonts, $scheme='') {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button,
body #booked-profile-page input[type="submit"],
body #booked-profile-page button,
body .booked-list-view input[type="submit"],
body .booked-list-view button,
body table.booked-calendar input[type="submit"],
body div.booked-calendar .booked-appt-list .timeslot .timeslot-people button,
body table.booked-calendar button,
body .booked-modal input[type="submit"],
body .booked-modal button {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}

CSS;
		}
		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

/* Calendar */
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .page-right, body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .page-left,
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .monthName {
	color: {$colors['inverse_dark']}!important;
}
table.booked-calendar th .monthName a {
	color: {$colors['extra_link']};
}
table.booked-calendar th .monthName a:hover {
	color: {$colors['extra_hover']};
}
.booked-calendar-wrap .booked-appt-list h2 {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-title {
	color: {$colors['text_link']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .spots-available {
	color: {$colors['text']};
}
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .monthName a,
body table.booked-calendar th .monthName > a {
	color: {$colors['text_dark']} !important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-head .bc-row .bc-col .monthName a:hover,
body table.booked-calendar th .monthName > a:hover {
	color: {$colors['text_link']} !important;
}
/* Form fields */
#booked-page-form {
	color: {$colors['text']};
	border-color: {$colors['bd_color']};
}

#booked-profile-page .booked-profile-header {
	background-color: {$colors['bg_color']} !important;
	border-color: transparent !important;
	color: {$colors['text']};
}
#booked-profile-page .booked-user h3 {
	color: {$colors['text_dark']};
}
#booked-profile-page .booked-profile-header .booked-logout-button:hover {
	color: {$colors['text_link']};
}

#booked-profile-page .booked-tabs {
	border-color: {$colors['alter_bd_color']} !important;
}

.booked-modal .bm-window p.booked-title-bar {
	background-color: {$colors['alter_dark']} !important;
}
.booked-modal .bm-window .close i {
	color: {$colors['alter_bg_color']};
}

.booked-calendarSwitcher.calendar,
.booked-calendarSwitcher.calendar select,
#booked-profile-page .booked-tabs {
	background-color: {$colors['alter_bg_color']} !important;
}
#booked-profile-page .booked-tabs li a {
	background-color: {$colors['extra_bg_hover']};
	color: {$colors['extra_dark']};
}
table.booked-calendar thead,
table.booked-calendar thead th,
table.booked-calendar tr.days,
table.booked-calendar tr.days th,
#booked-profile-page .booked-tabs li.active a,
#booked-profile-page .booked-tabs li.active a:hover,
#booked-profile-page .booked-tabs li a:hover {
	color: {$colors['extra_dark']} !important;
	background-color: {$colors['extra_bg_color']} !important;
}
table.booked-calendar tr.days,
table.booked-calendar tr.days th {
	border-color: {$colors['extra_bd_color']} !important;
}

table.booked-calendar td.today .date span {
	border-color: {$colors['text_link']};
}

table.booked-calendar td.today:hover .date span {
	background-color: {$colors['text_link']} !important;
	color: {$colors['inverse_link']} !important;
}
#booked-profile-page .booked-tab-content {
	background-color: {$colors['bg_color']};
	border-color: {$colors['alter_bd_color']};
}
table.booked-calendar td,
table.booked-calendar td+td {
	border-color: {$colors['alter_bd_color']};
}

body .booked-modal .bm-window a:hover {
	color: {$colors['text_hover2']};
}



body table.booked-calendar {
	background: transparent;
}

body #booked-profile-page input[type=submit].button-primary:hover,
body .booked-list-view button.button:hover,
body .booked-list-view input[type=submit].button-primary:hover,
body table.booked-calendar input[type=submit].button-primary:hover,
body .booked-modal input[type=submit].button-primary:hover,
body table.booked-calendar thead,
body table.booked-calendar thead th,
body #booked-profile-page .booked-profile-header,
body #booked-profile-page .booked-tabs li.active a,
body #booked-profile-page .booked-tabs li.active a:hover,
body #booked-profile-page .appt-block .google-cal-button > a:hover {
	color: {$colors['text_dark']} !important;
	background: transparent !important;
}


body #booked-profile-page input[type=submit].button-primary:hover,
body table.booked-calendar input[type=submit].button-primary:hover,
body .booked-list-view button.button:hover,
body .booked-list-view input[type=submit].button-primary:hover,
body .booked-modal input[type=submit].button-primary:hover,
body table.booked-calendar th,
body table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover,
body #booked-profile-page .booked-profile-header,
body #booked-profile-page .appt-block .google-cal-button > a:hover {
	color: {$colors['text_dark']} !important;
	border-color: transparent !important;
	background: transparent !important;
}

body .booked-modal button:hover,
body .booked-modal input[type=submit].button-primary:hover,
body div.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover,
body table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover{
	color: {$colors['text_dark']} !important;
	background: {$colors['text_hover2']} !important;
}

body table.booked-calendar tr.days,
body table.booked-calendar tr.days th,
body .booked-calendarSwitcher.calendar,
body .booked-calendarSwitcher.calendar select,
body #booked-profile-page .booked-tabs {
	color: {$colors['inverse_link']} !important;
	background: {$colors['text_link4']} !important;
}

body table.booked-calendar tr.days th, 
body #booked-profile-page .booked-tabs {
	border-color: {$colors['bg_color_04']} !important;	
}

body table.booked-calendar td.today .date span {
    border-color: {$colors['text_link2']} !important;
    color: {$colors['text_dark']} !important;
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.today .date span {
	box-shadow: inset 0 0 0 2px {$colors['text_link2']};
}
body div.booked-calendar-wrap div.booked-calendar .bc-body .bc-row.week .bc-col.today:hover .date span {
	background: {$colors['text_link2']} !important;
}
body table.booked-calendar td.today:hover .date span {
    border-color: {$colors['text_link2']} !important;
    background-color: {$colors['text_link2']} !important;
    color: {$colors['inverse_link']} !important;
}
CSS;
		}

		return $css;
	}
}
?>