<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('alisha_williams_booked_theme_setup9')) {
	add_action( 'after_setup_theme', 'alisha_williams_booked_theme_setup9', 9 );
	function alisha_williams_booked_theme_setup9() {
		if (alisha_williams_exists_booked()) {
			add_action( 'wp_enqueue_scripts', 							'alisha_williams_booked_frontend_scripts', 1100 );
			add_filter( 'alisha_williams_filter_merge_styles',					'alisha_williams_booked_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'alisha_williams_filter_tgmpa_required_plugins',		'alisha_williams_booked_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'alisha_williams_exists_booked' ) ) {
	function alisha_williams_exists_booked() {
		return class_exists('booked_plugin');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'alisha_williams_booked_tgmpa_required_plugins' ) ) {
	function alisha_williams_booked_tgmpa_required_plugins($list=array()) {
		if (in_array('booked', alisha_williams_storage_get('required_plugins'))) {
			$path = alisha_williams_get_file_dir('plugins/booked/booked.zip');
			$list[] = array(
					'name' 		=> esc_html__('Booked Appointments', 'alisha-williams'),
					'slug' 		=> 'booked',
					'source' 	=> !empty($path) ? $path : 'upload://booked.zip',
					'required' 	=> false,
                    'version'   => '2.4',
			);
		}
		return $list;
	}
}
	
// Enqueue plugin's custom styles
if ( !function_exists( 'alisha_williams_booked_frontend_scripts' ) ) {
	function alisha_williams_booked_frontend_scripts() {
		if (alisha_williams_is_on(alisha_williams_get_theme_option('debug_mode')) && alisha_williams_get_file_dir('plugins/booked/booked.css')!='')
			wp_enqueue_style( 'alisha-williams-booked',  alisha_williams_get_file_url('plugins/booked/booked.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'alisha_williams_booked_merge_styles' ) ) {
	function alisha_williams_booked_merge_styles($list) {
		$list[] = 'plugins/booked/booked.css';
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if (alisha_williams_exists_booked()) { require_once ALISHA_WILLIAMS_THEME_DIR . 'plugins/booked/booked.styles.php'; }
?>