<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

alisha_williams_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'classie', alisha_williams_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'imagesloaded', alisha_williams_get_file_url('js/theme.gallery/imagesloaded.min.js'), array(), null, true );
wp_enqueue_script( 'masonry', alisha_williams_get_file_url('js/theme.gallery/masonry.min.js'), array(), null, true );
wp_enqueue_script( 'alisha-williams-gallery-script', alisha_williams_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$alisha_williams_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$alisha_williams_sticky_out = alisha_williams_get_theme_option('sticky_style')=='columns' 
							&& is_array($alisha_williams_stickies) && count($alisha_williams_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$alisha_williams_cat = alisha_williams_get_theme_option('parent_cat');
	$alisha_williams_post_type = alisha_williams_get_theme_option('post_type');
	$alisha_williams_taxonomy = alisha_williams_get_post_type_taxonomy($alisha_williams_post_type);
	$alisha_williams_show_filters = alisha_williams_get_theme_option('show_filters');
	$alisha_williams_tabs = array();
	if (!alisha_williams_is_off($alisha_williams_show_filters)) {
		$alisha_williams_args = array(
			'type'			=> $alisha_williams_post_type,
			'child_of'		=> $alisha_williams_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $alisha_williams_taxonomy,
			'pad_counts'	=> false
		);
		$alisha_williams_portfolio_list = get_terms($alisha_williams_args);
		if (is_array($alisha_williams_portfolio_list) && count($alisha_williams_portfolio_list) > 0) {
			$alisha_williams_tabs[$alisha_williams_cat] = esc_html__('All', 'alisha-williams');
			foreach ($alisha_williams_portfolio_list as $alisha_williams_term) {
				if (isset($alisha_williams_term->term_id)) $alisha_williams_tabs[$alisha_williams_term->term_id] = $alisha_williams_term->name;
			}
		}
	}
	if (count($alisha_williams_tabs) > 0) {
		$alisha_williams_portfolio_filters_ajax = true;
		$alisha_williams_portfolio_filters_active = $alisha_williams_cat;
		$alisha_williams_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters alisha_williams_tabs alisha_williams_tabs_ajax">
			<ul class="portfolio_titles alisha_williams_tabs_titles">
				<?php
				foreach ($alisha_williams_tabs as $alisha_williams_id=>$alisha_williams_title) {
					?><li><a href="<?php echo esc_url(alisha_williams_get_hash_link(sprintf('#%s_%s_content', $alisha_williams_portfolio_filters_id, $alisha_williams_id))); ?>" data-tab="<?php echo esc_attr($alisha_williams_id); ?>"><?php echo esc_html($alisha_williams_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$alisha_williams_ppp = alisha_williams_get_theme_option('posts_per_page');
			if (alisha_williams_is_inherit($alisha_williams_ppp)) $alisha_williams_ppp = '';
			foreach ($alisha_williams_tabs as $alisha_williams_id=>$alisha_williams_title) {
				$alisha_williams_portfolio_need_content = $alisha_williams_id==$alisha_williams_portfolio_filters_active || !$alisha_williams_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $alisha_williams_portfolio_filters_id, $alisha_williams_id)); ?>"
					class="portfolio_content alisha_williams_tabs_content"
					data-blog-template="<?php echo esc_attr(alisha_williams_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(alisha_williams_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($alisha_williams_ppp); ?>"
					data-post-type="<?php echo esc_attr($alisha_williams_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($alisha_williams_taxonomy); ?>"
					data-cat="<?php echo esc_attr($alisha_williams_id); ?>"
					data-parent-cat="<?php echo esc_attr($alisha_williams_cat); ?>"
					data-need-content="<?php echo (false===$alisha_williams_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($alisha_williams_portfolio_need_content) 
						alisha_williams_show_portfolio_posts(array(
							'cat' => $alisha_williams_id,
							'parent_cat' => $alisha_williams_cat,
							'taxonomy' => $alisha_williams_taxonomy,
							'post_type' => $alisha_williams_post_type,
							'page' => 1,
							'sticky' => $alisha_williams_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		alisha_williams_show_portfolio_posts(array(
			'cat' => $alisha_williams_cat,
			'parent_cat' => $alisha_williams_cat,
			'taxonomy' => $alisha_williams_taxonomy,
			'post_type' => $alisha_williams_post_type,
			'page' => 1,
			'sticky' => $alisha_williams_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>