<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

alisha_williams_storage_set('blog_archive', true);

// Load scripts for 'Masonry' layout
if (substr(alisha_williams_get_theme_option('blog_style'), 0, 7) == 'masonry') {
	wp_enqueue_script( 'classie', alisha_williams_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
	wp_enqueue_script( 'imagesloaded', alisha_williams_get_file_url('js/theme.gallery/imagesloaded.min.js'), array(), null, true );
	wp_enqueue_script( 'masonry', alisha_williams_get_file_url('js/theme.gallery/masonry.min.js'), array(), null, true );
	wp_enqueue_script( 'alisha-williams-gallery-script', alisha_williams_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );
}

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$alisha_williams_classes = 'posts_container '
						. (substr(alisha_williams_get_theme_option('blog_style'), 0, 7) == 'classic' ? 'columns_wrap' : 'masonry_wrap');
	$alisha_williams_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$alisha_williams_sticky_out = alisha_williams_get_theme_option('sticky_style')=='columns' 
							&& is_array($alisha_williams_stickies) && count($alisha_williams_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($alisha_williams_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$alisha_williams_sticky_out) {
		if (alisha_williams_get_theme_option('first_post_large') && !is_paged() && !in_array(alisha_williams_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="<?php echo esc_attr($alisha_williams_classes); ?>"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($alisha_williams_sticky_out && !is_sticky()) {
			$alisha_williams_sticky_out = false;
			?></div><div class="<?php echo esc_attr($alisha_williams_classes); ?>"><?php
		}
		get_template_part( 'content', $alisha_williams_sticky_out && is_sticky() ? 'sticky' : 'classic' );
	}
	
	?></div><?php

	alisha_williams_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>