<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('alisha_williams_storage_get')) {
	function alisha_williams_storage_get($var_name, $default='') {
		global $ALISHA_WILLIAMS_STORAGE;
		return isset($ALISHA_WILLIAMS_STORAGE[$var_name]) ? $ALISHA_WILLIAMS_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('alisha_williams_storage_set')) {
	function alisha_williams_storage_set($var_name, $value) {
		global $ALISHA_WILLIAMS_STORAGE;
		$ALISHA_WILLIAMS_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('alisha_williams_storage_empty')) {
	function alisha_williams_storage_empty($var_name, $key='', $key2='') {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($ALISHA_WILLIAMS_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($ALISHA_WILLIAMS_STORAGE[$var_name][$key]);
		else
			return empty($ALISHA_WILLIAMS_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('alisha_williams_storage_isset')) {
	function alisha_williams_storage_isset($var_name, $key='', $key2='') {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($ALISHA_WILLIAMS_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($ALISHA_WILLIAMS_STORAGE[$var_name][$key]);
		else
			return isset($ALISHA_WILLIAMS_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('alisha_williams_storage_inc')) {
	function alisha_williams_storage_inc($var_name, $value=1) {
		global $ALISHA_WILLIAMS_STORAGE;
		if (empty($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = 0;
		$ALISHA_WILLIAMS_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('alisha_williams_storage_concat')) {
	function alisha_williams_storage_concat($var_name, $value) {
		global $ALISHA_WILLIAMS_STORAGE;
		if (empty($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = '';
		$ALISHA_WILLIAMS_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('alisha_williams_storage_get_array')) {
	function alisha_williams_storage_get_array($var_name, $key, $key2='', $default='') {
		global $ALISHA_WILLIAMS_STORAGE;
		if ( '' === $key2 ) {
			return ! empty( $var_name ) && '' !== $key && isset( $ALISHA_WILLIAMS_STORAGE[ $var_name ][ $key ] ) ? $ALISHA_WILLIAMS_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && '' !== $key && isset( $ALISHA_WILLIAMS_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $ALISHA_WILLIAMS_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}
}

// Set array element
if (!function_exists('alisha_williams_storage_set_array')) {
	function alisha_williams_storage_set_array($var_name, $key, $value) {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = array();
		if ($key==='')
			$ALISHA_WILLIAMS_STORAGE[$var_name][] = $value;
		else
			$ALISHA_WILLIAMS_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('alisha_williams_storage_set_array2')) {
	function alisha_williams_storage_set_array2($var_name, $key, $key2, $value) {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = array();
		if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name][$key])) $ALISHA_WILLIAMS_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$ALISHA_WILLIAMS_STORAGE[$var_name][$key][] = $value;
		else
			$ALISHA_WILLIAMS_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('alisha_williams_storage_merge_array')) {
	function alisha_williams_storage_merge_array($var_name, $key, $value) {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = array();
		if ($key==='')
			$ALISHA_WILLIAMS_STORAGE[$var_name] = array_merge($ALISHA_WILLIAMS_STORAGE[$var_name], $value);
		else
			$ALISHA_WILLIAMS_STORAGE[$var_name][$key] = array_merge($ALISHA_WILLIAMS_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('alisha_williams_storage_set_array_after')) {
	function alisha_williams_storage_set_array_after($var_name, $after, $key, $value='') {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = array();
		if (is_array($key))
			alisha_williams_array_insert_after($ALISHA_WILLIAMS_STORAGE[$var_name], $after, $key);
		else
			alisha_williams_array_insert_after($ALISHA_WILLIAMS_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('alisha_williams_storage_set_array_before')) {
	function alisha_williams_storage_set_array_before($var_name, $before, $key, $value='') {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = array();
		if (is_array($key))
			alisha_williams_array_insert_before($ALISHA_WILLIAMS_STORAGE[$var_name], $before, $key);
		else
			alisha_williams_array_insert_before($ALISHA_WILLIAMS_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('alisha_williams_storage_push_array')) {
	function alisha_williams_storage_push_array($var_name, $key, $value) {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($ALISHA_WILLIAMS_STORAGE[$var_name], $value);
		else {
			if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name][$key])) $ALISHA_WILLIAMS_STORAGE[$var_name][$key] = array();
			array_push($ALISHA_WILLIAMS_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('alisha_williams_storage_pop_array')) {
	function alisha_williams_storage_pop_array($var_name, $key='', $defa='') {
		global $ALISHA_WILLIAMS_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($ALISHA_WILLIAMS_STORAGE[$var_name]) && is_array($ALISHA_WILLIAMS_STORAGE[$var_name]) && count($ALISHA_WILLIAMS_STORAGE[$var_name]) > 0) 
				$rez = array_pop($ALISHA_WILLIAMS_STORAGE[$var_name]);
		} else {
			if (isset($ALISHA_WILLIAMS_STORAGE[$var_name][$key]) && is_array($ALISHA_WILLIAMS_STORAGE[$var_name][$key]) && count($ALISHA_WILLIAMS_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($ALISHA_WILLIAMS_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('alisha_williams_storage_inc_array')) {
	function alisha_williams_storage_inc_array($var_name, $key, $value=1) {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = array();
		if (empty($ALISHA_WILLIAMS_STORAGE[$var_name][$key])) $ALISHA_WILLIAMS_STORAGE[$var_name][$key] = 0;
		$ALISHA_WILLIAMS_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('alisha_williams_storage_concat_array')) {
	function alisha_williams_storage_concat_array($var_name, $key, $value) {
		global $ALISHA_WILLIAMS_STORAGE;
		if (!isset($ALISHA_WILLIAMS_STORAGE[$var_name])) $ALISHA_WILLIAMS_STORAGE[$var_name] = array();
		if (empty($ALISHA_WILLIAMS_STORAGE[$var_name][$key])) $ALISHA_WILLIAMS_STORAGE[$var_name][$key] = '';
		$ALISHA_WILLIAMS_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('alisha_williams_storage_call_obj_method')) {
	function alisha_williams_storage_call_obj_method($var_name, $method, $param=null) {
		global $ALISHA_WILLIAMS_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($ALISHA_WILLIAMS_STORAGE[$var_name]) ? $ALISHA_WILLIAMS_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($ALISHA_WILLIAMS_STORAGE[$var_name]) ? $ALISHA_WILLIAMS_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('alisha_williams_storage_get_obj_property')) {
	function alisha_williams_storage_get_obj_property($var_name, $prop, $default='') {
		global $ALISHA_WILLIAMS_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($ALISHA_WILLIAMS_STORAGE[$var_name]->$prop) ? $ALISHA_WILLIAMS_STORAGE[$var_name]->$prop : $default;
	}
}
?>