<?php
/**
 * The default template to display the content of the single post, page or attachment
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'post_item_single post_type_'.esc_attr(get_post_type()) 
												. ' post_format_'.esc_attr(str_replace('post-format-', '', get_post_format())) 
												. ' itemscope'
												); ?>
		itemscope itemtype="http://schema.org/<?php echo esc_attr(is_single() ? 'BlogPosting' : 'Article'); ?>">
	<?php
	// Structured data snippets
	if (alisha_williams_is_on(alisha_williams_get_theme_option('seo_snippets'))) {
		?>
		<div class="structured_data_snippets">
			<meta itemprop="headline" content="<?php the_title_attribute(); ?>">
			<meta itemprop="datePublished" content="<?php echo esc_attr(get_the_date('Y-m-d')); ?>">
			<meta itemprop="dateModified" content="<?php echo esc_attr(get_the_modified_date('Y-m-d')); ?>">
			<meta itemscope itemprop="mainEntityOfPage" itemType="https://schema.org/WebPage" itemid="<?php the_permalink(); ?>" content="<?php the_title_attribute(); ?>"/>	
			<div itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
				<div itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">
					<?php 
					$alisha_williams_logo_image = alisha_williams_get_retina_multiplier(2) > 1 
										? alisha_williams_get_theme_option( 'logo_retina' )
										: alisha_williams_get_theme_option( 'logo' );
					if (!empty($alisha_williams_logo_image)) {
						$alisha_williams_attr = alisha_williams_getimagesize($alisha_williams_logo_image);
						?>
						<img itemprop="url" src="<?php echo esc_url($alisha_williams_logo_image); ?>">
						<meta itemprop="width" content="<?php echo esc_attr($alisha_williams_attr[0]); ?>">
						<meta itemprop="height" content="<?php echo esc_attr($alisha_williams_attr[1]); ?>">
						<?php
					}
					?>
				</div>
				<meta itemprop="name" content="<?php echo esc_attr(get_bloginfo( 'name' )); ?>">
				<meta itemprop="telephone" content="">
				<meta itemprop="address" content="">
			</div>
		</div>
		<?php
	}
	
	// Featured image
	if ( !alisha_williams_sc_layouts_showed('featured')) {
		$post_date_day  = apply_filters('trx_addons_filter_get_post_date', get_the_date('d'));
		$post_date_month  = apply_filters('trx_addons_filter_get_post_date', get_the_date('M'));
		if ( has_post_thumbnail() ) {		
		?>
		<div class="post_featured_content">
		<?php		
		alisha_williams_show_post_featured();
		?>
		<div class="post_featured_date">
			<div class="post_featured_date_container">
				<div class="post_featured_date_day"><?php echo esc_attr($post_date_day) ?></div>
				<div class="post_featured_date_month"><?php echo esc_attr($post_date_month) ?></div>
			</div>
		</div></div>
		<?php		
		}
	}

	// Title and post meta
	if ( (!alisha_williams_sc_layouts_showed('title') || !alisha_williams_sc_layouts_showed('postmeta')) && !in_array(get_post_format(), array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if (!alisha_williams_sc_layouts_showed('title')) {
				the_title( '<h3 class="post_title entry-title"'.(alisha_williams_is_on(alisha_williams_get_theme_option('seo_snippets')) ? ' itemprop="headline"' : '').'>', '</h3>' );
			}
			// Post meta
			if (!alisha_williams_sc_layouts_showed('postmeta')) {
				alisha_williams_show_post_meta(array(
					'seo' => alisha_williams_is_on(alisha_williams_get_theme_option('seo_snippets')),
					'date' => false,
					'edit' => false,
					'share' => false,
					'counters' => 'comments'
					)
				);
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	?>
	<div class="post_content entry-content" itemprop="articleBody">
		<?php
			the_content( );

			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'alisha-williams' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'alisha-williams' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

			// Taxonomies and share
			if ( is_single() && !is_attachment() ) {
				?>
				<div class="post_meta post_meta_single"><?php
					
					// Post taxonomies
					the_tags( '<span class="post_meta_item post_tags"><span class="post_meta_label">'.esc_html__('Tags:', 'alisha-williams').'</span> ', ', ', '</span>' );

					// Share
					alisha_williams_show_share_links(array(
							'type' => 'block',
							'caption' => '',
							'before' => '<span class="post_meta_item post_share">',
							'after' => '</span>'
						));
					?>
				</div>
				<?php
			}
		?>
	</div><!-- .entry-content -->

	<?php
		// Author bio.
		if ( is_single() && !is_attachment() && get_the_author_meta( 'description' ) ) {
			get_template_part( 'templates/author-bio' );
		}
	?>
</article>
