<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

$alisha_williams_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$alisha_williams_post_format = get_post_format();
$alisha_williams_post_format = empty($alisha_williams_post_format) ? 'standard' : str_replace('post-format-', '', $alisha_williams_post_format);
$alisha_williams_animation = alisha_williams_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($alisha_williams_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($alisha_williams_post_format) ); ?>
	<?php echo (!alisha_williams_is_off($alisha_williams_animation) ? ' data-animation="'.esc_attr(alisha_williams_get_animation_classes($alisha_williams_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	alisha_williams_show_post_featured(array(
		'thumb_size' => alisha_williams_get_thumb_size($alisha_williams_columns==1 ? 'big' : ($alisha_williams_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($alisha_williams_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			alisha_williams_show_post_meta();
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>